///////////////////////////////////////////////////////////
//  KDSAdapter.cpp
//  Implementation of the Class KDSAdapter
//  Created on:      05-Dez-2013 12:50:54
//  Original author: mor2hi
///////////////////////////////////////////////////////////
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#include "KDSAdapter.h"
#include "../../Macro.h"
//#include "../../../fc_diagnosis/common/dia_KDSEntries.h"
#include "fc_diagnosis_if.h" 


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/KDSAdapter.cpp.trc.h"
#endif

KDSAdapter::KDSAdapter(DataMirrorItf* pDataMirrorAdapter) :
      oKeyMatrixData(pDataMirrorAdapter, KEY_MATRIX_DATA_ENTITY_CODE, _KDSEntityLength(KEY_MATRIX_COUNT)),
      oSystemKeyData(pDataMirrorAdapter,SYSTEM_KEY_DATA_ENTITY_CODE, _KDSEntityLength(SYSTEM_KEY_COUNT)),
      oCarBusData(pDataMirrorAdapter, CAR_BUS_KEY_DATA_ENTITY_CODE, _KDSEntityLength(CAR_BUS_KEY_COUNT)),
	  oRLadderData(pDataMirrorAdapter, RLADDER_KEY_DATA_ENTITY_CODE, _KDSEntityLength(RLADDER_BUS_KEY_COUNT))
{
   ETG_TRACE_USR4(("KDSAdapter::KDSAdapter"));
   ETG_TRACE_USR4(("KDSAdapter::KDSAdapter: pKeyMatrixKeyData: 0x%x", &oKeyMatrixData));
   ETG_TRACE_USR4(("KDSAdapter::KDSAdapter: pSystemKeyData: 0x%x", &oSystemKeyData));
   ETG_TRACE_USR4(("KDSAdapter::KDSAdapter: pCarBusData: 0x%x", &oCarBusData));
}

KDSAdapter::~KDSAdapter()
{
   ETG_TRACE_USR4(("KDSAdapter::~KDSAdapter"));
}

tBool KDSAdapter::readAndProvideKeyMatrixData()
{
	ETG_TRACE_FATAL(("KDSAdapter::readAndProvideKeyMatrixData: pData: 0x%x\n", &oKeyMatrixData));

   return (oKeyMatrixData.readPersistandDataAndMakeThemAvailableForV850());
}

tBool KDSAdapter::readAndProvideSystemKeyData()
{
	ETG_TRACE_FATAL(("KDSAdapter::readAndProvideSystemKeyData: pData: 0x%x\n", &oSystemKeyData));

   return (oSystemKeyData.readPersistandDataAndMakeThemAvailableForV850());
}

tBool KDSAdapter::readAndProvideCarBusData()
{
	ETG_TRACE_FATAL(("KDSAdapter::readAndProvideCarBusData: pData: 0x%x\n", &oCarBusData));

   return (oCarBusData.readPersistandDataAndMakeThemAvailableForV850());
}

tBool KDSAdapter::readAndProvideSwcRladderData()
{
	ETG_TRACE_FATAL(("KDSAdapter::readAndProvideSwcRladderData: pData: 0x%x\n", &oRLadderData));
   return (oRLadderData.readPersistandDataAndMakeThemAvailableForV850());
}

tBool KDSAdapter::getDataFromPersistantStorageAndProvideDataToV850(tU8 u8BrandType)
{
   tBool sendPassed = TRUE;

   tBool sendPassed1 = TRUE;
   tBool sendPassed2 = TRUE;
   tBool sendPassed3 = TRUE;
   tBool sendPassed4 = TRUE;
   //This is Table No 1
   sendPassed1 = readAndProvideKeyMatrixData();
   //This is Table no 2
   sendPassed2 = readAndProvideSystemKeyData();
   //This is Table No 3
   sendPassed3 = readAndProvideCarBusData();
   //Now Write Table 4 If Nissan
   if(u8BrandType == 0x01 || u8BrandType == 0x02)		//for PIVI load default data for table 4
   {   //If Brand Type is Nissan Load Data from PD table 4 for SWC RLadder
	   //And provide to V850
	   sendPassed4 = readAndProvideSwcRladderData();
   }

   if (
         (FALSE == sendPassed1)
         || (FALSE == sendPassed2)
         ||(FALSE == sendPassed3)
		 ||(FALSE == sendPassed4))
   {
      ETG_TRACE_USR4(("KDSAdapter::getDataFromPersistantStorageAndProvideDataToV850: data storage failed\n"));
      sendPassed = FALSE;
   }

   return (sendPassed);
}

