///////////////////////////////////////////////////////////
//  ThreadAdministration.h
//  Implementation of the Class ThreadAdministration
//  Created on:      14-Nov-2013 15:38:11
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(EA_6CF47DBA_AB3E_4702_A515_C3C685107DED__INCLUDED_)
#define EA_6CF47DBA_AB3E_4702_A515_C3C685107DED__INCLUDED_
#include <pthread.h>
#include <signal.h>

namespace ThreadAdministration_input
{
class ThreadAdministration
{

public:
	ThreadAdministration();
	virtual ~ThreadAdministration();
	 /**
    * Flag will be set when the Thread shall exit
    */
   tBool terminateObserverThread; //Stores the status of Observer Thread
   sigset_t    mask; //This is mask to tell which Signals to listen for

private:

	pthread_t ObserverThread;
   pthread_t ConsumerThread;

public:
   //Observer Thread will inform Consumer Thread when new msg comes via signal
	void informConsumerAboutNewIncomingMessage(int SignalNo);
	//Consumer Thread keeps waiting until it receives the signal.
	tBool waitForNewMessagesIncoming();
	int waitThreadEnd(pthread_t Thread);
	int createThread(pthread_t *Thread, void *(*pMessageReceiver)(void *));

	int createConsumerThread(void *(*pMessageReceiver)(void *), int SignalNo);
	int createObserverThread(void *(*pMessageReceiver)(void *));
	int waitObserverThreadEnd();
   int waitConsumerThreadEnd();
   int exitMainThread();
};
}
#endif // !defined(EA_6CF47DBA_AB3E_4702_A515_C3C685107DED__INCLUDED_)
