/*
 * ThreadAdministration.cpp
 *
 *  Created on: 14.11.2013
 *      Author: mor2hi
 */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ThreadAdministration.h"

using namespace ThreadAdministration_input;
ThreadAdministration::ThreadAdministration():ObserverThread(0),ConsumerThread(0)
{
   terminateObserverThread = FALSE;
   //Some cleanup
   sigemptyset(&mask);
}
ThreadAdministration::~ThreadAdministration()
{
   //Some cleanup
   sigemptyset(&mask);
   /*IMP Function call pthread_sigmask() to unblock from signal reception*/
   pthread_sigmask(SIG_UNBLOCK, &mask, (sigset_t *)0);
}

int ThreadAdministration::createThread(pthread_t *Thread, void *(*pMessageReceiver)(void *))
{
   return (pthread_create(Thread, NULL, pMessageReceiver, NULL));
}

int ThreadAdministration::createConsumerThread(void *(*pMessageReceiver)(void *),int SignalNo)
{
   sigemptyset(&mask);
   sigaddset(&mask, SIGINT);
   sigaddset(&mask, SIGQUIT);
   sigaddset(&mask, SignalNo);
   /*IMP Function call pthread_sigmask()*/
   pthread_sigmask(SIG_BLOCK, &mask, (sigset_t *)0); //This call will tell OS to Block and wait for SIGUSR1 or 2 for reception
   
   return (createThread(&ConsumerThread, pMessageReceiver));
}

int ThreadAdministration::createObserverThread(void *(*pMessageReceiver)(void *))
{
   return (createThread(&ObserverThread, pMessageReceiver));

}

int ThreadAdministration::waitThreadEnd(pthread_t Thread)
{
   // wait for end of thread
   return(pthread_join(Thread, NULL)); //to solve lint warning
   
}

int ThreadAdministration::waitConsumerThreadEnd()
{
   pthread_kill(ConsumerThread, SIGQUIT);
   int ret = waitThreadEnd(ConsumerThread);
   return ret; //to solve lint warning
}

int ThreadAdministration::waitObserverThreadEnd()
{
	int ret = waitThreadEnd(ObserverThread);
	return ret; //to solve lint warning
}

int ThreadAdministration::exitMainThread()
{
   pthread_exit((void *) pthread_self());
   return 0; //lint warning
}

void ThreadAdministration::informConsumerAboutNewIncomingMessage(int SignalNo)
{
#if defined (_PRINT__)
   printf("ThreadAdministration::informConsumerAboutNewIncomingMessage: interrupt\n");
#endif
   pthread_kill(ConsumerThread, SignalNo);
}

tBool ThreadAdministration::waitForNewMessagesIncoming()
{
   tBool MessageValid = FALSE;
   int signo;

   #if defined (_PRINT__)
   printf("ThreadAdministration::waitForNewMessagesIncoming\n");
   #endif

   if (0 == sigwait(&mask, &signo))
   {
      switch (signo)
      {
         case SIGINT:
         {
         #if defined (_PRINT__)
            printf("ThreadAdministration::waitForNewMessagesIncoming: interrupt\n");
         #endif
         }
         break;
         case SIGQUIT:
         {
            terminateObserverThread = TRUE;
         }
         break;
         case SIGUSR1:
         {
            MessageValid = TRUE;
         #if defined (_PRINT__)
            printf("ThreadAdministration::waitForNewMessagesIncoming: SigUsr 1 for Key Press Device %d\n", signo);
         #endif
         }
         break;
         case SIGUSR2:
         {
            MessageValid = TRUE;
         #if defined (_PRINT__)
            printf("ThreadAdministration::waitForNewMessagesIncoming: SigUsr 2 for Encoder Device %d\n", signo);
         #endif
         }
         break;
         default:
         #if defined (_PRINT__)
            printf("ThreadAdministration::waitForNewMessagesIncoming: unexpected signal %d\n", signo);
         #endif
         break;
      }
   }
   else
   {
      #if defined (_PRINT__)
      printf("ThreadAdministration::waitForNewMessagesIncoming: signal wait failed\n");
      #endif
   }

   return (MessageValid); // return the signal number SIGUSR1 or SIGUSR2
}
