///////////////////////////////////////////////////////////
//  SerialQueue.h
//  Implementation of the Class SerialQueue
//  Created on:      09-Aug-2013 16:04:12
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(SerialQueue_h_)
#define SerialQueue_h_
#include "DefineVector.h"
#define BITS_PER_BYTE 8
#define MAX_BYTE 0x000000FF
#define MAX_LONG 0x0000FFFF
#define MAX_WORD 0xFFFFFFFF
#define NO_BYTE_OF_BYTE 1
#define NO_BYTE_OF_LONG 2
#define NO_BYTE_OF_WORD 4
class SerialQueue
{
private:
//   SerialQueue& operator=(const SerialQueue& rhs);

public:
   DefineVector<tU8> oDataQueue;
   tVoid copyData(SerialQueue* pQueue);
   tVoid AddData(SerialQueue* pQueue);
   SerialQueue();
   SerialQueue(SerialQueue* pQueue);
   SerialQueue(tU8* pData, int DataLength);

   virtual ~SerialQueue();
   tVoid emptyQueue();
   int getSize();
   tBool isQueueEmpty();
   tVoid serialize(tU32 Data, tU8 NoOfByte);
   tU8 readByte(tU8 StartPosition);
	tU8 readByte();
	tU16 readLong(tU8 StartPosition);
	tU16 readLong();
   tU32 readWord(tU8 StartPosition);
	tU32 readWord();
	tVoid store(tU32 Data);
	tVoid store(tU16 Data);
	tVoid store(tU8 Data);
	tVoid removeBytesFromQueue(tU8 AmountOfBytes);
	tVoid removeByte();
	tVoid removeLong();
	tVoid removeWord();
	tVoid printData();
};
#endif
