///////////////////////////////////////////////////////////
//  SerialQueue.cpp
//  Implementation of the Class SerialQueue
//  Created on:      09-Aug-2013 16:04:12
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#include "SerialQueue.h"
#include "../Macro.h"

SerialQueue::SerialQueue()
{

}

int SerialQueue::getSize()
{
   return (oDataQueue.size());
}

tVoid SerialQueue::AddData(SerialQueue* pQueue)
{
   INP_POINTER_CHECK_CALL_NO_RET_VALUE(pQueue);

   for (tU8 i = 1; i <= (pQueue->oDataQueue.size()); i++)
   {
      store(pQueue->readByte(i));
   }
}

tVoid SerialQueue::copyData(SerialQueue* pQueue)
{
   INP_POINTER_CHECK_CALL_NO_RET_VALUE(pQueue);

   emptyQueue();
   for (tU8 i = 1; i <= (pQueue->oDataQueue.size()); i++)
   {
      store(pQueue->readByte(i));
   }
}
SerialQueue::SerialQueue(tU8* pData, int DataLength)
{
   INP_POINTER_CHECK_CALL_NO_RET_VALUE(pData);

   for (tU8 i = 1; i <= DataLength; i++)
   {
      store(pData[i - 1]);
   }

}

SerialQueue::SerialQueue(SerialQueue* pQueue)
{
   INP_POINTER_CHECK_CALL_NO_RET_VALUE(pQueue);
   copyData(pQueue);
}

/*
 SerialQueue& SerialQueue::operator=(const SerialQueue& rhs)
 {
 // protection again copy on itself
 if( &rhs == this)
 {
 NORMAL_M_ASSERT_ALWAYS();
 }

 copyData(rhs);
 return (*this);
 }
 */
SerialQueue::~SerialQueue()
{
}

tBool SerialQueue::isQueueEmpty()
{
   return (oDataQueue.isTableEmpty());
}


tVoid SerialQueue::serialize(tU32 Data, tU8 NoOfByte)
{
   tU32 ShiftedData = Data;

   for (tU8 i = 0; i < NoOfByte; i++)
   {
      oDataQueue.attachElement((tU8) ShiftedData);
      ShiftedData = ShiftedData >> BITS_PER_BYTE;
   }
}

tVoid SerialQueue::emptyQueue()
{
   oDataQueue.clear();
}

tU8 SerialQueue::readByte()
{
   return (readByte(DATA_SET_START_POSITION));
}

tU8 SerialQueue::readByte(tU8 ByteNumberOfElementInQueue)
{
   return (oDataQueue.readElement(ByteNumberOfElementInQueue - 1));
}

tU16 SerialQueue::readLong(tU8 ByteNumberOfElementInQueue)
{
   tU16 DataRead = INIT_VALUE;

   if ((ByteNumberOfElementInQueue + 1) <= oDataQueue.size())
   {
      DataRead = oDataQueue.readElement(ByteNumberOfElementInQueue - 1) << BITS_PER_BYTE;
      DataRead = DataRead + oDataQueue.readElement(ByteNumberOfElementInQueue);
   }

   return (DataRead);
}

tU16 SerialQueue::readLong()
{
   tU16 DataRead = INIT_VALUE;
   DataRead = readLong(DATA_SET_START_POSITION);

   return (DataRead);
}

tU32 SerialQueue::readWord(tU8 ByteNumberOfElementInQueue)
{

   tU32 DataRead = INIT_VALUE;

   if ((ByteNumberOfElementInQueue + 3) <= oDataQueue.size())
   {
      DataRead = oDataQueue.readElement(ByteNumberOfElementInQueue - 1);
      for (tU8 i = 1; i <= NO_BYTE_OF_WORD - 1; i++)
      {
         DataRead = DataRead << BITS_PER_BYTE;
         DataRead = DataRead + oDataQueue.readElement(ByteNumberOfElementInQueue - 1 + i);
      }
   }

   return (DataRead);

}

tU32 SerialQueue::readWord()
{

   tU32 DataRead = INIT_VALUE;

   DataRead = readWord(DATA_SET_START_POSITION);

   return (DataRead);

}

tVoid SerialQueue::removeBytesFromQueue(tU8 AmountOfBytes)
{
   for (tU8 i = 0; i < AmountOfBytes; i++)
   {
      oDataQueue.removeFirstElement();
   }

}
tVoid SerialQueue::removeByte()
{

   removeBytesFromQueue(NO_BYTE_OF_BYTE);
}

tVoid SerialQueue::removeLong()
{
   removeBytesFromQueue(NO_BYTE_OF_LONG);
}

tVoid SerialQueue::removeWord()
{
   removeBytesFromQueue(NO_BYTE_OF_WORD);

}

tVoid SerialQueue::store(tU32 Data)
{
#if defined (_PRINT__)
   printf("Here I am:SerialQueue:store tU32: %d <-> 0x%x\n", Data);
#endif

   serialize(Data, NO_BYTE_OF_WORD);
   // swap last four bytes
   oDataQueue.swapElement(oDataQueue.size() - 3, oDataQueue.size());
   oDataQueue.swapElement(oDataQueue.size() - 2, oDataQueue.size() - 1);

}

tVoid SerialQueue::store(tU16 Data)
{
#if defined (_PRINT__)
   printf("Here I am:SerialQueue:store tU16: %d <-> 0x%x\n", Data, Data);
#endif

   serialize((tU16) Data, NO_BYTE_OF_LONG);
// swap last two bytes
   oDataQueue.swapElement(oDataQueue.size() - 1, oDataQueue.size());
}

tVoid SerialQueue::store(tU8 Data)
{
#if defined (_PRINT__)
   printf("Here I am:SerialQueue:store tU8: %d <-> 0x%x\n", Data, Data);
#endif

   serialize((tU8) Data, NO_BYTE_OF_BYTE);
}

tVoid SerialQueue::printData()
{
#if defined (_PRINT__)
   printf("Here I am:SerialQueue:printData Queue Size: %d\n", oDataQueue.size());
#endif

   for (int i = 0; i < oDataQueue.size(); i++)
   {
#if defined (_PRINT__)
      printf("Here I am:SerialQueue Data: %d <-> 0x%x\n", oDataQueue._DefineVector[i], oDataQueue._DefineVector[i]);
#endif
   }
}
