/*
 * EpollInput.h
 *
 *  Created on: Mar 10, 2016
 *      Author: sgt4kor
 */

#ifndef VD_INPUT_FRAMEWORKS_EPOLLINPUT_H_
#define VD_INPUT_FRAMEWORKS_EPOLLINPUT_H_

#include <sys/epoll.h>
#include <linux/input.h>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

namespace vd_input_epoll {

class EpollInput {
public:
	EpollInput()
	{
		efiledesc = epoll_create1 (0);
	}
	virtual ~EpollInput()
	{

	}
	inline tVoid createInstance()
	{
	   if(efiledesc == 0)
	      efiledesc = epoll_create1 (0);
	}

	tS32 waitForEvent(struct epoll_event* p_epoll_event_out, tS32 timeout = -1,  tS32 max_events = 1)
	{
		return ( epoll_wait (efiledesc, p_epoll_event_out, max_events, timeout) );
	}

	tS32 addFileDescriptor(tS32 FileDesc);
	tS32 removeFileDescriptor(tS32 FileDesc);
private:
	//Section to create and init epoll events, filedescriptor
	tS32 efiledesc;
};

} /* namespace vd_input_epoll */

#endif /* VD_INPUT_FRAMEWORKS_EPOLLINPUT_H_ */
