///////////////////////////////////////////////////////////
//  DefineVector.h
//  Implementation of the Class DefineVector
//  Created on:      20-Sep-2012 16:11:01
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(DEFINE_VECTOR__INCLUDED_)
#define DEFINE_VECTOR__INCLUDED_
/*
 #define DEFINE_VECTOR__INCLUDED_
 #define SYSTEM_S_IMPORT_INTERFACE_VECTOR
 #define SYSTEM_S_IMPORT_INTERFACE_MAP
 #define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
 #include <stl_pif.h>
 */
//#define __INPUT_UNIT_TESTING__
#include "../config/vd_input_stl.h"
//using namespace bpstl;

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/**
 * Template class covers the interface for usage of stl vector.
 * It's used to handle enumerations
 */
template<typename DefineType>
class DefineVector
{
#define INIT_VALUE 0
#define DATA_SET_START_POSITION 1
private:

public:
   bpstl::vector<DefineType, bpstl::allocator<DefineType> > _DefineVector;

   DefineVector()
   {

   }

   int size()
   {
      return (_DefineVector.size());
   }

   tVoid clear()
   {
      _DefineVector.clear();
   }

   tBool isTableEmpty ()
   {
      return (_DefineVector.empty());
   }

   tBool isTypeAttached(DefineType Entity)
   {
      typename bpstl::vector<DefineType>::iterator tIterator;
      tBool EntityFound = FALSE;

      if (FALSE == (isTableEmpty()))
      {
         for (tIterator = _DefineVector.begin(); tIterator != _DefineVector.end(); tIterator++)
         {
            if (Entity == (*tIterator))
            {
               EntityFound = TRUE;
               break;
            }
         }
      }

      return (EntityFound);
   }

   tBool attachElement(DefineType Key)
   {
      _DefineVector.push_back(Key);

      return (TRUE);
   }

   tVoid swapElement(tU8 First, tU8 Second)
   {
      if (
            (First <= _DefineVector.size())
            &&
            (Second <= _DefineVector.size()
            )
      )
      bpstl::swap(_DefineVector[First-1], _DefineVector[Second-1]);
   }

   tBool removeFirstElement()
   {
      typename bpstl::vector
      <DefineType>::iterator tIterator;

      if ( FALSE == isTableEmpty())
      {
         tIterator = _DefineVector.begin();
         _DefineVector.erase(tIterator);
         return (TRUE);
      }
      else
      return (FALSE);
   }

   tBool removeElement(DefineType Entity)
   {
      tBool EntityFound = FALSE;
      typename bpstl::vector
      <DefineType>::iterator tIterator;

      if ( FALSE == isTableEmpty())
      {
         for (tIterator = _DefineVector.begin(); tIterator != _DefineVector.end(); tIterator++)
         {
            if (Entity == (*tIterator))
            {
               _DefineVector.erase(tIterator);
               EntityFound = TRUE;
               break;
            }
         }

         return (TRUE);
      }
      else
      return (FALSE);
   }

   DefineType readElement(tU8 ElementPos)
   {
      DefineType Key = INIT_VALUE;

      if (
            ( FALSE == isTableEmpty())
            &&
            ((ElementPos) < _DefineVector.size())
      )
      {
         Key = _DefineVector[ElementPos];
      }

      return (Key);
   }

   DefineType readFirstElement()
   {
      DefineType Key = INIT_VALUE;

      if ( FALSE == isTableEmpty())
      {
         Key = _DefineVector.front();
      }

      return (Key);
   }

   DefineType readFirstAndRemoveElement()
   {
      DefineType Key = INIT_VALUE;

      if ( FALSE == isTableEmpty())
      {
         Key = readFirstElement();
         removeFirstElement();
      }

      return (Key);
   }
};
#endif
