//
// CCA_Msg.cpp
//
//  Created on: 01.12.2011
//      Author: mor2hi
//

#include "CCAMsg.h"


#include "../vd_inputMain.h"
class vd_input_tclMain;

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     CCAMsg::vSendError
 *
 *DESCRIPTION:  Sends an error - message
 *
 *PARAMETER:    data for addressing the message
 *
 *RETURNVALUE:  None
 *

 *
 ******************************************************************-FUNCHEADER*/ //
/*
 tVoid CCAMsg::vSendError(const amt_tclServiceData* const poMessage, T_e8_Audio_CCAError ErrorCode)
 {

 fc_audiomanager_tclApp* poMain = NULL;
 poMain = fc_audiomanager_tclApp::theServer();

 AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMain);
 AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);

 // Form a generic error message
 gm_tclU8Message oErrorMsg(poMessage->u16GetTargetAppID(), poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(),
 poMessage->u16GetCmdCounter(), poMessage->u16GetServiceID(), poMessage->u16GetFunctionID(), AMT_C_U8_CCAMSG_OPCODE_ERROR);
 // Set the error code
 oErrorMsg.vSetByte((tU8) ErrorCode);

 // Check if there is any error
 if (poMain->enPostMessage(&oErrorMsg) != AIL_EN_N_NO_ERROR)
 {
 // Error in sending the message
 if (!oErrorMsg.bDelete())
 {
 // Error in deleting the message
 }
 }

 }
 */
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     CCAMsg::vSendMessage
 *
 *DESCRIPTION:  Forms & sends CCA messages
 *
 *PARAMETER:
 *
 *RETURNVALUE:  bool: true -> sending was successful
 *
 *
 ******************************************************************-FUNCHEADER*/
tBool CCAMsg::vSendMessage(fi_tclVisitorMessage* pResultMsg, tU16 u16SourceApp, tU16 u16TargetAppID, tU8 u8StreamType,
      tU16 u16StreamCounter, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16ServiceID, tU16 u16FktID, tU8 u8Opcode) const
{
   tBool bFuncReturn = FALSE;
   vd_input_tclMain* poMain = NULL;
   poMain = vd_input_tclMain::theServer();

   vd_input_NULL_POINTER_CHECK_VAL(poMain);

#if defined (_PRINT__)
   printf("Here I am:  CCAMsg::vSendMessage: try to send message now\n");
#endif

   // initialise result message
   pResultMsg->vInitServiceData(u16SourceApp, // source
         u16TargetAppID, // Target
         u8StreamType, // StreamType
         (tU8) u16StreamCounter, // StreamCounter
         u16RegID, // RegisterID
         u16CmdCounter, // nCmdCounter,
         u16ServiceID, // nServiceID,
         u16FktID, // function ID
         u8Opcode);

   ail_tenCommunicationError enResult = poMain->enPostMessage(pResultMsg);
   if (AIL_EN_N_NO_ERROR != enResult)
   {
#if defined (_PRINT__)
      printf("Here I am: CCAMsg::vSendMessage: failed!!: Error Code: %d, "\
            "SourceAppId: %d, TargetAppID: %d, StreamType: %d, StreamCounter: %d, RegId: %d, CmdCounter: %d, ServiceId: %d, FktId: %d, OpCode: %d\n",
            enResult,
            u16SourceApp, u16TargetAppID, u8StreamType,
            u16StreamCounter, u16RegID, u16CmdCounter, u16ServiceID, u16FktID, u8Opcode);
#endif

      //don't throw an assert, this is not an error in any case
      bFuncReturn = FALSE;

      // delete message
      // message handled, so it can be deleted - Done by framework, so it is no longer needed!
//      pResultMsg->bDelete();
   }
   else
   {
      bFuncReturn = TRUE;
   }

   return (bFuncReturn);
}
