/*
 * UsrActionEmu.h
 *
 *  Created on: Jan 13, 2016
 *      Author: sgt4kor
 */

#ifndef USRACTIONEMU_H_
#define USRACTIONEMU_H_
#include"../../Macro.h"
#include "../../vd_inputMain.h"
#include"../../Gateway/uInputAdaptor/uInputAdaptor.h"
#include "EvIncludes.h"

// basic file operations
#include <iostream>
#include <fstream>
#include <string>
using namespace vd_input_ThreadHandler;
using namespace vd_input_uInputAdaptor;

class EventObserver;
class KeySimApp;
class EncSimApp;
class TouchSimApp;


class UsrActionEmu : public Ivd_inputBase{
public:
	UsrActionEmu(vd_input_tclMain* poMain);
	virtual ~UsrActionEmu();
	//Set Of Virtual Functions to be overriden from base class
	virtual const tChar* getName() const {return "UsrActionEmu"; }
	virtual const tChar* getIfName() const {return "UsrActionEmu"; }
	virtual tVoid vHandleMessage(TMsg* pMsg) {(tVoid)pMsg; } //--Lint Prio 2 Fix
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo(){; }

	//Set of Public Functions:-
	tBool filepathValid(std::string filepath);
	tBool record(tU8 u8StartStop, std::string path = std::string("/tmp/InputEvent.txt"));
	tBool replay(tU8 u8StartStop, std::string path = std::string("/tmp/InputEvent.txt"));

	tVoid RecordInputEvent(struct input_event Event, tU16 ScreenID);
   //Thread common callback function for All key Events
	static tVoid* ReplayCallBack(tVoid* pData);
	pthread_mutex_t _MutexUsrAction;

private:
	std::string _strReplayFilePath;
	EventObserver* _poEvObserverRef;
	tU8 _u8RecordStatus;
	std::ofstream _RecordFileHandl;
	tU8 _u8ReplayStatus;
	ThreadHandler _oThreadHandler;
	//Reference of each Simulation App
	KeySimApp* KeySimAppRef;
	EncSimApp* EncSimAppRef;
	TouchSimApp* TouchSimAppRef;
	TouchSimApp* TouchSimAppRef_Secondary;

	static tS32 _uHardKeyDeviceFD;
	static tS32 _uSWCKeyDeviceFD;
	static tS32 _uITCommKeyDeviceFD;
	static tS32 _uEncoderDeviceFD;
	static tS32 _uTouchDeviceFD;
	static tS32 _uTouchDevice_SecFD;

	static inline tLong time_to_long(const struct timeval *tv) {
		return tv->tv_sec * 1000000L + tv->tv_usec;
	}

	static inline struct timeval long_to_time(tLong time) {
		struct timeval tv;
		tv.tv_sec = time/1000000L;
		tv.tv_usec = time % 1000000L;
		return tv;
	}
	static inline tULong sec2microsec(tULong  s)
	{
		return s * 1000000L;
	}
	static inline tULong microsec2sec(tULong  us)
	{
		return us / 1000000L;
	}

	tBool replayStart();
	tBool replayStop();
};

#endif /* USRACTIONEMU_H_ */
