/*
 * EventObserver.cpp
 *
 *  Created on: Aug 25, 2015
 *      Author: sgt4kor
 */

#include "EventObserver.h"
#include"UsrActionEmu.h"


#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"

#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM
#include "midw_common_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_DEVICE
#include "trcGenProj/Header/EventObserver.cpp.trc.h"
#endif

#define  MAX_EVENTS  (sizeof(struct input_event)*3)
#define TIME_OUT  (tS32) (7000) //milliseconds

//Alok
tBool EventObserver::bIsJammingCheckActive = FALSE;
//Alok

tBool EventObserver::bIsObserverActive = FALSE;
EventObserver* EventObserver::pSelf = NULL;


// function called by scandir to allow only files with "EVENT_DEV_NAME" to pass
static int is_event_device(const struct dirent *dir) {
    return strncmp(EVENT_DEV_NAME, dir->d_name, 5) == 0;
}

EventObserver::EventObserver(vd_input_tclMain* poMain): Ivd_inputBase(poMain), _u8StartStopRecording(0),_pUsrActionEmuRef(0)
{
	EventObserver::pSelf = this;
	_poMyCSMInterface = 0;
	_stlAllDevNameList.clear(); //to make sure Vector is empty
	_FileDescList.clear();
	KeyMap.clear();
	FileMap.clear();
	ETG_TRACE_USR4(("EventObserver::EventObserver() Initialized"));
	_s8ActivityCounter=-1;
	s32ScreenID = 1;
	_s32EventTypeHistory = -1;		//Coverity issue->Uninitialized(CID:74613)
	bIsDeviceMissing = FALSE;
}

EventObserver::~EventObserver()
{
	EventObserver::bIsObserverActive = FALSE;
	ETG_TRACE_USR4(("EventObserver::~EventObserver()->No of THREADS to KILL = %d", _stlAllDevNameList.size()));
	_s8ActivityCounter=-1;
	removeDevicesToMontior();//To be safe to de register epoll monitored devices
	_oThreadHandler.waitObserverThreadEnd();
	_oThreadHandler.exitMainThread();

	//Alok
	EventObserver::bIsJammingCheckActive = FALSE;
	//Alok

	_stlAllDevNameList.clear();
	_FileDescList.clear();
	_pUsrActionEmuRef = NULL;
	KeyMap.clear();
	FileMap.clear();
	//// Scope 2.1
	if (OSAL_NULL != _poMyCSMInterface) {
		OSAL_DELETE _poMyCSMInterface;
	}
	_poMyCSMInterface = OSAL_NULL;

}

tVoid EventObserver::initKeyMap()
{
	ETG_TRACE_USR4(("EventObserver::initKeyMap()"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_PHONE,"HK_PHONE"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_CD, "HK_CD"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_CAMERA, "HK_CAMERA"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_AUX, "HK_AUX"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_PREV, "HK_PREV"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_NEXT, "HK_NEXT" ));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_RADIO, "HK_RADIO"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_INFO, "HK_INFO" ));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_SETUP, "HK_SETUP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MAP, "HK_MAP" ));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_BACK, "HK_BACK"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_DAY_NIGHT, "HK_DAY_NIGHT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_NAV, "HK_NAV"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_ENTER, "HK_ENTER"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_XM, "HK_XM"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SYS_KEY_POWER, "SYS_KEY_POWER"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SYS_KEY_EJECT, "SYS_KEY_EJECT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_FM_AM, "HK_FM_AM"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MENU, "HK_MENU"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_APP, "HK_APP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_AUDIO, "HK_AUDIO"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_DISP, "HK_DISP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_RN_VOLUME_UP, "HK_RN_VOLUME_UP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_RN_VOLUME_DOWN, "HK_RN_VOLUME_DOWN"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_RN_VOLUME, "HK_RN_VOLUME"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_RN_HOME, "HK_RN_HOME"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SYS_KEY_RSC_ON_OFF, "SYS_KEY_RSC_ON_OFF"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_ELECTRO_VEHICLE, "HK_ELECTRO_VEHICLE"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_FOLDER_NEXT, "HK_FOLDER_NEXT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_FOLDER_PREV, "HK_FOLDER_PREV"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MUTE, "HK_MUTE"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_PIVI_CLIMATE, "HK_PIVI_CLIMATE"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_MEX"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_HOME_COCKPIT"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_SRC_COCKPIT"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_INF4CV_NAV"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_INF4CV_MAP"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_SRC_CABIN"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_HOME_CABIN"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_SET_COCKPIT"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_INF4CV_CAM"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_PHONE_ACCEPT"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_PHONE_REJECT"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_INF4CV_MON"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_SET_CABIN"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_VOL_COCKPIT"));
	KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MEX, "HK_VOL_CABIN"));
	
    //Long press keycodes for Renault
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_MENU_LONG, "HK_RN_MENU_LONG"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_SETUP_LONG, "HK_RN_SETUP_LONG"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SYS_KEY_POWER_LONG, "SYS_KEY_RN_POWER_LONG"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_HOME_LONG, "HK_RN_HOME_LONG"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_DAY_NIGHT_LONG, "HK_RN_DAY_NIGHT_LONG"));

    //Virtual Keys
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_VIRT_SRV_TESTMODE, "HK_VIRT_SRV_TESTMODE"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_VIRT_VOL_COMBI, "HK_VIRT_VOL_COMBI"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HVAC_MEX, "HVAC_MEX"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HVAC_SEAT, "HVAC_SEAT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (HK_VIRT_AUDIO_MODE_COMBI, "HK_VIRT_AUDIO_MODE_COMBI"));

    //SWCs
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_MODE, "SWC_MODE"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_OK, "SWC_OK"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_SEEK_UP, "SWC_SEEK_UP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_SEEK_DOWN, "SWC_SEEK_DOWN"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_TEL_VR, "SWC_TEL_VR"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_VOL_DOWN, "SWC_VOL_DOWN"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_VOL_UP, "SWC_VOL_UP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_TEL_HANG_UP, "SWC_TEL_HANG_UP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_BACK, "SWC_BACK"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_UP, "SWC_UP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_DOWN, "SWC_DOWN"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_MUTE, "SWC_MUTE"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_AUDIO_SRC_UP, "SWC_AUDIO_SRC_UP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_AUDIO_SRC_DOWN, "SWC_AUDIO_SRC_DOWN"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_RADIO, "SWC_RADIO"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_ENTER, "SWC_ENTER"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_LEFT, "SWC_LEFT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_RIGHT, "SWC_RIGHT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_PHONE_MUTE_DUO, "SWC_PHONE_MUTE_DUO"));
    //KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (SWC_TEL_OFF, "SWC_TEL_OFF"));

    //Joystick
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_UP, "JOYSTICK_UP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_DOWN, "JOYSTICK_DOWN"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_LEFT, "JOYSTICK_LEFT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_RIGHT, "JOYSTICK_RIGHT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_UPPER_LEFT, "JOYSTICK_UPPER_LEFT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_UPPER_RIGHT, "JOYSTICK_UPPER_RIGHT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_LOWER_LEFT, "JOYSTICK_LOWER_LEFT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_LOWER_RIGHT, "JOYSTICK_LOWER_RIGHT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_ENTER, "JOYSTICK_ENTER"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_MAP, "JOYSTICK_MAP"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_OPTION, "JOYSTICK_OPTION"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_HOME, "JOYSTICK_HOME"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_BACK, "JOYSTICK_BACK"));
    //PIVI
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_DAY_NIGHT, "JOYSTICK_DAY_NIGHT"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_DISP, "JOYSTICK_DISP"));

    //Joystick Long press
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_OPTION_LONGPRESS, "JOYSTICK_OPTION_LONGPRESS"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_HOME_LONGPRESS, "JOYSTICK_HOME_LONGPRESS"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_BACK_LONGPRESS, "JOYSTICK_BACK_LONGPRESS"));
    KeyMap.insert( std::pair<eVDInput_KeyCodes, std::string> (JOYSTICK_ENTER_LONGPRESS, "JOYSTICK_ENTER_LONGPRESS"));

}



tVoid EventObserver::vStartCommunication()
{
	ETG_TRACE_USR4(("EventObserver::vStartCommunication() entered."));
	initKeyMap();
	_poMyCSMInterface = new CSMInterface();
	INP_POINTER_CHECK_FATAL_ON_NULL_NO_RET(_poMyCSMInterface);
	//Event Observer Shall Be Always Running as per new CRQ
	startObserver();
	//Alok
	startJammingCheckThread();
	//Alok
}
//Alok
tVoid EventObserver::startJammingCheckThread()
{
	int status = -1;
	bIsJammingCheckActive = TRUE;
	status = _oJammingHandler.createObserverThread( &(EventObserver::TouchJammingCallback), reinterpret_cast<tVoid*>(this) );
	if(status == -1)
	{
		ETG_TRACE_USR4(("EventObserver::startJammingCheck()createJammingCheckThread FAILED"));
	}
	else
	{
		ETG_TRACE_USR4(("EventObserver::startJammingThreadCheck()createJammingCheckThread SUCCESS!...."));
		ETG_TRACE_USR4(("EventObserver::startJammingThreadCheck() THREAD_ID = %d",_oJammingHandler.ObserverThread));
	}
}

tVoid* EventObserver::TouchJammingCallback(tVoid* pData)
{
	Touchlist* _tTouchlist = NULL;
	ETG_TRACE_USR4((": TouchJammingCallback: ------------------------------->Enter"));
	while(TRUE == EventObserver::bIsJammingCheckActive)
	{
		 sleep(15);
		_tTouchlist = EventObserver::pSelf->getTouchInfoList();

		if (TRUE == _tTouchlist->empty()) //If List is Empty
		{
			ETG_TRACE_USR4((":TouchJammingCallback()-> Touch List is empty-> Waiting to capture Touch Events !!"))
		}
		//End of If

	}//End of While loop Thread
	return (tVoid*)(NULL);
}
//Alok
tVoid EventObserver::vTraceInfo()
{
	ETG_TRACE_USR4(("EventObserver::vTraceInfo()->TR_CLASS_VD_INPUT_DEVICE"));
}

tVoid EventObserver::vGetReferences()
{
	ETG_TRACE_USR4(("EventObserver::vGetReferences() entered."));
	INP_POINTER_CHECK_FATAL_ON_NULL_NO_RET(_cpoMain);
	_pUsrActionEmuRef = dynamic_cast<UsrActionEmu*>(_cpoMain->getHandler("UsrActionEmu"));
	INP_POINTER_CHECK_FATAL_ON_NULL_NO_RET(_pUsrActionEmuRef);
	ETG_TRACE_USR4(("EventObserver:: vGetReferences() Exit"));
	//_pCCAHandler = dynamic_cast<Ivd_input_tclServiceHandler*>(_cpoMain->getHandler("Ivd_input_tclServiceHandler"));
}
//*********************************************************************************************************************************
// 	Public Methods
//*********************************************************************************************************************************

tS32 EventObserver::printVariantSupportedKeyList()
{
	struct dirent **namelist;
	tS32 ndev;
	tS32 fd;
	tU32 evCode = 0;
	tChar name[256] = "Unknown";
	tU32 evtype_b[EV_MAX][NBITS(KEY_MAX)];

	tS32 KeyDeviceCount = 0;
	std::string KeyName(" ? ");
	// get list of files in dir DEV_INPUT_EVENT. Only event files will pass (see is_event_device filter)
	ndev = scandir(DEV_INPUT_EVENT, &namelist, is_event_device, versionsort);
	if (ndev <= 0)
		return 0;
	//Now parse the list and store filenames in Vector
	for (int i = 0; i < ndev; i++)
	{
		// iterating above all event device files
		char fname[64];
		// create file name from dir and found file
		snprintf(fname, sizeof(fname),
			 "%s/%s", DEV_INPUT_EVENT, namelist[i]->d_name);
		fd = open(fname, O_RDONLY);
		if(fd == -1)
			continue; //If unable to open FD then skip to next

		ioctl(fd, EVIOCGNAME(sizeof(name)), name); //Get the Name of Device

		if(0 != strcmp(name,"input_scc"))  //Check for Real Device created by V850
		{
			close(fd);
			continue;				//Continue if no input_scc device
		}
		//Clear Ev bits these are used for test bits to check event capabilities
		memset(evtype_b, 0, sizeof(evtype_b));
		ioctl(fd, EVIOCGBIT(0, EV_MAX), evtype_b[0]);
		evCode = EV_ABS;
		if(test_bit(evCode, evtype_b[0]) == 1){
			ETG_TRACE_USR4(("evCode: TOUCH found so continue...next device only key"));
			close(fd);
			continue;
		}
		evCode = EV_REL;
		if(test_bit(evCode, evtype_b[0]) == 1){
			ETG_TRACE_USR4(("evCode: Encoder found so continue...next device only key"));
			close(fd);
			continue;
		}
		evCode = EV_KEY;
		if(test_bit(evCode, evtype_b[0]) == 1)
		{
			KeyDeviceCount++;
			/* the bit is set in the event types list */
			ETG_TRACE_USR4(("VD_INPUT_KEYCONFIG: List of KEY-events for input-scc%d device at \"%s\" - START \n", KeyDeviceCount, fname));
			//Now Read Key events supported by this device
			ioctl(fd, EVIOCGBIT(EV_KEY, KEY_MAX_VALUE), evtype_b[EV_KEY]);
			for(tU16 code = (tU16)KEY_MIN_VALUE; code< (tU16)KEY_MAX_VALUE; code++) //optimizing search
			{
				if(test_bit(code, evtype_b[EV_KEY]) == 1)
				{
					//Store this Key in Map with code
					KeyName = getKeyName( (eVDInput_KeyCodes) (code) );
					ETG_TRACE_USR4(("VD_INPUT_KEYCONFIG: %x - %s \n",code, KeyName.c_str() ));
				}
			}
			ETG_TRACE_USR4(("VD_INPUT_KEYCONFIG: List of KEY-events for input-scc%d device at \"%s\" - END \n", KeyDeviceCount, fname));

		}
		close(fd);
		free(namelist[i]);
	}

	return KeyDeviceCount;
}

tS32 EventObserver::startObserver()
{
	int status = -1;

	if( FALSE == EventObserver::bIsObserverActive )
	{
		EventObserver::bIsObserverActive =TRUE;
		//Add Devices to be Monitored
		addDevicesToMontior();
		//Now Create Observer Thread to Monitor the Devices
		status = _oThreadHandler.createObserverThread(&(EventObserver::EvObserverCallback), NULL);
		if(status == -1)
		{
			ETG_TRACE_USR4(("EventObserver::startObserver()createObserverThread FAILED"));
		}
		else
		{
			ETG_TRACE_USR4(("EventObserver::startObserver()createObserverThread SUCESS!.. Devices[%d]", _FileDescList.size()));
			ETG_TRACE_USR4(("EventObserver::startObserver() THREAD_ID = %d",_oThreadHandler.ObserverThread));
		}
	}
	else
	{
		ETG_TRACE_USR4(("EventObserver::startObserver()->Already Started"));
	}
	return status;
}

tVoid EventObserver::stopObserver()
{
	if( TRUE == EventObserver::bIsObserverActive )
	{
		EventObserver::bIsObserverActive = FALSE;
		_oThreadHandler.detachObserverThread();
		ETG_TRACE_USR4(("EventObserver::stopObserver()->Observer Thread is Ended"));
		removeDevicesToMontior();
		_stlAllDevNameList.clear();
	}
}

Keylist* EventObserver::getKeyList()
{
	return (_tEvKeyDataHandler.getUpdatedKeyList());
}

Encoderlist* EventObserver::getEncoderDirList()
{
	return(_tEvEncDataHandler.getUpdatedEncoderDirList());
}
//For both AIVI and PIVI primary screentouch data
Touchlist* EventObserver::getTouchInfoList()
{
		return(_tEvTouchDataHandler.getUpdatedTouchList());
}
//For PIVI Secondary Screen touch data
Touchlist* EventObserver::getTouchInfoListPIVISecondary()
{
		return(_tEvTouchDataHandler_PIVI.getUpdatedTouchList());
}

tVoid EventObserver::getEncoderStatus(input_mainfi_tclMsgEncoderStatusStatus *Encoderobj)
{
	if( Encoderobj!= NULL )
	{
		_tEvEncDataHandler.lockEncoderList(); //lock mutex while reading ++
		Encoderobj->tEncoderStatus.s8EncVal_1 = _tEvEncDataHandler._s8EncStatus_1;
		Encoderobj->tEncoderStatus.s8EncVal_2 = _tEvEncDataHandler._s8EncStatus_2;
		Encoderobj->tEncoderStatus.s8EncVal_3 = _tEvEncDataHandler._s8EncStatus_3;
		Encoderobj->tEncoderStatus.s8EncVal_4 = _tEvEncDataHandler._s8EncStatus_4;
		Encoderobj->tEncoderStatus.s8EncVal_5 = _tEvEncDataHandler._s8EncStatus_5;
		_tEvEncDataHandler.unlockEncoderList(); //unlock mutex after reading --
	}
}
tBool EventObserver::StartStopRecording(tU8 u8StartStop)
{
	tBool bSuccess= FALSE;
	if(	EventObserver::bIsObserverActive == TRUE){
		_u8StartStopRecording = u8StartStop;
		bSuccess = TRUE;
	}
	else
	{
		_u8StartStopRecording = 0;
	}
	return bSuccess;
}
//**********************************************************************************************************************************
// EvObserver Thread Call Back Static Function
//**********************************************************************************************************************************



tVoid* EventObserver::EvObserverCallback(tVoid* pData)
{
	int ndev = 0;
	struct dirent **namelist;
	struct input_event EvData;
	memset(&EvData, 0, sizeof(struct input_event));
    struct epoll_event EpollEvent[MAX_EVENTS];
    memset(EpollEvent, 0, sizeof(EpollEvent));
    int ready = 0;
    tSize rstatus = 0;
    (tVoid)pData; //lint warning fix
	tU8 brandtype = pSelf->_cpoMain->u8GetBrandType();
	while(EventObserver::bIsObserverActive  == TRUE)
	{
		// Wait for input to become ready or until the time out; the first parameter is
		// Buffer of EpollData where Event Data will come from File Descriptor in Sets being monitored
		ndev = scandir(DEV_INPUT_EVENT, &namelist, is_event_device, versionsort);	
		if(ndev > pSelf->_stlAllDevNameList.size() && pSelf->bIsDeviceMissing == TRUE)
		{
			ETG_TRACE_USR4(("\nEvent number mismatch: Events added \n"));
			pSelf->removeDevicesToMontior();
			pSelf->addDevicesToMontior();
			pSelf->bIsDeviceMissing = FALSE;
		}

		ready = pSelf->_oEpollInput.waitForEvent(EpollEvent, TIME_OUT, MAX_EVENTS);
		ETG_TRACE_USR4(("waitForEvent No of Events = %d",ready));
		if((ready == -1)/*Indicates Epoll Error*/ || (ready == 0)/*Indicates Timeout*/)
		{
			ETG_TRACE_USR4(("\nError occured in Epoll or Timeout happened\n"));
			//Check if observer is stopped by user then break else continue
			if(EventObserver::bIsObserverActive == FALSE)
			{	//This shall help exit thread gracefully after any epoll error or timeout
				break;	//Exit the thread loop if Observer is Stopped
			}
		}
		else
		{
			for(int i=0; i<ready; i++)
			{
			    // If No epoll Error then read the next event fd
				int fd = EpollEvent[i].data.fd;
				if( brandtype == (tU8)0x02)			//Only for PIVI
				{
					//event 8 and 16 -->Primary Screen with Maps[screenid=2]->Seat1->Upper Display
					//event 9 and 15 -->Secondary Screen with Home[screenid=1]->Seat0->Lower Display
					//Default touch simulation and screen1 comes on Secondary->_tEvTouchDataHandler object
					if(
						( TRUE == pSelf->isCheckDevice(fd,"/dev/input/event8") ) ||
						( TRUE == pSelf->isCheckDevice(fd,"/dev/input/event16") )
					  )
					{
						pSelf->s32ScreenID=2;
					}
					if(
						( TRUE == pSelf->isCheckDevice(fd,"/dev/input/event9") ) ||
						( TRUE == pSelf->isCheckDevice(fd,"/dev/input/event15") )
					  )
					{
						pSelf->s32ScreenID=1;
					}
				}
				else //for Non PIVI Target
				{
					pSelf->s32ScreenID=1;
				}
				//ETG_TRACE_USR4(("EventObserver:PIVI TOUCH at Screen_id=(%d)",pSelf->s32ScreenID));
				//Read the FD
				rstatus = (tSize)read(fd, &EvData, sizeof(struct input_event));

				if ( (EpollEvent[i].events & EPOLLERR)||(EpollEvent[i].events & EPOLLHUP)||(!(EpollEvent[i].events & EPOLLIN)) )
				{
					    	ETG_TRACE_USR4(("\nEventObserver::EvObserverCallback()-> EpollError Continue\n"));
					    	pSelf->removeDevicesToMontior();
					    	pSelf->addDevicesToMontior();
					    	pSelf->bIsDeviceMissing = TRUE;
					    	//sleep(1000);
					    	continue;
				}
				if(errno != EAGAIN)
				{	//If Data is available for read then handle it/store it in file or variables
					if(rstatus >= sizeof(struct input_event))
					{
						pSelf->HandleInputEvent(EvData);
					}
				}
				else
				{
					ETG_TRACE_USR4(("\nEventObserver::EvObserverCallback()->Error EAGAIN occured in read\n"));
				}

			}
		}

	}
	//Exit The Loop of thread
	ETG_TRACE_USR4(("\nEventObserver::EvObserverCallback()->Exitting Pthread for Observer\n"));
	return (tVoid*)(NULL); //to solve Lint warning
}

tBool EventObserver::isCheckDevice(int fd,const char* Device)
{
	//Alok++
	tBool bStatus=FALSE;
	std::map <int,std::string>::iterator it;
	it = FileMap.find(fd);
	if(it != FileMap.end())
	{
		if(strcmp((it->second).c_str(),Device) == 0)
		{
			bStatus = TRUE;
		}

	}
	else
	{
		//do nothing
		bStatus = FALSE;
	}
	return bStatus;
	//Alok--
}
//*******************************************************************************************************************************
//	Private Functions
//*******************************************************************************************************************************


tVoid EventObserver::addDevicesToMontior()
{
	int NumOfDevices = createDevFileList();
	int fd = 0;
	//Clear FileDescList to ensure no previous data
	_FileDescList.clear();
	//Create Threads depending on Number of devices to read each device
	for(int i=0; i<NumOfDevices; i++)
	{
		fd = open(_stlAllDevNameList.at(i).c_str(), O_RDONLY | O_NONBLOCK); //open device file
		if(fd == -1)
		{
			ETG_TRACE_USR4(("Error opening file so skip to add in Observer= %d", fd));
			continue;
		}
		else
		{
			FileMap.insert(std::pair<int,std::string> (fd,_stlAllDevNameList.at(i).c_str()));
			ETG_TRACE_USR4(("Adding DEVICE: %s to Observer List", _stlAllDevNameList.at(i).c_str()));
			_FileDescList.push_back(fd);
		}
		if(-1 == EventObserver::_oEpollInput.addFileDescriptor(fd))
		{
			ETG_TRACE_USR4(("Failed to add FD to Epoll= %d", fd));
		}
		else
		{
			ETG_TRACE_USR4((" FD = (%d) added to Epoll successfully", fd));
		}
	}
}

tVoid EventObserver::removeDevicesToMontior()
{
	int NumOfDevices = _FileDescList.size();
	//Create Threads depending on Number of devices to read each device
	for(int i=0; i<NumOfDevices; i++)
	{
		EventObserver::_oEpollInput.removeFileDescriptor(_FileDescList[i]);
		if( -1 == close(_FileDescList[i]) )
		{
			ETG_TRACE_USR4(("Failed to CLOSE FD = %d", _FileDescList.at(i)));
		}
	}
	//Clear FileDescList
	_FileDescList.clear();
	//Clear device name List as well
	_stlAllDevNameList.clear();
}

tVoid EventObserver::HandleInputEvent(struct input_event Event)
{

	if(_u8StartStopRecording == 1)
	{
		//Also pass events to UserActionEmulator
		if(_pUsrActionEmuRef != NULL){
			_pUsrActionEmuRef->RecordInputEvent(Event, this->s32ScreenID);
		}
	}
	else
	{
		if(Event.type == EV_KEY && Event.code != BTN_TOUCH)
		{
			//Call KeyEvDataHandler for storing
			_s32EventTypeHistory = EV_KEY;
			pSelf->_tEvKeyDataHandler.handleKeyEvData(Event);
			std::string Name = getKeyName((eVDInput_KeyCodes)(Event.code));
			if(Event.value == 1)
			{
				//Only update MMCustomerAction counter on key press-->(Req by Customer and Alex)
				updateDeviceActivityCounter();
				ETG_TRACE_USR4(( " Detected KeyEvent: [%s] PRESS", Name.c_str() ));
			}
			else
			{
				ETG_TRACE_USR4(( " Detected KeyEvent: [%s] RELEASE", Name.c_str() ));
			}

			//Update Counter to indicate some Input Event Activity on Device
			////Scope 2.1
			//updateDeviceActivityCounter();
		}
		else if(Event.type == EV_REL)
		{
			//Call EncoderEvDataHandler for storing
			_s32EventTypeHistory = EV_REL;
			pSelf->_tEvEncDataHandler.handleEncEvData(Event);
			//Update Counter to indicate some Input Event Activity on Device
			////Scope 2.1
			updateDeviceActivityCounter();
		}
		else if(Event.type == EV_ABS || Event.code == BTN_TOUCH)
		{
			//Call MultitouchEvDataHandler for storing
			_s32EventTypeHistory = EV_ABS;
			//check if screen id is 1
			if(s32ScreenID == 1)
			{
				pSelf->_tEvTouchDataHandler.handleTouchEvData(Event);
			}
			else
			{
				pSelf->_tEvTouchDataHandler.handleTouchEvData(Event);
				//pSelf->_tEvTouchDataHandler_PIVI.handleTouchEvData(Event);
			}

			if(Event.code == BTN_TOUCH && Event.value == 1)
			{
				//Update Counter to indicate some Input Event Activity on Device on touch pressed only
				updateDeviceActivityCounter();
			}
			//else if screen no is 2 then call _tEvTouchDataHandler2.handleTouchEvData
		}
		else if(Event.type == EV_SYN)
		{
			switch(_s32EventTypeHistory)
			{
				case EV_KEY:
					pSelf->_tEvKeyDataHandler.handleKeyEvData(Event);
				break;
				case EV_REL:
					pSelf->_tEvEncDataHandler.handleEncEvData(Event);
				break;
				case EV_ABS:
					if(s32ScreenID == 1)
						pSelf->_tEvTouchDataHandler.handleTouchEvData(Event);
					else
					{
						pSelf->_tEvTouchDataHandler.handleTouchEvData(Event);
						//pSelf->_tEvTouchDataHandler_PIVI.handleTouchEvData(Event);
					}

				break;
			}
		}
	}
}

tVoid EventObserver::updateDeviceActivityCounter()
{
	if(_s8ActivityCounter >= 6)
    {
		_s8ActivityCounter = 0;
    }
    else
    {
	   _s8ActivityCounter++;
    }

    //Send to CSM
	sendDeviceActivity();
}

//CSM_C_ASIG_TX_MMCustomerAction
tVoid EventObserver::sendDeviceActivity()
{
	   /*tS32 CSM_lSignalWrite( void *pvHandle,
	                           tU32  dwSignalId,
	                           void *pvNewSignalData,
	                           tU8   bDataBufferLength,
	                           tU8   bTxType );
	                           */
	 tU32 u32CsmHandle = 0;
	 tS32 s32returnValue = 0;
	 /* s32returnValue = _poMyCSMInterface->CSM_lSignalWrite( (tVoid*)&u32CsmHandle, CSM_C_ASIG_TX_MMCustomerAction,
			                             (tVoid*)(&_s8ActivityCounter), 1,  CSM_C_TX_AS_CONFIGURED ); */

	//Single Signal Write for all signals CSM_C_ASIG_TX_MMCustomerAction
	if (CSM_C_NO_ERROR > s32returnValue)
	{
		ETG_TRACE_USR4((" :sendDeviceActivity: CSM_C_ASIG_TX_MMCustomerAction CAN data(%d) NOT sent ERROR!!", _s8ActivityCounter));
	}
	else
	{
		ETG_TRACE_USR4((" :sendDeviceActivity: CSM_C_ASIG_TX_MMCustomerAction CAN data(%d) sent Successfully!!", _s8ActivityCounter));
	}
}

tS32 EventObserver::createDevFileList()
{
	_stlAllDevNameList.clear();	
	struct dirent **namelist;
	int ndev;
	// get list of files in dir DEV_INPUT_EVENT. Only event files will pass (see is_event_device filter)
	ndev = scandir(DEV_INPUT_EVENT, &namelist, is_event_device, versionsort);
	if (ndev <= 0)
		return 0;
	//Now parse the list and store filenames in Vector
	for (int i = 0; i < ndev; i++)
	{
		// iterating above all event device files
		char fname[64];
		// create file name from dir and found file
		snprintf(fname, sizeof(fname),
			 "%s/%s", DEV_INPUT_EVENT, namelist[i]->d_name);
		//Store file name /dev/input/eventX name in vector X is no of device
		_stlAllDevNameList.push_back(fname);
		free(namelist[i]);
	}

	return _stlAllDevNameList.size();
}


std::string EventObserver::getKeyName(eVDInput_KeyCodes Keycode)
{
    std::map<eVDInput_KeyCodes, std::string>::const_iterator it;
    std::string Name;

    it = KeyMap.find(Keycode);
    if(it != KeyMap.end())
    {
        Name = it->second;
    }
    else
    {
    	Name = std::string(" ? ");
    }

    return Name;
}

//*************************************************************************************************************************************************
// E O F
//*************************************************************************************************************************************************
