/*
 * EvKeyDataRecorder.h
 *
 *  Created on: Aug 25, 2015
 *      Author: sgt4kor
 */

#ifndef EVKEYDATAHANDLER_H_
#define EVKEYDATAHANDLER_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include <linux/input.h>
#include <vector> //using std::vector
#include <pthread.h>

#define LIST_THRESHOLD_INDEX 10

typedef struct
{
	tS64 s64EvTime;
	tU16 u16KeyCode;
	tU8 u8Status;
}sKeyListElelment;

typedef std::vector<sKeyListElelment> Keylist;

class EvKeyDataHandler {

public:
	EvKeyDataHandler();
	virtual ~EvKeyDataHandler();
	tVoid handleKeyEvData(struct input_event sEvent);
    tVoid getCurrentKeyStatus(tU16 *KeyCode, tU8* Status); //Keycode and status out parameters

    Keylist _tKeyList;
	Keylist* getUpdatedKeyList();

	inline tVoid lockKeyList()
	{
		pthread_mutex_lock(&_MutexKeyList);
	}
	inline tVoid unlockKeyList()
	{
		pthread_mutex_unlock(&_MutexKeyList);
	}
private:
	sKeyListElelment _sKeyEventInfo;
	pthread_mutex_t _MutexKeyList;
	tVoid addKeyElement(sKeyListElelment& KeyElement);
	tBool changeExistingKeyElement(sKeyListElelment& KeyElement);
	tVoid delObsoleteEntries();

};

#endif /* EVKEYDATAHANDLER_H_ */
