/*
 * EvEncDataHandler.h
 *
 *  Created on: Aug 26, 2015
 *      Author: sgt4kor
 */

#ifndef EVENCDATAHANDLER_H_
#define EVENCDATAHANDLER_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include <linux/input.h>
#include<vector>
#include <pthread.h>
#define ENC_LIST_SIZE 5

typedef struct
{
	tS64 s64EvTime;
	tU16 u16EncType;
	tS8 s8EncSteps;
}sEncListElelment;

typedef std::vector<sEncListElelment> Encoderlist;


class EvEncDataHandler {
	typedef enum
	{
		ENCODER_1 = 0x06,
		ENCODER_2 = 0x08,
		ENCODER_3 = 0X07,
		ENCODER_4 = 0X03,
		ENCODER_5 = 0X09
	}enEncoderType;
public:
	tS8 _s8EncStatus_1;
	tS8 _s8EncStatus_2;
	tS8 _s8EncStatus_3;
	tS8 _s8EncStatus_4;
	tS8 _s8EncStatus_5;

	Encoderlist _tEncoderlist;

	EvEncDataHandler();
	virtual ~EvEncDataHandler();

	tVoid handleEncEvData(struct input_event sEvent);
    tVoid resetEncoderStatus();
    Encoderlist* getUpdatedEncoderDirList();
	inline tVoid lockEncoderList()
	{
		pthread_mutex_lock(&_MutexEncoder);
	}
	inline tVoid unlockEncoderList()
	{
		pthread_mutex_unlock(&_MutexEncoder);
	}
private:
	sEncListElelment _sEncListElement;

	pthread_mutex_t _MutexEncoder;
	tVoid addNewEncEntry(sEncListElelment& sEncListElement);
	tBool changeExistingEncEntry(sEncListElelment& sEncListElement);
	tVoid delObsoleteEncEntries();
	tVoid updateEncoderStatus(sEncListElelment& sEncListElement);
};

#endif /* EVENCDATAHANDLER_H_ */
