/*
 * vd_input_StatusServiceHandler.cpp
 *
 *  Created on: Feb 5, 2014
 *      Author: sgt4kor
 */

#include "vd_input_StatusServiceHandler.h"
#include "../vd_inputMain.h"
#include "../EvDataManager/EvObserver/EventObserver.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../etg_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_DEVICE
#include "trcGenProj/Header/vd_input_StatusServiceHandler.cpp.trc.h"
#endif
#include "../EvDataManager/EvObserver/EventObserver.h"
#include "../EvDataManager/EvObserver/UsrActionEmu.h"

BEGIN_MSG_MAP(vd_input_StatusServiceHandler, ahl_tclBaseWork)
//Properties Get
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_PRESSEDKEYS, AMT_C_U8_CCAMSG_OPCODE_GET, HandlePressedKeys)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_ENCODERDIRSTATUS, AMT_C_U8_CCAMSG_OPCODE_GET, HandleEncoderDirList)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_ENCODERSTATUS, AMT_C_U8_CCAMSG_OPCODE_GET, HandleEncoderStatus)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_TOUCHSTATUS, AMT_C_U8_CCAMSG_OPCODE_GET, HandleTouchStatus)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_TOUCHSTATUSPIVISECONDARY, AMT_C_U8_CCAMSG_OPCODE_GET, HandlePIVISecondaryTouchStatus)
//Method Start and Result
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_ENABLEINPUTEVENTS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onEnableInputEvent)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_DISABLEINPUTEVENTS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDisableInputEvent)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_SIMULATEKEYINJECTION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onSimulateKeyInjection)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_SIMULATEENCROTATION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onSimulateEncRotation)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_SIMULATESINGLETOUCH, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onSimulateSingleTouch)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_SIMULATETOUCHSLIDE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onSimulateTouchSlide)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_SIMULATEMULTITOUCH, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onSimulateMultiTouch)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_GESTURERECORD, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onGuestureRecord)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_GESTUREREPLAY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onGuestureReplay)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_SIMULATEPIVITOUCH, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onSimulatePIVITouch)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_DEVINPUTNOTIFYCONNECTION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDevInputNotifyConnection)
ON_MESSAGE_SVCDATA(INPUT_MAINFI_C_U16_SIMULATEPIVITOUCHSLIDE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onSimulatePIVITouchSlide)
//End
END_MSG_MAP()


vd_input_StatusServiceHandler::vd_input_StatusServiceHandler(vd_input_tclMain* poMainAppl, tU16 u16ServiceID, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion):
								Ivd_input_tclServiceHandler(poMainAppl, u16ServiceID, u16ServiceMajorVersion, u16ServiceMinorVersion)

{
   pvd_inputAppInstance = poMainAppl;
   _pEvObserverObjRef = NULL;
   _pUsrActionEmuRef = NULL;
}

vd_input_StatusServiceHandler::~vd_input_StatusServiceHandler()
{
	pvd_inputAppInstance = NULL;
	_pEvObserverObjRef = NULL;
	 _pUsrActionEmuRef = NULL;
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_input_StatusServiceHandler::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
*
* Example how to get a reference:
*  Declaration in 'vd_vehicledataServicevehicledata.h':
*     Add forward declaration:
*         class Ivd_vehicledata_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_vehicledata_tclObject2Get*  pIObjRef;
*
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_vehicledata_tclObject2Get*>(_cpoMain->getHandler("Ivd_vehicledata_tclObject2Get"));
*     vd_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_input_StatusServiceHandler::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_input_StatusServiceHandler::vGetReferences() entered."));

   // vd_input_StatusServiceHandler: user specific code start
   vd_input_NULL_POINTER_CHECK(pvd_inputAppInstance);

   _pEvObserverObjRef = dynamic_cast<EventObserver*>(pvd_inputAppInstance->getHandler("EventObserver"));
   vd_input_NULL_POINTER_CHECK(_pEvObserverObjRef);
   _pUsrActionEmuRef = dynamic_cast<UsrActionEmu*>(pvd_inputAppInstance->getHandler("UsrActionEmu"));
   vd_input_NULL_POINTER_CHECK(_pUsrActionEmuRef);
   ETG_TRACE_USR4(("vd_input_StatusServiceHandler::vGetReferences() Exit."));
   // vd_input_StatusServiceHandler: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_input_StatusServiceHandler::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_input_StatusServiceHandler::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_input_StatusServiceHandler::vStartCommunication() entered."));
   // vd_input_StatusServiceHandler: user specific code start
   // vd_input_StatusServiceHandler: user specific code end
}

tVoid vd_input_StatusServiceHandler::vTraceInfo()
{
   ETG_TRACE_USR4(("vd_input_StatusServiceHandler::vTraceInfo() entered."));
   // vd_input_StatusServiceHandler: user specific code start
    // vd_input_StatusServiceHandler: user specific code end
}
/*******************************************************************************
*
* FUNCTION: tVoid vd_input_StatusServiceHandler::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_input_StatusServiceHandler::vHandleMessage(Ivd_inputBase::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_input_StatusServiceHandler::vHandleMessage() entered %u -> data: %d.", ETG_ENUM(vd_INT_MSG , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // vd_input_StatusServiceHandler: user specific code start
   // vd_input_StatusServiceHandler: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_vehicle_tclServiceHdlcsm::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_input_StatusServiceHandler::vOnServiceAvailable()
{
    ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   // vd_vehicledata_tclServiceHdlvehicledatavOnServiceAvailable: user specific code start
   // vd_vehicledata_tclServiceHdlvehicledatavOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_vehicle_tclServiceHdlcsm::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_input_StatusServiceHandler::vOnServiceUnavailable()
{
    ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   // vd_vehicledata_tclServiceHdlvehicledatavOnServiceUnavailable: user specific code start
   // vd_vehicledata_tclServiceHdlvehicledatavOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool vd_input_StatusServiceHandler
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool vd_input_StatusServiceHandler::bStatusMessageFactory(tU16 u16FunctionId,
                                                            amt_tclServiceData& roOutMsg,
                                                            amt_tclServiceData* poInMsg)
{

   ETG_TRACE_USR4(("\vd_input_StatusServiceHandler::bStatusMessageFactory()->u16FunctionId=%d",u16FunctionId));
   tBool bSuccess = FALSE;

   amt_tclServiceData oFinal(poInMsg);
   roOutMsg = oFinal;

   if (roOutMsg == oFinal)
   {
      bSuccess = TRUE;
	  ETG_TRACE_USR4(("SUCCESS, u16FunctionId = %d",u16FunctionId));
   }
   else
   {
	  ETG_TRACE_USR4(("WARNING!! FAILED, u16FunctionId = %d",u16FunctionId));
   }

   return bSuccess;
}

// Set of virtual functions
tVoid vd_input_StatusServiceHandler::vUpdateClients(tU16 u16FunctionId, amt_tclServiceData* roOutMsg)
{
   ETG_TRACE_USR4(("\vd_input_StatusServiceHandler::vUpdateClients()->u16FunctionId=%d",u16FunctionId));
   eUpdateClients(u16FunctionId, roOutMsg); //This is Base class Function
}

/*******************************************************************************
*
* FUNCTION: tBool vd_vehicle_tclServiceHdlcsm
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool vd_input_StatusServiceHandler
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
    (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
    (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

    tBool bSuccess = FALSE;

    tU16 u16FunctionId = poMessage->u16GetFunctionID();

    ETG_TRACE_USR4(("vd_input_StatusServiceHandler:bProcessSet() entered. FID = 0x%4x.", u16FunctionId));

    fi_tclVisitorMessage oVisitorMsg(poMessage);

    (tVoid)u16FunctionId; //lint
    
    return bSuccess;
} // bProcessSet


/******************************************************************************************************
 * FUNCTION   : tVoid vd_input_StatusServiceHandler::vOnLoopbackService(amt_tclServiceData* poMessage)
 * DESCRIPTION: This function is called from the vOnLoopback() function of this
 *              CCA application if a message from one of this applications
 *              services is received (so called self or loopback messages).
 * PARAMETER  : [IN] u16ServiceID = Identifier of the service from where the
 *                                message was sent.
 *              [IN] poMessage = Message object.
 * RETURNVALUE: -
 ********************************************************************************************************/
tVoid vd_input_StatusServiceHandler::vOnLoopbackService(amt_tclServiceData* poMessage)
{

   tU16 u16FunctionId = poMessage->u16GetFunctionID();
   ETG_TRACE_USR4(("vd_input_StatusServiceHandler :: vOnLoopbackService() entered. iFID = 0x%4x", u16FunctionId));

   switch (u16FunctionId)
   {
      case INPUT_MAINFI_C_U16_PRESSEDKEYS:
      {
            ETG_TRACE_USR4(("vd_input_StatusServiceHandler::vOnLoopbackService() entered case INPUT_MAINFI_C_U16_PRESSEDKEYS"));
            //User defined code
         //   HandlePressedKeys(poMessage); //calling handler function
      }
      break;
      default:
      {
         ETG_TRACE_ERR(("vd_input_StatusServiceHandler:: vOnLoopbackService(). Unknown iFID %u.", u16FunctionId));
      }
      break;
   }

}

/******************************************************************************************************
 * FUNCTION   : tBool vd_input_StatusServiceHandler::vEnableEventObserver()
 * DESCRIPTION: This function can be called by CCA Method Start onEnableInputEv or from vd_input_main
 * 				for starting threads to capture input events.
 * PARAMETER  :
 *
 * RETURNVALUE: -
 ********************************************************************************************************/
tBool vd_input_StatusServiceHandler::vEnableEventObserver()
{
	tBool bRetStatus = TRUE;
	ETG_TRACE_FATAL((": From New Releases Observer is automatically started , so no need to start using Method\n"));
#if 0 //This Method will do nothing as Observer will always be running
	vd_input_NULL_POINTER_CHECK_VAL(_pEvObserverObjRef);
	if(FALSE == EventObserver::bIsObserverActive)
	{
		if( _pEvObserverObjRef->startObserver() > 0)
			bRetStatus =  TRUE;
	}
#endif
	return bRetStatus;
}
/******************************************************************************************************
 * FUNCTION   : tBool vd_input_StatusServiceHandler::vDisableEventObserver()
 * DESCRIPTION: This function can be called by CCA Method Start onEnableInputEv or from vd_input_main
 * 				for stopping threads to capture input events.
 * PARAMETER  :
 *
 * RETURNVALUE: -
 ********************************************************************************************************/
tBool vd_input_StatusServiceHandler::vDisableEventObserver()
{
	ETG_TRACE_FATAL((": From New Releases Observer is automatically started , so no need to stop using Method\n"));
#if 0 //This Method will do nothing as Observer will always be running
	vd_input_NULL_POINTER_CHECK_VAL(_pEvObserverObjRef);
	_pEvObserverObjRef->stopObserver();
	return (EventObserver::bIsObserverActive); //value of observer
#endif
	return TRUE;
}


/**************************************************************************************************
 * Different Property Handlers
 ***************************************************************************************************/

tVoid vd_input_StatusServiceHandler::HandlePressedKeys(amt_tclServiceData* poMessage)
{
	input_mainfi_tclMsgPressedKeysStatus oStatus;
	input_fi_tcl_KeyInfo oKeyInfo;
	vd_input_NULL_POINTER_CHECK(_pEvObserverObjRef);
	Keylist* pKeyListRef = _pEvObserverObjRef->getKeyList(); //get reference to list
	Keylist::iterator tIterator;

	oStatus.KeyInfoList.tKeyInfoList.clear();
	if(NULL!=pKeyListRef) //null pointer check
	{
		_pEvObserverObjRef->lockKeyList();//lock the list for reading ++
		if(FALSE==pKeyListRef->empty())
		{
			for (tIterator = pKeyListRef->begin(); tIterator != pKeyListRef->end(); tIterator++)
			{
				//Extract the info from Keylist iterator
				oKeyInfo.e16KeyCode.enType = (input_fi_tcl_e16_KeyCode::tenType)tIterator->u16KeyCode;
				oKeyInfo.u8KeyStatus = tIterator->u8Status;

				//Push this element in CCA list type
				oStatus.KeyInfoList.tKeyInfoList.push_back(oKeyInfo);
			}
		}
		_pEvObserverObjRef->unlockKeyList(); //unlock  list after reading the data --
	}
	else
	{
		//Noting --Lint fix
	}

	ETG_TRACE_USR4(("vHandlePressedKeys - Fi list size = %d",oStatus.KeyInfoList.tKeyInfoList.size()));
	//Create Visitor Messge
	fi_tclVisitorMessage oResultMessage(oStatus,VD_INPUT_FI_MAJOR_VERSION);
	// Send new status to client
	vSendStatusAnswerVisitorMessage(poMessage, &oResultMessage);
	oKeyInfo.vDestroy();
	oStatus.vDestroy();

}

tVoid vd_input_StatusServiceHandler::HandleEncoderDirList(amt_tclServiceData* poMessage)
{
	input_mainfi_tclMsgEncoderDirStatusStatus oStatus;
	input_fi_tcl_EncInfo oEncoderInfo;
	vd_input_NULL_POINTER_CHECK(_pEvObserverObjRef);
	Encoderlist* pEncoderlist = _pEvObserverObjRef->getEncoderDirList(); //get reference to list
	Encoderlist::iterator tIterator;
    //Init Encoder List to size 0
	oStatus.tEncoderDirectionList.tEncInfoList.clear();
	if( NULL != pEncoderlist ) //null pointer check
	{
		_pEvObserverObjRef->lockEncoderList(); //lock the list for reading ++
		if(FALSE==pEncoderlist->empty())
		{
			for (tIterator = pEncoderlist->begin(); tIterator != pEncoderlist->end(); tIterator++)
			{
				//Extract the info from Encoder List iterator
				oEncoderInfo.e8EncoderType.enType = (input_fi_tcl_e8_EncoderType::tenType)tIterator->u16EncType;
				oEncoderInfo.s8EncSteps = tIterator->s8EncSteps;
				//Push this element in CCA list type
				oStatus.tEncoderDirectionList.tEncInfoList.push_back(oEncoderInfo);
			}
		}
		_pEvObserverObjRef->unlockEncoderList(); //unlock  list after reading the data --
	}

	ETG_TRACE_USR4(("vHandleEncoderDirList list size = %d",oStatus.tEncoderDirectionList.tEncInfoList.size()));
	//Create Visitor Message
	fi_tclVisitorMessage oResultMessage(oStatus,VD_INPUT_FI_MAJOR_VERSION);
	// Send new status to client
	vSendStatusAnswerVisitorMessage(poMessage, &oResultMessage);
	oEncoderInfo.vDestroy();
	oStatus.vDestroy();
}

tVoid vd_input_StatusServiceHandler::HandleEncoderStatus(amt_tclServiceData* poMessage)
{
	input_mainfi_tclMsgEncoderStatusStatus oStatus;
	vd_input_NULL_POINTER_CHECK(_pEvObserverObjRef);
	//Getting the values of Encoders from Event Observer Member function getEncoderStatus()
	_pEvObserverObjRef->getEncoderStatus(&oStatus);

	//Create Visitor Message
	fi_tclVisitorMessage oResultMessage(oStatus,VD_INPUT_FI_MAJOR_VERSION);
	// Send new status to client
	vSendStatusAnswerVisitorMessage(poMessage, &oResultMessage);
	oStatus.vDestroy();
}

tVoid vd_input_StatusServiceHandler::HandleTouchStatus(amt_tclServiceData* poMessage)
{
	input_mainfi_tclMsgTouchStatusStatus oStatus;
	input_fi_tcl_TouchInfo oTouchInfo;
	vd_input_NULL_POINTER_CHECK(_pEvObserverObjRef);
	Touchlist* pTouchlist = _pEvObserverObjRef->getTouchInfoList(); //get reference to list
	Touchlist::iterator tIterator;
    //Clear TouchList FI type
	oStatus.tTouchDataList.sTouchInfo.clear();
	if(NULL != pTouchlist)//null pointer check
	{
		_pEvObserverObjRef->lockTouchList(); //lock the list for reading ++
		if(FALSE == pTouchlist->empty())
		{
			for (tIterator = pTouchlist->begin(); tIterator != pTouchlist->end(); tIterator++)
			{
				//Extract the info from Encoder List iterator
				oTouchInfo.s32XCoord = tIterator->s32XCoord;
				oTouchInfo.s32YCoord =  tIterator->s32YCoord;
				oTouchInfo.e8TouchStatus.enType = (input_fi_tcl_e8_TouchStatus::tenType) tIterator->u8TouchStatus;

				//Push this element in CCA list type
				oStatus.tTouchDataList.sTouchInfo.push_back(oTouchInfo);
			}
		}
		_pEvObserverObjRef->unlockTouchList();//unlock the list after reading --
	}

	ETG_TRACE_USR4(("HandleTouchStatus list size = %d",oStatus.tTouchDataList.sTouchInfo.size()));

	//Create Visitor Message
	fi_tclVisitorMessage oResultMessage(oStatus,VD_INPUT_FI_MAJOR_VERSION);
	// Send new status to client
	vSendStatusAnswerVisitorMessage(poMessage, &oResultMessage);
	oTouchInfo.vDestroy();
	oStatus.vDestroy();
}
tVoid vd_input_StatusServiceHandler::HandlePIVISecondaryTouchStatus(amt_tclServiceData* poMessage)
{
	input_mainfi_tclMsgTouchStatusStatus oStatus;
	input_fi_tcl_TouchInfo oTouchInfo;
	vd_input_NULL_POINTER_CHECK(_pEvObserverObjRef);
	Touchlist* pTouchlist = _pEvObserverObjRef->getTouchInfoListPIVISecondary(); //get reference to list
	Touchlist::iterator tIterator;
    //Clear TouchList FI type
	oStatus.tTouchDataList.sTouchInfo.clear();
	if(NULL != pTouchlist)//null pointer check
	{
		_pEvObserverObjRef->lockTouchList_PIVISecondary(); //lock the list for reading ++
		if(FALSE == pTouchlist->empty())
		{
			for (tIterator = pTouchlist->begin(); tIterator != pTouchlist->end(); tIterator++)
			{
				//Extract the info from Encoder List iterator
				oTouchInfo.s32XCoord = tIterator->s32XCoord;
				oTouchInfo.s32YCoord =  tIterator->s32YCoord;
				oTouchInfo.e8TouchStatus.enType = (input_fi_tcl_e8_TouchStatus::tenType) tIterator->u8TouchStatus;

				//Push this element in CCA list type
				oStatus.tTouchDataList.sTouchInfo.push_back(oTouchInfo);
			}
		}
		_pEvObserverObjRef->unlockTouchList_PIVISecondary();//unlock the list after reading --
	}

	ETG_TRACE_USR4(("HandleTouchStatus Secondary list size = %d",oStatus.tTouchDataList.sTouchInfo.size()));

	//Create Visitor Message
	fi_tclVisitorMessage oResultMessage(oStatus,VD_INPUT_FI_MAJOR_VERSION);
	// Send new status to client
	vSendStatusAnswerVisitorMessage(poMessage, &oResultMessage);
	oTouchInfo.vDestroy();
	oStatus.vDestroy();
}

/**************************************************************************************************
 * Handlers for Method start and method result
 ***************************************************************************************************/
tVoid vd_input_StatusServiceHandler::onEnableInputEvent(amt_tclServiceData* poMessage)
{
	input_mainfi_tclMsgEnableInputEventsMethodResult oStatus;
	ETG_TRACE_USR4(("vd_input_StatusServiceHandler::onEnableInputEvent() SourceAPP ID  = %d",poMessage->u16GetSourceAppID()));
	oStatus.SimulationStatus = vEnableEventObserver(); //call Start Event Observer
	fi_tclVisitorMessage oResultMsg( oStatus );
	// send it to client
	vSendMethodResultVisitorMessage( poMessage, &oResultMsg );
	oStatus.vDestroy();
}

tVoid vd_input_StatusServiceHandler::onDisableInputEvent(amt_tclServiceData* poMessage)
{
	input_mainfi_tclMsgDisableInputEventsMethodResult oStatus;
	oStatus.SimulationStatus = 	vDisableEventObserver(); //call Stop Event Observer
	fi_tclVisitorMessage oResultMsg( oStatus );
	// send it to client
	vSendMethodResultVisitorMessage( poMessage, &oResultMsg );
	oStatus.vDestroy();
}

tVoid vd_input_StatusServiceHandler::onSimulateKeyInjection(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );

	input_mainfi_tclMsgsimulateKeyInjectionMethodStart oDataIn;
	input_mainfi_tclMsgsimulateKeyInjectionMethodResult oDataOut;
    // extract payload
    oInMsg.s32GetData( oDataIn );
    //Trace the payload
    ETG_TRACE_USR4(("Input Param: KeyCode= %d, Status = %d",oDataIn.e16Keycode.enType, oDataIn.u8KeyStatus));

    if (NULL != pvd_inputAppInstance )
    {
    	//callin main simulateKey Function by passing data
    	pvd_inputAppInstance->simulateKey((tU16)oDataIn.e16Keycode.enType, oDataIn.u8KeyStatus);
        // create the answer message
        fi_tclVisitorMessage oOutMsg( oDataOut );
        vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
    }

    oDataIn.vDestroy();
    oDataOut.vDestroy();

}

tVoid vd_input_StatusServiceHandler::onSimulateEncRotation(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );

	input_mainfi_tclMsgsimulateEncRotationMethodStart oDataIn;
	input_mainfi_tclMsgsimulateEncRotationMethodResult oDataOut;
    // extract payload
    oInMsg.s32GetData( oDataIn );
    //Trace the payload
    ETG_TRACE_USR4(("Input Param: EncoderType= %d, Steps = %d",oDataIn.e8EncoderType.enType, oDataIn.s8EncSteps));

    if (NULL != pvd_inputAppInstance )
    {
    	//callin main simulateEncoder Function by passing data
    	pvd_inputAppInstance->simulateEncoder((tU16)oDataIn.e8EncoderType.enType, (tS32)oDataIn.s8EncSteps);
        // create the answer message
        fi_tclVisitorMessage oOutMsg( oDataOut );
        vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
    }

    oDataIn.vDestroy();
    oDataOut.vDestroy();
}

tVoid vd_input_StatusServiceHandler::onSimulateSingleTouch(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );

	input_mainfi_tclMsgsimulateSingleTouchMethodStart oDataIn;
	input_mainfi_tclMsgsimulateSingleTouchMethodResult oDataOut;
    // extract payload
    oInMsg.s32GetData( oDataIn );
    //Trace the payload
    ETG_TRACE_USR4(("Input Param: X= %d, Y = %d, TouchStatus = %d",oDataIn.s32XCoord, oDataIn.s32YCoord, oDataIn.e8TouchStatus.enType));

    if (NULL != pvd_inputAppInstance )
    {

    	//callin main simulateTouch  Function by passing data and slot id as 0
    	pvd_inputAppInstance->simulateTouch(oDataIn.s32XCoord, oDataIn.s32YCoord,0 ,(tS32)oDataIn.e8TouchStatus.enType);
        // create the answer message
        fi_tclVisitorMessage oOutMsg( oDataOut );
        vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
    }

    oDataIn.vDestroy();
    oDataOut.vDestroy();
}

tVoid vd_input_StatusServiceHandler::onDevInputNotifyConnection(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );
	input_mainfi_tclMsgDevInputNotifyConnectionMethodStart oDataIn;
	input_mainfi_tclMsgDevInputNotifyConnectionMethodResult oDataOut;
	//extract payload
	oInMsg.s32GetData( oDataIn );

	//ETG_TRACE_USR4(("Input Param: Devicetype= %d, ConnectionStatus = %d,Device Name=%d",oDataIn.DeviceType.enType, oDataIn.DeviceConnectStatus.enType,oDataIn.DeviceName));
	if(_pEvObserverObjRef)
	{
		_pEvObserverObjRef->updateDeviceActivityCounter();
		//create answer message
		fi_tclVisitorMessage oOutMsg( oDataOut );
		vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
	}
	 oDataIn.vDestroy();
	 oDataOut.vDestroy();

}
//-----------------------------START FOR PIVI-----------------------------------------------------
tVoid vd_input_StatusServiceHandler::onSimulatePIVITouch(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );

	input_mainfi_tclMsgsimulatePIVITouchMethodStart oDataIn;
	input_mainfi_tclMsgsimulatePIVITouchMethodResult oDataOut;
    // extract payload
    oInMsg.s32GetData( oDataIn );
    //Trace the payload
    ETG_TRACE_USR4(("Input Param: X= %d, Y = %d,Screen No=%d, TouchStatus = %d",oDataIn.s32XCoord, oDataIn.s32YCoord,oDataIn.s32ScreenNumber, oDataIn.e8TouchStatus.enType));

    if (NULL != pvd_inputAppInstance )
    {

    	//callin main simulateTouch  Function by passing data and slot id as 0
    	pvd_inputAppInstance->simulateTouch(oDataIn.s32XCoord, oDataIn.s32YCoord,0 ,(tS32)oDataIn.e8TouchStatus.enType,oDataIn.s32ScreenNumber);
        // create the answer message
        fi_tclVisitorMessage oOutMsg( oDataOut );
        vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
    }

    oDataIn.vDestroy();
    oDataOut.vDestroy();
}

tVoid vd_input_StatusServiceHandler::onSimulatePIVITouchSlide(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );

	input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart oDataIn;
	input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult oDataOut;
	// extract payload
	oInMsg.s32GetData( oDataIn );
	//Trace the payload
	ETG_TRACE_USR4(("Input Param:Start[%d, %d]->End[%d, %d] Duration=%d",oDataIn.s32XStart, oDataIn.s32YStart,
					oDataIn.s32XEnd, oDataIn.s32YEnd, oDataIn.u16Duration));

	if (NULL != pvd_inputAppInstance )
	{

		//callin main simulateTouchSlide  Function by passing data
		pvd_inputAppInstance->simulateTouchSlide(oDataIn.s32XStart, oDataIn.s32YStart,
												 oDataIn.s32XEnd, oDataIn.s32YEnd, (tS32)oDataIn.u16Duration, 2);
		// create the answer message
		fi_tclVisitorMessage oOutMsg( oDataOut );
		vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
	}

	oDataIn.vDestroy();
	oDataOut.vDestroy();
}
//-----------------------END FOR PIVI------------------------------------------------------------
tVoid vd_input_StatusServiceHandler::onSimulateTouchSlide(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );

	input_mainfi_tclMsgsimulateTouchSlideMethodStart oDataIn;
	input_mainfi_tclMsgsimulateTouchSlideMethodResult oDataOut;
    // extract payload
    oInMsg.s32GetData( oDataIn );
    //Trace the payload
    ETG_TRACE_USR4(("Input Param:Start[%d, %d]->End[%d, %d] Duration=%d",oDataIn.s32XStart, oDataIn.s32YStart,
    		        oDataIn.s32XEnd, oDataIn.s32YEnd, oDataIn.u16Duration));

    if (NULL != pvd_inputAppInstance )
    {

    	//callin main simulateTouchSlide  Function by passing data
    	pvd_inputAppInstance->simulateTouchSlide(oDataIn.s32XStart, oDataIn.s32YStart,
    		        							 oDataIn.s32XEnd, oDataIn.s32YEnd, (tS32)oDataIn.u16Duration);
        // create the answer message
        fi_tclVisitorMessage oOutMsg( oDataOut );
        vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
    }

    oDataIn.vDestroy();
    oDataOut.vDestroy();
}

tVoid vd_input_StatusServiceHandler::onSimulateMultiTouch(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );

	input_mainfi_tclMsgsimulateMultiTouchMethodStart oDataIn;
	input_mainfi_tclMsgsimulateMultiTouchMethodResult oDataOut;
    // extract payload
    oInMsg.s32GetData( oDataIn );
    //Trace the payload
    ETG_TRACE_USR4(("Input Param:SlotID=%d X= %d, Y = %d, TouchStatus = %d",oDataIn.s32SlotId, oDataIn.s32XCoord, oDataIn.s32YCoord, oDataIn.e8TouchStatus.enType));

    if (NULL != pvd_inputAppInstance )
    {

    	//calling main simulateTouch  Function by passing data and slot id as 0
    	pvd_inputAppInstance->simulateTouch(oDataIn.s32XCoord, oDataIn.s32YCoord, oDataIn.s32SlotId ,(tS32)oDataIn.e8TouchStatus.enType);
        // create the answer message
        fi_tclVisitorMessage oOutMsg( oDataOut );
        vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
    }

    oDataIn.vDestroy();
    oDataOut.vDestroy();
}


tVoid vd_input_StatusServiceHandler::onGuestureRecord(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );

	input_mainfi_tclMsgGestureRecordMethodStart oDataIn;
	input_mainfi_tclMsgGestureRecordMethodResult oDataOut;
    // extract payload
    oInMsg.s32GetData( oDataIn );

    if (NULL != _pUsrActionEmuRef )
    {
    	if(oDataIn.FilePath != NULL)
    	{
    		ETG_TRACE_FATAL(("onGuestureRecord:Start/Stop: %d, Filepath: %s\n",oDataIn.u8StartStop, oDataIn.FilePath.szValue));
    		oDataOut.bSuccess = _pUsrActionEmuRef->record(oDataIn.u8StartStop, std::string(oDataIn.FilePath.szValue));
    	}
    	else
    	{   //Now the guesture get saved in default /tmp/InputEvent.txt
    		ETG_TRACE_FATAL(("onGuestureRecord:Start/Stop: %d, Filepath: Default \"/tmp/InputEvent.txt\"\n",oDataIn.u8StartStop));
    		oDataOut.bSuccess = _pUsrActionEmuRef->record(oDataIn.u8StartStop);
    	}
        // create the answer message
        fi_tclVisitorMessage oOutMsg( oDataOut );
        vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
    	ETG_TRACE_FATAL(("onGuestureRecord: Record Success = %d", oDataOut.bSuccess));
    }

    oDataIn.vDestroy();
    oDataOut.vDestroy();
}


tVoid vd_input_StatusServiceHandler::onGuestureReplay(amt_tclServiceData* poMessage)
{
	fi_tclVisitorMessage oInMsg( poMessage );

	input_mainfi_tclMsgGestureReplayMethodStart oDataIn;
	input_mainfi_tclMsgGestureReplayMethodResult oDataOut;
    // extract payload
    oInMsg.s32GetData( oDataIn );

    if (NULL != _pUsrActionEmuRef )
    {
    	if(oDataIn.FilePath != NULL)
    	{
    		ETG_TRACE_FATAL(("onGuestureReplay:Start/Stop: %d, Filepath: %s\n",oDataIn.u8StartStop, oDataIn.FilePath.szValue));
    		oDataOut.bSuccess = _pUsrActionEmuRef->replay(oDataIn.u8StartStop, std::string(oDataIn.FilePath.szValue));
    	}
    	else
    	{   //Now the guesture get saved in default /tmp/InputEvent.txt
    		ETG_TRACE_FATAL(("onGuestureReplay:Start/Stop: %d, Filepath: Default \"/tmp/InputEvent.txt\"\n",oDataIn.u8StartStop));
    		oDataOut.bSuccess = _pUsrActionEmuRef->replay(oDataIn.u8StartStop);
    	}
        // create the answer message
        fi_tclVisitorMessage oOutMsg( oDataOut );
        vSendMethodResultVisitorMessage(poMessage, &oOutMsg);
    	ETG_TRACE_FATAL(("onGuestureReplay: REPLAY Success = %d", oDataOut.bSuccess));
    }

    oDataIn.vDestroy();
    oDataOut.vDestroy();
}



//**************************************************************************************************************
// Common Functions
//**************************************************************************************************************

/******************************************************************************************************
*
* FUNCTION:    tVoid vSendStatusAnswerVisitorMessage( const amt_tclServiceData* poMessage,
*                                                     fi_tclVisitorMessage* poResultMsg )
*
* DESCRIPTION: send messages function for message made with
*              tcl_VistorMessages
*
* PARAMETER:   Function - Visitor message to send
*
* RETURNVALUE: void
*
*******************************************************************************************************/
tVoid vd_input_StatusServiceHandler::vSendStatusAnswerVisitorMessage( const amt_tclServiceData* poMessage,
                                                                      fi_tclVisitorMessage* poResultMsg )
{
   ETG_TRACE_USR4(("vd_input_StatusServiceHandler::vSendStatusAnswerVisitorMessage"));
   // initialise result message
   poResultMsg->vInitServiceData( CCA_C_U16_APP_VD_INPUT,                 // source
                                  poMessage->u16GetSourceAppID(),    // Target
                                  AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
                                  0,                                 // StreamCounter
                                  poMessage->u16GetRegisterID(),     // RegisterID
                                  poMessage->u16GetCmdCounter(),     // nCmdCounter,
                                  CCA_C_U16_SRV_VD_INPUT,                 // nServiceID,
                                  poMessage->u16GetFunctionID(),     // function ID
                                  AMT_C_U8_CCAMSG_OPCODE_STATUS
                                );
   // send it to one client
  // (tVoid)bSendVisitorMessage( poResultMsg, poMessage->u16GetSourceAppID() );
   this->ePostMessage(poResultMsg); //this will send result message
}

/******************************************************************************************************
*
* FUNCTION:    tVoid vSendMethodResultVisitorMessage( const amt_tclServiceData* poMessage,
*                                                     fi_tclVisitorMessage* poResultMsg )
*
* DESCRIPTION: send messages function for message made with
*              tcl_VistorMessages
*
* PARAMETER:   Function - Visitor message to send method result
*
* RETURNVALUE: void
*
*******************************************************************************************************/
tVoid vd_input_StatusServiceHandler::vSendMethodResultVisitorMessage( const amt_tclServiceData* poMessage,
                                                                      fi_tclVisitorMessage* poResultMsg )
{
   ETG_TRACE_USR4(("vd_input_StatusServiceHandler::vSendMethodResultVisitorMessage"));
   // initialise result message
   poResultMsg->vInitServiceData( CCA_C_U16_APP_VD_INPUT,            // source
                                  poMessage->u16GetSourceAppID(),    // Target
                                  AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
                                  0,                                 // StreamCounter
                                  poMessage->u16GetRegisterID(),     // RegisterID
                                  poMessage->u16GetCmdCounter(),     // nCmdCounter,
                                  CCA_C_U16_SRV_VD_INPUT,            // nServiceID,
                                  poMessage->u16GetFunctionID(),     // function ID
                                  AMT_C_U8_CCAMSG_OPCODE_METHODRESULT
                                );
   // send it to client
   this->ePostMessage(poResultMsg); //this will send result message
}



