/*****************************************************************************
* FILE:         vd_clock_Client__CLIENT_NAME__.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     CsmClient.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/


#ifndef _VD_CLOCKTRACE_H_
#define _VD_CLOCKTRACE_H_

// __APPL_APP_MAIN_TRACE__Includes: user specific code start

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define FC_CLOCK_S_IMPORT_INTERFACE_MSG
#define FC_CLOCK_S_IMPORT_INTERFACE_GENERIC
#include "vd_clock_If.h"
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE //fi_tclVisitorMessage
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "common_fi_if.h"

#include "../../appl/vd_clock_datetime.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ETRACE_S_IMPORT_INTERFACE_ERRMEM
#include "etrace_if.h"

#define ETG_TRACING

#define VDCLOCK_ASSERT_NORMAL_RETURN(expr)             \
    if (!(expr)) {                                   \
        NORMAL_M_ASSERT_ALWAYS();                     \
        return;                                      \
    }
#define VDCLOCK_ASSERT_NORMAL_RETURN_VAL(expr, retval) \
    if (!(expr)) {                                   \
        NORMAL_M_ASSERT_ALWAYS();                     \
        return (retval);                             \
    }
#define VDCLOCK_ASSERT_FATAL_RETURN(expr)   \
    if (!(expr)) {                        \
        FATAL_M_ASSERT_ALWAYS();          \
        return;                           \
    }


#define VDCLOCK_ASSERT_FATAL_RETURN_VAL(expr, retval)  \
    if (!(expr)) {                                   \
        FATAL_M_ASSERT_ALWAYS();                     \
        return (retval);                             \
    }
#define TRACE_FLOW(call) if(traceFlow::mbEnableFuncTracing) { call };

enum TR_TEN_FlowEvents
{
   TR_EN_FlowEventInvoke = 0,
   TR_EN_FlowEventCTOR,
   TR_EN_FlowEventInit,
   TR_EN_FlowEventClose,
   TR_EN_FlowEventDTOR
};

enum TR_EN_EventCodes
{
   TR_EN_EventStatus      = 0,
   TR_EN_EventMask,
   TR_EN_EventPosted,
   TR_EN_EventReset,
   TR_EN_EventReceived
};
enum TR_TEN_MsgCodes
{
   TR_EN_MsgCode_CCA_InMessage      = 0xF803,
   TR_EN_MsgCode_CCA_OutMessage     = 0xF804,
   TR_EN_MsgCode_DateTime           = 0xF802,
   TR_EN_MsgCode_Minute             = 0xF801,
   TR_EN_MsgCode_NotifEntry         = 0xF805,
   TR_EN_MsgCode_OsalDateTime       = 0xF806
};

enum TR_TEN_EtasCodes
{
   TR_EN_EtasCode_CanState         = 0,
   TR_EN_EtasCode_CsmLocalTimeSent = 1,
   TR_EN_EtasCode_CsmLocalTimeNotSent = 2,
   TR_EN_EtasCode_LocalTimeAdjusted = 3
};

// Trace Defines
#define CLOCK_TRCL_DATA_TIMEINFO       0x0002


// ============================================================================
// defines and macros (scope: global)


// ==========================================================================
/*
enum VDCLK_TRACE_CLASSES	// (based on ApplicationID taken from tri_types.h)
{
	TR_CLASS_VD_CLOCK_APPLICATION				=  (TR_COMP_CLOCK),
	TR_CLASS_VD_CLOCK_SERVER_CLOCK,
	TR_CLASS_VD_CLOCK_CLIENT_SPM,
	TR_CLASS_VD_CLOCK_CLIENT_POS,
	TR_CLASS_VD_CLOCK_CLIENT_SENSOR,
	TR_CLASS_VD_CLOCK_EXTSOURCELISTENER,
	TR_CLASS_VD_CLOCK_CONTAINER,
	TR_CLASS_VD_CLOCK_DATETIME,
	TR_CLASS_VD_CLOCK_UPDATER,
	TR_CLASS_VD_CLOCK_TIMEZONE,
	TR_CLASS_VD_CLOCK_EVENT,
	TR_CLASS_VD_CLOCK_UTILS,
	TR_CLASS_VD_CLOCK_TICKTIMER,
	TR_CLASS_VD_CLOCK_INCADAPTER
};
*/
#define VDCLK_OsalErrorString() OSAL_coszErrorText(OSAL_u32ErrorCode())

#ifdef SKIP_TRACE
#define TRACE_OSALDateTime( rDateTime, u16Class, u16Line )  {}
#define TRACE_DateTime( oDateTime, u16Class, u16Line )  {}
#define TRACE_Minute( oDateTime, oRTCDateTime, u16Class, u16Line ) {}
#define TRACE_CSM_Message(au8BufData, u8BufLen, u16Class, u16Line)  {}
#define TRACE_CCA_InMessage(poMessage, u16Class, u16Line)   {}
#define TRACE_CCA_OutMessage(poMessage, u16Class, u16Line)   {}
#define TRACE_NotificationEntry(pEntry, u16Class, u16Line) {}
#define TRACE_Etas(u16Id, u32Arg1, u32Arg2, u32Arg3, u32Arg4) {}
#else

// (ApplicationID taken from tri_types.h)
//#define VDCLK_TRACE_CLASS_MAIN        (TR_COMP_CLOCK)

// Common-Layout:
//
//  |   0   |  1  ...  2  |   3   |   4   |   5   |  6  ...  7  |  8 ... 9    |
//  |Length |   ClassID   | Level | stat. | res.  |    MsgCode  |   LineNo    |









// ---   TRACE_Pointer   ---
//
//  |  9   ...  12   |  13  ...  x  |
//  |    Pointer     | PointerName  |

#define TRACE_Pointer( Level, Pointer , PointerName, u16Class, u16Line )   \
 if (et_bIsTraceActive(u16Class, (tU16) Level))                                   \
   {                                                                       \
      et_vTraceBinary                                                      \
      (                                                                    \
      u16Class,                                                            \
      (tU16) Level,                                                        \
      ET_EN_T16 _ u16Line _                                                \
      ET_EN_T8 _ (tU8) TR_EN_MsgCode_InvalidPointer _                      \
      ET_EN_T32 _ (tU32) Pointer _                                         \
      ET_EN_STRING _ PointerName _                                         \
      ET_EN_DONE                                                           \
      );                                                                   \
   }



// ---   TRACE_OSALTimeDate   ---
//
//  |  9   ...  10  |   11   |  12   |   13    |   14   |   15   |
//  |      Year     | Month  |  Day  |  Hours  |  Min.  |  Sec.  |

#define TRACE_OSALDateTime(sLocation, rDateTime, u16Class, u16Line )    \
{\
   if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_USER_2) /*== TRUE*/)      \
      et_vTraceBinary                                                      \
      (                                                                    \
      u16Class,                                                            \
      (tU16) TR_LEVEL_USER_2,                                               \
      ET_EN_T16 _ (tU16) TR_EN_MsgCode_OsalDateTime _                            \
      ET_EN_T16 _ u16Line _                                                \
      ET_EN_T16 _ (tU16) rDateTime.s32Year _                               \
      ET_EN_T8 _ (tU8) rDateTime.s32Month _                                \
      ET_EN_T8 _ (tU8) rDateTime.s32Day _                                  \
      ET_EN_T8 _ (tU8) rDateTime.s32Hour _                                 \
      ET_EN_T8 _ (tU8) rDateTime.s32Minute _                               \
      ET_EN_T8 _ (tU8) rDateTime.s32Second _                               \
      ET_EN_STRING _ sLocation _                                           \
      ET_EN_DONE                                                           \
      ); \
}


// ---   TRACE_TimeDate   ---
//
//  |  9   ...  10  |   11   |  12   |   13    |   14   |   15   |   16   |
//  |      Year     | Month  |  Day  |  Hours  |  Min.  |  Sec.  |  Valid |

#define TRACE_DateTime( sLocation, oDateTime, u16Class, u16Line )    \
{                                                           \
   tS16  yy = 0;   tU8   mm = 0;   tU8  dd = 0;             \
   tU8   hh = 0;   tU8   nn = 0;   tU8  ss = 0;             \
   tU8   wd = 0;                                            \
   oDateTime.u8GetComponents(&yy, &mm, &dd, &hh, &nn, &ss, &wd); \
   tU8   u8State = oDateTime.u8IsDateTimeValid();           \
                                                            \
 if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_USER_2))    \
      et_vTraceBinary                                       \
      (                                                     \
      u16Class,                                             \
      (tU16) TR_LEVEL_USER_2,                               \
      ET_EN_T16 _ (tU16) TR_EN_MsgCode_DateTime _             \
      ET_EN_T16 _ u16Line _                                 \
      ET_EN_T16 _ yy _                                      \
      ET_EN_T8 _ mm _                                       \
      ET_EN_T8 _ dd _                                       \
      ET_EN_T8 _ hh _                                       \
      ET_EN_T8 _ nn _                                       \
      ET_EN_T8 _ ss _                                       \
      ET_EN_T8 _ wd _                                       \
      ET_EN_T8 _ u8State _                                  \
      ET_EN_T32 _ (oDateTime).u32GetValue() _               \
      ET_EN_STRING _ sLocation _                            \
      ET_EN_DONE                                            \
      );                                                    \
}
// minute change notification
#define TRACE_Minute( sLocation, oDateTime, oRTCDateTime, u16Class, u16Line ) \
{\
   tS16  yyL = 0;   tU8   mmL = 0;   tU8  ddL = 0;       \
   tU8   hhL = 0;   tU8   nnL = 0;   tU8  ssL = 0;       \
   tU8   wdL = 0;                                        \
   tS16  yyR = 0;   tU8   mmR = 0;   tU8  ddR = 0;       \
   tU8   hhR = 0;   tU8   nnR = 0;   tU8  ssR = 0;       \
   tU8   wdR = 0;                                        \
   oDateTime.u8GetComponents(&yyL, &mmL, &ddL, &hhL, &nnL, &ssL, &wdL);  \
   oRTCDateTime.u8GetComponents(&yyR, &mmR, &ddR, &hhR, &nnR, &ssR, &wdR);  \
                                                                  \
   if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_COMPONENT))     \
      et_vTraceBinary                                             \
      (                                                           \
      u16Class,                                                   \
      (tU16) TR_LEVEL_COMPONENT,                                  \
      ET_EN_T16 _ (tU16) TR_EN_MsgCode_Minute _                   \
      ET_EN_T16 _ u16Line _                                       \
      ET_EN_T16 _ yyL _                                           \
      ET_EN_T8 _ mmL _                                            \
      ET_EN_T8 _ ddL _                                            \
      ET_EN_T8 _ hhL _                                            \
      ET_EN_T8 _ nnL _                                            \
      ET_EN_T8 _ ssL _                                            \
      ET_EN_T8 _ wdL _                                            \
      ET_EN_T16 _ yyR _                                           \
      ET_EN_T8 _ mmR _                                            \
      ET_EN_T8 _ ddR _                                            \
      ET_EN_T8 _ hhR _                                            \
      ET_EN_T8 _ nnR _                                            \
      ET_EN_T8 _ ssR _                                            \
      ET_EN_T8 _ wdR _                                            \
      ET_EN_STRING _ sLocation _                                  \
      ET_EN_DONE                                                  \
      );                                                          \
}


// ---   TRACE_NotificationEntry   ---
//
//  |  9 ... 10 | 11 ... 12 | 13 ... 14 | 15 ... 18 |     19    |
//  |   AppID   |   RegID   |  CmdCount |   pNext   |  UpdMask  |

#define TRACE_NotificationEntry(pEntry, u16Class, u16Line) \
{\
   if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_USER_3)) \
      et_vTraceBinary                                       \
      (                                                     \
      u16Class,                                             \
      (tU16) TR_LEVEL_USER_3,                              \
      ET_EN_T16 _ (tU16) TR_EN_MsgCode_NotifEntry _           \
      ET_EN_T16 _ u16Line _                                 \
      ET_EN_T16 _ pEntry.u16AppID _                         \
      ET_EN_T16 _ pEntry.u16RegisterID _                    \
      ET_EN_T16 _ pEntry.u16CmdCounter _                    \
      ET_EN_T32 _ pEntry.pNext _                            \
      ET_EN_T8  _ pEntry.u8NotifyConditionMask _            \
      ET_EN_DONE                                            \
      );                                                    \
}


#define TRACE_Etas(u16Id, u32Arg1, u32Arg2, u32Arg3, u32Arg4) \
    {                                                         \
        if (et_bIsTraceActive(VDCLK_TRACE_CLASS_ETAS, (tU16)TR_LEVEL_USER_4)) \
            et_vTraceBinary                                     \
                (                                               \
                 VDCLK_TRACE_CLASS_ETAS,                        \
                 (tU16) TR_LEVEL_USER_4,                        \
                 ET_EN_T16 _ u16Id _                            \
                 ET_EN_T32 _ u32Arg1 _                         \
                 ET_EN_T32 _ u32Arg2 _                         \
                 ET_EN_T32 _ u32Arg3 _                         \
                 ET_EN_T32 _ u32Arg4 _                         \
                 ET_EN_DONE                                     \
                 );                                             \
    }

// ---   TRACE_Event   ---
//
//  |  9   ...  12   |
//  |  Event-Mask    |










#define TRACE_CCA_InMessage(poMessage, u16Class, u16Line)                  \
{                                                                          \
 if ( et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_USER_1)                   \
   || et_bIsTraceActive((tU16) VDCLK_TRACE_CLASS_MESSAGES, (tU16)TR_LEVEL_USER_1)) \
 {                                                                         \
    tU32 u32MsgSize = (poMessage)->u32GetSize();                           \
    tU8 u8DataSize = (tU8) (u32MsgSize > 287 ? 255 : u32MsgSize - 32);     \
    {                                                                      \
      tU8* pu8MsgData = (poMessage)->pu8GetSharedMemBase() + 32;           \
      et_vTraceBinary                                                      \
      (                                                                    \
         u16Class,                                                         \
         (tU16) TR_LEVEL_USER_1,                                           \
         ET_EN_T16 _ (tU16) TR_EN_MsgCode_CCA_InMessage  _                   \
         ET_EN_T16 _ u16Line _                                             \
         ET_EN_T16 _ (poMessage)->u16GetSourceAppID() _                    \
         ET_EN_T16 _ (poMessage)->u16GetFunctionID() _                     \
         ET_EN_T8  _ (poMessage)->u8GetOpCode() _                          \
         ET_EN_T8LIST _ u8DataSize _ pu8MsgData _                          \
         ET_EN_DONE                                                        \
      );                                                                   \
    }                                                                      \
  }                                                                        \
}                                                                          \

#define TRACE_CCA_OutMessage(poMessage, u16Class, u16Line)                 \
{                                                                          \
 if (et_bIsTraceActive((tU16) VDCLK_TRACE_CLASS_MESSAGES, (tU16)TR_LEVEL_USER_1)  \
   || et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_USER_1))                  \
 {                                                                         \
    tU32 u32MsgSize = (poMessage)->u32GetSize();                           \
    tU8 u8DataSize = (tU8) (u32MsgSize > 287 ? 255 : u32MsgSize - 32);     \
    {                                                                      \
      tU8* pu8MsgData = (poMessage)->pu8GetSharedMemBase() + 32;           \
      et_vTraceBinary                                                      \
      (                                                                    \
         u16Class,                                                         \
         (tU16) TR_LEVEL_USER_1,                                           \
         ET_EN_T16 _ (tU16) TR_EN_MsgCode_CCA_OutMessage  _                  \
         ET_EN_T16 _ u16Line _                                             \
         ET_EN_T16 _ (poMessage)->u16GetTargetAppID() _                    \
         ET_EN_T16 _ (poMessage)->u16GetFunctionID() _                     \
         ET_EN_T8  _ (poMessage)->u8GetOpCode() _                          \
         ET_EN_T8LIST _ u8DataSize _ pu8MsgData _                          \
         ET_EN_DONE                                                        \
      );                                                                   \
    }                                                                      \
  }                                                                        \
}                                                                          \


#endif  // SKIP_TRACE


// __APPL_APP_MAIN_TRACE__Includes: user specific code end

enum tenTrcTraceClass__APP_NAME__ {
     TR_CLASS_VD_CLOCK_APPLICATION  = 0x4400 + 0,
     TR_CLASS_VD_CLOCK_SERVER_CLOCK  = 0x4400 + 1,
     TR_CLASS_VD_CLOCK_CLIENT_POS  = 0x4400 + 2,
     TR_CLASS_VD_CLOCK_CLIENT_SENSOR  = 0x4400 + 3,
     TR_CLASS_VD_CLOCK_CLIENT_DIAGLOG  = 0x4400 + 4,
     TR_CLASS_VD_CLOCK_CLIENT_SPM  = 0x4400 + 5,
     TR_CLASS_VD_CLOCK_CLIENT_SENSOR_PV  = 0x4400 + 6,
     TR_CLASS_VD_CLOCK_CLIENT_PROFILE  = 0x4400 + 7,

// __APP_NAME___TraceHEnum: user specific code start
 	TR_CLASS_VD_CLOCK_EXTSOURCELISTENER = 0x4400 + 8,
 	TR_CLASS_VD_CLOCK_CONTAINER         = 0x4400 + 9,
 	TR_CLASS_VD_CLOCK_DATETIME          = 0x4400 + 0x0A,
 	TR_CLASS_VD_CLOCK_UPDATER           = 0x4400 + 0x0B,
 	TR_CLASS_VD_CLOCK_TIMEZONE          = 0x4400 + 0x0C,
 	TR_CLASS_VD_CLOCK_EVENT             = 0x4400 + 0x0D,
 	TR_CLASS_VD_CLOCK_UTILS             = 0x4400 + 0x0E,
 	TR_CLASS_VD_CLOCK_TICKTIMER         = 0x4400 + 0x0F,
 	TR_CLASS_VD_CLOCK_INCADAPTER        = 0x4400 + 0x10,
// __APP_NAME___TraceHEnum: user specific code end

     TR_CLASS_VD_CLOCK_MAX
};

#define VD_CLOCK_VD_CLOCK_CMDHELP                                                           0x0001
#define VD_CLOCK_VD_CLOCK_POSTBROADCASTCMD                                                  0x0002
#define VD_CLOCK_VD_CLOCK_POSTBROADCASTCMDPARAM                                             0x0003
#define VD_CLOCK_VD_CLOCK_POSTCMDTOCLASS                                                    0x0004
#define VD_CLOCK_VD_CLOCK_TRACEINFO                                                         0x0005
#define VD_CLOCK_VD_CLOCK_VDCLK_GETTIME                                                     0x0006
#define VD_CLOCK_VD_CLOCK_VDCLK_GETIMEFORMAT                                                0x0007
#define VD_CLOCK_VD_CLOCK_VDCLK_GETDATEFORMAT                                               0x0008
#define VD_CLOCK_VD_CLOCK_VDCLK_GETGPSAUTOSYNC                                              0x0009
#define VD_CLOCK_VD_CLOCK_VDCLK_GETSYNCMODE                                                 0x000a
#define VD_CLOCK_VD_CLOCK_VDCLK_GETDST                                                      0x000f
#define VD_CLOCK_VD_CLOCK_VDCLK_GETTIMEZONE                                                 0x0010
#define VD_CLOCK_VD_CLOCK_VDCLK_SETTIMEFORMAT                                               0x000b
#define VD_CLOCK_VD_CLOCK_VDCLK_SETDATEFORMAT                                               0x000c
#define VD_CLOCK_VD_CLOCK_VDCLK_SETNEWDATEFORMAT                                            0x001f
#define VD_CLOCK_VD_CLOCK_VDCLK_SETTIME                                                     0x000d
#define VD_CLOCK_VD_CLOCK_VDCLK_SETGPSAUTOSYNC                                              0x000e
#define VD_CLOCK_VD_CLOCK_VDCLK_SETTIMEZONE                                                 0x0011
#define VD_CLOCK_VD_CLOCK_VDCLK_SETDST                                                      0x0012
#define VD_CLOCK_VD_CLOCK_VDCLK_SETINCTIME                                                  0x0013
#define VD_CLOCK_VD_CLOCK_VDCLK_GETAUTOTIMEZONE_OFFSET                                      0x0015
#define VD_CLOCK_VD_CLOCK_VDCLK_SETAUTOTIMEZONE_OFFSET                                      0x0016
#define VD_CLOCK_VD_CLOCK_VDCLK_GETLOCALTIMEDATE                                            0x0017
#define VD_CLOCK_VD_CLOCK_VDCLK_SETLOCALTIMEDATE                                            0x0018
#define VD_CLOCK_VD_CLOCK_VDCLK_GETLOCALTIMEDATE_MINUTEUPDATE                               0x0019
#define VD_CLOCK_VD_CLOCK_VDCLK_SETLOCALTIMEDATE_MINUTEUPDATE                               0x001a
#define VD_CLOCK_VD_CLOCK_VDCLK_GETREGIONTIMEZONE                                           0x001b
#define VD_CLOCK_VD_CLOCK_VDCLK_SETREGIONTIMEZONE                                           0x001c
#define VD_CLOCK_VD_CLOCK_VDCLK_HW_VERSIONINFO                                              0x001d
#define VD_CLOCK_VD_CLOCK_VDCLK_SW_VERSIONINFO                                              0x001e
#define VD_CLOCK_VD_CLOCK_PROFILE_SIMULATION                                                0x0020



#endif // _VD_CLOCKTRACE_H_

