/*****************************************************************************
* FILE:         vd_clock_AppMain.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     applMain.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "vd_clock_AppMain.h"

// vd_clock_tclAppMainIncludes: user specific code start
#include "vd_clock_datacontainer.h"
#include "vd_clock_updater.h"
#include "vd_clock_INCAdapter.h"
#include "../../appl/DiagSystemSetListener.h"

//tU8 vd_clock_tclAppMain::m_u8INC_msg_buff[60]={0};

/************************************************
* Helper class for administration of a property
*************************************************/
/*
 constructor
vdclock_tclPropertyAdmin::vdclock_tclPropertyAdmin()
   : _bRegDone(FALSE)
   , _bRegInProgress(FALSE)
   , _bUnRegInProgress(FALSE)
{
}*/

// vd_clock_tclAppMainIncludes: user specific code end

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_APPLICATION
#include "trcGenProj/Header/vd_clock_AppMain.cpp.trc.h"
#endif


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/

// Static self reference to be used in function callbacks.
vd_clock_tclAppMain* vd_clock_tclAppMain::_poMainAppInstance = NULL;

tUChar  vd_clock_tclAppMain::_auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE] = {0};

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
* FUNCTION   : vd_clock_tclAppMain::theServer()
* DESCRIPTION: Creates new server object by using the singleton pattern.
* PARAMETER  : None.
* RETURNVALUE: Pointer to the instance of this application.
*******************************************************************************/
vd_clock_tclAppMain* vd_clock_tclAppMain::theServer()
{
   if ( NULL == _poMainAppInstance )
   {
      _poMainAppInstance = new vd_clock_tclAppMain();
   }
   return _poMainAppInstance;
}


/*******************************************************************************
*
* FUNCTION: vd_clock_tclAppMain::vd_clock_tclAppMain()
*
* DESCRIPTION: Constructor.
*
*              Initialize static self reference to be used in function
*              callbacks.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclAppMain::vd_clock_tclAppMain():ahl_tclBaseOneThreadApp(CCA_C_U16_APP_VD_CLOCK)
{
   ETG_TRACE_USR4(("vd_clock_tclAppMain() entered."));

   vd_clock_tclAppMain::_poMainAppInstance   = this;
   
   _bStartPerformed = FALSE;   

   // vd_clock_tclAppMainConstructor: user specific code start
   m_poServiceDiaglib = NULL;
   m_poSystemSetListener = NULL;
   _bfirstupdate = TRUE;
   _bSContActive = FALSE;
   // vd_clock_tclAppMainConstructor: user specific code end

   vTracePlugIn();
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclAppMain::~vd_clock_tclAppMain()
*
* DESCRIPTION: Destructor.
*
*              Invalidate static self reference.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclAppMain::~vd_clock_tclAppMain()
{
   ETG_TRACE_USR4(("~vd_clock_tclAppMain() entered."));

   // --- unplug TTFIS trace ---
   vTraceUnplug();   

   // vd_clock_tclAppMainDestructor: user specific code start
   m_poServiceDiaglib = NULL;
   m_poSystemSetListener = NULL;
   _bfirstupdate = FALSE;
   // vd_clock_tclAppMainDestructor: user specific code end

   vd_clock_tclAppMain::_poMainAppInstance = NULL;
}

/*******************************************************************************
*
* FUNCTION: tBool vd_clock_tclAppMain::vStart()
*
* DESCRIPTION:
*
* PARAMETER: None.
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid vd_clock_tclAppMain::vStart(tVoid)
{

   if (!_bStartPerformed) {

      // vd_clock_tclAppMainvStart: user specific code start
      // vd_clock_tclAppMainvStart: user specific code end
   
      vGetReferences();
      vStartCommunication();
      
       _bStartPerformed = TRUE;   
   }
}

/*******************************************************************************
*
* FUNCTION: tBool vd_clock_tclAppMain::bOnInit()
*
* DESCRIPTION: This function is called by the CCA framework before starting any
*              CCA message related communication action. As default this
*              function always returns TRUE. The user has to implement all his
*              local application initialization (create client and service
*              handler, create worker threads, allocate application memory,...).
*              If returns TRUE, initialization could be successfully performed
*              and framework will register application, else, a reset of the
*              system is forced immediately.
*
*              This function is the counterpart of vOnApplicationClose().
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = Application successfully initialized.
*              FALSE = Application NOT successfully initialized.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
*******************************************************************************/
tBool vd_clock_tclAppMain::bOnInit()
{
   tBool bSuccess = TRUE;

   ETG_TRACE_USR4(("bOnInit() entered."));

   while (!_bStartPerformed) {
       OSAL_s32ThreadWait(100);
       ETG_TRACE_FATAL(("vd_clock_tclAppMain::bOnInit(): vStart not called now --> wait."));
   }
   
   // vd_clock_tclAppMainbOnInit: user specific code start
	m_poServiceDiaglib = new diaglib::tclServiceDiaglib(this, 0x01);
	if (NULL == m_poServiceDiaglib)
	{
		bSuccess = FALSE;
		NORMAL_M_ASSERT_ALWAYS();
	}
	else
	{
		ETG_TRACE_USR1(("bOnInit() - DIAGLib service created"));
		diaglib::tclSystemSetIF* m_poSystemSetIF;
		vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
		m_poSystemSetIF = m_poServiceDiaglib->poGetSysSet();
		m_poSystemSetListener = new tclSystemSetListener(m_poSystemSetIF, this,_poContainer);
		if (m_poSystemSetListener != NULL)
		{
			m_poSystemSetIF->vRegisterListener( SYSSETID_CLOC, diaglib::EN_TYPE_DEFAULT_TEF, m_poSystemSetListener );
			m_poSystemSetIF->vRegisterListener( SYSSETID_CLOC, diaglib::EN_TYPE_DEFAULT_HMI, m_poSystemSetListener );
			m_poSystemSetIF->vRegisterListener( SYSSETID_CLOC, diaglib::EN_TYPE_CODING,      m_poSystemSetListener );
			ETG_TRACE_USR1(("bOnInit() - DIAG SystemSet Listener registered"));
		}
		else
		{
			ETG_TRACE_USR1(("bOnInit() - ERROR - DIAG SystemSet Listener could not be registered"));
		}
		/*            if(_poContainer)
            {
               _poContainer->vSetDefaultSettings(TRUE);
            }*/
	}

   // vd_clock_tclAppMainbOnInit: user specific code end

   
   return bSuccess;
}

/********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState).
*******************************************************************************/
/*tVoid vd_clock_tclAppMain::vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState)
{
    if (u32AppState == AMT_C_U32_STATE_OFF) {
        // vd_clock_tclAppMainvOnNewAppStateOff: user specific code start
        // vd_clock_tclAppMainvOnNewAppStateOff: user specific code end
    } else {
        // vd_clock_tclAppMainvOnNewAppStateNotOff: user specific code start
        // vd_clock_tclAppMainvOnNewAppStateNotOff: user specific code end
    }
  
    // vd_clock_tclAppMainvOnNewAppState: user specific code start


    // vd_clock_tclAppMainvOnNewAppState: user specific code end

    ahl_tclBaseOneThreadApp::vOnNewAppState(u32OldAppState, u32AppState);
}*/

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclAppMain::vOnApplicationClose()
*
* DESCRIPTION: This function is called by the CCA framework to indicate the
*              imminent shutdown of the application. The user has to implement
*              the de-initialization of all his local application data (destroy
*              client and service handler, destroy worker threads, free
*              application memory, ... ). After this function call the
*              destructor of this application will be called.
*
*              This function is the counterpart of bOnInit().
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
*******************************************************************************/
tVoid vd_clock_tclAppMain::vOnApplicationClose()
{
   ETG_TRACE_USR4(("vOnApplicationClose() entered."));

   // vd_clock_tclAppMainvOnApplicationClose: user specific code start

   vApplicationCloseAcknowledge (AIL_C_U8_APP_END_SUCCESSFUL);

   // vd_clock_tclAppMainvOnApplicationClose: user specific code end

   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclAppMain::vOnTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called by the CCA framework on the expiration
*              of a previously via function bStartTimer() started timer. The
*              expired timer is forwarded to the respective service or
*              client-handler via a call of vProcessTimer().
*
*              The function is called from this applications context and
*              therefore no interthread programming rules must be considered
*              and the application methods and/or member variables can be
*              accessed without using the static self reference
*              'm_poMainAppInstance'.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tVoid vd_clock_tclAppMain::vOnTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("vOnTimer(id: %d) entered.", u16TimerId ));

   // vd_clock_tclAppMainvOnTimer: user specific code start
   // vd_clock_tclAppMainvOnTimer: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclAppMain::vOnLoopback
*                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called by the CCA framework if a message was
*              sent from one if this applications services or from a
*              callback-handler of this application (so called self or loopback
*              messages). The message can be forwarded to the respective service
*              via a call of vOnLoopbackService(). If there is no service
*              registered for this message then the user has the option to
*              directly evaluate the message in the default block of this.
*              methods switch-clause.
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*
*            [IN] poMessage = Message object.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
*******************************************************************************/
tVoid vd_clock_tclAppMain::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vOnLoopback() entered with service ID %04x.", u16ServiceID));

   // vd_clock_tclAppMainvOnLoopback_entry: user specific code start
   // vd_clock_tclAppMainvOnLoopback_entry: user specific code end
   
   gm_tclStreamMessage oVisitorMsg(poMessage);

   vd_clock_tclBaseIf::TMsg oMsg;

   if (oVisitorMsg.u32GetDataSize() >= sizeof(oMsg)) {
      memcpy((tVoid*)&oMsg, oVisitorMsg.pcocGetData(), sizeof(oMsg));
      
      if (oMsg.eCmd != (vd_clock_tclBaseIf::ECmdTypes)poMessage->u16GetFunctionID()) {
         ETG_TRACE_FATAL(("vOnLoopbackService() failed. iFID = 0x%04x, cmd = 0x%04x.", (tU32)poMessage->u16GetFunctionID(), (tU32)oMsg.eCmd));
         NORMAL_M_ASSERT_ALWAYS();
      }
      else {
         //post message
         tU8* pu8MsgData = NULL;
         tU32 u32Len = 0;
         if ((oMsg.tDataTrailer.pu8Data != NULL) && (oMsg.tDataTrailer.u32Len != 0)) {
             pu8MsgData = new tU8[oMsg.tDataTrailer.u32Len];
             if (pu8MsgData != NULL) {
                 memcpy((tVoid*)pu8MsgData, oVisitorMsg.pcocGetData()+sizeof(oMsg), oMsg.tDataTrailer.u32Len);
                 oMsg.tDataTrailer.pu8Data = pu8MsgData;
             }

         }
         vDispatchInternalMsg(&oMsg);
         if (pu8MsgData != NULL) {
             delete[] pu8MsgData;
         }
      }
   }
   else {
      ETG_TRACE_FATAL(("vOnLoopbackService() failed. message data size = %d, internal message size = %d.", (tU32)oVisitorMsg.u32GetDataSize(), (tU32)sizeof(oMsg) ));
      NORMAL_M_ASSERT_ALWAYS();
   }

   // vd_clock_tclAppMainvOnLoopback_exit: user specific code start
   // vd_clock_tclAppMainvOnLoopback_exit: user specific code end   
}


tVoid vd_clock_tclAppMain::vDispatchInternalMsg(vd_clock_tclBaseIf::TMsg* pInternalMsg)
{
   if (pInternalMsg->eCmd == vd_clock_tclBaseIf::eCmdTraceCmdReceived) {
      //vHandleTraceMessageGen(_auchTraceInputBuffer);
       vHandleTraceMessage(_auchTraceInputBuffer);
 
       std::set<vd_clock_tclBaseIf*>::iterator iter;
       for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
            (*iter)->vHandleTraceMessage(_auchTraceInputBuffer);
       }
   }
   else {
      std::set<vd_clock_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (pInternalMsg->strClassName[0] != 0) 
         {
            if (0 == OSAL_s32StringCompare((*iter)->getIfName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
            if (0 == OSAL_s32StringCompare((*iter)->getName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
         } else {
            (*iter)->vHandleMessage(pInternalMsg);
         }
      }
   }
}

#ifndef _CCA_APPLICATION_WO_SERVICE
tVoid vd_clock_tclAppMain::vPostInternalMessage(vd_clock_tclBaseIf::TMsg* pInternalMsg)
{
   ETG_TRACE_USR1(("vd_clock_tclAppMain::vPostInternalMessage(): post internal message '%d'.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes, pInternalMsg->eCmd)));
   
   // vd_clock_tclAppMainPostInternStartUserSpecificClassCode: user specific code start
   // vd_clock_tclAppMainPostInternStartUserSpecificClassCode: user specific code end

   tU32 u32DataLengthMsg = sizeof(vd_clock_tclBaseIf::TMsg);
   tU8* pu8MsgData = NULL;

   const tChar* pStreamMsg = (const tChar*)pInternalMsg;

   if ((pInternalMsg->tDataTrailer.pu8Data != NULL) && (pInternalMsg->tDataTrailer.u32Len != 0)) {
       u32DataLengthMsg = (tU32)sizeof(vd_clock_tclBaseIf::TMsg) + pInternalMsg->tDataTrailer.u32Len;

       pu8MsgData = new tU8[u32DataLengthMsg];

       if (pu8MsgData != NULL) {
           (tVoid)OSAL_pvMemoryCopy((tVoid*)&pu8MsgData[0], pInternalMsg, sizeof(vd_clock_tclBaseIf::TMsg));
           (tVoid)OSAL_pvMemoryCopy((tVoid*)&pu8MsgData[sizeof(vd_clock_tclBaseIf::TMsg)], pInternalMsg->tDataTrailer.pu8Data, pInternalMsg->tDataTrailer.u32Len);

           pStreamMsg = (const tChar*)pu8MsgData;
           ETG_TRACE_FATAL(("vd_clock_tclAppMain::vPostInternalMessage(): send stream message '%d'.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes, pInternalMsg->eCmd)));
       }
   }

   gm_tclStreamMessage oStreamMsg(u16GetAppId(), u16GetAppId(), 0, 0, 54, (tU16)pInternalMsg->eCmd, AMT_C_U8_CCAMSG_OPCODE_SET, u32DataLengthMsg );
   if (OSAL_NULL != oStreamMsg.pu8GetSharedMemBase()) {
       oStreamMsg.vSetData((const tChar*)pStreamMsg);
       if ( oStreamMsg.bIsValid() ) {
          if (enPostMessage(&oStreamMsg, TRUE) != AIL_EN_N_NO_ERROR) {
             NORMAL_M_ASSERT_ALWAYS();
          }
       } else {
          NORMAL_M_ASSERT_ALWAYS();
       }
   } else {
      ETG_TRACE_ERRMEM(("vd_clock_tclAppMain::vPostInternalMessage(): message %d with data size %u bytes could not create! No shared memory.",
            ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes, pInternalMsg->eCmd), (tUInt)sizeof(vd_clock_tclBaseIf::TMsg) ));
   }

   if (pu8MsgData != NULL) {
       delete[] pu8MsgData;
   }
   // vd_clock_tclAppMainPostInternEndUserSpecificClassCode: user specific code start
   // vd_clock_tclAppMainPostInternEndUserSpecificClassCode: user specific code end

}
#endif

/*******************************************************************************
* FUNCTION   : vd_clock_tclAppMain::vTracePlugIn
* DESCRIPTION: Activate the TTFIS command channel for vd_clock
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid vd_clock_tclAppMain::vTracePlugIn(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;

   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_CLOCK;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)vd_clock_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &MyTraceChannel);
      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TracePlugin"));
      }
      // close trace device and clear channel
      OSAL_s32IOClose(desc);
   }
}

/*******************************************************************************
* FUNCTION   : vd_clock_tclAppMain::vTraceUnplug
* DESCRIPTION: Deactivate the TTFIS command channel for vd_clock
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid vd_clock_tclAppMain::vTraceUnplug(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;
   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_CLOCK;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)vd_clock_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &MyTraceChannel);

      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TraceUnplug"));
      }

      // close trace device and clear channel
      OSAL_s32IOClose(desc);
   }
}

/*******************************************************************************
* FUNCTION   : vd_clock_tclAppMain::vTraceCallbackFunction
* DESCRIPTION: Callback function for TTFIS command channel of __APP_NAME__
* PARAMETER  : [IN] puchData = buffer with trace input data
* RETURNVALUE: None
*******************************************************************************/
tVoid vd_clock_tclAppMain::vTraceCallbackFunction(const tUChar* puchData)
{
#ifdef _CCA_APPLICATION_WO_SERVICE

   //vd_clock_tclAppMain::vHandleTraceMessageGen(puchData);
   vd_clock_tclAppMain::vHandleTraceMessage(puchData);
#else
   if (puchData[0] < TRACE_BUFFER_MAXSIZE) {
      ETG_TRACE_USR4(("vTraceCallbackFunction(), length of TTFis message=%u\n Data: %*p",puchData[0],ETG_LIST_LEN(puchData[0]), ETG_LIST_PTR_T8(&(puchData[1]))));
      memcpy(_auchTraceInputBuffer, puchData, puchData[0]+1);

      if (NULL != _poMainAppInstance) {
         vd_clock_tclBaseIf::TMsg oMsg;
         (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
         
         oMsg.eCmd = vd_clock_tclBaseIf::eCmdTraceCmdReceived;
         oMsg.strClassName[0]=0;
         oMsg.u.u32Data = 0;

         _poMainAppInstance->vPostInternalMessage(&oMsg);
      }
   } else {
      ETG_TRACE_ERR(("MAIN :: Input trace command too long"));
   }
#endif // _CCA_APPLICATION_WO_SERVICE
}

tVoid vd_clock_tclAppMain::vLoadRegistry() 
{
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t)"/dev/root/opt/bosch/base/registry/procvd_clock.reg")) == OSAL_OK)
        {
            ETG_TRACE_FATAL(("REGISTRY loaded '/opt/bosch/base/registry/procvd_clock.reg'!"));

        } else {
            ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY  '/opt/bosch/base/registry/procvd_clock.reg'!"));
        }
    }
    OSAL_s32IOClose(regHandle);
}

#ifndef _CCA_APPLICATION_WO_SERVICE

tVoid vd_clock_tclAppMain::vPostMsgLocalTimeDateUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgLocalTimeDateUpdate(): LocalTimeDateUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::LocalTimeDateUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgLocalTimeDateUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgLocalTimeDateUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgAutoTimeZoneOffsetUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgAutoTimeZoneOffsetUpdate(): AutoTimeZoneOffsetUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::AutoTimeZoneOffsetUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgAutoTimeZoneOffsetUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgAutoTimeZoneOffsetUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgAvailableTimezonesUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgAvailableTimezonesUpdate(): AvailableTimezonesUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::AvailableTimezonesUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgAvailableTimezonesUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgAvailableTimezonesUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgClock_MeterSettingsUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgClock_MeterSettingsUpdate(): Clock_MeterSettingsUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::Clock_MeterSettingsUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgClock_MeterSettingsUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgClock_MeterSettingsUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgclocksourcestatusUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgclocksourcestatusUpdate(): clocksourcestatusUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::clocksourcestatusUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgclocksourcestatusUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgclocksourcestatusUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgDateformatUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgDateformatUpdate(): DateformatUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::DateformatUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgDateformatUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgDateformatUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgDaysPerMonthUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgDaysPerMonthUpdate(): DaysPerMonthUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::DaysPerMonthUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgDaysPerMonthUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgDaysPerMonthUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgDebugMode_TimeDateUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgDebugMode_TimeDateUpdate(): DebugMode_TimeDateUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::DebugMode_TimeDateUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgDebugMode_TimeDateUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgDebugMode_TimeDateUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgDiagconfigUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgDiagconfigUpdate(): DiagconfigUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::DiagconfigUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgDiagconfigUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgDiagconfigUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgDSTUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgDSTUpdate(): DSTUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::DSTUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgDSTUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgDSTUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgDefaultSetting(const tChar* strIfName, tU32 u32DefaultSetting) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgDefaultSetting(): eDefaultSetting message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::eDefaultSetting;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32DefaultSetting;
    // vd_clock_tclAppMain::vPostMsgDefaultSetting: user specific code start
    // vd_clock_tclAppMain::vPostMsgDefaultSetting: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgEpochUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgEpochUpdate(): EpochUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::EpochUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgEpochUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgEpochUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgFormatsourcestatusUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgFormatsourcestatusUpdate(): FormatsourcestatusUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::FormatsourcestatusUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgFormatsourcestatusUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgFormatsourcestatusUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgGPSAutoSyncUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgGPSAutoSyncUpdate(): GPSAutoSyncUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::GPSAutoSyncUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgGPSAutoSyncUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgGPSAutoSyncUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgLocalTimeDate_MinuteUpdateUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgLocalTimeDate_MinuteUpdateUpdate(): LocalTimeDate_MinuteUpdateUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::LocalTimeDate_MinuteUpdateUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgLocalTimeDate_MinuteUpdateUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgLocalTimeDate_MinuteUpdateUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgLocaltimeOffsetUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgLocaltimeOffsetUpdate(): LocaltimeOffsetUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::LocaltimeOffsetUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgLocaltimeOffsetUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgLocaltimeOffsetUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgNewDateformatUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgNewDateformatUpdate(): NewDateformatUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::NewDateformatUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgNewDateformatUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgNewDateformatUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgSyncmodeUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgSyncmodeUpdate(): SyncmodeUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::SyncmodeUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgSyncmodeUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgSyncmodeUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgTimeDatefromValueUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgTimeDatefromValueUpdate(): TimeDatefromValueUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::TimeDatefromValueUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgTimeDatefromValueUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgTimeDatefromValueUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgTimeformatUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgTimeformatUpdate(): TimeformatUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::TimeformatUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgTimeformatUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgTimeformatUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgTimezoneUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgTimezoneUpdate(): TimezoneUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::TimezoneUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgTimezoneUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgTimezoneUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgUTCTimeDateUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgUTCTimeDateUpdate(): UTCTimeDateUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::UTCTimeDateUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgUTCTimeDateUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgUTCTimeDateUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
tVoid vd_clock_tclAppMain::vPostMsgHUDActivateStateUpdate(const tChar* strIfName) {

    ETG_TRACE_USR4(("vd_clock_tclAppMain::vPostMsgHUDActivateStateUpdate(): HUDActivateStateUpdate message to '%50s'", strIfName));

    vd_clock_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = vd_clock_tclBaseIf::HUDActivateStateUpdate;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    // vd_clock_tclAppMain::vPostMsgHUDActivateStateUpdate: user specific code start
    // vd_clock_tclAppMain::vPostMsgHUDActivateStateUpdate: user specific code end
    vPostInternalMessage(&oMsg);
}
#endif

// vd_clock_tclAppMainUserSpecificClassCode: user specific code start


tVoid  vd_clock_tclAppMain:: vOnNewAppState(tU32 u32OldAppState,    // actual state
                                     tU32 u32AppState)       // state to change to
{
   ETG_TRACE_USR4(("vOnNewAppState oldAppstate %d ---> NewAppstate %d", u32OldAppState, u32AppState));

   ahl_tclBaseOneThreadApp::vOnNewAppState(u32OldAppState, u32AppState);

   if(u32AppState == u32OldAppState)
      ;  // nothing to change
   else
   {
      // analyse the state we have to go to
      switch(u32AppState)
      {
      case AMT_C_U32_STATE_NORMAL:
      case AMT_C_U32_STATE_DIAGNOSIS:
         {
            // inform the framework if you are ready to receive and send messages

			vServiceAvailabilityChanged
			(
					CCA_C_U16_SRV_CLOCK,
					AMT_C_U8_SVCSTATE_AVAILABLE
			);

			if(u32OldAppState == AMT_C_U32_STATE_OFF || u32OldAppState == AMT_C_U32_STATE_PAUSE )
			{
				//_poMainAppInstance->vAddObj(new vdclk_tclUpdater(_poMainAppInstance));
				vdclk_tclUpdater* _poUpdater = dynamic_cast<vdclk_tclUpdater*>(_poMainAppInstance->getHandler("vdclk_tclUpdater"));
				if(_poUpdater)
				{
					ETG_TRACE_USR4(("vdclk_tclUpdater object created"));

					// TO DO: CHECK THE NORMAL USE CASE
					_poUpdater ->vStartUpdaterThread();

					/* commented for interrupt shutdown */
					/*_poUpdater ->vTriggerUpdate(cu32TrigEventCANClockReceived);*/
				}
				else
				{
					ETG_TRACE_USR4(("vdclk_tclUpdater object not created"));

            	}
            }
           /* if(_bfirstupdate)
            {
            	SendComponentStatusActive_INC();
            	_bfirstupdate = FALSE;
            }*/


			//ticket NCG3D-25524
			if (u32OldAppState == AMT_C_U32_STATE_OFF || u32OldAppState == AMT_C_U32_STATE_PAUSE || u32OldAppState == AMT_C_U32_STATE_INITIALIZED)
			{
				ETG_TRACE_USR4(("vdclk_tclUpdater sending component active status"));
				SendComponentStatusActive_INC();

				 vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
				if(_poContainer)
				{
					_poContainer->vAppState(u32AppState);
				}
			}
		}
		break;

      case AMT_C_U32_STATE_PAUSE:
      case AMT_C_U32_STATE_OFF:
         {
        	 // inform the framework that we are not ready to received or send messages
             // inform the framework that we are not ready to received or send messages
             vServiceAvailabilityChanged
                (
                   CCA_C_U16_SRV_CLOCK,
                   AMT_C_U8_SVCSTATE_NOT_AVAILABLE
                );

             SendComponentStatusInActive_INC();

        	 vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));

        	 if(_poContainer)
        	 _poContainer->vSaveData();

        	 vdclk_tclUpdater* _poUpdater = dynamic_cast<vdclk_tclUpdater*>(_poMainAppInstance->getHandler("vdclk_tclUpdater"));

        	 if(_poUpdater)
        		 _poUpdater->bShutdown();
         }
         break;

      default:
         {
             ETG_TRACE_COMP(("unhandled AppState:%d", ETG_ENUM(APP_STATE, u32AppState)));
         }
         break;
      }
   }

   //update spm about the app state is successful
   vAppStateChanged (u32AppState, 0);
}


tVoid vd_clock_tclAppMain::vOnServiceState
(
 tU16  u16ServiceId   ,
 tU16  u16ServerId    ,
 tU16  u16RegisterId  ,
 tU8   u8ServiceState ,
 tU16  u16SubId
 )
{
	ETG_TRACE_USR4(("Received vOnServiceState %d ",u8ServiceState));

  // call the corresponding method of the super class to give AIL the chance to do the rest

	ahl_tclBaseOneThreadApp::vOnServiceState
	(
			u16ServiceId,
			u16ServerId,
			u16RegisterId,
			u8ServiceState,
			u16SubId );
}


tVoid vd_clock_tclAppMain::SendComponentStatusInActive_INC()
{
	ETG_TRACE_USR4(("Sending Component status INActive to INC"));

	vd_clock_INCAdapter* _poINCAdapter = dynamic_cast<vd_clock_INCAdapter*>(_poMainAppInstance->getHandler("vd_clock_INCAdapter"));


	tU8 u8INC_msg_buff[MAX_MSG_SIZE_COMPONENTSTATUS]= {0};

	u8INC_msg_buff[0] = 0x20; // msg id
	u8INC_msg_buff[1] = 0x02; // INActive status
	u8INC_msg_buff[2] = 0x01;//version

	tU8 u8DataLength = sizeof(u8INC_msg_buff);

	if(_poINCAdapter != NULL)
	{
		_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8DataLength);
	}else
	{
		ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
	}

}

tVoid vd_clock_tclAppMain::SendComponentStatusActive_INC()
{
	ETG_TRACE_USR4(("Sending Component status Active to INC"));

	vd_clock_INCAdapter* _poINCAdapter = dynamic_cast<vd_clock_INCAdapter*>(_poMainAppInstance->getHandler("vd_clock_INCAdapter"));

	tU8 u8INC_msg_buff[MAX_MSG_SIZE_COMPONENTSTATUS]= {0};

	u8INC_msg_buff[0] = 0x20; // msg id
	u8INC_msg_buff[1] = 0x01; // active status
	u8INC_msg_buff[2] = 0x01; // version number

	tU8 u8DataLength = sizeof(u8INC_msg_buff);

	if(_poINCAdapter != NULL)
	{
		_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8DataLength);
	}else
	{
		ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
	}
}


/*
tBool vd_clock_tclAppMain::bOnAcceptNewRegister (tU16 u16ServiceId, tU16 u16ClientAppId, tU16 u16ClientSubId, tU16* pu16RegisterId)
{
	ETG_TRACE_USR4(("vd_clock_tclAppMain::bOnAcceptNewRegister() entered. u16ClientAppId = %d", u16ClientAppId));
	ETG_TRACE_USR4(("vd_clock_tclAppMain::bOnAcceptNewRegister() entered. pu16RegisterId = %d", *pu16RegisterId));
	tBool retVal = ahl_tclBaseOneThreadApp::bOnAcceptNewRegister(u16ServiceId, u16ClientAppId, u16ClientSubId, pu16RegisterId);
	ETG_TRACE_USR4(("vd_clock_tclAppMain::bOnAcceptNewRegister() entered. pu16RegisterId = %d", *pu16RegisterId));


	return retVal;
}
*/
// vd_clock_tclAppMainUserSpecificClassCode: user specific code end


/*******************************************************************************
*                                       E O F
*******************************************************************************/
