

/*****************************************************************************
* FILE:         vd_clock_ClientSpm.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientSpmIncludes: user specific code start
// vd_clock_tclClientSpmIncludes: user specific code end

#include "vd_clock_ClientSpm.h"
#include "vd_clock_ClientSpmCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_SPM
#include "trcGenProj/Header/vd_clock_ClientSpm.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define SPM_SERVICE_ID              256
#define SPM_FI_MAJOR_VERSION        1
#define SPM_FI_MINOR_VERSION        3

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(vd_clock_tclClientSpm, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_SYSPWRMODE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleSysPwrModeOpStatus)
   // vd_clock_tclClientSpm_MsgMap: user specific code start
   // vd_clock_tclClientSpm_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSpm::
*             vd_clock_tclClientSpm(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSpm::vd_clock_tclClientSpm(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientSpm(poMainAppl, SPM_SERVICE_ID, SPM_FI_MAJOR_VERSION, SPM_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpm() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // vd_clock_tclClientSpmConstructor: user specific code start
   // vd_clock_tclClientSpmConstructor: user specific code end
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SYSPWRMODE);
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSpm::
*             ~vd_clock_tclClientSpm(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSpm::~vd_clock_tclClientSpm(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientSpm() entered."));
   _poCallbackIf = OSAL_NULL;

   // vd_clock_tclClientSpmDestructor: user specific code start
   // vd_clock_tclClientSpmDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpm::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientSpm.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     SPM_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpm::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpm::vGetReferences() entered."));
   
   // vd_clock_tclClientSpmvGetReferences: user specific code start
   // vd_clock_tclClientSpmvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpm::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpm::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpm::vStartCommunication() entered."));
   // vd_clock_tclClientSpmvStartCommunication: user specific code start
   // vd_clock_tclClientSpmvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpm::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpm::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpm::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // vd_clock_tclClientSpmvHandleMessage: user specific code start
   // vd_clock_tclClientSpmvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpm::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpm::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientSpm::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientSpmvHandleTraceMessage: user specific code start
   // vd_clock_tclClientSpmvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpm::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpm::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      SysPwrMode (SPM_COREFI_C_U16_SYSPWRMODE) -> Opcode: Status, UpReg, RelUpReg, Get, Error, "));

   // vd_clock_tclClientSpmvTraceInfo: user specific code start
   // vd_clock_tclClientSpmvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpm::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientSpm::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // vd_clock_tclClientSpmvOnServiceAvailable: user specific code start
   // vd_clock_tclClientSpmvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpm::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientSpm::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // vd_clock_tclClientSpmvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientSpmvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property SPM_COREFI_C_U16_SYSPWRMODE
*******************************************************************************/

tVoid vd_clock_tclClientSpm::vHandleSysPwrModeOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         spm_corefi_tclMsgSysPwrModeStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _SysPwrMode_SysPwrModeStatus = oStatus.SysPwrMode;

            ETG_TRACE_USR1(("vd_clock_tclClientSpm::vHandleSysPwrModeOpStatus(): Status update message received for 'SPM_COREFI_C_U16_SYSPWRMODE' (FID: 0x0204)!"));

            onSysPwrModeStatus(oStatus.SysPwrMode);

            // vHandleSysPwrModeOpStatus: user specific code start
            // vHandleSysPwrModeOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientSpm::vHandleSysPwrModeOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientSpm::onSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode) {

   if (_poCallbackIf) _poCallbackIf->onSysPwrModeStatus(SysPwrMode); 

   // onSysPwrModeStatus: user specific code start
   // onSysPwrModeStatus: user specific code end

}






tBool vd_clock_tclClientSpm::sendSysPwrModeGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgSysPwrModeGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_SYSPWRMODE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientSpm::sendSysPwrModeGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_SYSPWRMODE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// vd_clock_tclClientSpmvd_clock_ClientSpm: user specific code start
// vd_clock_tclClientSpmvd_clock_ClientSpm: user specific code end

//EOF
