/*****************************************************************************
* FILE:         vd_clock_ClientSensor_pv.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ClientSensor_pv_H_
#define __vd_clock_ClientSensor_pv_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ivd_clock_ClientSensor_pv.h"
#include "vd_clock_AppMain.h"

// vd_clock_tclClientSensor_pv_Include: user specific code start
// vd_clock_tclClientSensor_pv_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class vd_clock_tclClientSensor_pvCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class vd_clock_tclClientSensor_pv : public Ivd_clock_tclClientSensor_pv
{

public:
   virtual const tChar* getName() const { return "vd_clock_tclClientSensor_pv"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   vd_clock_tclClientSensor_pv(tVoid); 
   vd_clock_tclClientSensor_pv(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientSensor_pv();

   virtual tVoid vSetCallbackIf(vd_clock_tclClientSensor_pvCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // vd_clock_tclClientSensor_pvDeclarations: user specific code start
   // vd_clock_tclClientSensor_pvDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'vd_clock_tclClientSensor_pv' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   vd_clock_tclClientSensor_pv& operator = (const vd_clock_tclClientSensor_pv &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   vd_clock_tclClientSensor_pvCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendpositionGet();
   virtual tVoid getpositionStatus(tF64& rposLatitude, tF64& rposLongitude, sensor_fi_tcl_e8_position_source& rposSource, sensor_fi_tcl_e16_pv_ISOCountryCode& rcountryCode, sensor_fi_tcl_e8_countrycode_source& rcountryCodeSource, sensor_fi_tcl_pv_TimeZone& rtimeZone, sensor_fi_tcl_e8_timezone_source& rtimeZoneSource) {
      rposLatitude          = _posLatitude_positionStatus;
      rposLongitude         = _posLongitude_positionStatus;
      rposSource            = _posSource_positionStatus;
      rcountryCode          = _countryCode_positionStatus;
      rcountryCodeSource    = _countryCodeSource_positionStatus;
      rtimeZone             = _timeZone_positionStatus;
      rtimeZoneSource       = _timeZoneSource_positionStatus;
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandlepositionOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onpositionStatus(tF64 posLatitude, tF64 posLongitude, sensor_fi_tcl_e8_position_source posSource, sensor_fi_tcl_e16_pv_ISOCountryCode countryCode, sensor_fi_tcl_e8_countrycode_source countryCodeSource, sensor_fi_tcl_pv_TimeZone timeZone, sensor_fi_tcl_e8_timezone_source timeZoneSource);


private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   tF64                                     _posLatitude_positionStatus;
   tF64                                     _posLongitude_positionStatus;
   sensor_fi_tcl_e8_position_source         _posSource_positionStatus;
   sensor_fi_tcl_e16_pv_ISOCountryCode      _countryCode_positionStatus;
   sensor_fi_tcl_e8_countrycode_source      _countryCodeSource_positionStatus;
   sensor_fi_tcl_pv_TimeZone                _timeZone_positionStatus;
   sensor_fi_tcl_e8_timezone_source         _timeZoneSource_positionStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(vd_clock_tclClientSensor_pv) 

// vd_clock_tclClientSensor_pvDeclarationsPart2: user specific code start
// vd_clock_tclClientSensor_pvDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientSensor_pv_H_


