/*****************************************************************************
* FILE:         vd_clock_ClientSensor.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ClientSensor_H_
#define __vd_clock_ClientSensor_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ivd_clock_ClientSensor.h"
#include "vd_clock_AppMain.h"

// vd_clock_tclClientSensor_Include: user specific code start
// vd_clock_tclClientSensor_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class vd_clock_tclClientSensorCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class vd_clock_tclClientSensor : public Ivd_clock_tclClientSensor
{

public:
   virtual const tChar* getName() const { return "vd_clock_tclClientSensor"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   vd_clock_tclClientSensor(tVoid); 
   vd_clock_tclClientSensor(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientSensor();

   virtual tVoid vSetCallbackIf(vd_clock_tclClientSensorCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // vd_clock_tclClientSensorDeclarations: user specific code start
   // vd_clock_tclClientSensorDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'vd_clock_tclClientSensor' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   vd_clock_tclClientSensor& operator = (const vd_clock_tclClientSensor &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   vd_clock_tclClientSensorCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/
   virtual tBool sendGnssWnEpochSet(sensor_fi_tcl_TimeDate TargetWnDate);


   virtual tBool sendGnssWnEpochGet();
   virtual tVoid getGnssWnEpochStatus(sensor_fi_tcl_TimeDate& rActualWnDate) {
      rActualWnDate         = _ActualWnDate_GnssWnEpochStatus;
   }

   virtual tBool sendGnssDataGet();
   virtual tVoid getGnssDataStatus(sensor_fi_tcl_GnssData& rGnssData) {
      rGnssData             = _GnssData_GnssDataStatus;
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleGnssWnEpochOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleGnssDataOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onGnssWnEpochStatus(sensor_fi_tcl_TimeDate ActualWnDate);
   virtual tVoid onGnssDataStatus(sensor_fi_tcl_GnssData GnssData);


private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   sensor_fi_tcl_TimeDate                   _ActualWnDate_GnssWnEpochStatus;
   sensor_fi_tcl_GnssData                   _GnssData_GnssDataStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(vd_clock_tclClientSensor) 

// vd_clock_tclClientSensorDeclarationsPart2: user specific code start

// vd_clock_tclClientSensorDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientSensor_H_


