

/*****************************************************************************
* FILE:         vd_clock_ClientSensor.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientSensorIncludes: user specific code start
// vd_clock_tclClientSensorIncludes: user specific code end

#include "vd_clock_ClientSensor.h"
#include "vd_clock_ClientSensorCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_SENSOR
#include "trcGenProj/Header/vd_clock_ClientSensor.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define SENSOR_SERVICE_ID              176
#define SENSOR_FI_MAJOR_VERSION        1
#define SENSOR_FI_MINOR_VERSION        2

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(vd_clock_tclClientSensor, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleGnssWnEpochOpStatus)
   ON_MESSAGE_SVCDATA(SENSOR_LOCATIONFI_C_U16_GNSSDATA, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleGnssDataOpStatus)
   // vd_clock_tclClientSensor_MsgMap: user specific code start
   // vd_clock_tclClientSensor_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSensor::
*             vd_clock_tclClientSensor(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSensor::vd_clock_tclClientSensor(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientSensor(poMainAppl, SENSOR_SERVICE_ID, SENSOR_FI_MAJOR_VERSION, SENSOR_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // vd_clock_tclClientSensorConstructor: user specific code start
   // vd_clock_tclClientSensorConstructor: user specific code end
   vAddAutoRegisterForProperty(SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH);
   vAddAutoRegisterForProperty(SENSOR_LOCATIONFI_C_U16_GNSSDATA);
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSensor::
*             ~vd_clock_tclClientSensor(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSensor::~vd_clock_tclClientSensor(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientSensor() entered."));
   _poCallbackIf = OSAL_NULL;

   // vd_clock_tclClientSensorDestructor: user specific code start
   // vd_clock_tclClientSensorDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientSensor.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     SENSOR_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor::vGetReferences() entered."));
   
   // vd_clock_tclClientSensorvGetReferences: user specific code start
   // vd_clock_tclClientSensorvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor::vStartCommunication() entered."));
   // vd_clock_tclClientSensorvStartCommunication: user specific code start
   // vd_clock_tclClientSensorvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // vd_clock_tclClientSensorvHandleMessage: user specific code start
   // vd_clock_tclClientSensorvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientSensor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientSensorvHandleTraceMessage: user specific code start
   // vd_clock_tclClientSensorvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      GnssWnEpoch (SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH) -> Opcode: Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      GnssData (SENSOR_LOCATIONFI_C_U16_GNSSDATA) -> Opcode: Get, UpReg, RelUpReg, Status, Error, "));

   // vd_clock_tclClientSensorvTraceInfo: user specific code start
   // vd_clock_tclClientSensorvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientSensor::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // vd_clock_tclClientSensorvOnServiceAvailable: user specific code start
   // vd_clock_tclClientSensorvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientSensor::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // vd_clock_tclClientSensorvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientSensorvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH
*******************************************************************************/

tVoid vd_clock_tclClientSensor::vHandleGnssWnEpochOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         sensor_locationfi_tclMsgGnssWnEpochStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SENSOR_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _ActualWnDate_GnssWnEpochStatus = oStatus.ActualWnDate;

            ETG_TRACE_USR1(("vd_clock_tclClientSensor::vHandleGnssWnEpochOpStatus(): Status update message received for 'SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH' (FID: 0x46)!"));

            onGnssWnEpochStatus(oStatus.ActualWnDate);

            // vHandleGnssWnEpochOpStatus: user specific code start
            // vHandleGnssWnEpochOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientSensor::vHandleGnssWnEpochOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientSensor::onGnssWnEpochStatus(sensor_fi_tcl_TimeDate ActualWnDate) {

   if (_poCallbackIf) _poCallbackIf->onGnssWnEpochStatus(ActualWnDate); 

   // onGnssWnEpochStatus: user specific code start
   // onGnssWnEpochStatus: user specific code end

}

/*******************************************************************************
* Handling of property SENSOR_LOCATIONFI_C_U16_GNSSDATA
*******************************************************************************/

tVoid vd_clock_tclClientSensor::vHandleGnssDataOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         sensor_locationfi_tclMsgGnssDataStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SENSOR_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _GnssData_GnssDataStatus = oStatus.GnssData;

            ETG_TRACE_USR1(("vd_clock_tclClientSensor::vHandleGnssDataOpStatus(): Status update message received for 'SENSOR_LOCATIONFI_C_U16_GNSSDATA' (FID: 0x49)!"));

            onGnssDataStatus(oStatus.GnssData);

            // vHandleGnssDataOpStatus: user specific code start
            // vHandleGnssDataOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientSensor::vHandleGnssDataOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientSensor::onGnssDataStatus(sensor_fi_tcl_GnssData GnssData) {

   if (_poCallbackIf) _poCallbackIf->onGnssDataStatus(GnssData); 

   // onGnssDataStatus: user specific code start
   // onGnssDataStatus: user specific code end

}





tBool vd_clock_tclClientSensor::sendGnssWnEpochSet(sensor_fi_tcl_TimeDate TargetWnDate) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      sensor_locationfi_tclMsgGnssWnEpochSet  oSet;
      //the data content
      oSet.TargetWnDate = TargetWnDate;


      fi_tclVisitorMessage oOutMessage(oSet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH, (tU8) AMT_C_U8_CCAMSG_OPCODE_SET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientSensor::sendGnssWnEpochSet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oSet.vDestroy();
   }
   return bRetVal;
}

tBool vd_clock_tclClientSensor::sendGnssWnEpochGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      sensor_locationfi_tclMsgGnssWnEpochGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientSensor::sendGnssWnEpochGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool vd_clock_tclClientSensor::sendGnssDataGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      sensor_locationfi_tclMsgGnssDataGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SENSOR_LOCATIONFI_C_U16_GNSSDATA, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientSensor::sendGnssDataGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SENSOR_LOCATIONFI_C_U16_GNSSDATA, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// vd_clock_tclClientSensorvd_clock_ClientSensor: user specific code start
// vd_clock_tclClientSensorvd_clock_ClientSensor: user specific code end

//EOF
