/*****************************************************************************
* FILE:         vd_clock_Starter.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     appl_ClientStarter.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Create application specific objects here
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "vd_clock_AppMain.h"

// AsfClientStarterIncludeTop: user specific code start
// AsfClientStarterIncludeTop: user specific code end

#include "vd_clock_ServiceClock.h"
#include "vd_clock_ServiceClockIf.h"
#include "vd_clock_ClientPos.h"
#include "vd_clock_ClientPosIf.h"
#include "vd_clock_ClientDiaglog.h"
#include "vd_clock_ClientDiaglogIf.h"
#include "vd_clock_ClientProfile.h"
#include "vd_clock_ClientProfileIf.h"
#include "vd_clock_ClientSensor_pv.h"
#include "vd_clock_ClientSensor_pvIf.h"
#include "vd_clock_ClientSensor.h"
#include "vd_clock_ClientSensorIf.h"
#include "vd_clock_ClientVehicledata.h"
#include "vd_clock_ClientVehicledataIf.h"
#include "vd_clock_ClientSpm.h"
#include "vd_clock_ClientSpmIf.h"


// AsfClientStarterInclude: user specific code start
#include "vd_clock_datacontainer.h"
#include "vd_clock_updater.h"
#include "vd_clock_datetime.h"
#include "vd_clock_INCAdapter.h"
#include "ProfileManager.h"
// AsfClientStarterInclude: user specific code end

void vAppProxyStarter(vd_clock_tclAppMain *poServer){

    {
        // AsfClientStartervd_clock_tclServiceClock: user specific code start
        // AsfClientStartervd_clock_tclServiceClock: user specific code end
        {
            vd_clock_tclServiceClock *poCcaProxy = new vd_clock_tclServiceClock(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            vd_clock_tclServiceClockIf *poCcaProxy = new vd_clock_tclServiceClockIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStartervd_clock_tclClientPos: user specific code start
        // AsfClientStartervd_clock_tclClientPos: user specific code end
        {
            vd_clock_tclClientPos *poCcaProxy = new vd_clock_tclClientPos(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            vd_clock_tclClientPosIf *poCcaProxy = new vd_clock_tclClientPosIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStartervd_clock_tclClientDiaglog: user specific code start
        // AsfClientStartervd_clock_tclClientDiaglog: user specific code end
        {
            vd_clock_tclClientDiaglog *poCcaProxy = new vd_clock_tclClientDiaglog(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            vd_clock_tclClientDiaglogIf *poCcaProxy = new vd_clock_tclClientDiaglogIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStartervd_clock_tclClientProfile: user specific code start
        // AsfClientStartervd_clock_tclClientProfile: user specific code end
        {
            vd_clock_tclClientProfile *poCcaProxy = new vd_clock_tclClientProfile(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            vd_clock_tclClientProfileIf *poCcaProxy = new vd_clock_tclClientProfileIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStartervd_clock_tclClientSensor_pv: user specific code start
        // AsfClientStartervd_clock_tclClientSensor_pv: user specific code end
        {
            vd_clock_tclClientSensor_pv *poCcaProxy = new vd_clock_tclClientSensor_pv(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            vd_clock_tclClientSensor_pvIf *poCcaProxy = new vd_clock_tclClientSensor_pvIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStartervd_clock_tclClientSensor: user specific code start
        // AsfClientStartervd_clock_tclClientSensor: user specific code end
        {
            vd_clock_tclClientSensor *poCcaProxy = new vd_clock_tclClientSensor(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            vd_clock_tclClientSensorIf *poCcaProxy = new vd_clock_tclClientSensorIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStartervd_clock_tclClientVehicledata: user specific code start
        // AsfClientStartervd_clock_tclClientVehicledata: user specific code end
        {
            vd_clock_tclClientVehicledata *poCcaProxy = new vd_clock_tclClientVehicledata(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            vd_clock_tclClientVehicledataIf *poCcaProxy = new vd_clock_tclClientVehicledataIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStartervd_clock_tclClientSpm: user specific code start
        // AsfClientStartervd_clock_tclClientSpm: user specific code end
        {
            vd_clock_tclClientSpm *poCcaProxy = new vd_clock_tclClientSpm(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            vd_clock_tclClientSpmIf *poCcaProxy = new vd_clock_tclClientSpmIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
    }

    // AsfClientProxyStarter: user specific code start
    {
       {
           poServer->vAddObj(new vdclk_tclDataContainer(poServer));
       }
       {
    	   poServer->vAddObj(new vdclk_tclUpdater(poServer));
       }
       {
    	   poServer->vAddObj(new vd_clock_INCAdapter(poServer));
       }
       {
    	   poServer->vAddObj(new profileManager(poServer));
       }
    }

    // AsfClientProxyStarter: user specific code end
}
