/*****************************************************************************
* FILE:         vd_clock_ClientVehicledataIf.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ClientVehicledataIf__IF__H_
#define __vd_clock_ClientVehicledataIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_vd_clock_ClientVehicledataIf.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_ClientVehicledataCallbackIf.h"
#include "vd_clock_types.h"
// vd_clock_tclClientVehicledataIf_Include: user specific code start
#include "vd_clock_datacontainer.h"
// vd_clock_tclClientVehicledataIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivd_clock_tclClientVehicledata;

class vd_clock_tclClientVehicledataIf : public Ivd_clock_tclClientVehicledataIf, public vd_clock_tclClientVehicledataCallbackIF
{
public:

   vd_clock_tclClientVehicledataIf(tVoid); 
   vd_clock_tclClientVehicledataIf(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientVehicledataIf();

   virtual const tChar* getName() const { return "vd_clock_tclClientVehicledataIf"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   tU8 u8Month,u8Day,u8Second;
   tS32 u8Hour,u8Minute;
   tU8 finalhour,finalMinute;
   tU16 u8Year;
   tU8 s8MinuteOffsetValue,s8HourOffsetValue;

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendDateModeGet(){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendDateModeGet();
   }
   virtual tVoid getDateModeStatus(tU8& rDateModeValue){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getDateModeStatus(rDateModeValue);
   }


   virtual tBool sendTmModeGet(){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendTmModeGet();
   }
   virtual tVoid getTmModeStatus(tU8& rTmModeValue){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getTmModeStatus(rTmModeValue);
   }


   virtual tBool sendTimeDateGet(){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendTimeDateGet();
   }
   virtual tVoid getTimeDateStatus(tU64& rTimeDateValue){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getTimeDateStatus(rTimeDateValue);
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onDateModeStatus(tU8 DateModeValue);
   virtual tVoid onTmModeStatus(tU8 TmModeValue);
   virtual tVoid onTimeDateStatus(tU64 TimeDateValue);


   // vd_clock_tclClientVehicledataIfDeclarations: user specific code start
   // vd_clock_tclClientVehicledataIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ivd_clock_tclClientVehicledata* _poClientRef;
   vdclk_tclDataContainer* _poContainer;

// vd_clock_tclClientVehicledataIfDeclarationsPart2: user specific code start
// vd_clock_tclClientVehicledataIfDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientVehicledataIf__IF__H_


