
/*****************************************************************************
* FILE:         vd_clock_ClientVehicledataIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// vd_clock_tclClientVehicledataIfIncludes: user specific code start
// vd_clock_tclClientVehicledataIfIncludes: user specific code end

#include "vd_clock_ClientVehicledataIf.h"
#include "Ivd_clock_ClientVehicledata.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_SPM
#include "trcGenProj/Header/vd_clock_ClientVehicledataIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientVehicledataIf::
*             vd_clock_tclClientVehicledataIf(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientVehicledataIf::vd_clock_tclClientVehicledataIf(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientVehicledataIf(poMainAppl)
{
   ETG_TRACE_USR1(("vd_clock_tclClientVehicledataIf() entered."));
   _poClientRef = OSAL_NULL;
   _poContainer = OSAL_NULL;
   // vd_clock_tclClientVehicledataIfConstructor: user specific code start
   u8Month=OSAL_NULL;
   u8Day=OSAL_NULL;
   u8Hour=OSAL_NULL;
   u8Minute=OSAL_NULL;
   u8Second=OSAL_NULL;
   u8Year=OSAL_NULL;
   s8MinuteOffsetValue=OSAL_NULL;
   s8HourOffsetValue=OSAL_NULL;
   finalhour = 0;
   finalMinute = 0;
   // vd_clock_tclClientVehicledataIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientVehicledataIf::
*             ~vd_clock_tclClientVehicledataIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientVehicledataIf::~vd_clock_tclClientVehicledataIf(tVoid)
{
  ETG_TRACE_USR1(("~vd_clock_tclClientVehicledataIf() entered."));
   _poClientRef = OSAL_NULL;
   _poContainer = OSAL_NULL;
   // vd_clock_tclClientVehicledataIfDestructor: user specific code start
   // vd_clock_tclClientVehicledataIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledataIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientVehicledataIf.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     VEHICLEDATA_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledataIf::vGetReferences(tVoid)
{
  ETG_TRACE_USR1(("vd_clock_tclClientVehicledataIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ivd_clock_tclClientVehicledata*>(_cpoMain->getHandler("Ivd_clock_tclClientVehicledata"));

   VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // vd_clock_tclClientVehicledataIfvGetReferences: user specific code start
   _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));

   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
   // vd_clock_tclClientVehicledataIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledataIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledataIf::vStartCommunication(tVoid)
{
  ETG_TRACE_USR1(("vd_clock_tclClientVehicledataIf::vStartCommunication() entered."));
   // vd_clock_tclClientVehicledataIfvStartCommunication: user specific code start
   // vd_clock_tclClientVehicledataIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledataIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledataIf::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
  ETG_TRACE_USR1(("vd_clock_tclClientVehicledataIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // vd_clock_tclClientVehicledataIfvHandleMessage: user specific code start
   // vd_clock_tclClientVehicledataIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledataIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledataIf::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
  ETG_TRACE_USR1(("vd_clock_tclClientVehicledataIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientVehicledataIfvHandleTraceMessage: user specific code start
   // vd_clock_tclClientVehicledataIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledataIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledataIf::vTraceInfo()
{
   // vd_clock_tclClientVehicledataIfvTraceInfo: user specific code start
   // vd_clock_tclClientVehicledataIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledataIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientVehicledataIf::onServiceAvailable()
{
  ETG_TRACE_USR1(("vd_clock_tclClientVehicledataIf::onServiceAvailable() entered."));

   // vd_clock_tclClientVehicledataIfvOnServiceAvailable: user specific code start
   // vd_clock_tclClientVehicledataIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledataIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientVehicledataIf::onServiceUnavailable()
{
  ETG_TRACE_USR1(("vd_clock_tclClientVehicledataIf::onServiceUnavailable() entered."));

   // vd_clock_tclClientVehicledataIfvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientVehicledataIfvOnServiceUnavailable: user specific code end
}

tVoid vd_clock_tclClientVehicledataIf::onTimeDateStatus(tU64 TimeDateValue) {
   //#ifdef VARIANT_S_FTR_ENABLE_INF4CV
   ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus(): CALLED" ) );
   unsigned long data[8];
   tS32 s32MinuteOffset, s32HourOffset;
    for (int i = 0; i < 8; ++i)
    {
		data[i] = (TimeDateValue >> (8 * i)) & 0xFF;
		ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of data[i] is value :%02X",data[i]) );
	}
	

   if ((data[1] >= 0xFE) || (data[2] >= 0xFE) || (data[6] >= 0xFE) || (data[7] >= 0xFE) )
   {
        ETG_TRACE_ERR(("vReadCSMDateTime:No Data Available from CAN"));
   }
   else
   {
	    tS8 s8Mins = data[6] - 0x7D;
        tS8 s8Hrs = data[7] - 0x7D;
		s32MinuteOffset = data[1] + s8Mins;
        s32HourOffset =  (tS8)((data[2]+ s8Hrs));
		ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  s8Mins %d",s8Mins) );
		ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  s8Hrs %d",s8Hrs) );
		ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  s32MinuteOffset %d",s32MinuteOffset) );
		ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  s32HourOffset %d",s32HourOffset) );
		if(data[0] >= 0xFE)
		{
	        	u8Second = 0;
		}
		else
		{
	        	u8Second = data[0]/4;
		}
		if (s32HourOffset <= 0)
        {
           s32HourOffset += 24;
        }
		s32HourOffset = (s32HourOffset*60) + s32MinuteOffset + (u8Second/60);
		ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  s32HourOffset 1 %d",s32HourOffset) );
		u8Minute = (tS8)(s32HourOffset%60);
        u8Hour = (tS8)((s32HourOffset/60)%24);
		if(u8Minute < 0)
		{
			finalMinute = (u8Minute) * -1;
		}
		else
		{
			finalMinute = u8Minute;
		}
		if(u8Hour < 0)
		{
			finalhour = (u8Hour) * -1;
		}
		else
		{
           finalhour = u8Hour;
		}
		
		ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  finalMinute %d",finalMinute) );
		ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  finalhour %d",finalhour) );
		if(data[3] >= 0xFE || (data[3] == 0) )
		{
		 u8Month = 1;
		}
		else
		{
		u8Month = data[3];
		}
		if(data[4] >= 0xFE || (data[4] == 0))
		{
		  u8Day = 1;
		}
		else
		{
	          u8Day = data[4]/4;
		}
		if(data[5] >= 0xFE)
		{
	           u8Year = 1985;
		}
		else
		{
	           u8Year = data[5] + 1985;
		}
		if(u8Year < 1985)
		{
			ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus invalid Year %d",u8Year));
		}
		else if((u8Month < 1) || (u8Month > 12) || (u8Day == 0))
		{
			ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus invalid month and day %d,%d",u8Month,u8Day));
		}
		else
		{
			ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus CANTime is Valid"));
			_poContainer->SetCANTimeAvailabity(TRUE);
		
	        ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  is u8Second %d",u8Second) );
	        ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  is u8Minute %d",finalMinute) );
	        ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  is u8Hour %d",finalhour) );
	        ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  is u8Month %d",u8Month) );
	        ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  is u8Day %d",u8Day) );
	        ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  is u8Year %d",u8Year) );
	        ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  is s8MinuteOffsetValue %d",s8MinuteOffsetValue) );
	        ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTimeDateStatus():value of  is s8HourOffsetValue %d",s8HourOffsetValue) );
		    //_poContainer->vSetCANTime(u8Year,finalMinute,u8Day,finalhour,u8Minute,u8Second);
		   _poContainer->vSetCANTime(u8Year,u8Month,u8Day,finalhour,finalMinute,u8Second);
		}
   }
//#endif
  

   //_poContainer->vSetCANTime(u8Year,u8Month,u8Day,u8Hour,u8Minute,u8Second);
   // onTimeDateStatus: user specific code start
   // onTimeDateStatus: user specific code end
}

tVoid vd_clock_tclClientVehicledataIf::onDateModeStatus(tU8 DateModeValue)
{
	 ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onDateModeStatus() %d",DateModeValue));
	 if(DateModeValue == 0)
	 {
		 _poContainer->vSetNewDateFormat(VDCLK_EN_DF_DD_MM_YYYY_DASH);
	 }
	 else if(DateModeValue == 1)
	 {
		 _poContainer->vSetNewDateFormat(VDCLK_EN_DF_MM_DD_YYYY_DASH);
	 }
	 else if(DateModeValue == 2)
	 {
		 _poContainer->vSetNewDateFormat(VDCLK_EN_DF_YYYY_MM_DD_DASH);
	 }
	 else
	 {
		 ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::Invalid Date Format recieved"));
	 }
}

tVoid vd_clock_tclClientVehicledataIf::onTmModeStatus(tU8 TmModeValue)
{
	 ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTmModeStatus() %d",TmModeValue) );
	 if(TmModeValue == 0)
	 {
		 _poContainer->vSetTimeFormat(VDCLK_EN_TF_Mode12);
	 }
	 else if(TmModeValue == 1)
	 {
		 _poContainer->vSetTimeFormat(VDCLK_EN_TF_Mode24);
	 }
	 else
	 {
        ETG_TRACE_USR1( ( "vd_clock_tclClientVehicledataIf::onTmModeStatus Invalid"));
	 }
}



// vd_clock_tclClientVehicledataIfvd_clock_ClientVehicledataIf: user specific code start
// vd_clock_tclClientVehicledataIfvd_clock_ClientVehicledataIf: user specific code end

//EOF
