
/*****************************************************************************
* FILE:         vd_clock_ClientSpmIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientSpmIfIncludes: user specific code start
// vd_clock_tclClientSpmIfIncludes: user specific code end

#include "vd_clock_ClientSpmIf.h"
#include "Ivd_clock_ClientSpm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_SPM
#include "trcGenProj/Header/vd_clock_ClientSpmIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSpmIf::
*             vd_clock_tclClientSpmIf(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSpmIf::vd_clock_tclClientSpmIf(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientSpmIf(poMainAppl)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientSpmIfConstructor: user specific code start
   _poDiagHandler = OSAL_NULL;
   // vd_clock_tclClientSpmIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSpmIf::
*             ~vd_clock_tclClientSpmIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSpmIf::~vd_clock_tclClientSpmIf(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientSpmIfDestructor: user specific code start
   _poDiagHandler = OSAL_NULL;
   // vd_clock_tclClientSpmIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpmIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientSpmIf.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     SPM_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpmIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpmIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ivd_clock_tclClientSpm*>(_cpoMain->getHandler("Ivd_clock_tclClientSpm"));

   VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // vd_clock_tclClientSpmIfvGetReferences: user specific code start
   _poDiagHandler = dynamic_cast<Ivd_clock_tclClientDiaglogIf*>(_cpoMain->getHandler("Ivd_clock_tclClientDiaglogIf"));

   VD_CLOCK_NULL_POINTER_CHECK(_poDiagHandler);

   // vd_clock_tclClientSpmIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpmIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpmIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpmIf::vStartCommunication() entered."));
   // vd_clock_tclClientSpmIfvStartCommunication: user specific code start
   // vd_clock_tclClientSpmIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpmIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpmIf::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpmIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // vd_clock_tclClientSpmIfvHandleMessage: user specific code start
   // vd_clock_tclClientSpmIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpmIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpmIf::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientSpmIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientSpmIfvHandleTraceMessage: user specific code start
   // vd_clock_tclClientSpmIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpmIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSpmIf::vTraceInfo()
{
   // vd_clock_tclClientSpmIfvTraceInfo: user specific code start
   // vd_clock_tclClientSpmIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpmIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientSpmIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpmIf::onServiceAvailable() entered."));

   // vd_clock_tclClientSpmIfvOnServiceAvailable: user specific code start
   // vd_clock_tclClientSpmIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSpmIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientSpmIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientSpmIf::onServiceUnavailable() entered."));

   // vd_clock_tclClientSpmIfvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientSpmIfvOnServiceUnavailable: user specific code end
}

tVoid vd_clock_tclClientSpmIf::onSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientSpmIf::onSysPwrModeStatus(): CALLED" ) );

   // onSysPwrModeStatus: user specific code start
   tBool  isAccON = FALSE;
     switch((tU8)SysPwrMode.enType)
   {
      case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF:
      {
         isAccON = FALSE;

         ETG_TRACE_USR4(("vd_clock_ClientSpmIf::onSysPwrModeStatus(): IGN OFF"));
      }
      break;
      case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN:
      {
         isAccON = TRUE;
         ETG_TRACE_USR4(("vd_clock_ClientSpmIf::onSysPwrModeStatus(): IGN ON"));
   
      }
      break;
      case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY:
      {
         isAccON = TRUE;
    
         ETG_TRACE_USR4(("vd_clock_ClientSpmIf::onSysPwrModeStatus(): On ACC"));
      }
      break;
      case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK:
      {
    	  isAccON = TRUE;
         ETG_TRACE_USR4(("vd_clock_ClientSpmIf::onSysPwrModeStatus(): On Crank "));
      }
      break;
      default:
      {
         isAccON = FALSE;
     
         ETG_TRACE_USR4(("vd_clock_ClientSpmIf::onSysPwrModeStatus(): Invalid case"));
      }
      break;
   }
     if(_poDiagHandler)
     {
     _poDiagHandler->vSetACCInfo(isAccON);
     }
     else
     {
    	 ETG_TRACE_USR4(("vd_clock_ClientSpmIf::onSysPwrModeStatus(): _poDiagHandler is NULL"));
     }

   // onSysPwrModeStatus: user specific code end
}




// vd_clock_tclClientSpmIfvd_clock_ClientSpmIf: user specific code start
// vd_clock_tclClientSpmIfvd_clock_ClientSpmIf: user specific code end

//EOF
