/*****************************************************************************
* FILE:         vd_clock_ClientSensorIf.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef __vd_clock_ClientSensorIf__IF__H_
#define __vd_clock_ClientSensorIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_vd_clock_ClientSensorIf.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_ClientSensorCallbackIf.h"

// vd_clock_tclClientSensorIf_Include: user specific code start
#include "vd_clock_datacontainer.h"
// vd_clock_tclClientSensorIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivd_clock_tclClientSensor;

class vd_clock_tclClientSensorIf : public Ivd_clock_tclClientSensorIf, public vd_clock_tclClientSensorCallbackIF
{
public:

   vd_clock_tclClientSensorIf(tVoid); 
   vd_clock_tclClientSensorIf(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientSensorIf();

   virtual const tChar* getName() const { return "vd_clock_tclClientSensorIf"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

   virtual tBool sendGnssWnEpochSet(sensor_fi_tcl_TimeDate TargetWnDate) {
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendGnssWnEpochSet(TargetWnDate);
   }


   virtual tBool sendGnssWnEpochGet(){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendGnssWnEpochGet();
   }
   virtual tVoid getGnssWnEpochStatus(sensor_fi_tcl_TimeDate& rActualWnDate){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getGnssWnEpochStatus(rActualWnDate);
   }


   virtual tBool sendGnssDataGet(){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendGnssDataGet();
   }
   virtual tVoid getGnssDataStatus(sensor_fi_tcl_GnssData& rGnssData){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getGnssDataStatus(rGnssData);
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onGnssWnEpochStatus(sensor_fi_tcl_TimeDate ActualWnDate);
   virtual tVoid onGnssDataStatus(sensor_fi_tcl_GnssData GnssData);


   // vd_clock_tclClientSensorIfDeclarations: user specific code start
   // vd_clock_tclClientSensorIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
public:
   virtual tBool isGPSDataValid();

private:
   Ivd_clock_tclClientSensor* _poClientRef;

// vd_clock_tclClientSensorIfDeclarationsPart2: user specific code start

   tBool _bGPSFirstUpdate;
   tBool _bfirstupdate;
   vdclk_tclDataContainer* _poContainer;
   tBool _bGPSDataValid;







// vd_clock_tclClientSensorIfDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientSensorIf__IF__H_


