
/*****************************************************************************
* FILE:         vd_clock_ClientSensorIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientSensorIfIncludes: user specific code start

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/rtc.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>

// vd_clock_tclClientSensorIfIncludes: user specific code end

#include "vd_clock_ClientSensorIf.h"
#include "Ivd_clock_ClientSensor.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_SENSOR
#include "trcGenProj/Header/vd_clock_ClientSensorIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSensorIf::
*             vd_clock_tclClientSensorIf(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSensorIf::vd_clock_tclClientSensorIf(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientSensorIf(poMainAppl)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensorIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientSensorIfConstructor: user specific code start
   _poContainer  = OSAL_NULL;
   _bGPSDataValid = FALSE;
   _bfirstupdate = TRUE;
   _bGPSFirstUpdate = FALSE;
   // vd_clock_tclClientSensorIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSensorIf::
*             ~vd_clock_tclClientSensorIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSensorIf::~vd_clock_tclClientSensorIf(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientSensorIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientSensorIfDestructor: user specific code start
   _poContainer = OSAL_NULL;
   _bfirstupdate = FALSE;
   // vd_clock_tclClientSensorIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensorIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientSensorIf.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     SENSOR_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensorIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensorIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ivd_clock_tclClientSensor*>(_cpoMain->getHandler("Ivd_clock_tclClientSensor"));

   VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // vd_clock_tclClientSensorIfvGetReferences: user specific code start

   _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));

   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

   // vd_clock_tclClientSensorIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensorIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensorIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensorIf::vStartCommunication() entered."));
   // vd_clock_tclClientSensorIfvStartCommunication: user specific code start
   // vd_clock_tclClientSensorIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensorIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensorIf::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensorIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // vd_clock_tclClientSensorIfvHandleMessage: user specific code start
   // vd_clock_tclClientSensorIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensorIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensorIf::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientSensorIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientSensorIfvHandleTraceMessage: user specific code start
   // vd_clock_tclClientSensorIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensorIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensorIf::vTraceInfo()
{
   // vd_clock_tclClientSensorIfvTraceInfo: user specific code start
   // vd_clock_tclClientSensorIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensorIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientSensorIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensorIf::onServiceAvailable() entered."));

   // vd_clock_tclClientSensorIfvOnServiceAvailable: user specific code start
   // vd_clock_tclClientSensorIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensorIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientSensorIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensorIf::onServiceUnavailable() entered."));

   // vd_clock_tclClientSensorIfvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientSensorIfvOnServiceUnavailable: user specific code end
}

tVoid vd_clock_tclClientSensorIf::onGnssWnEpochStatus(sensor_fi_tcl_TimeDate ActualWnDate) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientSensorIf::onGnssWnEpochStatus(): CALLED" ) );

   // onGnssWnEpochStatus: user specific code start
	ETG_TRACE_USR4(("Epoch Time Status (Year:Month:Day:HH:MM:SS:mSS): %d:%d:%d:%d:%d:%d",
			ActualWnDate.td_year,
			ActualWnDate.td_month,
			ActualWnDate.td_day,
			ActualWnDate.td_hour,
			ActualWnDate.td_minute,
			ActualWnDate.td_second));
   // onGnssWnEpochStatus: user specific code end
}
tVoid vd_clock_tclClientSensorIf::onGnssDataStatus(sensor_fi_tcl_GnssData GnssData) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientSensorIf::onGnssDataStatus(): CALLED" ) );

   // onGnssDataStatus: user specific code start


	ETG_TRACE_USR4(("GPS Time (Year:Month:Day:HH:MM:SS:mSS): %d:%d:%d:%d:%d:%d:%d",
			GnssData.GnssPvtData.UtcTimeDate.td_year,
			GnssData.GnssPvtData.UtcTimeDate.td_month,
			GnssData.GnssPvtData.UtcTimeDate.td_day,
			GnssData.GnssPvtData.UtcTimeDate.td_hour,
			GnssData.GnssPvtData.UtcTimeDate.td_minute,
			GnssData.GnssPvtData.UtcTimeDate.td_second,
			GnssData.GnssPvtData.UtcTimeDate.td_milliSeconds));


	vdclk_tclUpdater* _poUpdater = dynamic_cast<vdclk_tclUpdater*>(_cpoMain->getHandler("vdclk_tclUpdater"));
	tBool _RTCValid = FALSE;
	unsigned char _GPSMountedType = 0;
	if(_poUpdater)
	{
		_RTCValid= _poUpdater->_RTCValidOnce;

	}

	if( (GnssData.GnssPvtData.GnssStatus.GnssMode.enType == GNSSMODE_NOFIX) ||
			(GnssData.GnssPvtData.GnssStatus.GnssMode.enType == GNSSMODE_UNKNOWN))
	{
		//_bGPSDataValid = FALSE;

		if(_poContainer != NULL)
		{
			_GPSMountedType = _poContainer->getGPSType();
		}
		if( _bfirstupdate &&(_GPSMountedType == 0x01))
		{
			if(_RTCValid == FALSE)
			{
				_bfirstupdate = FALSE;

				//todo: discuss why its required
				/*if(_poContainer == NULL)
        		{
        			ETG_TRACE_USR4(("_poContainer is NULL"));
        		}
        		else
        		{
        			_poContainer->defaultValueforGPS();
        			_poContainer->vStoreDefaultSystemTime();
        		}*/
			}
		}


	}
	else if((GnssData.GnssPvtData.GnssStatus.GnssMode.enType == GNSSMODE_2DFIX) ||
			(GnssData.GnssPvtData.GnssStatus.GnssMode.enType == GNSSMODE_3DFIX))
	{

		if(_poContainer != NULL)
		{
			//_poContainer->vSetGPSTime((tS16)SensorYear, (tU8)SensorMonth, (tU8)SensorDay, (tU8)SensorHour, (tU8)SensorMinute, (tU8)SensorSeconds);
			//Don't update always the GPS time, only update the GPS time when we were not able to read the RTC.
			// To Do: check do we really need the comparison for the year 2017
			//To Do: Check for the validity of the GNSS data
			if((_RTCValid == FALSE) && (GnssData.GnssPvtData.UtcTimeDate.td_year >= 2017))
			{
				_bGPSDataValid = TRUE;

				//Not able to read the RTC but we got the valids GPS data, update the system time to client.
				//Todo: check if there is any issue with the offset/local time update.
				_poContainer->vSetGPSTime((tS16)GnssData.GnssPvtData.UtcTimeDate.td_year,
						GnssData.GnssPvtData.UtcTimeDate.td_month,
						GnssData.GnssPvtData.UtcTimeDate.td_day,
						GnssData.GnssPvtData.UtcTimeDate.td_hour,
						GnssData.GnssPvtData.UtcTimeDate.td_minute,
						GnssData.GnssPvtData.UtcTimeDate.td_second);
			}

		}
	}
	//ETG_TRACE_USR4(("Mod_Clock: onGnssDataStatus:GPSType:%d,RTCValid:%d,GPS Type: %d",
	//		_GPSMountedType, _RTCValid,GnssData.GnssPvtData.GnssStatus.GnssMode));

   // onGnssDataStatus: user specific code end
}




// vd_clock_tclClientSensorIfvd_clock_ClientSensorIf: user specific code start
tBool vd_clock_tclClientSensorIf::isGPSDataValid()
{
    return _bGPSDataValid;
}
// vd_clock_tclClientSensorIfvd_clock_ClientSensorIf: user specific code end

//EOF
