/*****************************************************************************
* FILE:         vd_clock_ClientPosIf.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ClientPosIf__IF__H_
#define __vd_clock_ClientPosIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_vd_clock_ClientPosIf.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_ClientPosCallbackIf.h"

// vd_clock_tclClientPosIf_Include: user specific code start
#include "vd_clock_timezone.h"
#include "vd_clock_datacontainer.h"
// vd_clock_tclClientPosIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivd_clock_tclClientPos;

class vd_clock_tclClientPosIf : public Ivd_clock_tclClientPosIf, public vd_clock_tclClientPosCallbackIF
{
public:

   vd_clock_tclClientPosIf(tVoid); 
   vd_clock_tclClientPosIf(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientPosIf();

   virtual const tChar* getName() const { return "vd_clock_tclClientPosIf"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendPositionGet(){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendPositionGet();
   }
   virtual tVoid getPositionStatus(fi_tcl_PositionHeadingSpeed& rPositionElementBlock, fi_tcl_e8_PositionCalculationState& rPositionStatus, fi_tcl_PosixExactTime& rSensorPosixTime, fi_tcl_s32_Meter& rHeight, fi_tcl_s16_Degree& rInclination, fi_tcl_s16_CentimeterSecond& rAcceleration){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getPositionStatus(rPositionElementBlock, rPositionStatus, rSensorPosixTime, rHeight, rInclination, rAcceleration);
   }


   virtual tBool sendPositionInfoGet(){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendPositionInfoGet();
   }
   virtual tVoid getPositionInfoStatus(fi_tcl_RoadAttributes& rRoadAttributes, fi_tcl_PositionWGS84& rPositionCoord, fi_tcl_u8_DirectionAbsolute& rCourse, tBool& rIsEntryPoint, fi_tcl_PosixExactTime& rSensorPosixTime, std::vector<fi_tcl_SingleRoadInfo, std::allocator<fi_tcl_SingleRoadInfo> >& rPositionInfo){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getPositionInfoStatus(rRoadAttributes, rPositionCoord, rCourse, rIsEntryPoint, rSensorPosixTime, rPositionInfo);
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onPositionStatus(fi_tcl_PositionHeadingSpeed PositionElementBlock, fi_tcl_e8_PositionCalculationState PositionStatus, fi_tcl_PosixExactTime SensorPosixTime, fi_tcl_s32_Meter Height, fi_tcl_s16_Degree Inclination, fi_tcl_s16_CentimeterSecond Acceleration);
   virtual tVoid onPositionInfoStatus(fi_tcl_RoadAttributes RoadAttributes, fi_tcl_PositionWGS84 PositionCoord, fi_tcl_u8_DirectionAbsolute Course, tBool IsEntryPoint, fi_tcl_PosixExactTime SensorPosixTime, std::vector<fi_tcl_SingleRoadInfo, std::allocator<fi_tcl_SingleRoadInfo> > PositionInfo);


   // vd_clock_tclClientPosIfDeclarations: user specific code start

   virtual tFloat fLatLonDistance(tFloat lat1, tFloat lon1, tFloat lat2, tFloat lon2);
   virtual tFloat deg2rad(tFloat deg);
   virtual tFloat rad2deg(tFloat rad);
   virtual tFloat fConvertCoord(tS32 value)  const;

   tVoid vSwitchOnTime();
   tVoid vSwitchOnDistance();
   tVoid vSwitchOnBoth();
   tVoid vSwitchAutomatic();

   tU8 u8ReturnIndexOfTZ(tS16 CountryCode, tS16 Offset) const;

   tBool bCheckCurrentDaylightSavingTimeStatus(fi_tcl_e8_DST_State& DSTState);
   const vdclk_trTimezoneDetails& getTzDetails(tU16 u16IndexOfTimeZone) ;

   // vd_clock_tclClientPosIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ivd_clock_tclClientPos* _poClientRef;

// vd_clock_tclClientPosIfDeclarationsPart2: user specific code start

   vdclk_tclDataContainer* _poContainer;

   static const tU16  _cau16FIDs[];
  // static const tFloat _CONST_FACTOR;
   tInt               _lastTimeZoneValue;
   tU16               _u16IndexOfTimeZone;
   tS16               _s16OldCountryCode;

   tFloat            _latToTZChange;
   tFloat            _lonToTZChange;
   tFloat            _currentLat;
   tFloat            _currentLon;
   tFloat            _km_Value;

   tBool              _bSwitchOnTime;
   tBool              _bSwitchOnDistance;
   tBool              _bSwitchAutomatic;
   tBool              _bSwitchWhatIsFirst;
   tS32               _s32SwitchTimeCounter;
   VDCLK_TEN_TIMEZONE_Setting _enTIMEZONE_Setting;



// vd_clock_tclClientPosIfDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientPosIf__IF__H_


