
/*****************************************************************************
* FILE:         vd_clock_ClientPosIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientPosIfIncludes: user specific code start

#include "vd_clock_types.h"

// define how the switching should be run
// VDCLK_SWITCH_ON_TIME          = 0,
// VDCLK_SWITCH_ON_DISTANCE      = 1,
// VDCLK_SWITCH_ON_BOTH          = 2,
// VDCLK_SWITCH_AUTOMATIC        = 3
int CLK_SWITCH_MODE = VDCLK_SWITCH_AUTOMATIC;   // switch instantly if time zone change

// km from point of time zone change
#define SWITCH_DISTANCE    0.5      //(500m)

// seconds to change local time after crossing time zone border
#define CLK_SWITCH_TIME    120      // (2 minutes)

#define pi 3.14159265358979323846f

const tFloat _CONST_FACTOR = 360.0f / 4294967295.0f;

// vd_clock_tclClientPosIfIncludes: user specific code end

#include "vd_clock_ClientPosIf.h"
#include "Ivd_clock_ClientPos.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_POS
#include "trcGenProj/Header/vd_clock_ClientPosIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientPosIf::
*             vd_clock_tclClientPosIf(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientPosIf::vd_clock_tclClientPosIf(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientPosIf(poMainAppl)
{
   ETG_TRACE_USR4(("vd_clock_tclClientPosIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientPosIfConstructor: user specific code start
   _poContainer  = OSAL_NULL;

   _lastTimeZoneValue             = -1;
   _latToTZChange                 = 0.0;
   _lonToTZChange                 = 0.0;
   _currentLat                    = 0.0;
   _currentLon                    = 0.0;
   _km_Value                      = 0.0;
   _s32SwitchTimeCounter          = CLK_SWITCH_TIME;

   // set default time zone index
   _u16IndexOfTimeZone            = vdclk_u16DefaultTimeZoneIndex;

   // set default country code
   _s16OldCountryCode               =  0;

   // initial some bools
   _bSwitchOnTime                 = FALSE;
   _bSwitchOnDistance             = FALSE;
   _bSwitchAutomatic              = FALSE;
   _bSwitchWhatIsFirst            = FALSE;
   _enTIMEZONE_Setting			  = VDCLK_EN_Not_Changed;
   // vd_clock_tclClientPosIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientPosIf::
*             ~vd_clock_tclClientPosIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientPosIf::~vd_clock_tclClientPosIf(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientPosIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientPosIfDestructor: user specific code start
   _poContainer = OSAL_NULL;
   // vd_clock_tclClientPosIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPosIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientPosIf.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     POS_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPosIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientPosIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ivd_clock_tclClientPos*>(_cpoMain->getHandler("Ivd_clock_tclClientPos"));

   VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // vd_clock_tclClientPosIfvGetReferences: user specific code start
   
   _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));

   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
   // vd_clock_tclClientPosIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPosIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPosIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientPosIf::vStartCommunication() entered."));
   // vd_clock_tclClientPosIfvStartCommunication: user specific code start
   // vd_clock_tclClientPosIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPosIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPosIf::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientPosIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // vd_clock_tclClientPosIfvHandleMessage: user specific code start
   // vd_clock_tclClientPosIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPosIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPosIf::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientPosIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientPosIfvHandleTraceMessage: user specific code start
   // vd_clock_tclClientPosIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPosIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPosIf::vTraceInfo()
{
   // vd_clock_tclClientPosIfvTraceInfo: user specific code start
   // vd_clock_tclClientPosIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPosIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientPosIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientPosIf::onServiceAvailable() entered."));

   // vd_clock_tclClientPosIfvOnServiceAvailable: user specific code start
   // vd_clock_tclClientPosIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPosIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientPosIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientPosIf::onServiceUnavailable() entered."));

   // vd_clock_tclClientPosIfvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientPosIfvOnServiceUnavailable: user specific code end
}

tVoid vd_clock_tclClientPosIf::onPositionStatus(fi_tcl_PositionHeadingSpeed PositionElementBlock, fi_tcl_e8_PositionCalculationState PositionStatus, fi_tcl_PosixExactTime SensorPosixTime, fi_tcl_s32_Meter Height, fi_tcl_s16_Degree Inclination, fi_tcl_s16_CentimeterSecond Acceleration) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientPosIf::onPositionStatus(): CALLED" ) );

   // onPositionStatus: user specific code start

   (tVoid)PositionStatus;
   (tVoid)SensorPosixTime;
   (tVoid)Height;
   (tVoid)Inclination;
   (tVoid)Acceleration;

   // calculate lat and lon from current read message
   _currentLat = fConvertCoord(PositionElementBlock.PositionWGS84.Latitude.s32Value);
   _currentLon = fConvertCoord(PositionElementBlock.PositionWGS84.Longitude.s32Value);

   // switch on Time
   if(_bSwitchOnTime)
   {
	   vSwitchOnTime();
   }
   // switch on Distance
   else if(_bSwitchOnDistance)
    {
        vSwitchOnDistance();
    }
   // switch whatever comes first
   else if(_bSwitchWhatIsFirst)
    {
        vSwitchOnBoth();
    }
// switch on the spot if time zone change reached
   else if(_bSwitchAutomatic)
    {
        vSwitchAutomatic();
    }

   // onPositionStatus: user specific code end
}
tVoid vd_clock_tclClientPosIf::onPositionInfoStatus(fi_tcl_RoadAttributes RoadAttributes, fi_tcl_PositionWGS84 PositionCoord, fi_tcl_u8_DirectionAbsolute Course, tBool IsEntryPoint, fi_tcl_PosixExactTime SensorPosixTime, std::vector<fi_tcl_SingleRoadInfo, std::allocator<fi_tcl_SingleRoadInfo> > PositionInfo) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientPosIf::onPositionInfoStatus(): CALLED" ) );

   // onPositionInfoStatus: user specific code start

   (tVoid)RoadAttributes;
   (tVoid)PositionCoord;
   (tVoid)Course;
   (tVoid)IsEntryPoint;
   (tVoid)SensorPosixTime;
   (tVoid)PositionInfo;
   // onPositionInfoStatus: user specific code end
}




// vd_clock_tclClientPosIfvd_clock_ClientPosIf: user specific code start

tFloat vd_clock_tclClientPosIf::fConvertCoord(tS32 value) const
{
   return (tFloat)value * _CONST_FACTOR;
}

/*************************************************************************
*  FUNCTION:    vSwitchOnTime
*
*	DESCRIPTION: switches time zone automatically after reaching 0
*
*	PARAMETER:   none
*
*	RETURNVALUE: void
*************************************************************************/
tVoid vd_clock_tclClientPosIf::vSwitchOnTime()
{
   // decrease counter by 1
   _s32SwitchTimeCounter--;
   ETG_TRACE_COMP(("vSwitchOnTime() counter = %d" , (tS32)_s32SwitchTimeCounter));
   // did we reached 0?
   if(_s32SwitchTimeCounter == 0)
   {
      ETG_TRACE_COMP(("vSwitchOnTime()::Counter has reached 0" ));

      // reset all settings according time caused TZ change
      _bSwitchOnTime          = FALSE;
      _s32SwitchTimeCounter   = CLK_SWITCH_TIME;

      VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

      // set new local time
      if(_poContainer->bGetPositionBased())
	  {
    	  _poContainer->vSetTimeZone(_enTIMEZONE_Setting);
         _poContainer->vSetTimeZone(_u16IndexOfTimeZone);
   }
   }
}

/*************************************************************************
*  FUNCTION:    vSwitchOnDistance
*
*	DESCRIPTION: switches time zone automatically after reaching a distance
*               bigger than SWITCH_DISTANCE
*
*	PARAMETER:   none
*
*	RETURNVALUE: void
*************************************************************************/
tVoid vd_clock_tclClientPosIf::vSwitchOnDistance()
{
   // calculate distance from current position to coordinates while
   // crossing the time zone border
   _km_Value = fLatLonDistance(_latToTZChange,
                               _lonToTZChange,
                               _currentLat,
                               _currentLon);

   ETG_TRACE_COMP(("vSwitchOnDistance() km = %.3f", _km_Value)); //lint !e740: Unusual pointer cast...

   // if we reached the desired distance from time zone change point
   // switch the time zone
   if(_km_Value > SWITCH_DISTANCE)
   {
      // reset all settings according the distance TZ change
      _bSwitchOnDistance = FALSE;
      _km_Value = 0.0;

      VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

      // set new local time
      if(_poContainer->bGetPositionBased())
	  {
    	  _poContainer->vSetTimeZone(_u16IndexOfTimeZone);
    	  _poContainer->vSetTimeZone(_enTIMEZONE_Setting);
		  }
   }
}



/*************************************************************************
*  FUNCTION:    vSwitchOnBoth
*
*	DESCRIPTION: switches time zone when CLK_SWITCH_TIME in seconds after
*               time zone border crossing has gone by or
*               distance after time zone border crossing
*               is bigger than set in SWITCH_DISTANCE
*
*	PARAMETER:   none
*
*	RETURNVALUE: void
*************************************************************************/
tVoid vd_clock_tclClientPosIf::vSwitchOnBoth()
{
   // decrease counter by 1 until it is 0
   _s32SwitchTimeCounter--;

   // calculate distance from current position to coordinates while
   // crossing the time zone border
   _km_Value = fLatLonDistance(_latToTZChange,
                               _lonToTZChange,
                               _currentLat,
                               _currentLon);

   ETG_TRACE_COMP(("vSwitchOnBoth()  counter = %d km = %.3f" , (tS32)_s32SwitchTimeCounter, _km_Value)); //lint !e740: Unusual pointer cast...

   // check what comes first
   if((_km_Value > SWITCH_DISTANCE) || (_s32SwitchTimeCounter == 0))
   {
      // reset all settings
      _bSwitchWhatIsFirst = FALSE;
      _s32SwitchTimeCounter = CLK_SWITCH_TIME;
      _km_Value = 0.0;

      VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

      // set new local time
      if(_poContainer->bGetPositionBased())
	  {
      _poContainer->vSetTimeZone(_u16IndexOfTimeZone);
    	  _poContainer->vSetTimeZone(_enTIMEZONE_Setting);
	  }
   }
}

/*************************************************************************
*  FUNCTION:    vSwitchAutomatic
*
*	DESCRIPTION: switches time zone automatically without any delay
*
*	PARAMETER:   none
*
*	RETURNVALUE: void
*************************************************************************/
tVoid vd_clock_tclClientPosIf::vSwitchAutomatic()
{
   ETG_TRACE_COMP(("vSwitchAutomatic()"));

   // reset settings
   _bSwitchAutomatic = FALSE;

   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

   // set new local time
   if(_poContainer->bGetPositionBased())
   {
 	  _poContainer->vSetTimeZone(_u16IndexOfTimeZone);
	   _poContainer->vSetTimeZone(_enTIMEZONE_Setting);
	   }
}


/*************************************************************************
*  FUNCTION:    bCheckCurrentDaylightSavingTimeStatus
*
*	DESCRIPTION: Check Current Daylight Saving Time Status
*
*	PARAMETER:   fi_tcl_e8_DST_State DSTState
*
*	RETURNVALUE: tBool true if changed
*************************************************************************/
tBool vd_clock_tclClientPosIf::bCheckCurrentDaylightSavingTimeStatus(fi_tcl_e8_DST_State& DSTState)
{
   tBool bDSTChanged = FALSE;

   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);

   switch(DSTState.enType)
   {
      // Standard time (= UTC_TIME)
      case fi_tcl_e8_DST_State::FI_EN_T_STANDARDTIME:
		  ETG_TRACE_USR4(("DSTState=FI_EN_T_STANDARDTIME"));

		  _poContainer->vSetLastKnownDSTSettings((tU16)VDCLK_EN_DST_Off);

         // if switched from ON to OFF
         if(_poContainer->bGetDaylightSavingTimeOn() == TRUE)
         {
            // set DST without update the clock hmi
        	 _poContainer->vSetDaylightSavingTime(VDCLK_EN_DST_Off, FALSE);
            bDSTChanged = TRUE;
            ETG_TRACE_USR4(("DST changed to OFF"));
         }
         else
         {
            ETG_TRACE_USR4(("DST currently OFF"));
         }

      break;

      // daylight saving time (= UTC_TIME + 1)
      case fi_tcl_e8_DST_State::FI_EN_T_DAYLIGHTSAVINGTIME:
	   ETG_TRACE_USR4(("DSTState=FI_EN_T_DAYLIGHTSAVINGTIME"));

	   _poContainer->vSetLastKnownDSTSettings((tU16)VDCLK_EN_DST_On);

         // if switched from OFF to ON
         if(_poContainer->bGetDaylightSavingTimeOn() == FALSE)
         {
            // set DST without update the clock hmi
        	 _poContainer->vSetDaylightSavingTime(VDCLK_EN_DST_On, FALSE);
            bDSTChanged = TRUE;
            ETG_TRACE_USR4(("DST changed to ON"));
         }
         else
            ETG_TRACE_USR4(("DST currently ON"));

      break;

      // not used, just make lint happy
      case fi_tcl_e8_DST_State::FI_EN_T_EVALUATIONNECESSARY:
      default:
	   ETG_TRACE_USR4(("DSTState=default case"));
      break;
   } // end of switch DST_State
   return bDSTChanged;
}



/*************************************************************************
*  FUNCTION:    getTzDetails
*
*	DESCRIPTION: read from the table
*
*	PARAMETER:   tU16 u16IndexOfTimeZone 1..max based
*
*	RETURNVALUE: vdclk_rTZDetails entry
*************************************************************************/
const vdclk_trTimezoneDetails& vd_clock_tclClientPosIf::getTzDetails(tU16 u16IndexOfTimeZone)
{
   if(u16IndexOfTimeZone < 1 || u16IndexOfTimeZone > vdclk_u16NumberOfTimeZones) {
         ETG_TRACE_ERRMEM(("getTzDetails():got invalid index %d reset to 1!", u16IndexOfTimeZone));
         u16IndexOfTimeZone = 1;
   }
   return vdclk_rTZDetails[u16IndexOfTimeZone-1];
} //lint !e1762


/*************************************************************************
* FUNCTION:    u8ReturnIndexOfTZ(tU16 Offset, tU16 CountryCode)
*
* DESCRIPTION: Searches through the CountryCode matrix and returns
*              the value of the index which matches the Offset and
*              Country code
*
* PARAMETER:   tU16 offset of time zone, tU16 CountryCode for current position
*
* RETURNVALUE: tU8
*************************************************************************/
tU8 vd_clock_tclClientPosIf::u8ReturnIndexOfTZ(tS16 CountryCode, tS16 Offset) const
{
   tU8 retValue = 0;

   ETG_TRACE_USR4(("Search for new Time Zone Index for Code %d and Offset %d", CountryCode, Offset));

   // search for country code AND corresponding offset in vdclk_TZCountryCodes[]
   for(int i=0 ; i<vdclk_u16NumberOfCountryCodes ; i++)
   {
      if((CountryCode == vdclk_TZCountryCodes[i].s16CountryCode) && (Offset == vdclk_TZCountryCodes[i].s16TimeOffset))
      {
         // found new index
         retValue = vdclk_TZCountryCodes[i].u8IndexOfTZ;
         break;
      }
   }
   ETG_TRACE_USR4(("Found index %d",retValue));
   return retValue;
}


/*************************************************************************
*  FUNCTION:    fLatLonDistance
*
*	DESCRIPTION: calculates distance between two positions consisting
*               lat and lon coordinates
*
*	PARAMETER:    tFloat lat1, tFloat lon1, tFloat lat2, tFloat lon2
*
*	RETURNVALUE:  the distance between the points in km
*************************************************************************/
tFloat vd_clock_tclClientPosIf::fLatLonDistance(tFloat lat1,
                                                   tFloat lon1,
                                                   tFloat lat2,
                                                   tFloat lon2)
{
   ETG_TRACE_COMP(("calculate Lat Lon Distance"));

   tFloat theta, dist = 0.0;
   theta = lon1 - lon2;
   dist = sin((tDouble)deg2rad(lat1)) * sin((tDouble)deg2rad(lat2)) + cos((tDouble)deg2rad(lat1)) * cos((tDouble)deg2rad(lat2)) * cos((tDouble)deg2rad(theta));
   dist = acos((tDouble)dist);
   dist = rad2deg(dist);
   dist = dist * 60.0f * 1.1515f;
   return (dist);
}

/*************************************************************************
*  FUNCTION:    deg2rad
*
*	DESCRIPTION: converts a given value in degrees to radiants
*
*	PARAMETER:    tFloat deg
*
*	RETURNVALUE:  the value in radiant
*************************************************************************/
tFloat vd_clock_tclClientPosIf::deg2rad(tFloat deg)
{
   return ( deg * pi / 180.0f);
}

/*************************************************************************
*  FUNCTION:    rad2deg
*
*	DESCRIPTION: converts a given value in radiants to degrees
*
*	PARAMETER:    tFloat rad
*
*	RETURNVALUE:  the value in degree
*************************************************************************/
tFloat vd_clock_tclClientPosIf::rad2deg(tFloat rad)
{
   return ( rad * 180.0f / pi);
}


// vd_clock_tclClientPosIfvd_clock_ClientPosIf: user specific code end

//EOF
