/*
 * vd_clock_updater.cpp
 *
 *  Created on: Apr 23, 2015
 *      Author: vee4kor
 */


#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_UPDATER
#include "trcGenProj/Header/vd_clock_updater.cpp.trc.h"
#endif


#include "vd_clock_types.h"
#include "vd_clock_utils.h"
#include "vd_clock_datetime.h"
#include "vd_clock_datacontainer.h"
#include "vd_clock_updater.h"
#include "vd_clock_Event.h"
#include "vd_clock_AppMain_Trace.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_ClientSensorIf.h"


#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/rtc.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>

#if defined(VARIANT_S_FTR_ENABLE_FEAT_SET_CLOCK_OPEL)
#include "ExternalSourceListener/vd_clock_ExtSourceListener_mcopel.h"
#elif defined(VARIANT_S_FTR_ENABLE_FEAT_SET_CLOCK_VAG)
#include "ExternalSourceListener/vd_clock_ExtSourcerListener_csm.h"
#elif defined(VARIANT_S_FTR_ENABLE_CLOCK_CAN_BAP_RECEPTION)
#include "ExternalSourceListener/vd_clock_ExtSourceListener_Bap.h"
#else
#include "ExternalSourceListener/vd_clock_ExtSourceListener.h"
#endif


Ivd_clock_tclClientSensorIf* vdclk_tclUpdater:: _poClientSensor = NULL;


// Trace class definition
#undef _CLASS

#define _CLASS   ((tU16) TR_CLASS_VD_CLOCK_UPDATER)

tString VDCLK_C_UpdaterThreadName  = (tString) "CLK_UpdThread"; //lint !e1773 based on OSAL interface description no change possible

// ****************************************************************************
// ***			C l a s s   I n t e r f a c e   F u n c t i o n s				 ***
// ****************************************************************************

vdclk_tclUpdater:: vdclk_tclUpdater	(vd_clock_tclAppMain* poMainAppl):vd_clock_tclBaseIf(poMainAppl)
{
    ETG_TRACE_COMP(("Flow-Event: %d", ETG_ENUM(VD_CLOCK_FlowEvents,TR_EN_FlowEventCTOR)));


    _bDefaultState = FALSE;
	_bDefaultStateDA = false;
	_bDefaultStateNAR = false;
	_RTCOpenReadStatus = false;
	_RTCValidOnce = false;
	_bBAPAvailable = false;
	_bCANAvailable = false;
	_poContainer = NULL;
	vdclk_poRunIndicator = NULL;
	_poUpdateTrigger = NULL;
	_poExtSourceListener = NULL;
	m_poINCAdapter = NULL;

	retval = -1;

	// initialize member variables
	_hTickTimer = OSAL_C_INVALID_HANDLE;
	_hRTC       = OSAL_ERROR;
	_u32LocalTimeOnLastTick = OSAL_C_U32_INFINITE;
	_fdRTC = -1;		//Coverity Issue not declared

   // store self reference for acces to class methods/data in callbacks
   // and threads
   _poUpdater = this;
  // _poApp = poMainAppl;
   //Object for eventhandler class, which handles event related thread status
   vdclk_poRunIndicator = new vdclk_tclEvent ("CLK_RunEvt");
   VDCLOCK_ASSERT_NORMAL_RETURN(NULL != vdclk_poRunIndicator);

   // Object for event handler class, which handle event for updater class(update time from source)
   _poUpdateTrigger = new vdclk_tclEvent("CLK_UpdtTrgEvt");
   VDCLOCK_ASSERT_NORMAL_RETURN(NULL != _poUpdateTrigger);


#if defined(VARIANT_S_FTR_ENABLE_FEAT_SET_CLOCK_OPEL)
   _poExtSourceListener = OSAL_NEW vdclk_ExtSourceListener_vwllnf(_poUpdateTrigger, _poContainer);
#elif defined(VARIANT_S_FTR_ENABLE_FEAT_SET_CLOCK_VAG)
   _poExtSourceListener = OSAL_NEW vdclk_ExtSourceListener_vwmibe(_poUpdateTrigger, _poContainer);
#else
   _poExtSourceListener = OSAL_NEW vdclk_ExtSourceListener(); //lint !e1713 Redundant parentheses ignored
#endif

   // set my own life status indicator
   if(vdclk_poRunIndicator)
   vdclk_poRunIndicator->vPost ( cu32EventMaskUpdaterAlive, _CLASS, __LINE__ );

}

// ****************************************************************************

vdclk_tclUpdater::~vdclk_tclUpdater (	tVoid )
{
	_poContainer = NULL;
	m_poINCAdapter = NULL;

	_bDefaultStateDA = false;
	_bDefaultStateNAR = false;
	_RTCOpenReadStatus = false;
	_RTCValidOnce = false;
	retval = -1;

   if (OSAL_NULL==vdclk_poRunIndicator) {
      ETG_TRACE_ERR(("~vdclk_tclUpdater: vdclk_poRunIndicator==NULL"));
   }
   else {
       OSAL_DELETE vdclk_poRunIndicator;
   }

   if (OSAL_NULL==_poUpdateTrigger) {
      ETG_TRACE_ERR(("~vdclk_tclUpdater: _poUpdateTrigger==NULL"));
   }
   else {
       OSAL_DELETE _poUpdateTrigger;
   }
   if (OSAL_NULL==_poExtSourceListener) {
      ETG_TRACE_ERR(("~vdclk_tclUpdater: _poExtSourceListener==NULL"));
   }
   else {
       OSAL_DELETE _poExtSourceListener;
   }

}

// ****************************************************************************

tBool	 vdclk_tclUpdater::	bShutdown ()
{

	ETG_TRACE_COMP(("Updater Shutdown called "));

#if 0
   tS32  s32Err         = OSAL_OK;
#endif // if 0
// not usfull in shutdown   VDCLOCK_ASSERT_NORMAL_RETURN_VAL(OSAL_ERROR  != _hRTC,FALSE);

   // terminate Updater Thread
   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poUpdateTrigger)
   _poUpdateTrigger->vPost ( cu32CmdEventTerminateUpdaterThread, _CLASS, __LINE__ );


   VD_CLOCK_NULL_POINTER_CHECK_VAL(vdclk_poRunIndicator);

	// wait until updater thread is closed
	if(vdclk_poRunIndicator-> bAwaitClearance ( cu32EventMaskUpdaterThreadAlive, cu32TerminationTimeOutUpdaterThread, /* (timeout after 200ms) */
			_CLASS, __LINE__ ))
	{
		ETG_TRACE_COMP(("Updater Thread not closed after 200 ms"));
		//return FALSE;
	}

#if 0
#if (OSAL_CONF == OSAL_WINNT) || defined(LSIM)
   ;
#else
	   s32Err = OSAL_s32IOClose( _hRTC );
#endif

   if (OSAL_OK != s32Err) {
       ETG_TRACE_ERR(("OSAL_s32IOClose(_hRTC) failed:code=%s",
                        VDCLK_OsalErrorString() ));
    }
   _hRTC = OSAL_ERROR;
#endif

	tS32 retvalClose = -1;
	retvalClose = close(_fdRTC);

	if(retvalClose < 0)
	{
		ETG_TRACE_USR4(("error in closing the device file"));
	}
	else
	{
		ETG_TRACE_USR4(("RTC File closed successfully"));
	}

   // objects aren't owned by this class so the pointers are
   // just invalidated
   _poUpdater		  = OSAL_NULL;

   // clear my own life status indicator
   vdclk_poRunIndicator-> vClear ( cu32EventMaskUpdaterAlive, _CLASS, __LINE__ );
   ETG_TRACE_COMP(("Flow-Event: %d", ETG_ENUM(VD_CLOCK_FlowEvents,TR_EN_FlowEventDTOR)));
   return TRUE;
}

// ****************************************************************************

tVoid	 vdclk_tclUpdater:: vTriggerUpdate ( OSAL_tEventMask u32TrigEvents )
{
   VDCLOCK_ASSERT_NORMAL_RETURN(OSAL_NULL != _poUpdateTrigger);
   _poUpdateTrigger-> vPost (u32TrigEvents, _CLASS, __LINE__);
};



// ****************************************************************************
// ***				C l a s s   P r i v a t e   S e c t i o n						 ***
// ****************************************************************************

vdclk_tclUpdater*	vdclk_tclUpdater::_poUpdater = NULL;

// ****************************************************************************
/*
vdclk_tclUpdater::vdclk_tclUpdater ()
{
   // default constructor

   _hTickTimer = OSAL_C_INVALID_HANDLE;
   _hRTC = OSAL_ERROR;
   _u32LocalTimeOnLastTick = OSAL_C_U32_INFINITE;
   _bBAPAvailable = false;
   _bCANAvailable = false;
   _poContainer = NULL;
   vdclk_poRunIndicator = NULL;
   _poUpdateTrigger = NULL;
   _poExtSourceListener = NULL;
}
*/
// ****************************************************************************
// ***			    	    U p d a t e r   T h r e a d 						       ***

tVoid	 vdclk_tclUpdater::vStartUpdaterThread ()
{
    ETG_TRACE_COMP(("Flow-Event: %d", ETG_ENUM(VD_CLOCK_FlowEvents,TR_EN_FlowEventInvoke)));

   // read thread prio and stack size from registry,
   //   fall back to default values on error
   tU32 u32ThreadPriority = vdclk_u32GetRegistryValue ( VDCLK_KeyRTCPrio, _CLASS, __LINE__ );   // Tracing information _CLASS
   tU32 u32ThreadStacksize = vdclk_u32GetRegistryValue ( VDCLK_KeyRTCStack, _CLASS, __LINE__ );  // Tracing information _CLASS and Line

  // tU32 u32ThreadPriority = 0x0000004D;
   //tU32 u32ThreadStacksize = 0x00000400;
   // free ressources of previous thread (if any)
   static OSAL_tThreadID   _hUpdaterThreadId = 0;
   if (_hUpdaterThreadId)
   {
      OSAL_s32ThreadDelete(_hUpdaterThreadId);
   }

   // configure and start new thread
#if (OSAL_CONF == OSAL_TENGINE)
   u32ThreadStacksize = 1024; 	//workaround for LCN2kai- it will be removed when registry changes.
#endif
   OSAL_trThreadAttribute tThreadAttribute = { VDCLK_C_UpdaterThreadName,
                                               u32ThreadPriority,
                                               (tS32) u32ThreadStacksize,
                                               (OSAL_tpfThreadEntry) vUpdatingLoopStarter,
                                               (tVoid*) this };
   _hUpdaterThreadId = OSAL_ThreadSpawn ( &tThreadAttribute );
   VDCLOCK_ASSERT_NORMAL_RETURN(OSAL_ERROR != _hUpdaterThreadId);

   return;
}

// ****************************************************************************

tVoid vdclk_tclUpdater::vUpdatingLoopStarter(tVoid* pvArg)
{
    vdclk_tclUpdater* poThis = (vdclk_tclUpdater*) pvArg;
    VDCLOCK_ASSERT_NORMAL_RETURN(OSAL_NULL != poThis);
    poThis->vUpdatingLoop();
}


tVoid	 vdclk_tclUpdater::vUpdatingLoop()
{
   // check if pointers are valid
   VDCLOCK_ASSERT_NORMAL_RETURN(OSAL_NULL != vdclk_poRunIndicator);

   vdclk_tclDataContainer* poCont = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));
   //VD_CLOCK_NULL_POINTER_CHECK(poCont);
   // initialize listeners
   vSetupTickTimer();


   VDCLOCK_ASSERT_NORMAL_RETURN(OSAL_NULL != _poExtSourceListener);

   // prepare event status buffer and mask
   OSAL_tEventMask  u32EventStatus = 0;
   OSAL_tEventMask  u32EventMask
      = cu32TrigEventTimer
        | cu32TrigEventCANClockReceived
        | cu32TrigEventCANClockTimeOut
        | cu32TrigEventCANFormatReceived
        | cu32TrigEventCANFormatTimeOut
        | cu32TrigEventVehicledata_CANClockReceived
        | cu32TrigEventVehicledata_CANClockTimeOut
        | cu32TrigEventEXTClock_BAPClockReceived
        | cu32TrigEventExtClock_BAPClockTimeOut
        | cu32CmdEventTerminateUpdaterThread;

   // indicate, that we are alive
   if(vdclk_poRunIndicator)
   vdclk_poRunIndicator-> vPost( cu32EventMaskUpdaterThreadAlive, _CLASS, __LINE__ );

#if (OSAL_CONF == OSAL_WINNT) || defined(LSIM)
   ;
#else
//   _hRTC = OSAL_IOOpen( OSAL_C_STRING_DEVICE_RTC, OSAL_EN_READWRITE );

	struct rtc_time rtc_tm_da;

	rtc_tm_da.tm_hour = 1;
	rtc_tm_da.tm_isdst = 0;
	rtc_tm_da.tm_mday = 1;
	rtc_tm_da.tm_min = 0;
	rtc_tm_da.tm_mon =  1;
	rtc_tm_da.tm_sec = 0;
	rtc_tm_da.tm_wday = 1;
	rtc_tm_da.tm_yday = 1;
	rtc_tm_da.tm_year = 117;

	for( int itr=0; itr<7; itr++ )
	{
		ETG_TRACE_USR4(("Mod_Clock: No of trail:%d", itr));

		_fdRTC = open("/dev/rtc",O_RDWR);

		if ( _fdRTC >= 0 )
		{
			retval = ioctl(_fdRTC, RTC_RD_TIME, &rtc_tm_da);
			if( (retval < 0) || (rtc_tm_da.tm_year == 117 && rtc_tm_da.tm_mon == 1 && rtc_tm_da.tm_hour == 1  && rtc_tm_da.tm_min == 0 && rtc_tm_da.tm_sec == 0) )
			{
				tS32 RTCCloseStatus = 0;
				RTCCloseStatus = close(_fdRTC);
				OSAL_s32ThreadWait(300);
			}
			else
			{
				_RTCValidOnce = TRUE;
				break;
			}
		}
		else
		{
			OSAL_s32ThreadWait(300);
		}
	}
	if ( (rtc_tm_da.tm_year == 117 && rtc_tm_da.tm_mon == 1 && rtc_tm_da.tm_hour == 1  && rtc_tm_da.tm_min == 0 && rtc_tm_da.tm_sec == 0 ) )
	{
		//RTC got closed above so open the RTC again
		_fdRTC = open("/dev/rtc",O_RDWR);
		if ( _fdRTC >= 0 )
		{
			retval = ioctl(_fdRTC, RTC_RD_TIME, &rtc_tm_da);
		}
		//ETG_TRACE_USR4(("Mod_Clock: RTC could not be able to open after all trials:FD:%d, RTC status:%d", _fdRTC, retval));
	}

	ETG_TRACE_USR4(("Mod_Clock: vUpdatingLoop RTC Status: Open:%d Read:%d ReadOnce:%d", _fdRTC, retval,_RTCValidOnce ));
	ETG_TRACE_USR3(("Mod_Clock: RTC Time(Initial): (YY:MM:DD:HH:MM:SS) %d:%d:%d:%d:%d:%d",
			rtc_tm_da.tm_year,
			rtc_tm_da.tm_mon,
			rtc_tm_da.tm_mday,
			rtc_tm_da.tm_hour,
			rtc_tm_da.tm_min,
			rtc_tm_da.tm_sec));

	/*   struct rtc_time rtc_tm_da;

   rtc_tm_da.tm_hour = 1;
   rtc_tm_da.tm_isdst = 0;
   rtc_tm_da.tm_mday = 1;
   rtc_tm_da.tm_min = 0;
   rtc_tm_da.tm_mon =  1;
   rtc_tm_da.tm_sec = 0;
   rtc_tm_da.tm_wday = 1;
   rtc_tm_da.tm_yday = 1;
   rtc_tm_da.tm_year = 117;

   retval = ioctl(_fdRTC, RTC_RD_TIME, &rtc_tm_da);*/

	//todo: Set the default value for the DA variant to 1:00, 1, 1, 2017, RX6110
	if ( _poContainer != NULL )
	{
		if ( ( _poContainer->getGPSType() == 0x02)
				&& ( (rtc_tm_da.tm_year == 70 )
						|| retval < 0)
						&& _bDefaultStateDA == FALSE
		) //variant type
		{
			//try it out
			struct rtc_time rtc_tm1;
			rtc_tm1.tm_hour = 1;
			rtc_tm1.tm_isdst = 0;
			rtc_tm1.tm_mday = 1;
			rtc_tm1.tm_min = 0;
			rtc_tm1.tm_mon =  10;
			rtc_tm1.tm_sec = 0;
			rtc_tm1.tm_wday = 1;
			rtc_tm1.tm_yday = 1;
			rtc_tm1.tm_year = 117;
			tS32 Write_retval = -1;
			Write_retval = ioctl(_fdRTC, RTC_SET_TIME, &rtc_tm1);

			if ( poCont != NULL)
				poCont-> vFactoryReset();

			_bDefaultStateDA =  TRUE;  // TO DO: check for 120 seconds ACC off/ON

			ETG_TRACE_USR4(("Mod_Clock:Factory reset for the DA variant. Write status to RTC:%d , DefaultState:DA %d", Write_retval, _bDefaultStateDA));
		}


		// NAV VAriant

		if(retval < 0)
		{
			if ( (rtc_tm_da.tm_year == 117 && rtc_tm_da.tm_mon == 1 && rtc_tm_da.tm_hour == 1  && rtc_tm_da.tm_min == 0)//&& rtc_tm_da.tm_sec == 0
					&& _bDefaultStateNAR == FALSE && _poContainer->getGPSType() == 0x01 )
			{
				//Default value of RTC so reset the datapool.

				if ( poCont != NULL)
					//poCont->vFactoryReset(); // no need of reset in cmc variants
				_bDefaultStateNAR = TRUE;
				ETG_TRACE_USR4(("Mod_Clock:Factory reset for the NAR variant. DefaultState:NAR %d",_bDefaultStateNAR));
			}
		}
	}

#endif

    _RTCOpenReadStatus = TRUE;

	// ---   main loop   ---
	// terminating at event: cu32CmdEventTerminateUpdaterThread
	OSAL_trTimeDate  tTmpTimeDate;
	tTmpTimeDate.s32Second = 0;
	tTmpTimeDate.s32Minute = 0;
	tTmpTimeDate.s32Hour = 1;
	tTmpTimeDate.s32Day = 1;
	tTmpTimeDate.s32Month = 1;
	tTmpTimeDate.s32Year = 117;
	tTmpTimeDate.s32Weekday = 0;
	tTmpTimeDate.s32Yearday = 0;
	tTmpTimeDate.s32Daylightsaving = 0;

   OSAL_tenRtcTimeState  tRtcTimeState = OSAL_RTC_VALID;  // NIKAI-5913


   struct rtc_time rtc_tm;

	rtc_tm.tm_hour = 1;
	rtc_tm.tm_isdst = 0;
	rtc_tm.tm_mday = 1;
	rtc_tm.tm_min = 0;
	rtc_tm.tm_mon =  1;
	rtc_tm.tm_sec = 0;
	rtc_tm.tm_wday = 1;
	rtc_tm.tm_yday = 1;
	rtc_tm.tm_year = 117;

   for (; /* ever */ ;)
   {
      _poUpdateTrigger-> vWait ( u32EventMask, 1500, &u32EventStatus, _CLASS, __LINE__ );


      if ( u32EventStatus != 0L )
      {
         // ----------------------------------------
         // ---   termination command received   ---
         if (cu32CmdEventTerminateUpdaterThread & u32EventStatus)
         {
             break;  // terminate infinite loop
         }

         // clear events
		 if(_poUpdateTrigger!=OSAL_NULL)
         _poUpdateTrigger-> vClear (u32EventStatus, _CLASS, __LINE__);

#if 0 // to be removed in future releases


#if (OSAL_CONF == OSAL_WINNT) || defined(LSIM)
		 tS32 s32Err  = OSAL_s32ClockGetTime(&tTmpTimeDate);
#elif (OSAL_CONF == OSAL_NUCLEUS)
         // read time stamp from RTC
         // (instead of OSAL_s32ClockGetTime as we have the device open anyway)
		 tS32 s32Err = OSAL_s32IOControl
          ( _hRTC,OSAL_C_S32_IOCTRL_RTC_GET_RTC_TIME,(tS32) &tTmpTimeDate);
#else
	     OSAL_trRtcRead rRtcRead;
	     rRtcRead.RegisterForRtcTime.updateRate = 0;
	     rRtcRead.RegisterForRtcTime.registerForNotify = OSAL_RTC_NOTIFY_ON_GPS_TIME;
	     tS32 s32Err = OSAL_s32IORead(_hRTC, (tPS8)&rRtcRead,sizeof(rRtcRead));
	     tTmpTimeDate = rRtcRead.RtcTimes.gpsUtcTime;
        tRtcTimeState = rRtcRead.RtcTimes.gpsUtcTimeState;  // NIKAI-5913
#endif
         if (OSAL_OK != s32Err) {
             ETG_TRACE_ERR(("OSAL_s32IORead(_hRTC=%d) failed:code=%s",_hRTC,
            		          VDCLK_OsalErrorString()));
         }

#endif


#if (OSAL_CONF == OSAL_WINNT) || defined(LSIM)
		 tS32 s32Err  = OSAL_s32ClockGetTime(&tTmpTimeDate);

	     rtc_tm.tm_year = tTmpTimeDate.s32Year;
	     rtc_tm.tm_mon = tTmpTimeDate.s32Month;
	     rtc_tm.tm_mday = tTmpTimeDate.s32Day;
	     rtc_tm.tm_hour = tTmpTimeDate.s32Hour;
	     rtc_tm.tm_min = tTmpTimeDate.s32Minute;
	     rtc_tm.tm_sec = tTmpTimeDate.s32Second;
	     rtc_tm.tm_wday = tTmpTimeDate.s32Weekday;
	     rtc_tm.tm_yday = tTmpTimeDate.s32Yearday;
	     rtc_tm.tm_isdst = tTmpTimeDate.s32Daylightsaving;

#else


			/*if(_poClientSensor->isGPSDataValid() && GPSType == 0x01)
         {
			 //tRtcTimeState = OSAL_RTC_INVALID;
         }*/
			//else
			//{

			retval = ioctl(_fdRTC, RTC_RD_TIME, &rtc_tm);
			if(retval <0)
			{
				// remove later
				tRtcTimeState = OSAL_RTC_INVALID;
			}
			else
			{
				_RTCValidOnce = TRUE;
				tRtcTimeState = OSAL_RTC_VALID;
			}

			//}
			if (_poClientSensor != NULL && _poContainer != NULL )
			{
				ETG_TRACE_USR4(("Mod_Clock: vUpdatingLoop RTC read Status: isGPSDataValid:%d, GPSType:%d,tRtcTimeState:%d ReturnValue_Read:%d ",
						_poClientSensor->isGPSDataValid(), _poContainer->getGPSType(), tRtcTimeState, retval ));
			}
#endif



			/*if ( (rtc_tm.tm_year == 117 && rtc_tm.tm_mon == 1 && rtc_tm.tm_hour == 1 && rtc_tm.tm_sec == 0 && rtc_tm.tm_min == 0)
				 && _bDefaultState == FALSE )
		 {
			 //Default value of RTC so reset the datapool.
			 poCont->vFactoryReset();
			 _bDefaultState = TRUE;

		 }*/

			ETG_TRACE_USR3(("Mod_Clock: RTC Time: (YY:MM:DD:HH:MM:SS) %d:%d:%d:%d:%d:%d",
					rtc_tm.tm_year,
					rtc_tm.tm_mon,
					rtc_tm.tm_mday,
					rtc_tm.tm_hour,
					rtc_tm.tm_min,
					rtc_tm.tm_sec));



         // --------------------------------
         // ---   Timer event received   ---
         if ( cu32TrigEventTimer & u32EventStatus )
         {
           //  TRACE_OSALDateTime("vUpdatingLoop", tTmpTimeDate, _CLASS, __LINE__ );
             //ETG_TRACE_USR3(("GPS_RTC_TIMESTATE VALUE %d",tRtcTimeState));

             // Increment the internal timer and update the container
             if(poCont)
             poCont-> vOnTickTimerEvent (rtc_tm, tRtcTimeState); //tRtcTimeState is always OSAL_RTC_VALID for nucleus, winnt

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_CLOCK_OPEL
             tBool bLocalTimeAdjusted = FALSE;
             if (VDCLK_EN_SyncMode_CAN != poCont->enGetSyncMode()) {
                 vdclk_tclDateTime  oLocalDateTime;
                 poCont->vGetLocalDateTime(&oLocalDateTime);
                 ETG_TRACE_USR4(("OldLocalTime?? %u",_u32LocalTimeOnLastTick));
                 tU32 u32NewLocalTime = oLocalDateTime.u32GetValue();
                 ETG_TRACE_USR4(("NewLocalTime?? %u",u32NewLocalTime));
                 tS64 s64TimeDiff = (tS64)u32NewLocalTime - (tS64)_u32LocalTimeOnLastTick;

                 if ((s64TimeDiff > 2) || (s64TimeDiff<0)) {
                     bLocalTimeAdjusted = TRUE;
                     // write UTC time /date to CAN (mNavData)
                     ETG_TRACE_USR1(("NewLocalTime for CAN %u",u32NewLocalTime));
                 }
                 TRACE_Etas(TR_EN_EtasCode_LocalTimeAdjusted, bLocalTimeAdjusted, 0, 0, 0);

                 _u32LocalTimeOnLastTick = u32NewLocalTime;
                 _poExtSourceListener->vWriteCSMLocalTimeDate (oLocalDateTime, bLocalTimeAdjusted);
             }
#endif

#ifdef VARIANT_S_FTR_ENABLE_CLOCK_CAN_BAP_RECEPTION
             // write UTC time /date to CAN (mNavData)
            _poExtSourceListener->vWriteCSMTimeDate (tTmpTimeDate);
#endif

			};
			// --------------------------------------------
			// ---   CAN-message (Date/Time) received   ---

			/* commented for interrupt shutdown */
			/*         if ( cu32TrigEventCANClockReceived & u32EventStatus )
         {

        	 if(poCont)
             if (VDCLK_EN_SyncMode_Manual != poCont->enGetSyncMode()) {

                 tU8 enChangeMask = 0;
                 // read and validate date and time from CAN-message
                 _poExtSourceListener->vReadCSMDateTime(tTmpTimeDate, enChangeMask);

                 // special handling for invalid date effecting date format
                 static tU8 u8LastChangeMask = 0;
                 if ((enChangeMask & ((tU8) VDCLK_EN_DateChange)) != u8LastChangeMask)
                 {
                     // trigger evaluation of CAN format
                     u32EventStatus |= cu32TrigEventCANFormatReceived;
                     u8LastChangeMask = (enChangeMask & ((tU8) VDCLK_EN_DateChange));
                 }

                 // update data container
                 poCont-> vOnClockExtSourceListenerEvent ( tTmpTimeDate,
                                                        enChangeMask );


        	 ETG_TRACE_USR4(("received cu32TrigEventCANClockReceived"));

        	 m_poINCAdapter->vGetMCANTime(tTmpTimeDate);

			 ETG_TRACE_USR4(("MCANTimeDate Year %d",tTmpTimeDate.s32Year));
			 ETG_TRACE_USR4(("MCANTimeDate Month %d",tTmpTimeDate.s32Month));
			 ETG_TRACE_USR4(("MCANTimeDate Day %d",tTmpTimeDate.s32Day));
			 ETG_TRACE_USR4(("MCANTimeDate Hours %d",tTmpTimeDate.s32Hour));
			 ETG_TRACE_USR4(("MCANTimeDate Minutes %d",tTmpTimeDate.s32Minute));
			 ETG_TRACE_USR4(("MCANTimeDate Seconds %d",tTmpTimeDate.s32Second));

			 if(poCont)
			 {
 		        poCont-> vOnClockExtSourceListenerEvent ( tTmpTimeDate, VDCLK_EN_AllChange);
			 }
             //}
         }*/

			// --------------------------------------------
			// ---   CAN-message (Date/Time) time-out   ---
			/* commented for interrupt shutdown */
			/*        if ( cu32TrigEventCANClockTimeOut & u32EventStatus )
         {

            // update data container
        	if(poCont)
        		poCont->vOnClockExtSourceListenerEvent ( tTmpTimeDate, 0);  // change mask indicates all invalid
         }*/

			// -----------------------------------------
			// ---   CAN-message (Format) received   ---
			/* commented for interrupt shutdown */
			/*         if ( cu32TrigEventCANFormatReceived & u32EventStatus )
         {
           // VDCLK_TEN_TimeFormat    enTimeFormat;
           // VDCLK_TEN_DateFormat    enDateFormat;
            tU32                    u32TimeFormat = 0;
            tU32                    u32DateFormat = 0;
            tBool                   bFormatMasterAvailable = FALSE;
            if(_poExtSourceListener)
            _poExtSourceListener->vReadCSMFormat ( //enTimeFormat,
                                               // enDateFormat,
            		                            u32TimeFormat,
            		                            u32DateFormat,
                                                bFormatMasterAvailable );
            // update data container
            if(poCont)
            poCont->  vOnFormatExtSourceListenerEvent ( //enTimeFormat,
                                                     //enDateFormat,
            		                                 u32TimeFormat,
                                                     u32DateFormat,
                                                     bFormatMasterAvailable );
         }*/

			// -----------------------------------------
			// ---   CAN-message (Format) received   ---
			/* commented for interrupt shutdown */
			/*         if ( cu32TrigEventCANFormatTimeOut & u32EventStatus )
         {
            // update data container
        	if(poCont)
            poCont-> vOnFormatExtSourceListenerEvent ( (VDCLK_TEN_TimeFormat) 0,
                                                    (VDCLK_TEN_DateFormat) 0,
                                                    FALSE );
         }*/

			// ---   BAP-message (Date/Time) received   ---
			/* commented for interrupt shutdown */
			/*if ( cu32TrigEventEXTClock_BAPClockReceived & u32EventStatus )
         {
        	 ETG_TRACE_USR4(("received cu32TrigEventEXTClock_BAPClockReceived"));
        	 _bBAPAvailable = true;
        	// if(poCont)
        	// poCont->vSetBAPAvailability(_bBAPAvailable);
                 // update data container
        	 if(_poExtSourceListener)
        	 {
        		 _poExtSourceListener->vGetBAPTime(tTmpTimeDate);

        		 // remove it after final release
    			 ETG_TRACE_USR4(("tTmpTimeDate Year %d",tTmpTimeDate.s32Year));
    			 ETG_TRACE_USR4(("tTmpTimeDate Month %d",tTmpTimeDate.s32Month));
    			 ETG_TRACE_USR4(("tTmpTimeDate Day %d",tTmpTimeDate.s32Day));
    			 ETG_TRACE_USR4(("tTmpTimeDate Hours %d",tTmpTimeDate.s32Hour));
    			 ETG_TRACE_USR4(("tTmpTimeDate Minutes %d",tTmpTimeDate.s32Minute));
    			 ETG_TRACE_USR4(("tTmpTimeDate Seconds %d",tTmpTimeDate.s32Second));

    			 if(poCont)
    			 {
        		    poCont-> vOnClockExtSourceListenerEvent ( tTmpTimeDate,
        		                		 VDCLK_EN_AllChange);
    			 }
        	 }

         }

         // ---   BAP-message (Date/Time) time-out   ---
         if ( cu32TrigEventExtClock_BAPClockTimeOut & u32EventStatus )
         {
        	 ETG_TRACE_USR4(("received cu32TrigEventExtClock_BAPClockTimeOut"));
        	 _bBAPAvailable = false;
        	// if(poCont)
        	// poCont->vSetBAPAvailability(_bBAPAvailable);
         }*/

			// ---   CAN-message (Date/Time) received   ---
			/* commented for interrupt shutdown */
			/*         if ( cu32TrigEventVehicledata_CANClockReceived & u32EventStatus )
         {
        	 ETG_TRACE_USR4(("received cu32TrigEventVehicledata_CANClockReceived"));

        	 _bCANAvailable = true;
                 // update data container
        	 ETG_TRACE_USR4(("_bBAPAvailable %d",_bBAPAvailable));
        	 if(!_bBAPAvailable)
        	 {
        		 if(_poExtSourceListener)
        		 {
        			 _poExtSourceListener->vGetCANTime(tTmpTimeDate);

        			 // remove it after final release
        			 ETG_TRACE_USR4(("tTmpTimeDate Year %d",tTmpTimeDate.s32Year));
        			 ETG_TRACE_USR4(("tTmpTimeDate Month %d",tTmpTimeDate.s32Month));
        			 ETG_TRACE_USR4(("tTmpTimeDate Day %d",tTmpTimeDate.s32Day));
        			 ETG_TRACE_USR4(("tTmpTimeDate Hours %d",tTmpTimeDate.s32Hour));
        			 ETG_TRACE_USR4(("tTmpTimeDate Minutes %d",tTmpTimeDate.s32Minute));
        			 ETG_TRACE_USR4(("tTmpTimeDate Seconds %d",tTmpTimeDate.s32Second));

        			 if(poCont)
        			 {
                        poCont-> vOnClockExtSourceListenerEvent (tTmpTimeDate,
                		    VDCLK_EN_AllChange);
        			 }
        		 }
        	 }

         }*/
			// --------------------------------------------
			// ---   CAN-message (Date/Time) time-out   ---
			/* commented for interrupt shutdown */
			/*         if ( cu32TrigEventVehicledata_CANClockTimeOut & u32EventStatus )
         {
        	 ETG_TRACE_USR4(("received cu32TrigEventVehicledata_CANClockTimeOut"));
        	 _bCANAvailable = false;

         }*/
		}
		// -------------------------------------
		// ---   received something unknown  ---
		else
		{
			ETG_TRACE_ERR(("unknown Event:%u", u32EventMask));
		};
	};

   // do the cleanup
   vShutdownTickTimer();
 //OSAL_DELETE _poExtSourceListener;
// _poExtSourceListener = OSAL_NULL;
   if(_poUpdateTrigger)
   _poUpdateTrigger->vClear ( cu32CmdEventTerminateUpdaterThread, _CLASS, __LINE__ );

  //OSAL_DELETE _poUpdateTrigger;
// _poUpdateTrigger = NULL;

   // indicate closure
   if(vdclk_poRunIndicator)
   vdclk_poRunIndicator-> vClear ( cu32EventMaskUpdaterThreadAlive, _CLASS, __LINE__ );

   // shutdown
    ETG_TRACE_COMP(("Flow-Event: %d", ETG_ENUM(VD_CLOCK_FlowEvents,TR_EN_FlowEventClose)));
   OSAL_vThreadExit();
}

// ****************************************************************************
// ***			    	       T i c k - T i m e r    						       ***

#undef _CLASS
#define _CLASS   ((tU16) TR_CLASS_VD_CLOCK_TICKTIMER)

// ****************************************************************************

tVoid	vdclk_tclUpdater::vSetupTickTimer()
{
    ETG_TRACE_COMP_CLS((TR_CLASS_VD_CLOCK_TICKTIMER, "Flow-Event: %d",
                        ETG_ENUM(VD_CLOCK_FlowEvents,TR_EN_FlowEventInit)));

    // create timer
   tS32 s32Err = OSAL_s32TimerCreate ( (OSAL_tpfCallback) vTickTimerCallback,
                                       (tVoid *) this,
                                       &_hTickTimer );
   if (OSAL_OK != s32Err)
   {
       ETG_TRACE_ERR_CLS((TR_CLASS_VD_CLOCK_TICKTIMER,"TickTimer create failed, code=%s",VDCLK_OsalErrorString()));
       NORMAL_M_ASSERT_ALWAYS();
   }

   VDCLOCK_ASSERT_NORMAL_RETURN(OSAL_C_INVALID_HANDLE != _hTickTimer);

   // wind up timer
   s32Err = OSAL_s32TimerSetTime ( _hTickTimer,
                                    20,      // first event at 1000 msec
                                    1000     // subsequent events every second
                                 );
   if (OSAL_OK != s32Err) {
       ETG_TRACE_ERR_CLS((TR_CLASS_VD_CLOCK_TICKTIMER,
                          "TickTimer SetTime failed, code=%s",VDCLK_OsalErrorString()));
   }

   return;
}

// ****************************************************************************

tVoid  vdclk_tclUpdater::vShutdownTickTimer ()
{
    ETG_TRACE_USR4(("..."));

   // stop and delete timer
   tS32 s32Err = OSAL_s32TimerSetTime ( _hTickTimer, 0, 0 );
   if (OSAL_OK != s32Err) {
       ETG_TRACE_ERR_CLS((TR_CLASS_VD_CLOCK_TICKTIMER,
                          "TickTimer Reset failed, code=%s",VDCLK_OsalErrorString()));
   }

   ETG_TRACE_USR4(("..."));

   s32Err = OSAL_s32TimerDelete ( _hTickTimer );
   if (OSAL_OK != s32Err) {
       ETG_TRACE_ERR_CLS((TR_CLASS_VD_CLOCK_TICKTIMER,
                          "TickTimer Delete failed, code=%s",VDCLK_OsalErrorString()));
   }
    ETG_TRACE_COMP_CLS((TR_CLASS_VD_CLOCK_TICKTIMER, "Flow-Event: %d",
                        ETG_ENUM(VD_CLOCK_FlowEvents,TR_EN_FlowEventClose)));
   return;
}

// ****************************************************************************

tVoid vdclk_tclUpdater::vTickTimerCallback ( tVoid* pArg	)

   // just trigger main updater thread

{
   vdclk_tclUpdater* poUpdater = (vdclk_tclUpdater*) pArg;
   if (OSAL_NULL == poUpdater) {
       ETG_TRACE_ERR_CLS((TR_CLASS_VD_CLOCK_TICKTIMER, "vTickTimerCallback:poUpdater=OSAL_NULL"));
       return;
   }
   if (OSAL_NULL == poUpdater->_poUpdateTrigger) {
       ETG_TRACE_ERR_CLS((TR_CLASS_VD_CLOCK_TICKTIMER, "vTickTimerCallback:_poUpdateTrigger=OSAL_NULL"));
       return;
   }

   poUpdater-> _poUpdateTrigger-> vPost ( cu32TrigEventTimer, _CLASS, __LINE__ );
}


tVoid vdclk_tclUpdater::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vdclk_tclUpdater::vGetReferences() entered."));

   _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));

   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

   m_poINCAdapter = dynamic_cast<vd_clock_INCAdapter*>(_cpoMain->getHandler("vd_clock_INCAdapter"));

   VD_CLOCK_NULL_POINTER_CHECK(m_poINCAdapter);
   
   _poClientSensor = dynamic_cast<vd_clock_tclClientSensorIf*>(_cpoMain->getHandler("Ivd_clock_tclClientSensorIf"));

   VD_CLOCK_NULL_POINTER_CHECK(_poClientSensor);
}

tVoid vdclk_tclUpdater::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
  (tVoid) pMsg;
}

tVoid vdclk_tclUpdater::vStartCommunication()
{
    vStartUpdaterThread();
}


tVoid vdclk_tclUpdater::vTraceInfo()
{

}

tVoid vdclk_tclUpdater::vHandleTraceMessage(const tUChar* puchData)
{
	(tVoid) puchData;
}
