/*
 * vd_clock_types.h
 *
 *  Created on: Apr 23, 2015
 *      Author: vee4kor
 */

#ifndef VD_CLOCK_TYPES_H_
#define VD_CLOCK_TYPES_H_


// Definitions for TimeFormat
enum VDCLK_TEN_TimeFormat
{
   VDCLK_EN_TF_Mode12 = 1, // midw_ext_fi_tclDCLK_TEN_TimeFormat::FI_EN_VDCLK_EN_TF_MODE12,
   VDCLK_EN_TF_Mode24 = 2
};

//Definition for Timeformat Index
enum VDCLK_TimeFormatIndex
{
   VDCLK_EN_TF_Index_Mode24 = 0, // midw_ext_fi_tclDCLK_TEN_TimeFormat::FI_EN_VDCLK_EN_TF_MODE12,
   VDCLK_EN_TF_Index_Mode12 = 1,
   VDCLK_EN_TF_Index_Invalid = 4
};


// Definitions for GPS epoch
enum VDCLK_TEN_GPS_EPOCH
{								//midw_ext_fi_tclDCLK_TEN_GPS_EPOCH():enType(FI_EN_VDCLK_EN_GPS_EPOCH_1)
	VDCLK_EN_GPS_EPOCH_1 = 1,	// 01.01.2012 - 31.12.2030
	VDCLK_EN_GPS_EPOCH_2 = 2,	// 01.01.2031 - 31.12.2049
	VDCLK_EN_GPS_EPOCH_3 = 3	// 01.01.2050 - 31.12.2068
};

// Definitions for DateFormat
enum VDCLK_TEN_DateFormat
{
    VDCLK_EN_DF_dd_mm_yyyy = 1,   // previous versions with dot 20.5.2011         // DD.MM.YYYY  for MIBE
    VDCLK_EN_DF_mm_dd_yyyy = 2,   // previous versions US format 05/20/2011       // YYYY-MM-DD  for MIBE
    VDCLK_EN_DF_yyyy_mm_dd = 3,   // previous versions DIN format 2011-05-20      // MM-DD-YYYY  for MIBE
    VDCLK_EN_DF_dd_mm_yyyy_dash = 4,   // 20/05/2011
    VDCLK_EN_DF_dd_mm_yyyy_dot = 5,   // 20-05-2011
    VDCLK_EN_DF_yyyy_dd_mm_dash = 6,      // 2011-20-05
	VDCLK_EN_DF_yyyy_mm_mdd_JPN = 7,
	VDCLK_EN_DF_yyyy_mm_dd_KOR = 8
};

//Definition of New date format
enum VDCLK_TEN_NewDateFormat
{
	VDCLK_EN_DF_DD_MM_YYYY_DASH =1,
	VDCLK_EN_DF_MM_DD_YYYY_DASH =2,
 	VDCLK_EN_DF_YYYY_MM_DD_DASH =3 ,
 	VDCLK_EN_DF_DD_MM_YYYY_SLASH = 4,
	VDCLK_EN_DF_MM_DD_YYYY_SLASH = 5,
	VDCLK_EN_DF_DD_MM_YYYY_DOT = 6,
	VDCLK_EN_DF_YYYY_MM_DD_JPN =7,
	VDCLK_EN_DF_YYYY_MM_DD_KOR = 8,
	VDCLK_EN_DF_TEXT = 9
};

// Definitions for Clock source status
enum VDCLK_TEN_ClockSourceStatus
{
   VDCLK_EN_CSS_System           = 1, // midw_ext_fi_tclDCLK_TEN_ClockSourceStatus::FI_EN_VDCLK_EN_CSS_SYSTEM,
   VDCLK_EN_CSS_Master           = 2,
   VDCLK_EN_CSS_MasterTimeOnly   = 3
};

enum VDCLK_TEN_DST_Setting
{
   VDCLK_EN_DST_Off           = 0,
   VDCLK_EN_DST_On            = 1,
   VDCLK_EN_DST_Auto          = 2,
   VDCLK_EN_DST_Auto_OFF      = 3,
   VDCLK_EN_DST_None          = 4
};

enum  VDCLK_TEN_FormatSourceStatus
{
   VDCLK_EN_FSS_System           = 1, // midw_ext_fi_tclDCLK_TEN_FormatSourceStatus::FI_EN_VDCLK_EN_FSS_SYSTEM,
   VDCLK_EN_FSS_Master           = 2,
   VDCLK_EN_FSS_MasterTimeOnly   = 3
};

enum VDCLK_TEN_TimeDateStatus
{
   VDCLK_EN_SecondChange   = 0x01, //midw_ext_fi_tclDCLK_TEN_TimeDateStatus::FI_EN_VDCLK_EN_SECONDCHANGE,
   VDCLK_EN_MinuteChange   = 0x02,
   VDCLK_EN_HourChange     = 0x04,
   VDCLK_EN_HMITimeChange  = 0x06,
   VDCLK_EN_TimeChange     = 0x07,
   VDCLK_EN_TimeValid      = 0x08,
   VDCLK_EN_DayChange      = 0x10,
   VDCLK_EN_MonthChange    = 0x20,
   VDCLK_EN_YearChange     = 0x40,
   VDCLK_EN_DateChange     = 0x70,
   VDCLK_EN_AllChange      = 0x77,
   VDCLK_EN_DateValid      = 0x80,
   VDCLK_EN_AllValid       = 0x88
} ;

enum  VDCLK_TEN_SyncMode  //VDCLK_TEN_SyncMode
{
    VDCLK_EN_SyncMode_GPS         = 0,
    VDCLK_EN_SyncMode_CAN         = 1,
    VDCLK_EN_SyncMode_Manual      = 2,
    VDCLK_EN_SyncMode_CanOrManual = 3,
    VDCLK_EN_SyncMode_MAX         = 4
};

enum VDCLK_SWITCH_MODE
{
   VDCLK_SWITCH_ON_TIME          = 0,
   VDCLK_SWITCH_ON_DISTANCE      = 1,
   VDCLK_SWITCH_ON_BOTH          = 2,
   VDCLK_SWITCH_AUTOMATIC        = 3
};

enum VDCLK_REGIONTYPE
{
   USA = 1,    // USA
   CAN = 2,    // Canada
   EUR = 3,    // Europe
   PRC = 4,    // Peoples Republic China
   GCC = 5,    // Golf Coast Countries
   RUS = 6,    // Russia
   ASR = 7,    // Australia
   ARG = 8,    // Argentina
   BRA = 9,    // Brasil
   SAF = 10,   // South Africa
   MEX = 11,   // Mexico
   THI = 12,   // Thailand
   TKY = 16    // Turkey
};

/*State of time.Synchoronisation state in the current power cycle*/
enum VDCLK_TEN_GPSRTCTIMESTATE
{
   VDCLK_EN_RTCTIMESTATE_INVALID         = 1,
   VDCLK_EN_RTCTIMESTATE_EVER_SYNC       = 2,
   VDCLK_EN_RTCTIMESTATE_VALID           = 3
};

enum VDCLK_REGIONCODE_MIBE
{
	VDCLK_EN_NONE = 0,
	VDCLK_EN_Manual = 1,
	VDCLK_EN_CET = 2,   // Europe
	VDCLK_EN_USA = 3,   // USA
	VDCLK_EN_Automatic = 4
};


enum VDCLK_DSTAutoState
{
	VDCLK_EN_DEFAULTTIME = 0,
	VDCLK_EN_SUMMERTIME = 1,
	VDCLK_EN_WINTERTIME =2
};

enum VDCLK_MONTH
{
	VDCLK_EN_JANUARY = 1,
	VDCLK_EN_FEBRUARY = 2,
	VDCLK_EN_MARCH = 3,
	VDCLK_EN_APRIL = 4,
	VDCLK_EN_MAY = 5,
	VDCLK_EN_JUNE = 6,
	VDCLK_EN_JULY = 7,
	VDCLK_EN_AUGUST = 8,
	VDCLK_EN_SEPTEMBER = 9,
	VDCLK_EN_OCTOBER = 10,
	VDCLK_EN_NOVEMBER = 11,
	VDCLK_EN_DECEMBER = 12
};

/*enum VDCLK_TEN_Domain
{
   VDCLK_EN_DomainSystem,
   VDCLK_EN_DomainMaster,
   VDCLK_EN_DomainAutomatic,
   VDCLK_DomainCount
};*/

enum VDCLK_TEN_DomainOffset
{
	VDCLK_EN_TZ = 0,
	VDCLK_EN_Manual_Mode = 1,
	VDCLK_EN_Auto = 2,
	VDCLK_EN_DomainCount
};

enum VDCLK_TEN_TIMEZONE_Setting
{
VDCLK_EN_Not_Changed	=	0,
VDCLK_EN_Eniwetok_Kwajalein	= 	1,
VDCLK_EN_Midway_Island_Samoa	=	2,
VDCLK_EN_Hawaii	=	3,
VDCLK_EN_Alaska	=	4,
VDCLK_EN_Pacific	=	5,
VDCLK_EN_Arizona	=	6,
VDCLK_EN_Mountain	=	7,
VDCLK_EN_Central_America	=	8,
VDCLK_EN_Central	=	9,
VDCLK_EN_Mexico_City	=	10,
VDCLK_EN_Saskatchewan	=	11,
VDCLK_EN_Bogota_Lima	=	12,
VDCLK_EN_Eastern	=	13,
VDCLK_EN_Indiana	=	14,
VDCLK_EN_Atlantic	=	15,
VDCLK_EN_Caracas_La_Paz	=	16,
VDCLK_EN_Sandiego	=	17,
VDCLK_EN_Newfoundland	=	18,
VDCLK_EN_Brasilia	=	19,
VDCLK_EN_Buenos_Aires_Georgetown	=	20,
VDCLK_EN_Greenland	=	21,
VDCLK_EN_Mid_Atlantic	=	22,
VDCLK_EN_Azores	=	23,
VDCLK_EN_Cape_Verde_Is	=	24,
VDCLK_EN_Casablanca_Monrovia	=	25,
VDCLK_EN_London	=	26,
VDCLK_EN_Amsterdam	=	27,
VDCLK_EN_Belgrade	=	28,
VDCLK_EN_Paris	=	29,
VDCLK_EN_Sarajevo	=	30,
VDCLK_EN_West_Central_Africa            	=	31,
VDCLK_EN_Athens            	=	32,
VDCLK_EN_Istanbul          	=	33,
VDCLK_EN_Bucharest          	=	34,
VDCLK_EN_Cairo           	=	35,
VDCLK_EN_Harare          	=	36,
VDCLK_EN_Helsinki       	=	37,
VDCLK_EN_Jerusalem        	=	38,
VDCLK_EN_Baghdad          	=	39,
VDCLK_EN_Kuwait           	=	40,
VDCLK_EN_Moscow       	=	41,
VDCLK_EN_Nairobi        	=	42,
VDCLK_EN_Tehran         	=	43,
VDCLK_EN_Abu_Dhabi        	=	44,
VDCLK_EN_Baku         	=	45,
VDCLK_EN_Kabul         	=	46,
VDCLK_EN_Ekaterinburg         	=	47,
VDCLK_EN_Islamabad         	=	48,
VDCLK_EN_Calcutta         	=	49,
VDCLK_EN_Kathmandu         	=	50,
VDCLK_EN_Almat          	=	51,
VDCLK_EN_Astana          	=	52,
VDCLK_EN_SriJayawardenepura_Kotte          	=	53,
VDCLK_EN_Novosibirsk           	=	54,
VDCLK_EN_Yangon           	=	55,
VDCLK_EN_Bangkok          	=	56,
VDCLK_EN_Krasnoyarsk          	=	57,
VDCLK_EN_Beijing           	=	58,
VDCLK_EN_Irkutsk          	=	59,
VDCLK_EN_Kuala_Lumpur          	=	60,
VDCLK_EN_Perth         	=	61,
VDCLK_EN_Taipei         	=	62,
VDCLK_EN_Tokyo          	=	63,
VDCLK_EN_Seoul       	=	64,
VDCLK_EN_Yakutsk        	=	65,
VDCLK_EN_Adelaide       	=	66,
VDCLK_EN_Darwin       	=	67,
VDCLK_EN_Brisbane        	=	68,
VDCLK_EN_Canberra        	=	69,
VDCLK_EN_Guam          	=	70,
VDCLK_EN_Hobart         	=	71,
VDCLK_EN_Vladivostok       	=	72,
VDCLK_EN_Magadan         	=	73,
VDCLK_EN_Auckland         	=	74,
VDCLK_EN_Nuku_alofa         	=	75,
VDCLK_EN_Saudi_Arabia          	=	76,
VDCLK_EN_Qatar          	=	77,
VDCLK_EN_Bahrain         	=	78,
VDCLK_EN_United_Arab_Emirates       	=	79,
VDCLK_EN_Oman          	=	80,
VDCLK_EN_Queensland         	=	81,
VDCLK_EN_New_South_Wales         	=	82,
VDCLK_EN_Victoria          	=	83,
VDCLK_EN_Tasmania           	=	84,
VDCLK_EN_Northern_Territory        	=	85,
VDCLK_EN_South_Australia         	=	86,
VDCLK_EN_Western_Australia          	=	87,
VDCLK_EN_New_Zealand          	=	88

};

enum  VDCLK_TEN_GNSSDATAMODE  //VDCLK_TEN_SyncMode
{
	GNSSMODE_NOFIX         = 1,
	GNSSMODE_2DFIX         = 2,
	GNSSMODE_3DFIX      = 3,
	GNSSMODE_UNKNOWN = 4,
};

enum VDCLK_TEN_HUDACTIVATE
{
	HUD_ACTIVATE	= 1,
	HUD_DEACVTIVATE	= 2

};

#endif /* VD_CLOCK_TYPES_H_ */
