/*
 * vd_clock_timezone.h
 *
 *  Created on: Apr 23, 2015
 *      Author: vee4kor
 */

#ifndef VD_CLOCK_TIMEZONE_H_
#define VD_CLOCK_TIMEZONE_H_


const  tU16 TZNAM_SIZE  = 8;
const tU16 TZEUR_RUS_GOM_SIZE = 75;
const  tU16 TZAZR_SIZE  = 8;
const tU16 TZGCC_SIZE = 6;

const tU8 NAM_REGION = 0x00;
const tU8 EUR_RUS_GOM_REGION = 0x01;
const tU8 AZR_REGION = 0x02;
const tU8 GCC_REGION = 0x03;

struct vdclk_trTimezoneDetails
{
   tS32 s16TZOffset;
   tU16 u16Index;
   tCString szDescription;
   tU16 u16HexIndex;
};


typedef struct
{
   const tU8 u8Region;
   const tU16 u16DefaultTimeZone;
   const tU16* const pu16TimeZoneList;
   const tU16 u16SizeOfTimeZoneArray;
} sMapTimeZone;

extern const tU16 vdclk_u16DefaultTimeZoneIndex;
extern const tU16 vdclk_u16NumberOfTimeZones;
extern const vdclk_trTimezoneDetails  vdclk_rTZDetails[];
extern const tU8 u8TimeZoneListForNAM[];

extern const tU8 u8TimeZoneListForEUR_RUS_GOM[];


extern const tU8 NAM_REGION;
extern const tU8 EUR_RUS_GOM_REGION;
extern const tU8 AZR_REGION;
extern const tU8 GCC_REGION;

extern const sMapTimeZone mapTimeZone[];


struct vdclk_trCountryCodes
{
   tS16 s16CountryCode;
   tS32 s16TimeOffset;
   tU8  u8IndexOfTZ;
};

extern vdclk_trCountryCodes vdclk_TZCountryCodes[];
extern tU16 vdclk_u16NumberOfCountryCodes;












#endif /* VD_CLOCK_TIMEZONE_H_ */
