/*
 * vd_clock_timezone.cpp
 *
 *  Created on: Apr 23, 2015
 *      Author: vee4kor
 */



#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"



#include "I_vd_clock_ServiceClockIf.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_TIMEZONE
#include "trcGenProj/Header/vd_clock_timezone.cpp.trc.h"
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "../framework/app/vd_clock_AppMain_Trace.h"
#include "../framework/app/vd_clock_AppMain.h"
#include "vd_clock_timezone.h"

/*************************************************************************
*  STRUCTURE:   vdclk_trTimezoneDetails
*
*	DESCRIPTION: holds information the current time zones with seconds to UTC,
*               Index of time zone and the string to be displayed on HMI
*               {seconds to UTC, index, string to be displayed}
*	PARAMETER:   none
*
*	RETURNVALUE: none
*************************************************************************/
const vdclk_trTimezoneDetails vdclk_rTZDetails[]
= {
		{	0,	0,"Not Changed",0x00},
   //  { 	0,  1, "-Auto"},
      {	-43200,		 1,	"Eniwetok_Kwajalein",0x02},
      { -39600,  2, "-11:00 Midway Is., Samoa",0x03},
      { -36000,  3, "-10:00 Hawaii",0x04},
      { -32400,  4, "-09:00 Alaska",0x05},
      { -28800,  5, "-08:00 US Pacific Time",0x06},
      {	-25200,		 6,	"Arizona",0x07},
      { -25200,  7, "-07:00 US Mountain Time",0x08},
      { -21600,  8, "-06:00 Central America",0x09},
      { -21600, 9, "-06:00 US Central Time",0x0A},
      { -21600, 10, "-06:00 Guadalajara, Mexico",0x0B},
      { -21600,  11, "-06:00 Saskatchewan",0x0C},
      { -18000, 12, "-05:00 Bogota, Lima, Quito",0x0D},
      { -18000, 13, "-05:00 US Eastern Time",0x0E},
      {	-18000,		14,	"Indiana",0x0F},
      { -14400, 15, "-04:00 Atlantic Time (Can.)",0x10},
 //     { -14400, 17, "-04:00 Asunción, La Paz"},   SONDERZEICHEN!!!!!!!!!!!!!
      { -14400, 16, "-04:30 Caracas",0x11},
      { -28800, 17, "-04:00 Santiago",0x12},
      { -12600, 18, "-03:30 Newfoundland",0x13},
      { -10800, 19, "-03:00 Brasilia",0x14},
      { -10800, 20, "-03:00 Buenos Aires",0x15},
      { -10800, 21, "-03:00 Greenland",0x16},
      { -7200,  22, "-02:00 Mid-Atlantic",0x17},
      { -3600,  23, "-01:00 Azores",0x18},
      { -3600,  24, "-01:00 Cape Verde Is.",0x19},
      {  0,     25, "00:00 Casablanca, Monrovia",0x1A},
      {  0,     26, "00:00 Lisbon, London",0x1B},
      { +3600,  27, "+01:00 Amsterdam, Berlin",0x1C},
      { +3600,  28, "+01:00 Belgrade, Bratislava",0x1D},
      { +3600,  29, "+01:00 Paris, Prague, Rome",0x1E},
      { +3600,  30, "+01:00 Sarajevo, Stockholm",0x1F},
      { +3600,  31, "+01:00 West Central Africa",0x20},
      { +7200,  32, "+02:00 Athens",0x21},
      { +7200,  33, "+02:00 Istanbul",0x22},
      { +7200,  34, "+02:00 Bucharest",0x23},
      { +7200,  35, "+02:00 Beirut, Cairo",0x24},
      { +7200,  36, "+02:00 Harare, Pretoria",0x25},
      { +7200,  37, "+02:00 Helsinki, Kiev, Riga",0x26},
      { +7200,  38, "+02:00 Jerusalem",0x27},
      { +10800, 39, "+03:00 Baghdad",0x28},
      { +10800, 40, "+03:00 Kuwait, Riyadh",0x29},
      { +10800, 41, "+03:00 Moscow",0x2A},
      { +10800, 42, "+03:00 Nairobi",0x2B},
      { +12600, 43, "+03:30 Tehran",0x2C},
      { +14400, 44, "+04:00 Abu Dhabi, Muscat",0x2D},
      { +14400, 45, "+04:00 Baku",0x2E},
      { +16200, 46, "+04:30 Kabul",0x2F},
      { +18000, 47, "+05:00 Yekaterinburg",0x30},
      {	+18000,		48,	"Islamabad ",0x31},
      { +19800, 49,	"5:30 Kolkata, New Delhi",0x32},
      { +20700, 50, "+05:45 Katmandu",0x33},
      { +21600, 51, "+06:00 Novosibirsk",0x34},
      { +21600, 52, "+06:00 Astana, Dhaka",0x35},
      {	+19080,		53,	"Sri Jayawardenepura Kotte",0x36},
      { +21600, 54, "+06:00 Novosibirsk",0x37},
      { +23400, 55, "+06:30 Yangon (Rangoon)",0x38},
      { +25200, 56, "+07:00 Bangkok, Hanoi",0x39},
      { +25200, 57, "+07:00 Krasnoyarsk",0x3A},
      { +32400, 58, "+09:00 Beijing Japan Std. Time",0x3B},
      { +28800, 59, "+08:00 Irkutsk, Ulan Bator",0x3C},
      { +28800, 60, "+08:00 Kuala Lumpur",0x3D},
      { +28800, 61, "+08:00 Perth",0x3E},
      { +28800, 62, "+08:00 Taipei",0x3F},
      { +32400, 63, "+09:00 Osaka, Tokyo",0x40},
      { +32400, 64, "+09:00 Seoul",0x41},
      { +32400, 65, "+09:00 Yakutsk",0x42},
      { +34200, 66, "+09:30 Adelaide",0x43},
      //{ +34200, 85, "+09:30 Adelaide, Darwin"},     // replaced by AUS Eastern Std. Time
      { +34200, 67, "+09:30  Darwin",0x44},
      {	+36000,		68,	"Brisbane",0x45},
      {	+36000,		69,	"Canberra  ",0x46},
      { +36000, 70, "+10:00 Guam, Port Moresby",0x47},
      {	+36000,		71,	"Hobart",0x48},
      { +36000, 72, "+10:00 Vladivostok",0x49},
      { +39600, 73, "+11:00 Magadan",0x4A},
      {	+43200,		74,	"Auckland ",0x4B},
      { +46800, 75, "+13:00 Nuku'alofa",0x4C},
      { +10800, 76,	"+1:00 Saudi Arabia",0x60},
      { +10800, 77,	"+1:00 Qatar",0x61},
      { +10800, 78,	"+1:00 Bahrain",0x62},
      { +10800, 79, "+03:00 Arabic Std. Time",0x63},
      { +14400, 80,	"+2:00 Oman",0x64},
      { +36000, 81, "+1:00 Queensland",0x71},
      { +36000, 82, "+1:00 New South Wales",0x72},
      { +36000, 83, "+1:00 Victoria",0x73},
      { +36000, 84, "+1:00 Tasmania",0x74},
      { +34200, 85, "+12:30 Northern Territory",0x75},
      { +34200, 86, "+12:30 South Australia",0x76},
      { +28800, 87,"+23:00 Western Australia",0x77},
      { +43200, 88,	"+3:00 New Zealand",0x78}
   };

const tU16 vdclk_u16NumberOfTimeZones = sizeof(vdclk_rTZDetails) / sizeof(vdclk_trTimezoneDetails);
const tU16 vdclk_u16DefaultTimeZoneIndex = 1; // GMT

/*************************************************************************
*  STRUCTURE:   vdclk_TZCountryCodes
*
*	DESCRIPTION: holds information about the time zones and they're
*               corresponding country to set the correct time zone.
*               {CountryCode,  TimeOffsetInSeconds, IndexOfTimeZoneList}
*	PARAMETER:   none
*
*	RETURNVALUE: none
*************************************************************************/
vdclk_trCountryCodes vdclk_TZCountryCodes[]
= {
      { -1,    -43200, 1},    //  -12:00 Int. Date Line West
      { -1,    -39600, 2},	   //  -11:00 Midway Is., Samoa
      { -1,    -36000, 3},	   //  -10:00 Hawaii
      { -1,    -32400, 4},	   //  -09:00 Alaska
      { 13496, -28800, 5},	   //  -08:00 Tijuana, Baja Calif.
      { -1,    -28800, 6},	   //  -08:00 US Pacific Time
      { -1,    -25200, 7},	   //  -07:00 US Mountain Time
      { 13496, -25200, 8},	   //  -07:00 Chihuahua, Mazatlan
      { 3118,  -21600, 9},	   //  -06:00 Saskatchewan
      { 13496, -21600, 10},	//  -06:00 Guadalajara, Mexico
      { 22113, -21600, 11},	//  -06:00 US Central Time
      { -1,    -21600, 12},	//  -06:00 Central America
      { -1,    -18000, 13},	//  -05:00 US Eastern Time
      { 3564,  -18000, 14},
      { 16562, -18000, 14},
      { 5237,  -18000, 14},	//  -05:00 Bogota, Lima, Quito
      { -1,    -16200, 15},	//  -04:30 Caracas
      { 2625,  -14400, 16},	//  -04:00 Manaus
      { 16985, -14400, 17},	//  -04:00 Asunción, La Paz
      { 2540,  -14400, 17},
      { 3340,  -14400, 18},	//  -04:00 Santiago
      { -1,    -14400, 19},	//  -04:00 Atlantic Time (Canada)
      { -1,    -12600, 20},	//  -03:30 Newfoundland
      { 22105, -10800, 21},	//  -03:00 Montevideo
      { 7756,  -10800, 22},	//  -03:00 Greenland
      { 1607,  -10800, 23},	//  -03:00 Buenos Aires
      { -1,    -10800, 24},	//  -03:00 Brasilia
      { -1,    -7200,  25},	//  -02:00 Mid-Atlantic
      { 3606,  -3600,  26},	//  -01:00 Cape Verde Is.
      { -1,    -3600,  27},	//  -01:00 Azores
      { 13362,     0,  28},
      { 12370,     0,  28},   //  00:00 Casablanca, Monrovia
      { -1,        0,  29},
      { 7250,      0,  29},	//  00:00 Lisbon, London
      { -1,     3600,  30},	//  +01:00 Central European Time    IF REGION IS EUR, ELSE {-1, 3600, 38}
      { 14724,  3600,  31},
      { 4277,   3600,  31},	//  +01:00 Amsterdam, Berlin
      { 20034,  3600,  32},
      { 20171,  3600,  32},	//  +01:00 Belgrade, Bratislava
      { 8878,   3600,  33},
      { 2220,   3600,  33},	//  +01:00 Budapest, Brussels
      { 4555,   3600,  34},
      { 5744,   3600,  34},	//  +01:00 Copenhagen, Madrid
      { 6721,   3600,  35},
      { 3909,   3600,  35},
      { 9857,   3600,  35},	//  +01:00 Paris, Prague, Rome
      { 2344,   3600,  36},
      { 20197,  3600,  36},	//  +01:00 Sarajevo, Stockholm
      { 16876,  3600,  37},
      { 8790,   3600,  37},	//  +01:00 Warsaw, Zagreb
      { -1,     3600,  38},	//  +01:00 West Central Africa      IF REGION IS SAF, ELSE {-1, 3600, 30}
      { -1,     7200,  39},	//  +02:00 Eastern European Time
      { 10738,  7200,  40}, 	//  +02:00 Amman
      { 7747,   7200,  41},
      { 18933,  7200,  41},  	//  +02:00 Athens, Bucharest
      { 12366,  7200,  42},
      { 5369,   7200,  42},	//  +02:00 Beirut, Cairo
      { 20274,  7200,  43},	//  +02:00 Damascus
      { 27365,  7200,  44},
      { 26662,  7200,  44},	//  +02:00 Harare, Pretoria
      { 6446,   7200,  45},
      { 21874,  7200,  45},
      { 12993,  7200,  45},	//  +02:00 Helsinki, Kiev, Riga
      { 21170,  7200,  46},	//  +02:00 Istanbul
      { 9842,   7200,  47},	//  +02:00 Jerusalem
      { 2450,   7200,  48},	//  +02:00 Minsk
      { 14381,  7200,  49},	//  +02:00 Windhoek
      { -1,    10800,  50},	//  +03:00 Arabic Standard Time
      { 9809,  10800,  51},	//  +03:00 Baghdad
      { 12020, 10800,  52},
      { 19509, 10800,  52},  	//  +03:00 Kuwait, Riyadh
      { 19123, 10800,  53},	//  +03:00 Moscow
      { 11438, 10800,  54},	//  +03:00 Nairobi
      { 7343,  10800,  55},	//  +03:00 Tbilisi
      { -1,    12600,  56},	//  +03:30 Tehran
      { -1,    14400,  57},	//  +04:00 Gulf Standard Time       IF REGION IS GCC, ELSE {-1, 14400, 60}
      { 1605,  14400,  58},
      { 15790, 14400,  58},	//  +04:00 Abu Dhabi, Muscat
      { 1861,  14400,  59},	//  +04:00 Baku
      { -1,    14400,  60},	//  +04:00 Caucasus Std. Time       IF REGION IS EUR, ELSE {-1, 14400, 57}
      { 1613,  14400,  61},	//  +04:00 Yerevan
      { -1,    16200,  62},	//  +04:30 Kabul
      { -1,    18000,  63},	//  +05:00 Yekaterinburg
      { 16427, 18000,  64},
      { 22338, 18000,  64},	//  +05:00 Karachi, Tashkent
      { -1,    19800,  65},	//  +05:30 Kolkata, New Delhi
      { 12641, 19800,  66},	//  +05:30 Colombo
      { -1,    20700,  67},	//  +05:45 Katmandu
      { -1,    21600,  68},
      { 19123, 21600,  68},	//  +06:00 Almaty, Novosibirsk
      { 11322, 21600,  69},
      { 2276,  21600,  69},	//  +06:00 Astana, Dhaka
      { -1,    23400,  70},	//  +06:30 Yangon (Rangoon)
      { -1,    25200,  71},
      { 22989, 25200,  71},	//  +07:00 Bangkok, Hanoi
      { 19123, 25200,  72},	//  +07:00 Krasnoyarsk
      { -1,    28800,  73},	//  +08:00 China Standard Time
      { 19123, 28800,  74},
      { 13767, 28800,  74},	//  +08:00 Irkutsk, Ulan Bator
      { 14131, 28800,  75},	//  +08:00 Kuala Lumpur
      { 19696, 28800,  76},	//  +08:00 Singapore
      { 1715,  28800,  77},	//  +08:00 Perth
      { 21230, 28800,  78},	//  +08:00 Taipei
      { 1715,  28800,  79},	//  +08:00 AUS Western Standard Time
      { -1,    32400,  80},	//  +09:00 Japan Standard Time
      { 10766, 32400,  81},	//  +09:00 Osaka, Tokyo
      { 11762, 32400,  82},	//  +09:00 Seoul
      { 19123, 32400,  83},	//  +09:00 Yakutsk
      { -1,    34200,  84},	//  +09:30 AUS Central Standard Time
      { -1,    36000,  85},	//  +10:00 AUS Eastern Standard Time
      { 7853,  36000,  86},
      { 16839, 36000,  86},	//  +10:00 Guam, Port Moresby
      { 19123, 36000,  87},	//  +10:00 Vladivostok
      { -1,    39600,  88},	//  +11:00 New Caledonia
      { 19123, 39600,  89},	//  +11:00 Magadan
      { 6473,  43200,  90},	//  +12:00 Fiji, Marshall Is.
      { 19123, 43200,  91},	//  +12:00 Kamchatka
      { -1,    43200,  92},	//  +12:00 Wellington
      { -1,    46800,  93},	//  +13:00 Nuku'alofa
   };

tU16 vdclk_u16NumberOfCountryCodes = sizeof(vdclk_TZCountryCodes) / sizeof(vdclk_trCountryCodes);

const tU16 u16TimeZoneListForNAM[TZNAM_SIZE] =
{
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_PACIFIC,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_MOUNTAIN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_CENTRAL,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_EASTERN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ATLANTIC,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_NEWFOUNDLAND,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_HAWAII,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ALASKA

};


const tU16 u16TimeZoneListForEUR_RUS_GOM[TZEUR_RUS_GOM_SIZE] =
{
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ENIWETOK_KWAJALEIN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_MIDWAY_ISLAND_SAMOA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_HAWAII,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ALASKA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_PACIFIC,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ARIZONA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_MOUNTAIN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_CENTRAL_AMERICA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_CENTRAL,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_MEXICO_CITY,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_SASKATCHEWAN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BOGOTA_LIMA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_EASTERN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_INDIANA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ATLANTIC,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_CARACAS_LA_PAZ,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_SANDIEGO,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_NEWFOUNDLAND,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BRASILIA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BUENOS_AIRES_GEORGETOWN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_GREENLAND,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_MID_ATLANTIC,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_AZORES,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_CAPE_VERDE_ISC,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_CASABLANCA_MONROVIA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_LONDON,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_AMSTERDAM,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BELGRADE,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_PARIS,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_SARAJEVO,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_WEST_CENTRAL_AFRICA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ATHENS,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ISTANBUL,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BUCHAREST,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_CAIRO,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_HARARE,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_HELSINKI,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_JERUSALEM_MEXICO,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BAGHDAD,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_KUWAIT,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_MOSCOW,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_NAIROBI,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_TEHRAN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ABU_DHABI,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BAKU_LA_PAZ,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_KABUL,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_EKATERINBURG,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ISLAMABAD,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_CALCUTTA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_KATHMANDU,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ALMAT,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ASTANA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_SRIJAYAWARDENEPURA_KOTTE,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_NOVOSIBIRSK,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_YANGON,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BANGKOK,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_KRASNOYARSK,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BEIJING,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_IRKUTSK,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_KUALA_LUMPUR,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_PERTH,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_TAIPEI,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_TOKYO,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_SEOUL,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_YAKUTSK,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ADELAIDE,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_DARWIN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BRISBANE,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_CANBERRA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_GUAM,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_HOBART,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_VLADIVOSTOK,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_MAGADAN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_AUCKLAND,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_NUKU_ALOFA,

};

const tU16 u16TimeZoneListForAZR[TZAZR_SIZE] =
{
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_QUEENSLAND,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_NEW_SOUTH_WALES,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_VICTORIA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_TASMANIA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_NORTHERN_TERRITORY,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_SOUTH_AUSTRALIA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_WESTERN_AUSTRALIA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_NEW_ZEALAND

};

const tU16 u16TimeZoneListForGCC[TZGCC_SIZE] =
{
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_SAUDI_ARABIA,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_QATAR,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_BAHRAIN,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_KUWAIT,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_UNITED_ARAB_EMIRATES,
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_OMAN,

};


const sMapTimeZone mapTimeZone[] =
{
   // Region             //DefaultTimeZone      							// Pointer To Language Table   // Size Of Array
   { NAM_REGION,          clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_PACIFIC,  u16TimeZoneListForNAM          , TZNAM_SIZE },
   { EUR_RUS_GOM_REGION, clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_ENIWETOK_KWAJALEIN,  u16TimeZoneListForEUR_RUS_GOM  , TZEUR_RUS_GOM_SIZE },
   { AZR_REGION,          clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_QUEENSLAND,  u16TimeZoneListForAZR          , TZAZR_SIZE },
   { GCC_REGION, clock_fi_tclDCLK_TEN_TIMEZONE_Setting::FI_EN_VDCLK_EN_SAUDI_ARABIA,  u16TimeZoneListForGCC  , TZGCC_SIZE },
};
