/*
 * vd_clock_container.cpp
 *
 *  Created on: Apr 23, 2015
 *      Author: vee4kor
 */


#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"


#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM
#define CSM_C_PROJECT_USERSPACE_SMART_HU
#include "midw_common_if.h"







#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CONTAINER
#include "trcGenProj/Header/vd_clock_datacontainer.cpp.trc.h"
#endif

#include "vd_clock_datacontainer.h"
#include "vd_clock_types.h"
#include "vd_clock_utils.h"
#include "vd_clock_datetime.h"
#include "../framework/app/vd_clock_AppMain_Trace.h"
#include "../framework/app/vd_clock_AppMain.h"
#include <linux/rtc.h>
#include "vd_clock_timezone.h"
#include "vd_clock_Event.h"
#include "vd_clock_datetime.h"
#include "vd_clock_ServiceClockIf.h"
#include "vd_clock_ClientSensorIf.h"





#define _CLASS    ((tU16) TR_CLASS_VD_CLOCK_CONTAINER)

#define bIsGpsSync(a) ((a)== VDCLK_EN_SyncMode_GPS)

//const tU16    cu16DataFileVersionMaj   = 4;
//const tU8     cu8DataFileVersionMin    = 1;

tCString cszContainerSemName  = "CLK_ConfigSem";
const tU32  cu32SecondsPerMinute   = 60L;
const tU32  cu32SecondsPerHour     = 60L * cu32SecondsPerMinute;

Ivd_clock_tclServiceClockIf* vdclk_tclDataContainer:: _poServiceHandler = NULL;

Ivd_clock_tclClientSensorIf* vdclk_tclDataContainer:: _poClientSensor = NULL;


/************************************************************************
 * FUNCTION:    vEnterCriticalSection
 *
 * DESCRIPTION: set a semaphore
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vEnterCriticalSection(tCString from)
{
	ETG_TRACE_COMP(("vEnterCriticalSection: called from %s", from));
	VDCLOCK_ASSERT_NORMAL_RETURN(OSAL_C_INVALID_HANDLE!=_hDataUpdateSemaphore);
	tS32 s32Err = OSAL_s32SemaphoreWait( _hDataUpdateSemaphore, OSAL_C_TIMEOUT_FOREVER);

	if (OSAL_OK != s32Err) {
		ETG_TRACE_ERR((" vEnterCriticalSection:failed:code=%s",
				VDCLK_OsalErrorString() ));
	}
};

/************************************************************************
 * FUNCTION:    vReleaseCriticalSection
 *
 * DESCRIPTION: releases the semaphore
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vReleaseCriticalSection (tCString from)
{
	ETG_TRACE_COMP(("vReleaseCriticalSection: called from %s", from));
	VDCLOCK_ASSERT_NORMAL_RETURN(OSAL_C_INVALID_HANDLE!=_hDataUpdateSemaphore);

	tS32 s32Err = OSAL_s32SemaphorePost( _hDataUpdateSemaphore );
	if (OSAL_OK != s32Err) {
		ETG_TRACE_ERR((" vReleaseCriticalSection:failed:code=%s",
				VDCLK_OsalErrorString() ));
	}
};


#ifndef __COVERITY__ 
vdclk_tclDataContainer::vdclk_tclDataContainer (vd_clock_tclAppMain* poMainAppl):vd_clock_tclBaseIf(poMainAppl)
{

	ETG_TRACE_USR4(("vdclk_tclDataContainer() entered."));

	_hDataUpdateSemaphore = OSAL_C_INVALID_HANDLE;
	tS32 s32TmpResult = OSAL_s32SemaphoreCreate ( cszContainerSemName,
			&_hDataUpdateSemaphore,
			1 );

	if (OSAL_OK != s32TmpResult) {
		ETG_TRACE_ERR((" SemCreate failed:code=%s", VDCLK_OsalErrorString() ));
		NORMAL_M_ASSERT_ALWAYS();
	}
	//_poApp = poMainAppl;

	_u16TimeZoneIndex = 0;   // Index of current time zone (GMT)

	_bDST_ON = FALSE;             // daylight saving (summer) time (DST) On/Off
	_bDST_AutoSet = FALSE;        // DST adjusted automatically according to current date (currently not implemented)

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_CLOCK_MC
	_enSyncMode =  VDCLK_EN_SyncMode_CAN;
	// internal time synchronized to GPS transparently displayed to HMI
#elif defined(VARIANT_S_FTR_ENABLE_CLOCK_CAN_BAP_RECEPTION)
	_enSyncMode =  VDCLK_EN_SyncMode_CAN;
#else
	_enSyncMode =  VDCLK_EN_SyncMode_CanOrManual;       // internal time synchronized to GPS transparently displayed to HMI
#endif
	/* for (tU8 u8 = (tU8) VDCLK_EN_DomainSystem; u8 < (tU8) VDCLK_DomainCount; u8++)
   {
      _s64DynOffset[u8] = 0LL;
   }*/
	_enTimeFormat           = VDCLK_EN_TF_Mode24;
	_enDateFormat           = VDCLK_EN_DF_dd_mm_yyyy;
	_enNewDateFormat        = VDCLK_EN_DF_DD_MM_YYYY_DASH;
	_u32DateFormat          = 0;
	_u32TimeFormat          = VDCLK_EN_TF_Index_Invalid;
	_enClockSourceStatus    = VDCLK_EN_CSS_System;
	_enFormatSourceStatus   = VDCLK_EN_FSS_System;
	_enGPSEpoch			   = VDCLK_EN_GPS_EPOCH_1;
	_enSyncMode			   = VDCLK_EN_SyncMode_CanOrManual;
	_isPositionBased        = FALSE;
	_isEnabled              = FALSE;
	_isDefaultSetting       = FALSE;
	_s64Offs                = 0LL;
	_enRTCTimeState         = VDCLK_EN_RTCTIMESTATE_INVALID;
	_bIsOffsetValid         = TRUE;
	_enDaylightSaving       = VDCLK_EN_DST_Off;
	_enRegionCode           = VDCLK_EN_NONE;
	_bSummerTimeSET         = FALSE;
	_bWinterTimeSET         = FALSE;
	_enDSTAutoState         = VDCLK_EN_DEFAULTTIME;
	_bBapAvailable          = FALSE;
	_bCanAvailable          = FALSE;
	_u32PrevSystemTimeOffset = 0;
	_u16AutoSetTZ           	= 36;
	_u16AutoSetDST          	= 0;
	mDrvHandle              	= 0;
	mIsOpen                 	= FALSE;
	offset_hour				= 0;
	offset_minute			= 0;
	_u64AutoTimezoneOffset  	= 0;
	_bDefaultSetting 		= TRUE;
	_bGetTimeZoneAvailability = TRUE;
	hour_sign 				= 0;
	min_sign					= 0;
	offset_hour 				= 0;
	offset_minute 			= 0;
	_cantimeavailable       = FALSE;

	/*	for (tU8 u8 = (tU8) VDCLK_EN_DomainSystem; u8 < (tU8) VDCLK_DomainCount; u8++)
	{
		_s64DynOffset[u8] = 0LL;
	}*/
	_bDefaultSetting = FALSE;

	_s64DynOffset[VDCLK_EN_TZ] = 0LL;
	_s64DynOffset[VDCLK_EN_Manual_Mode] = 0LL;
	_s64DynOffset[VDCLK_EN_Auto] = 0LL;

	// TRACE_DateTime("In constructor", _oSystemTime, _CLASS, __LINE__);


	// post my own life status indicator
	//   vdclk_poRunIndicator-> vPost( cu32EventMaskContainerAlive, _CLASS, __LINE__ );
	//// Scope 2.1
	_poMyCSMInterface = NULL;
	_poINCAdapter = NULL;
	_poUpdater = NULL;

	_vDateFormat.push_back(VDCLK_EN_DF_dd_mm_yyyy);
	_vDateFormat.push_back(VDCLK_EN_DF_mm_dd_yyyy);
	_vDateFormat.push_back(VDCLK_EN_DF_yyyy_mm_dd);
	_vDateFormat.push_back(VDCLK_EN_DF_dd_mm_yyyy_dash);
	_vDateFormat.push_back(VDCLK_EN_DF_dd_mm_yyyy_dot);
	_vDateFormat.push_back(VDCLK_EN_DF_yyyy_dd_mm_dash);
	_vDateFormat.push_back(VDCLK_EN_DF_yyyy_mm_mdd_JPN);
	_vDateFormat.push_back(VDCLK_EN_DF_yyyy_mm_dd_KOR);

	_vTimeFormat.push_back(VDCLK_EN_TF_Mode24);
	_vTimeFormat.push_back(VDCLK_EN_TF_Mode12);



	_vNewDateFormat.push_back(VDCLK_EN_DF_DD_MM_YYYY_DASH);
	_vNewDateFormat.push_back(VDCLK_EN_DF_MM_DD_YYYY_DASH);
	_vNewDateFormat.push_back(VDCLK_EN_DF_YYYY_MM_DD_DASH);
	_vNewDateFormat.push_back(VDCLK_EN_DF_DD_MM_YYYY_SLASH);
	_vNewDateFormat.push_back(VDCLK_EN_DF_MM_DD_YYYY_SLASH);
	_vNewDateFormat.push_back(VDCLK_EN_DF_DD_MM_YYYY_DOT);
	_vNewDateFormat.push_back(VDCLK_EN_DF_YYYY_MM_DD_JPN);
	_vNewDateFormat.push_back(VDCLK_EN_DF_YYYY_MM_DD_KOR);
	_vNewDateFormat.push_back(VDCLK_EN_DF_TEXT);
	_GPSType = getGPSType();

	ClockInfo_Mode = 0;
	ClockMode_Disp = 0;
	ClockInfo_Disp = 0;
	ClockInfo_Clock= 0;
	ClockINfo_Hr = 0;
	ClockInfo_Min = 0;
	OffsetHr_Sign = 0;
	OffsetHr_Val = 0;
	OffsetMin_Sign = 0;
	OffsetMin_Val = 0;
	ClockInfo_TZState = 0;
	ClockInfo_TZVal =0;
	ClockDST_State = 0;
	ClockDST_Value = 0;

	u8Region = 0xFF;
	u8regioncode = 0xFF;	//Coverity Fix
	u8OEMType = 0xFF;		//Coverity Fix
	_VariantType = 0;

	//SensorUpdate_Flag = 0;//++Sindhu
	//bEnabled = FALSE;
	//bPositionBased = FALSE;
	RTC_ManualOffset = 0;

	_bfirstLocalMinute = TRUE; // First update to status for disclaimer pop up

	_bSystemTimeSet = FALSE;


	// Clock meter settings set feature start
	_InvalidParam = 0;
	Flag_TZ = FALSE;
	// Clock meter settings set feature End

	_u32AppState = 0;
	_bRTCVAlid = FALSE;
	_bDefaultSettingFlag = FALSE;
	enPrevDomainOffset = VDCLK_EN_Auto;


};
#endif

/************************************************************************
 * FUNCTION:    destructor
 *
 * DESCRIPTION: destructs the vdclk_tclDataContainer
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *************************************************************************/
vdclk_tclDataContainer::~vdclk_tclDataContainer (tVoid)
{
	ETG_TRACE_USR4(("~vdclk_tclDataContainer() entered."));
	_poINCAdapter = OSAL_NULL;
	//// Scope 2.1
	if (OSAL_NULL != _poMyCSMInterface) {
		OSAL_DELETE _poMyCSMInterface;
	}
	_poMyCSMInterface = OSAL_NULL;
	_poUpdater = OSAL_NULL;

	_bfirstLocalMinute = FALSE; //// First update to status for disclaimer pop up
	_u32AppState = 0;
	_bRTCVAlid = FALSE;
	_bDefaultSettingFlag = FALSE;
	_isPositionBased     = FALSE;
	_isEnabled           = FALSE;
	_cantimeavailable    = FALSE;

};
tVoid  vdclk_tclDataContainer::ReceivedSecondsFromCAN()
{
	ETG_TRACE_USR4(("ReceivedSecondsFromCAN"));
 
}


/************************************************************************
 * FUNCTION:    vSetDefaultSettings
 *
 * DESCRIPTION: reads the default values and sets them to the system
 *
 * PARAMETER:   tBool bResetAllUsers
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetDefaultSettings	(tBool bResetAllUsers)
{

	ETG_TRACE_USR4(("vSetDefaultSettings %d", bResetAllUsers));


	vEnterCriticalSection("vSetDefaultSettings");

#ifdef VARIANT_S_FTR_ENABLE_CLOCK_CAN_BAP_RECEPTION
	_enSyncMode = VDCLK_EN_SyncMode_CAN;
#endif

	VDCLK_TEN_TimeFormat enPrevTimeFormat  = _enTimeFormat;
	// VDCLK_TEN_DateFormat enPrevDateFormat  = _enDateFormat;
	tU32                 u32PrevDateFormat = _u32DateFormat;
	tU16                 u16PrevTimeZone   = _u16TimeZoneIndex;
	tBool                bPrevDST_On       = _bDST_ON;
	VDCLK_TEN_SyncMode   enPrevSyncMode    = _enSyncMode;
	VDCLK_TEN_GPS_EPOCH  enPrevGPS_epoch   = _enGPSEpoch;
	tS64                 s64Prevoffset    = _s64Offs;

	//tS64 s64Diff  = _s64DynOffset[VDCLK_EN_DomainMaster];


	vReleaseCriticalSection("vSetDefaultSettings");

	// reload
	ETG_TRACE_USR3(("reloading data"));

	// when default settings are loaded, vLoadData() should
	// read KDS values.
	//_isDefaultSetting = TRUE;		Coverity Fix - Value is over written
	//vLoadData();
	_isDefaultSetting = FALSE;

	tBool bPrevGPSSync= bIsGpsSync(enPrevSyncMode);
	tBool bGPSSync = bIsGpsSync(_enSyncMode);
	// post events, if state has changed
	/*tBool bTimeChanged = (s64Diff > 60LL) || (s64Diff < -60LL)
                    																												 || (u16PrevTimeZone != _u16TimeZoneIndex)
                    																												 || (bPrevDST_On != _bDST_ON)
                    																												 || (bPrevGPSSync != bGPSSync)
                    																												 || (enPrevGPS_epoch != _enGPSEpoch);

	OSAL_tEventMask u32EventMask
	= ( bTimeChanged                          ? cu32EventMaskPropertyNotify8200 : 0L)
	| ((enPrevTimeFormat != _enTimeFormat)    ? cu32EventMaskPropertyNotify8210 : 0L)
	| ((u32PrevDateFormat != _u32DateFormat)  ? cu32EventMaskPropertyNotify8220 : 0L)
	| ((u16PrevTimeZone != _u16TimeZoneIndex) ? cu32EventMaskPropertyNotify8410 : 0L)
	| ((bPrevDST_On != _bDST_ON)              ? cu32EventMaskPropertyNotify8420 : 0L)
	| ((bPrevGPSSync != bGPSSync)             ? cu32EventMaskPropertyNotify8430 : 0L)
	| ((enPrevSyncMode != _enSyncMode)        ? cu32EventMaskPropertyNotify8440 : 0L)
	| ((enPrevGPS_epoch != _enGPSEpoch)       ? cu32EventMaskPropertyNotify8460 : 0L)
	| ((s64Prevoffset != _s64Offs)            ? cu32EventMaskPropertyNotify8470 : 0L);

   u32EventMask = u32EventMask;
/*
   if (u32EventMask)
   {
      VDCLOCK_ASSERT_NORMAL_RETURN(OSAL_NULL != vdclk_poNotificationTrigger);
      vdclk_poNotificationTrigger-> vPost (u32EventMask, _CLASS, __LINE__);
      vSaveData(TRUE);
   };
	 */

	//  vSaveData(TRUE);

	vd_clock_tclAppMain::theServer()->vPostMsgTimeformatUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgTimezoneUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgDSTUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgDateformatUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgEpochUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgSyncmodeUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgGPSAutoSyncUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocaltimeOffsetUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer() ->vPostMsgAutoTimeZoneOffsetUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer() ->vPostMsgNewDateformatUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer() ->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer() ->vPostMsgUTCTimeDateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer() ->vPostMsgDebugMode_TimeDateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer() ->vPostMsgHUDActivateStateUpdate("Ivd_clock_tclServiceClockIf");

};


/************************************************************************
 * FUNCTION:    vGetLocalDateTime
 *
 * DESCRIPTION: gets the local date time according an offset
 *
 * PARAMETER:   vdclk_tclDateTime*  poLocalDateTime
 *
 * RETURNVALUE: none
 *************************************************************************/
#ifndef __COVERITY__ 
tVoid  vdclk_tclDataContainer::vGetLocalDateTime (vdclk_tclDateTime*  poLocalDateTime)
{
    ETG_TRACE_USR4(("vGetLocalDateTime Entered"));

    vEnterCriticalSection("vGetLocalDateTime");

	VDCLK_TEN_DomainOffset enDomainOffset;

	enPrevDomainOffset = enDomainOffset;
	ETG_TRACE_USR4(("Previous Domain offset is %d ",enPrevDomainOffset ));

	ETG_TRACE_USR4(("Recieved bGetPositionBased Value %d",bGetPositionBased()));
	ETG_TRACE_USR4(("Recieved Sync Mode Value %d",(bIsGpsSync(_enSyncMode))));
	ETG_TRACE_USR4(("Recieved  Actual Sync Mode Value %d",_enSyncMode));
	
	if((bGetPositionBased() == 0) && (bIsGpsSync(_enSyncMode) == 1)) // timezone mode
	{
		enDomainOffset = VDCLK_EN_TZ;
		_s64Offs =  _s64DynOffset[VDCLK_EN_TZ] + _u64AutoTimezoneOffset;
		ETG_TRACE_USR3(("vGetLocalDateTime: TZ offset  %d", _s64Offs));

	}
	else if((bGetPositionBased()== 0) && (bIsGpsSync(_enSyncMode) == 0)) //manual mode
	{
		enDomainOffset = VDCLK_EN_Manual_Mode;
		_s64Offs =  _s64DynOffset[VDCLK_EN_Manual_Mode];
		ETG_TRACE_USR3(("vGetLocalDateTime: Manual offset  %d", _s64Offs));

	}
	else if ((bGetPositionBased()== 1) && (bIsGpsSync(_enSyncMode) == 1)) //auto mode
	{
		if(_cantimeavailable == false)
		{
		enDomainOffset = VDCLK_EN_Auto;
		_s64Offs =  _s64DynOffset[VDCLK_EN_Auto] + _u64AutoTimezoneOffset;
                
		ETG_TRACE_USR3(("vGetLocalDateTime: Auto offset  %d", _s64Offs));
		}
		else
		{
			enDomainOffset = VDCLK_EN_Manual_Mode;
		   _s64Offs =  _s64DynOffset[VDCLK_EN_Manual_Mode];
		    ETG_TRACE_USR3(("vGetLocalDateTime: CAN offset  %d", _s64Offs));

		}
		
	}
       else
		{
			
		    ETG_TRACE_USR3(("vGetLocalDateTime: Invalid Mode Received "));

		}
	tU32 u32NewValue = 0;
	*poLocalDateTime = _oSystemTime;        // use assignment operator

	vReleaseCriticalSection("vGetLocalDateTime");

	if (_s64Offs > 0L)
	{
		u32NewValue = (tU32) ((tS64) poLocalDateTime->u32GetValue() + _s64Offs);
		poLocalDateTime->u8SetValue(u32NewValue);
		_bIsOffsetValid = TRUE;
	}
	else if ( (tU32) -_s64Offs > poLocalDateTime->u32GetValue())
	{
		ETG_TRACE_USR3(("local date time:%u", poLocalDateTime->u32GetValue()));
		ETG_TRACE_USR3(("(tS32)_s64Offs:%d", (tS32) _s64Offs));
		// would lead to invalid date / time; ignore
		_bIsOffsetValid = FALSE;
	}
	else
	{
		u32NewValue = (tU32) ((tS64) poLocalDateTime->u32GetValue() + _s64Offs);
		poLocalDateTime->u8SetValue(u32NewValue);
		_bIsOffsetValid = TRUE;
	};

		vd_clock_tclAppMain::theServer()->vPostMsgLocaltimeOffsetUpdate("Ivd_clock_tclServiceClockIf");

	TRACE_DateTime("vGetLocalDateTime", (*poLocalDateTime), _CLASS, __LINE__);
	return;
};
#endif

/************************************************************************
 * FUNCTION:    vSetLocalDateTime
 *
 * DESCRIPTION: stores the offset to the system time in _s64DynOffset
 *
 * PARAMETER:   vdclk_tclDateTime const * const poNewLocalDateTime
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetLocalDateTime (vdclk_tclDateTime const * const poNewLocalDateTime)
{
	vEnterCriticalSection("vSetLocalDateTime");

	// modify DTO value
	_s64DynOffset[VDCLK_EN_Manual_Mode] = (tS64) poNewLocalDateTime->u32GetValue() - (tS64)_oSystemTime.u32GetValue();

	vReleaseCriticalSection("vSetLocalDateTime");
	ETG_TRACE_USR3(("DTO:%u", _s64DynOffset[VDCLK_EN_Manual_Mode]));
	return;
};

/************************************************************************
 * FUNCTION:    vSetCANLocalDateTime
 *
 * DESCRIPTION: stores the offset to the system time in _s64DynOffset
 *
 * PARAMETER:   vdclk_tclDateTime const * const poNewLocalDateTime
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetCANLocalDateTime (vdclk_tclDateTime const * const poNewLocalDateTime)
{
	vEnterCriticalSection("vSetCANLocalDateTime");

	// modify DTO value
	_s64DynOffset[VDCLK_EN_Manual_Mode] = (tS64) poNewLocalDateTime->u32GetValue() - (tS64)_oSystemTime.u32GetValue();

	vReleaseCriticalSection("vSetLocalDateTime");
	ETG_TRACE_USR3(("DTO:%u", _s64DynOffset[VDCLK_EN_Manual_Mode]));
	return;
};


/************************************************************************
 * FUNCTION:    vGetSystemDateTime
 *
 * DESCRIPTION: gets the system time
 *
 * PARAMETER:   vdclk_tclDateTime*  poSystemDateTime
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vGetSystemDateTime (vdclk_tclDateTime& oSystemDateTime) const
{
	oSystemDateTime = _oSystemTime;        // use assignment operator

	TRACE_DateTime("vGetSystemDateTime", oSystemDateTime, _CLASS, __LINE__);
	return;
};


/************************************************************************
 * FUNCTION:    enGetClockSourceStatus
 *
 * DESCRIPTION: returns the source status of clock source (enum  value)
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: VDCLK_TEN_ClockSourceStatus
 *************************************************************************/
VDCLK_TEN_ClockSourceStatus vdclk_tclDataContainer::enGetClockSourceStatus () const
{
	return _enClockSourceStatus;
};

/************************************************************************
 * FUNCTION:    enGetFormatSourceStatus
 *
 * DESCRIPTION: returns the status of the FormatSourceStatus
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: VDCLK_TEN_FormatSourceStatus
 *************************************************************************/
VDCLK_TEN_FormatSourceStatus vdclk_tclDataContainer::enGetFormatSourceStatus () const
{
	return _enFormatSourceStatus;
};

/************************************************************************
 * FUNCTION:    enGetTimeFormat
 *
 * DESCRIPTION: returns the current time format
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: VDCLK_TEN_TimeFormat
 *************************************************************************/
VDCLK_TEN_TimeFormat vdclk_tclDataContainer::enGetTimeFormat () const
{
	//return _enTimeFormat;
	ETG_TRACE_USR4(("Time Format Index  is : %d",_u32TimeFormat));
	ETG_TRACE_USR4(("Time Format value  is : %d",_vTimeFormat[_u32TimeFormat]));

	if((_u32TimeFormat == 0)||(_u32TimeFormat == 1))
	{
		return _vTimeFormat[_u32TimeFormat];
	}else
	{
		return _vTimeFormat[0];
	}
};

/************************************************************************
 * FUNCTION:    vSetTimeFormat
 *
 * DESCRIPTION: sets the given time format (see parameter)
 *
 * PARAMETER:   VDCLK_TEN_TimeFormat NewFormat
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetTimeFormat (VDCLK_TEN_TimeFormat NewFormat)
{
	vSetTimeFormatGeneric((VDCLK_TEN_TimeFormat)NewFormat);

	vd_clock_tclAppMain::theServer()->vPostMsgTimeformatUpdate("Ivd_clock_tclServiceClockIf");

};


tVoid  vdclk_tclDataContainer::vSetTimeFormatGeneric (VDCLK_TEN_TimeFormat NewFormat)
{
	vEnterCriticalSection("vSetTimeFormat");

	// _enTimeFormat = NewFormat;
	// ETG_TRACE_USR4(("Time Format ist (%d)",_enTimeFormat));

	bpstl::vector<VDCLK_TEN_TimeFormat>::iterator it;
	for( it = _vTimeFormat.begin(); it != _vTimeFormat.end(); it++ )
	{
		if(*it == NewFormat)
		{
			_u32TimeFormat = it - _vTimeFormat.begin() ;
			ETG_TRACE_USR4(("Time Format Index: %d",_u32TimeFormat));
		}
	}
	vReleaseCriticalSection("vSetTimeFormat");

	ETG_TRACE_USR4(("Time Format set to (%d)",_vTimeFormat[_u32TimeFormat]));


};

/************************************************************************
 * FUNCTION:    enGetDateFormat
 *
 * DESCRIPTION: returns the current date format
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: VDCLK_TEN_DateFormat
 *************************************************************************/
VDCLK_TEN_DateFormat vdclk_tclDataContainer::enGetDateFormat() const
{
	// return _enDateFormat;
	ETG_TRACE_USR4(("Date Format Index  is : %d",_u32DateFormat));
	ETG_TRACE_USR4(("Date Format value  is : %d",_vDateFormat[_u32DateFormat]));


	return _vDateFormat[_u32DateFormat];
};

/************************************************************************
 * FUNCTION:    enGetNewDateFormat
 *
 * DESCRIPTION: returns the current date format
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: VDCLK_TEN_DateFormat
 *************************************************************************/
VDCLK_TEN_NewDateFormat vdclk_tclDataContainer::enGetNewDateFormat() const
{
	// return _enDateFormat;
	ETG_TRACE_USR4(("new Date Format Index  is : %d",_u32DateFormat));
	ETG_TRACE_USR4(("new Date Format value  is : %d",_vNewDateFormat[_u32DateFormat]));


	return _vNewDateFormat[_u32DateFormat];
};

/************************************************************************
 * FUNCTION:    vSetDateFormat
 *
 * DESCRIPTION: stores the current (or new) date format
 *
 * PARAMETER:   VDCLK_TEN_DateFormat NewFormat
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetDateFormat (VDCLK_TEN_DateFormat NewFormat)
{
	vEnterCriticalSection("vSetDateFormat");

	// _enDateFormat = NewFormat;
	bpstl::vector<VDCLK_TEN_DateFormat>::iterator it;
	for( it = _vDateFormat.begin(); it != _vDateFormat.end(); it++ )
	{
		if(*it == NewFormat)
		{
			_u32DateFormat = it - _vDateFormat.begin() ;
			ETG_TRACE_USR4(("Date Format Index: %d",_u32DateFormat));
		}
	}
	vReleaseCriticalSection("vSetDateFormat");

	ETG_TRACE_USR4(("Date Format set to (%d)",_vDateFormat[_u32DateFormat]));

	vd_clock_tclAppMain::theServer()->vPostMsgDateformatUpdate("Ivd_clock_tclServiceClockIf");
};

/************************************************************************
 * FUNCTION:    vSetNewDateFormat
 *
 * DESCRIPTION: stores the current (or new) date format
 *
 * PARAMETER:   VDCLK_TEN_NewDateFormat NewFormat
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetNewDateFormat (VDCLK_TEN_NewDateFormat NewFormat)
{
	vEnterCriticalSection("vSetNewDateFormat");

	// _enDateFormat = NewFormat;
	bpstl::vector<VDCLK_TEN_NewDateFormat>::iterator it;
	for( it = _vNewDateFormat.begin(); it != _vNewDateFormat.end(); it++ )
	{
		if(*it == NewFormat)
		{
			_u32DateFormat = it - _vNewDateFormat.begin() ;
			ETG_TRACE_USR4(("new Date Format Index: %d",_u32DateFormat));
		}
	}

	vReleaseCriticalSection("vSetNewDateFormat");

	ETG_TRACE_USR4(("new Date Format set to (%d)",_vNewDateFormat[_u32DateFormat]));

	vd_clock_tclAppMain::theServer()->vPostMsgNewDateformatUpdate("Ivd_clock_tclServiceClockIf");
};

/************************************************************************
 * FUNCTION:    bGetDaylightSavingTimeOn
 *
 * DESCRIPTION: returns if the daylight saving time is set or not
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: tBool
 *************************************************************************/
tBool  vdclk_tclDataContainer::bGetDaylightSavingTimeOn (tVoid) const
{
	return _bDST_ON;
};

/************************************************************************
 * FUNCTION:    bGetDaylightSavingTimeAuto
 *
 * DESCRIPTION: TSTS
 *              check if this is needed
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: tBool
 *************************************************************************/
tBool  vdclk_tclDataContainer::bGetDaylightSavingTimeAuto (tVoid) const
{
	return FALSE;  // function currently not implemented
};

/************************************************************************
 * FUNCTION:    vSetDaylightSavingTime
 *
 * DESCRIPTION: sets the daylight saving time VDCLK_TEN_DST_Setting
 *
 * PARAMETER:   VDCLK_TEN_DST_Setting const enDST_Setting, tBool identifier
 *              (needed to identify the caller. If it is clienthandlernavi,
 *              dont call updateAutomaticTime because this will be done
 *              when time zone is changed (irritating clock HMI due to double
 *              update))
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetDaylightSavingTime (VDCLK_TEN_DST_Setting const enDST_Setting,
		tBool hmi_update)
{

	vSetDaylightSavingTimeGeneric( (VDCLK_TEN_DST_Setting)enDST_Setting, hmi_update );

	vd_clock_tclAppMain::theServer()->vPostMsgDSTUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");

	ETG_TRACE_USR4(("Daylight saving time set to (%d) identifier %d",_bDST_ON, hmi_update));

	return;
};

tVoid  vdclk_tclDataContainer::vSetDaylightSavingTimeGeneric (VDCLK_TEN_DST_Setting const enDST_Setting,
		tBool hmi_update)
{

#ifndef VARIANT_S_FTR_ENABLE_CLOCK_CAN_BAP_RECEPTION
	if (enDST_Setting == VDCLK_EN_DST_Auto)
	{
		ETG_TRACE_COMP(("Automatic setting of daylight saving time (DST) not supported"));
		return;
	}
#endif

	vEnterCriticalSection("vSetDaylightSavingTime");

	// update member variables
	tBool bVal = (enDST_Setting == VDCLK_EN_DST_On);
	_bDST_ON = bVal;
	// enDST_Setting used for MIBE project
	_enDaylightSaving = enDST_Setting;

	vReleaseCriticalSection("vSetDaylightSavingTime");

	if(hmi_update == TRUE)
	{
		ETG_TRACE_USR4(("Updating time to (%d) identifier %d",bVal, hmi_update));
		vUpdateTZAutomaticTime();
	}

	tU32 u32EvtMask = 0;
	u32EvtMask |= cu32EventMaskPropertyNotify8420;
	ETG_TRACE_USR4(("Daylight saving time set to (%d) identifier %d",bVal, hmi_update));
	return;
};

/************************************************************************
 * FUNCTION:    vSetGPS_AutoSync
 *
 * DESCRIPTION: toggles the clock mode (auto, manual, timezone)
 *
 * PARAMETER:   tBool bEnabled, tBool bPositionBased
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetGPS_AutoSync (tBool bEnabled,
		tBool bPositionBased)
{

	vSetGPS_AutoSyncGeneric(bEnabled,bPositionBased);
	vd_clock_tclAppMain::theServer()->vPostMsgGPSAutoSyncUpdate("Ivd_clock_tclServiceClockIf");
};


tVoid  vdclk_tclDataContainer::vSetGPS_AutoSyncGeneric (tBool bEnabled,
		tBool bPositionBased)
{
	ETG_TRACE_USR4(("vSetGPS_AutoSyncGeneric: Input: bEnabled:%d  bPositionBased:%d",bEnabled,bPositionBased));
	VDCLK_TEN_SyncMode enSyncMode;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_CLOCK_MC
	enSyncMode = bEnabled ? VDCLK_EN_SyncMode_GPS : VDCLK_EN_SyncMode_CAN;
#else
	enSyncMode = bEnabled ? VDCLK_EN_SyncMode_GPS : VDCLK_EN_SyncMode_CanOrManual;
#endif
	vSetSyncMode(enSyncMode);
	_isEnabled = bEnabled;
	_bDST_AutoSet = bPositionBased;

	tU32 u32EvtMask = 0;
	if (_isPositionBased != bPositionBased)
	{
		if(_isPositionBased)
		{
			_isPositionBased = FALSE;
		}
		else
		{
			_isPositionBased = TRUE;
		}
		u32EvtMask |= cu32EventMaskPropertyNotify8430;
	}
	if (bIsGpsSync(enSyncMode) != bEnabled)
	{
		u32EvtMask |= cu32EventMaskPropertyNotify8430;
	}
	if (u32EvtMask)
	{

		//   vdclk_poNotificationTrigger->vPost(u32EvtMask, _CLASS, __LINE__);
	}
	ETG_TRACE_USR4(("vSetGPS_AutoSyncGeneric: Output: bEnabled:%d  bPositionBased:%d",_isEnabled,_isPositionBased));

	// Set the manual time to auto time when the mode is changed from Auto/TZ to Manual NCG3D-83405
	vToManualTimeInitialization(bEnabled,bPositionBased);
};

/************************************************************************
 * FUNCTION:    vSetSyncMode
 *
 * DESCRIPTION: sets the syncMode of the clock
 *
 * PARAMETER:   VDCLK_TEN_SyncMode enSyncMode
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetSyncMode (VDCLK_TEN_SyncMode enSyncMode)
{
	vEnterCriticalSection("vSetSyncMode");

	VDCLK_TEN_SyncMode enPrevSyncMode = _enSyncMode;
	_enSyncMode = enSyncMode;


	vReleaseCriticalSection("vSetSyncMode");


	if (enPrevSyncMode != enSyncMode)
	{
		tU32 u32EvtMask = cu32EventMaskPropertyNotify8200;
		u32EvtMask |= cu32EventMaskPropertyNotify8440;

		vd_clock_tclAppMain::theServer()->vPostMsgSyncmodeUpdate("Ivd_clock_tclServiceClockIf");
		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
	}
};

/************************************************************************
 * FUNCTION:    enGetSyncMode
 *
 * DESCRIPTION: returns the current set syncMode
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: VDCLK_TEN_SyncMode
 *************************************************************************/
VDCLK_TEN_SyncMode  vdclk_tclDataContainer::enGetSyncMode (tVoid) const
{
	VDCLK_TEN_SyncMode enRetVal = _enSyncMode;

	return enRetVal;
};

/************************************************************************
 * FUNCTION:    bGetGPS_AutoSync
 *
 * DESCRIPTION: returns if auto mode is set or not
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: tBool
 *************************************************************************/
tBool  vdclk_tclDataContainer::bGetGPS_AutoSync (tVoid) const
{
	return (tBool)bIsGpsSync(_enSyncMode);
};

/************************************************************************
 * FUNCTION:    bGetPositionBased
 *
 * DESCRIPTION: returns if _isPositionBased is set or not
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: tBool
 *************************************************************************/
tBool  vdclk_tclDataContainer::bGetPositionBased (tVoid) const
{
	return _isPositionBased;
};

/************************************************************************
 * FUNCTION:    u16GetTimeZoneIndex
 *
 * DESCRIPTION: returns the current set time zone index
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: tU16
 *************************************************************************/
tU16  vdclk_tclDataContainer::u16GetTimeZoneIndex () const
{
	return _u16TimeZoneIndex;
};

/************************************************************************

 * FUNCTION:    vSetTimeZone
 *
 * DESCRIPTION: changes the time zone
 *
 * PARAMETER:   tU16 const u16Index
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSetTimeZone (tU16 const u16Index)
{
	vSetTimeZoneGeneric(u16Index);

	vd_clock_tclAppMain::theServer()->vPostMsgTimezoneUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");

	return;
};
tVoid  vdclk_tclDataContainer::vSetTimeZoneGeneric (tU16 const u16Index)
{
	vEnterCriticalSection("vSetTimeZone");

	// update member variables
	_u16TimeZoneIndex = (u16Index > 0 ? u16Index - 1 : vdclk_u16DefaultTimeZoneIndex);

	ETG_TRACE_USR1(("Timezoneindex received: %d", u16Index));

	vReleaseCriticalSection("vSetTimeZone");

	vUpdateTZAutomaticTime();
	OSAL_tEventMask u32NotifyEvents = 0UL;
	u32NotifyEvents = cu32EventMaskPropertyNotify8410 | cu32EventMaskPropertyNotify8200;
	return;
};

/************************************************************************
 * FUNCTION:    enGetGPSEpoch
 *
 * DESCRIPTION: returns the current set GPS week epoch
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: VDCLK_TEN_GPS_EPOCH
 *************************************************************************/
VDCLK_TEN_GPS_EPOCH vdclk_tclDataContainer::enGetGPSEpoch() const
{
	VDCLK_TEN_GPS_EPOCH result = _enGPSEpoch;
	if(_poClientSensor)
	{
		_poClientSensor->sendGnssWnEpochGet();
	}

	return result;
}

/************************************************************************
 * FUNCTION:    enSetGPSEpoch
 *
 * DESCRIPTION: sets the member _enGPSEpoch with the value in parameter
 *
 * PARAMETER:   VDCLK_TEN_GPS_EPOCH epoch
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid vdclk_tclDataContainer::enSetGPSEpoch(VDCLK_TEN_GPS_EPOCH epoch)
{
	vEnterCriticalSection("enSetGPSEpoch");
	_enGPSEpoch = epoch;

	sensor_fi_tcl_TimeDate _EpochTime;
	switch(_enGPSEpoch)
	{
	case 1:
		ETG_TRACE_USR4(("Epoch 2014 - 2034"));

		_EpochTime.td_year = 2014;
		_EpochTime.td_month = 11;
		_EpochTime.td_day = 30;
		_EpochTime.td_hour = 0;
		_EpochTime.td_minute = 0;
		_EpochTime.td_second = 0;
		break;
	case 2:
		ETG_TRACE_USR4(("Epoch 2034-2054"));

		_EpochTime.td_year = 2034;
		_EpochTime.td_month = 07;
		_EpochTime.td_day = 16;
		_EpochTime.td_hour = 0;
		_EpochTime.td_minute = 0;
		_EpochTime.td_second = 0;

		break;
	case 3:
		ETG_TRACE_USR4(("Epoch 2054-2073"));

		_EpochTime.td_year = 2054;
		_EpochTime.td_month = 03;
		_EpochTime.td_day = 01;
		_EpochTime.td_hour = 0;
		_EpochTime.td_minute = 0;
		_EpochTime.td_second = 0;

		break;
	default:
		ETG_TRACE_USR4(("Epoch default"));
		_EpochTime.td_year = 2014;
		_EpochTime.td_month = 11;
		_EpochTime.td_day = 30;
		_EpochTime.td_hour = 0;
		_EpochTime.td_minute = 0;
		_EpochTime.td_second = 0;
		break;
	}
	ETG_TRACE_USR4(("Epoch Time Set(Year:Month:Day: , HH:MM:SS): %d:%d:%d:%d:%d:%d:",
			_EpochTime.td_year,
			_EpochTime.td_month,
			_EpochTime.td_day,
			_EpochTime.td_hour,
			_EpochTime.td_minute,
			_EpochTime.td_second));

	if(_poClientSensor)
	{
		_poClientSensor->sendGnssWnEpochSet(_EpochTime);
	}

	OSAL_tEventMask u32NotifyEvents = 0UL;
	u32NotifyEvents =    cu32EventMaskPropertyNotify8460;
	vd_clock_tclAppMain::theServer()->vPostMsgEpochUpdate("Ivd_clock_tclServiceClockIf");

	vReleaseCriticalSection("enSetGPSEpoch");

}


/************************************************************************
 * FUNCTION:    vLoadData
 *
 * DESCRIPTION: loads machine and user data
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vLoadData ()
{

	// active status

	if(vd_clock_tclAppMain::theServer)
	{
		ETG_TRACE_USR4(("Sending component active status"));
		vd_clock_tclAppMain::theServer()->SendComponentStatusActive_INC();
	}

	// reading KDS entry
	vReadfromDatapool();

	// _enRegionCode = ReadKDS();
	//tU8 u8Region = 0xFF;


	if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "DestinationRegion1", &u8Region, 1) )
	{

		ETG_TRACE_USR1(("_u8ReadConfiguredRegion(): KDS Region is 0x%02x.", u8Region));
	}
	else
	{
		// Set the Default region as USA
		u8Region = Region_USA;
		ETG_TRACE_ERR(("_u8ReadConfiguredRegion(): KDS Region Read Failed. Setting region as USA"));
	}

	ETG_TRACE_USR4(("KDS read Region Code = %d",u8Region));
	//get the variant type DA or no
	_VariantType =  getVariantSelection();


	if(_VariantType == 0x01)
	{
		getRegionBasedSupportedTimeZone(u8Region);
	}

	// setting up default values for date for region based
	if(_u32DateFormat == 0)
		getRegionBasedSupportedDateFormat(u8Region);

	u8OEMType = getOEMType();



#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_CLOCK_NISSAN
#if 0
	// when System is set back to factorys settings
	if(_isDefaultSetting == TRUE)
	{
		// get object of KDS reader
		// vdclk_tclKDSReader kdsReader;

		// read the KDS entry, do nothing if failed
		// 0x0D59 = identifier for vehicle information
		// data = array to store data in
		// if(kdsReader.ReadKDS(VEHICLE_CONFIG_ENTRY_KEY, sizeof(kdsReader.data)))
		// {
		// 3 = Byte to read
		// 0x0F = Mask to compare with
		// 3 = number of bits to shift the _enRegionCode
		// TRUE = shift to the right (False = left)
		//  _enRegionCode = (VDCLK_REGIONTYPE)kdsReader.getSingleKDSValue(3, 0x0F, 3, TRUE);

		ETG_TRACE_USR4(("KDS read Region Code = %d",_enRegionCode));

		// set default values for NAR or CAN or MEX coded systems
		if((_enRegionCode == USA) || (_enRegionCode == CAN) || (_enRegionCode == MEX))
		{
			vSetTimeFormat(VDCLK_EN_TF_Mode12);       // time format = 12h
			vSetDateFormat(VDCLK_EN_DF_mm_dd_yyyy);   // date format = mm/dd/yyyy
			vSetTimeZone(6);                          // time zone   = US Pacific time (index no.6)
			ETG_TRACE_USR1(("NAR coded device: Set time format to 12, date format mm/dd/yyyy, time zone US pacific time"));
		}
		// default values for all others
		else
		{
			vSetTimeFormat(VDCLK_EN_TF_Mode24);       // time format = 24h
			vSetDateFormat(VDCLK_EN_DF_yyyy_mm_dd);   // date format = dd.mm.yyyy
			vSetTimeZone(35);                         // time zone   = Paris, Prague, Rome (index no. 35)
			ETG_TRACE_USR1(("Not NAR coded device: Set time format to 24, date format dd.mm.yyyy, time zone Paris,Prague,Rome"));
		}

		// General settings
		// Daylight saving time = OFF
		// GPS synch            = AUTO      ALREADY DONE
		vSetDaylightSavingTime(VDCLK_EN_DST_Off, TRUE);
		vUpdateAutomaticTime();
		ETG_TRACE_USR1(("Set DST OFF"));
		/* handle it specifically in the timezone file( create new definition for countrycodes instead)
         switch(_enRegionCode)
         {
            // EUR = 0x03 (Europe)
            // set Caucasus standard time instead of Golf standard time
            case EUR:
               vdclk_TZCountryCodes[75].u8IndexOfTZ = 60;
               ETG_TRACE_USR1(("KDS coded EUR: Set CountryCode[75] to index 60"));
               break;

            // GCC = 0x05 (Golf Coast Countries)
            // set Golf standard time instead of Caucasus standard time
            case GCC:
               vdclk_TZCountryCodes[79].u8IndexOfTZ = 57;
               ETG_TRACE_USR1(("KDS coded GCC: Set CountryCode[79] to index 57"));
               break;

            // SAF = 0x0A (South Africa)
            // set West central africa time instead of Central europe time
            case SAF:
               vdclk_TZCountryCodes[50].u8IndexOfTZ = 38;
               ETG_TRACE_USR1(("KDS coded SAF: Set CountryCode[50] to index 38"));
               break;

            default:
               ETG_TRACE_USR1(("KDS Default case"));
               break;
         }
		 */
		//}// end of reading Nissan region code
	}
#endif // #if 0
#endif

};

/************************************************************************
 * FUNCTION:    vSave Data
 *
 * DESCRIPTION: prepares the storage of data in the FFS and creates a thread to
 *              store the data
 *
 * PARAMETER:   tBool bDelayedWriting
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vSaveData (tBool bDelayedWriting)
{
	(tVoid)bDelayedWriting;
	vStoretoDatapool();
};

// **********************************************************************
// ***	U p d a t e r   I n t e r f a c e   F u n c t i o n s			 ***
// **********************************************************************
/************************************************************************
 * FUNCTION:    vOnTickTimerEvent
 *
 * DESCRIPTION: Callback function for TickTimer thread
 *              to update member variable _oSystemTime
 *
 * PARAMETER:   const OSAL_trTimeDate& rNewDateTime
               const OSAL_tenRtcTimeState enRTCTimeState   // indicates whether the RTC TimeDate is Valid or not
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vOnTickTimerEvent (const rtc_time& rNewDateTime, const OSAL_tenRtcTimeState enRTCTimeState)
{

	// check prerequisites
	if (OSAL_C_INVALID_HANDLE==_hDataUpdateSemaphore) {
		ETG_TRACE_ERR(("vOnTickTimerEvent: invalid _hDataUpdateSemaphore"));
	}
	vEnterCriticalSection("vOnTickTimerEvent");
	ETG_TRACE_USR3(("rNewDateTime.tm_year %d",rNewDateTime.tm_year));
	// workaround (1) to compensate for setting RTC by vdSensor
	tU32  u32OldValue = _oSystemTime.u32GetValue();

	_enRTCTimeState = (VDCLK_TEN_GPSRTCTIMESTATE)enRTCTimeState;

	// For NIKAI-5913;  s32OffsetYear = 1900, if rtctimestate is valid or eversync;      and s32OffsetYear = 1925 if rtctimestate is INVALID
	tS32 s32OffsetYear = 1900;//(enRTCTimeState == OSAL_RTC_INVALID) ? 1947 : 1900;

	/*	tS32 s32OffsetYear = 0;
	unsigned char RTCType = 0xFF;
	dp_tclKdsCMVariantCoding _oVariantCoding;
	RTCType = FALSE;
	_oVariantCoding.u8GetRTC(RTCType);

	ETG_TRACE_USR4(("RTC  RTCType:%x ", RTCType));

	if ( RTCType == 0x02)
	{
		s32OffsetYear = 1947;
	}
	else if(RTCType == 0x03)
	{
		s32OffsetYear = 1900;
	}
	else
	{
		s32OffsetYear = (enRTCTimeState == OSAL_RTC_INVALID) ? 1947 : 1900;
	}*/

	if((enRTCTimeState == OSAL_RTC_VALID))
	{
		// update system date and time regularly
		_oSystemTime.u8Update((tS16) rNewDateTime.tm_year + s32OffsetYear,  // RTC-time is based on 1900-1-1
				(tU8)  rNewDateTime.tm_mon + 1,
				(tU8)  rNewDateTime.tm_mday,
				(tU8)  rNewDateTime.tm_hour,
				(tU8)  rNewDateTime.tm_min,
				(tU8)  rNewDateTime.tm_sec,
				(tU8)  VDCLK_EN_AllChange);
	}
	/*	else if(_poClientSensor->isGPSDataValid())
	{
		//do nothing system time already set from Gps
	}*/
	else
	{
		/*		if(_bSystemTimeSet == FALSE)
		{
			//todo: check we can initiate the factory reset here, since RTC is not valid and it should not jump
			//vFactoryReset();
			_oSystemTime.u8Update(2017, 1, 1, 1, 0, 0, (tU8)VDCLK_EN_AllChange);
			_bSystemTimeSet = TRUE;
		}*/
		tU32 u32TempValue = _oSystemTime.u32GetValue();
		u32TempValue ++;
		_oSystemTime.u8SetValue(u32TempValue);
	}

	TRACE_DateTime("vOnTickTimerEvent", _oSystemTime, _CLASS, __LINE__);

	vReleaseCriticalSection("vOnTickTimerEvent");

	// inform main that we got a time
	//if (_poApp) {
	//    _poApp->vOnTickTimerEvent();
	// }

	// workaround (2) to compensate for setting RTC by vdSensor

	/* commented for interrupt shutdown */
	/*	if (u32OldValue == 0UL)
		;  // initial call, nothing to do
	else
	{
		u32OldValue++;  // expected new value
		tU32  u32NewValue = _oSystemTime.u32GetValue();
		tS64 s64Diff = (tS64) u32NewValue - (tS64) u32OldValue;
		if ((s64Diff > 2L) || (s64Diff < -2L))
		{
			vEnterCriticalSection("vOnTickTimerEvent() s64Diff > +/-2L");

		  // adjust dynamic offset for master time
         _s64DynOffset[VDCLK_EN_DomainMaster] -= s64Diff;

		 vReleaseCriticalSection("vOnTickTimerEvent() s64Diff > +/-2L");

         ETG_TRACE_SYS(("RTC internally updated by %d", s64Diff));
      };
      /*if ((s64Diff > 60L) || (s64Diff < -60L))
      {
         vSaveData(TRUE);
      };
	}*/

	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer() ->vPostMsgUTCTimeDateUpdate("Ivd_clock_tclServiceClockIf");

	//Log the Linux OS system time

	tBool _isGPSValid = FALSE ;
	if(_poClientSensor)
	{
		_isGPSValid = _poClientSensor->isGPSDataValid();
	}

	if(_GPSType == 0x02)
	{
		vStoreLocalTime();
	}

	else if(_GPSType == 0x01)
	{

		if((_isGPSValid) || (_poUpdater->_RTCValidOnce))
		{
			vStoreOSSystemTime();

		}
		else
		{
		//	vStoreLocalTime();
		}
	}

	ETG_TRACE_USR4(("Mod_Clock: OnTickTimerEvent:GPSType:%d, isGPSDataValid:%d, enRTCTimeState:%d",
			_GPSType, _isGPSValid, enRTCTimeState));

	_bRTCVAlid = TRUE;
	vDefaultInitialization(_u32AppState,_bRTCVAlid);

	// just for verification, remove it after testing
	//OSAL_trTimeDate  TmpTimeDate;

	//OSAL_s32ClockGetTime(&TmpTimeDate);

	//TRACE_OSALDateTime("Verifying Linux system Time", TmpTimeDate, _CLASS, __LINE__ );
};

/************************************************************************
 * FUNCTION:    vOnClockExtSourceListenerEvent
 *
 * DESCRIPTION: Callback function for Updater thread
 *              to update member variable _s64DynOffset[VDCLK_EN_DomainMaster]
 *              - notifies on master availability change
 *
 * PARAMETER:   const OSAL_trTimeDate& rnewValue, tU8 u8ValidityMask
 *
 * RETURNVALUE: none
 *************************************************************************/
/*tVoid  vdclk_tclDataContainer::vOnClockExtSourceListenerEvent (const OSAL_trTimeDate& rnewValue,
		tU8 u8ValidityMask)
{
	tBool                   bNotifyStatus = FALSE;
	tBool                   bNotifyClock  = FALSE;
	tBool                   bSaveData     = FALSE;

	// translate parameter to vdclk_tclDatetime
	vdclk_tclDateTime oMasterTime;
	oMasterTime.u8Update
	(
			(tS16) rnewValue.s32Year,
			(tU8)  rnewValue.s32Month,
			(tU8)  rnewValue.s32Day,
			(tU8)  rnewValue.s32Hour,
			(tU8)  rnewValue.s32Minute,
			(tU8)  rnewValue.s32Second,
			u8ValidityMask
	);
	TRACE_DateTime("vOnClockExtSourceListenerEvent", oMasterTime, _CLASS, __LINE__);

	if (_enSyncMode == VDCLK_EN_SyncMode_Manual ) { //if (_enSyncMode == VDCLK_EN_SyncMode_Manual // || _enSyncMode == VDCLK_EN_SyncMode_GPS )
		ETG_TRACE_USR1(("Ignoring vOnClockExtSourceListenerEvent due to synMode %d", ETG_ENUM(VDCLK_TEN_SyncMode, _enSyncMode)));
		return;
	}

	// check prerequisites
	if (u8ValidityMask == 0)
	{  // update member variables for missing master clock signal
		vEnterCriticalSection("vOnClockExtSourceListenerEvent() u8ValidityMask == 0");

		bNotifyStatus        = (_enClockSourceStatus != VDCLK_EN_CSS_System);
		_enClockSourceStatus = VDCLK_EN_CSS_System;

		vReleaseCriticalSection("vOnClockExtSourceListenerEvent() u8ValidityMask == 0");
	}
	else if (((oMasterTime.u8IsDateTimeValid() & (tU8) VDCLK_EN_TimeValid)) == 0)
	{  // master should provide at least valid time
		ETG_TRACE_COMP(("Master time invalid!"));
	}
	else if (_oSystemTime.u8IsDateTimeValid() != (tU8) VDCLK_EN_AllValid)
	{  // system should provide valid date and time
		ETG_TRACE_COMP(("System time invalid!"));
	}
	else if (oMasterTime.s16GetCenturyBase() != _oSystemTime.s16GetCenturyBase())
	{  // should not happen
		ETG_TRACE_COMP(("Different century bases!"));
	}
	else
	{
		// update member variables
		vEnterCriticalSection("vOnClockExtSourceListenerEvent() else");


#ifdef VARIANT_S_FTR_ENABLE_CLOCK_ENABLE_USA_MEZ_ALGORITHM

		ETG_TRACE_USR3((" enGetDaylightSavingTimeStatus = %d", enGetDaylightSavingTimeStatus()));
		ETG_TRACE_USR3((" _bBapAvailable = %d", _bBapAvailable));
		ETG_TRACE_USR3((" _enRegionCode = %d", _enRegionCode));

		if((enGetDaylightSavingTimeStatus() == VDCLK_EN_DST_Auto) && (_bBapAvailable == TRUE))
		{
			ETG_TRACE_USR3((" _bSummerTimeSET = %d", _bSummerTimeSET));
			ETG_TRACE_USR3((" _bWinterTimeSET = %d", _bWinterTimeSET));

			if(_enRegionCode == VDCLK_EN_CET)
				vHandleDSTAutoMEZ((tU16)rnewValue.s32Year, (tU8)rnewValue.s32Month, (tU8)rnewValue.s32Day,(tU8) rnewValue.s32Hour);
			else if(_enRegionCode == VDCLK_EN_USA)
				vHandleDSTAutoUSA((tU16)rnewValue.s32Year, (tU8)rnewValue.s32Month, (tU8)rnewValue.s32Day,(tU8) rnewValue.s32Hour);
		}
#endif

		if (oMasterTime.u8IsDateTimeValid() == (tU8) VDCLK_EN_TimeValid)
		{
			// do some extra calculations if master provides time only (date missing)
			ETG_TRACE_USR3(("Master time without date"));
			// get the time difference
			vdclk_tclDateTime oTempDate = _oSystemTime;
			tS32 s32Diff = (tS32) (oTempDate.u32GetValue() % 86400L)   // 86400 seconds per day
                        																												- (tS32) (oMasterTime.u32GetValue() % 86400L);
			// adjust date obtained from system time to match master time
			// should be valid for all time zones except GMT+13:00 (Nuku'alofa)
			if (s32Diff >= 43200L)   // 43200 seconds per 12 hours
			{
				oTempDate += 86400LL;
			}
			else if (oTempDate.u32GetValue() < 86400L)
				; // do nothing in this case
			else if (s32Diff < -43200L)
			{
				oTempDate += (-86400LL);
			};
			// add missing date to oMasterTime
			tS16  s16Year;       tU8   u8Month;       tU8   u8Day;
			tU8   u8Hour;        tU8   u8Minute;      tU8   u8Second;
			tU8   u8Weekday;
			oTempDate.u8GetComponents
			(
					&s16Year,      &u8Month,      &u8Day,
					&u8Hour,       &u8Minute,     &u8Second,
					&u8Weekday
			);
			oMasterTime.u8Update
			(
					s16Year,       u8Month,       u8Day,
					u8Hour,        u8Minute,      u8Second,
					(tU8) VDCLK_EN_DateChange
			);
		}

		// update the system time based on the master time received
		vUpdateSystemTime(&oMasterTime);

		// calculate and update dynamic time offset
		tS64 s64NewOffset = (tS64)oMasterTime.u32GetValue() - (tS64)_oSystemTime.u32GetValue();
		tS64 s64Diff = s64NewOffset - _s64DynOffset[VDCLK_EN_DomainMaster];
		if ((s64Diff > 1L) || (s64Diff < -1L))
		{  // 1 second hysteresis to avoid fluttering
			_s64DynOffset[VDCLK_EN_DomainMaster] += s64Diff;
			bNotifyClock = TRUE;
			ETG_TRACE_USR3((" Domain master offset: %d", _s64DynOffset[VDCLK_EN_DomainMaster]));
		}
		else
		{
			ETG_TRACE_USR3(("dyn time offset within tolerance"));
			bNotifyClock = FALSE;
		}

		// write to ffs if more than 1 minute
		bSaveData = ((s64Diff > 60L) || (s64Diff < -60L));

		// deal with missing counter
		VDCLK_TEN_ClockSourceStatus  enPrevStatus = _enClockSourceStatus;
		tU8 u8Mask = (tU8) VDCLK_EN_DateChange | (tU8) VDCLK_EN_HMITimeChange;
		if ((u8ValidityMask & u8Mask) == u8Mask)
		{
			_enClockSourceStatus = VDCLK_EN_CSS_Master;
		}
		else if ((u8ValidityMask & u8Mask) == (tU8) VDCLK_EN_HMITimeChange)
		{
			_enClockSourceStatus = VDCLK_EN_CSS_MasterTimeOnly;
		}
		else if ((u8ValidityMask & u8Mask) == 0)
		{
			_enClockSourceStatus = VDCLK_EN_CSS_System;
		}
		else
		{
			ETG_TRACE_USR3(("invalid validity mask:0x%x", u8ValidityMask));
			_enClockSourceStatus = VDCLK_EN_CSS_System;
		}

		if (enPrevStatus != _enClockSourceStatus)
		{
			bNotifyStatus = TRUE;
		}

		vReleaseCriticalSection("vOnClockExtSourceListenerEvent() else");

		if(bNotifyClock == TRUE)//sending update on valid time change
		{
			vd_clock_tclAppMain::theServer()->vPostMsgclocksourcestatusUpdate("Ivd_clock_tclServiceClockIf");
			vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
			vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
		}
	}

	if (bSaveData)
	{
		vSaveData(TRUE);
	}
	return;
};*/

/************************************************************************
 * FUNCTION:    vOnFormatExtSourceListenerEvent
 *
 * DESCRIPTION:  Callback function for Updater thread to update member
 *               variable _s64DynOffset[VDCLK_EN_DomainMaster]
 *
 * PARAMETER:   VDCLK_TEN_TimeFormat enTimeFormat,
 *              VDCLK_TEN_DateFormat enDateFormat,
 *              tBool bFormatMasterAvailable
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vOnFormatExtSourceListenerEvent (//VDCLK_TEN_TimeFormat enTimeFormat,
		// VDCLK_TEN_DateFormat enDateFormat,
		tU32 u32TimeFormat,
		tU32 u32DateFormat,
		tBool bFormatMasterAvailable)
{
	// store current state
	//  VDCLK_TEN_TimeFormat    enPrevTimeFormat  = _enTimeFormat;
	//VDCLK_TEN_DateFormat    enPrevDateFormat  = _enDateFormat;
	tU32 u32PrevTimeFormat = _u32TimeFormat;
	tU32 u32PrevDateFormat = _u32DateFormat;
	VDCLK_TEN_FormatSourceStatus enPrevStatus = _enFormatSourceStatus;

	vEnterCriticalSection("vOnFormatExtSourceListenerEvent");

	// update member variables
	if (bFormatMasterAvailable)
	{
		// _enTimeFormat = enTimeFormat;
		// _enDateFormat = enDateFormat;
		_u32TimeFormat = u32TimeFormat;
		_u32DateFormat = u32DateFormat;
		_enFormatSourceStatus = VDCLK_EN_FSS_Master;
	}
	else
	{
		_enFormatSourceStatus = VDCLK_EN_FSS_System;
	};
	vReleaseCriticalSection("vOnFormatExtSourceListenerEvent");

	if (bFormatMasterAvailable && (u32PrevTimeFormat != _u32TimeFormat))
	{
		vd_clock_tclAppMain::theServer()->vPostMsgTimeformatUpdate("Ivd_clock_tclServiceClockIf");
	}

	if (bFormatMasterAvailable && (u32PrevDateFormat != _u32DateFormat))
	{
		vd_clock_tclAppMain::theServer()->vPostMsgDateformatUpdate("Ivd_clock_tclServiceClockIf");
	}

	// if master availability has changed
	if (enPrevStatus != _enFormatSourceStatus)
	{
		vd_clock_tclAppMain::theServer()->vPostMsgFormatsourcestatusUpdate("Ivd_clock_tclServiceClockIf");
	}

};

/************************************************************************
 * FUNCTION:    vUpdateClockSourceStatus
 *
 * DESCRIPTION: compares previous state with current state and post a change
 *
 * PARAMETER:   VDCLK_TEN_ClockSourceStatus NewStatus
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vUpdateClockSourceStatus (VDCLK_TEN_ClockSourceStatus NewStatus)
{
	// update member variable
	vEnterCriticalSection("vUpdateClockSourceStatus");

	VDCLK_TEN_ClockSourceStatus enPrevStatus = _enClockSourceStatus;
	_enClockSourceStatus = NewStatus;

	vReleaseCriticalSection("vUpdateClockSourceStatus");


	if (NewStatus != enPrevStatus)
	{
		vd_clock_tclAppMain::theServer()->vPostMsgclocksourcestatusUpdate("Ivd_clock_tclServiceClockIf");
	}

}

// **********************************************************************
// ***	               P r i v a t e   S e c t i o n	          		 ***
// **********************************************************************
/************************************************************************
 * FUNCTION:    vUpdateAutomaticTime
 *
 * DESCRIPTION: updates the automatic time with a given offset
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *************************************************************************/
/*tVoid  vdclk_tclDataContainer::vUpdateAutomaticTime (tVoid)
{
	tS64 s64PrevOffset = _s64DynOffset[VDCLK_EN_Auto];

	vEnterCriticalSection("vUpdateAutomaticTime");
	_s64DynOffset[VDCLK_EN_Auto] = (tS64)vdclk_rTZDetails[_u16TimeZoneIndex].s16TZOffset + (_bDST_ON ? 3600 : 0) + _u64AutoTimezoneOffset;
	ETG_TRACE_USR1(("vSetAutoTimeZoneOffset received after timezone offset: %d", _s64DynOffset[VDCLK_EN_Auto]));
	vReleaseCriticalSection("vUpdateAutomaticTime");
	// TRACE
	vdclk_tclDateTime oLocalDateTime = _oSystemTime;        // use assignment operator
	TRACE_DateTime("vUpdateAutomaticTime", oLocalDateTime, _CLASS, __LINE__);
	oLocalDateTime += _s64DynOffset[VDCLK_EN_Auto];
	TRACE_DateTime("vUpdateAutomaticTime after addition", oLocalDateTime, _CLASS, __LINE__);

	if (s64PrevOffset != _s64DynOffset[VDCLK_EN_Auto])
	{
		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
	}
};*/

/************************************************************************
 * FUNCTION:    vUpdateTZAutomaticTime
 *
 * DESCRIPTION: updates the automatic time with a given offset
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::vUpdateTZAutomaticTime (tVoid)
{
	tS64 s64PrevOffset = _s64DynOffset[VDCLK_EN_TZ];

	vEnterCriticalSection("vUpdateTZAutomaticTime");

	if(_bGetTimeZoneAvailability == TRUE)
	{
		_s64DynOffset[VDCLK_EN_TZ] = (tS64)vdclk_rTZDetails[_u16TimeZoneIndex].s16TZOffset + (_bDST_ON ? 3600 : 0);
	}
	else
	{
		_s64DynOffset[VDCLK_EN_TZ] = (tS64)vdclk_rTZDetails[_u16TimeZoneIndex].s16TZOffset ;
	}

	ETG_TRACE_USR1(("vSetAutoTimeZoneOffset received after timezone offset: %d", _s64DynOffset[VDCLK_EN_TZ]));

	vReleaseCriticalSection("vUpdateTZAutomaticTime");
	// TRACE
	vdclk_tclDateTime oLocalDateTime = _oSystemTime;        // use assignment operator
	TRACE_DateTime("vUpdateTZAutomaticTime", oLocalDateTime, _CLASS, __LINE__);
	oLocalDateTime += _s64DynOffset[VDCLK_EN_TZ];

	if (s64PrevOffset != _s64DynOffset[VDCLK_EN_TZ])
	{
		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
	}
};
tBool vdclk_tclDataContainer::vGetClockMode() const
{
	if((bGetGPS_AutoSync()) && (bGetPositionBased()))
		return TRUE;
	else
		return FALSE;
}

/************************************************************************
 * FUNCTION:    vSetLastKnownDSTSettings
 *
 * DESCRIPTION: sets last known DST settings for quick recovery when clock
 *              is returning in auto mode from different settings
 *
 * PARAMETER:   tU16 u16AutoSetDST
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid vdclk_tclDataContainer::vSetLastKnownDSTSettings(tU16 u16AutoSetDST)
{
	_u16AutoSetDST = u16AutoSetDST;
}



tU16 vdclk_tclDataContainer::u16GetAutoDSTState()
{
	return _u16AutoSetDST;
}


/************************************************************************
 * FUNCTION:    enGetDaylightSavingTimeStatus
 *
 * DESCRIPTION: Get the status of DayLightSavingTime status
 *
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: VDCLK_TEN_DST_Setting
 *  VDCLK_EN_DST_Off           = 0,
   VDCLK_EN_DST_On            = 1,
   VDCLK_EN_DST_Auto          = 2,
   VDCLK_EN_DST_Auto_OFF      = 3,
   VDCLK_EN_DST_None          = 4
 *************************************************************************/
VDCLK_TEN_DST_Setting vdclk_tclDataContainer::enGetDaylightSavingTimeStatus() const
{
	ETG_TRACE_USR3((" _enDaylightSaving = %d", _enDaylightSaving));
	return _enDaylightSaving;
}

/************************************************************************
 * FUNCTION:    s64GetLocalTimeOffset
 *
 * DESCRIPTION: gets the local time offset value
 *
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: S64 offset value
 *************************************************************************/
tS64 vdclk_tclDataContainer::s64GetLocalTimeOffset() const
{
	VDCLK_TEN_DomainOffset enDomain;
	tS64 s64Offset = 0LL;

	tBool _isGPSValid = FALSE ;
	if(_poClientSensor)
	{
		_isGPSValid = _poClientSensor->isGPSDataValid();
	}

	if((_bIsOffsetValid)
			&&((_isGPSValid) || (_poUpdater->_RTCValidOnce)))
	{
		s64Offset =_s64Offs;

	}

	else
	{
		s64Offset = 0;

	}
	ETG_TRACE_USR3((" GetLocalTimeOffset _s64DynOffset=%d", s64Offset));
	//ETG_TRACE_USR3((" Offset Validity = %d", _bIsOffsetValid));
	return s64Offset;
}

/************************************************************************
 * FUNCTION:    enGetRtcTimeState
 *
 * DESCRIPTION: gets the validity flag for the UTC time. It gets the value from RTC.
 *
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: VDCLK_GPSRTCTIMESTATE:invalid=1, eversync=2,valid=3
 *************************************************************************/
VDCLK_TEN_GPSRTCTIMESTATE vdclk_tclDataContainer::enGetRtcTimeState() const
{
	ETG_TRACE_USR3((" _enRTCTimeState = %d", _enRTCTimeState));
	return _enRTCTimeState;
}

/************************************************************************
 * FUNCTION:    vSetLastKnownTZSettings
 *
 * DESCRIPTION: sets last known TZ settings for quick recovery when clock
 *              is returning in auto mode from different settings
 *
 * PARAMETER:   tU16 u16AutoSetTZ
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid vdclk_tclDataContainer::vSetLastKnownTZSettings(tU16 u16AutoSetTZ)
{
	_u16AutoSetTZ = u16AutoSetTZ;
}


tU16 vdclk_tclDataContainer::u16GetAutoTZIndex()
{
	return _u16AutoSetTZ;
}


tVoid vdclk_tclDataContainer::vReadfromDatapool()
{
	ETG_TRACE_USR4(("vReadfromDatapool entered"));

	tS64 s64Offset_Master;
	tS64 s64Offset_Automatic;
	tU16 u16Timezoneindex;
	tBool bGpsAutoSync;
	tBool bAutoEnabled;
	tBool bDST;
	tBool bDSTAutoSet;
	tU8 u8Timeformat;
	tU8 u8Dateformat;
	tU8 u8Syncmode;
	tBool bDefaultSettings;
	tS64 s64Offset_Auto, s64Offset_Manual,s64Offset_TZ,s64AutoTZOffset,s64OffsetHour, s64OffsetMinute;

	_oDpMasterModeOffset.s32GetData(s64Offset_Master);
	_oDpAutoModeOffset.s32GetData(s64Offset_Automatic);
	_oDpTimezoneIndex.s32GetData(u16Timezoneindex);
	_oDpbGPSAutoSync.s32GetData(bGpsAutoSync);
	_oDpAutoEnabled.s32GetData(bAutoEnabled);
	_oDpbDST.s32GetData(bDST);
	_oDpbDSTAutoSet.s32GetData(bDSTAutoSet);
	_oDpTimeformat.s32GetData(u8Timeformat);
	_oDpDateformat.s32GetData(u8Dateformat);
	_oDpSyncmode.s32GetData(u8Syncmode);
	_oDpDefaultsetting.s32GetData(bDefaultSettings);
	_oDpAutoTZOffset.s32GetData(s64AutoTZOffset);
	_oDpMinuteOffset.s32GetData(s64OffsetMinute);
	_oDpHourOffset.s32GetData(s64OffsetHour);
	_oDpTZModeOffset.s32GetData(s64Offset_TZ);
	_oDpManualModeOffset.s32GetData(s64Offset_Manual);
	_oDpAutomaticModeOffset.s32GetData(s64Offset_Auto);



	//_s64DynOffset[VDCLK_EN_DomainMaster]  = s64Offset_Master;
	//_s64DynOffset[VDCLK_EN_DomainAutomatic]  = s64Offset_Automatic;
	_u16TimeZoneIndex = u16Timezoneindex;
	_isPositionBased = bGpsAutoSync;
	_isEnabled = bAutoEnabled;
	_bDST_ON = bDST;
	_bDST_AutoSet = bDSTAutoSet;
	_u32DateFormat = (tU32)u8Dateformat;
	_enSyncMode = (VDCLK_TEN_SyncMode)u8Syncmode;
	_bDefaultSetting = bDefaultSettings;

	_s64DynOffset[VDCLK_EN_Auto] = s64Offset_Auto;
	_s64DynOffset[VDCLK_EN_Manual_Mode] = s64Offset_Manual;
	_s64DynOffset[VDCLK_EN_TZ] = s64Offset_TZ;
	_u64AutoTimezoneOffset = s64AutoTZOffset;
	offset_hour = s64OffsetHour;
	offset_minute = s64OffsetMinute;



	//If either 24 Hour or 12 Hour Index is set in Datapool means User has selected valid value from Datapool
	//Onfirst startup we fill Datapool value as VDCLK_EN_TF_Index_Invalid (4) so this condition becomes false.
	//On first startup we then excute else part and read from KDS
	if((u8Timeformat==VDCLK_EN_TF_Index_Mode24) || (u8Timeformat==VDCLK_EN_TF_Index_Mode12))
	{
		//Now we use the value from Datapool and store User defined Time format
		_oDpTimeformat.s32GetData(u8Timeformat);
		_u32TimeFormat = (tU32)u8Timeformat;
		ETG_TRACE_USR4((": vReadfromDatapool->Get Time format from Datapool(UserSet) =  %d (%s)",u8Timeformat, (u8Timeformat==VDCLK_EN_TF_Index_Mode24)?"24 Hour":"12 Hour"));

	}
	else  // time format is Invalid in Datapool , So we use the default defined in KDS
	{
		dp_tclKdsSystemConfiguration1 _oSystemConfiguration;
		_oSystemConfiguration.u8GetClock1224h(u8Timeformat);
		_u32TimeFormat = (tU32)u8Timeformat;
		ETG_TRACE_USR4((": vReadfromDatapool->Get Time format from KDS(1st Time) = %d (%s)", u8Timeformat, (u8Timeformat==VDCLK_EN_TF_Index_Mode24)?"24 Hour":"12 Hour"));

	}

	//ETG_TRACE_USR4(("  vReadfromDatapool  %d_s64DynOffset[VDCLK_EN_Auto]",_s64DynOffset[VDCLK_EN_Auto]));
	//ETG_TRACE_USR4(("  vReadfromDatapool  %d _s64DynOffset[VDCLK_EN_DomainAutomatic]",_s64DynOffset[VDCLK_EN_DomainAutomatic]));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _u16TimeZoneIndex",_u16TimeZoneIndex));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d GPSAutoSync _isEnabled",_isPositionBased));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d bAutoEnabled _isEnabled",_isEnabled));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _bDST_ON",_bDST_ON));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _bDST_AutoSet",_bDST_AutoSet));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _u32TimeFormat",_u32TimeFormat));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _u32DateFormat",_u32DateFormat));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _enSyncMode",_enSyncMode));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _bDefaultSetting",_bDefaultSetting));


	ETG_TRACE_USR4(("  vReadfromDatapool  %d _s64DynOffset[VDCLK_EN_Auto]",_s64DynOffset[VDCLK_EN_Auto]));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _s64DynOffset[VDCLK_EN_Manual_Mode]",_s64DynOffset[VDCLK_EN_Manual_Mode]));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _s64DynOffset[VDCLK_EN_TZ]",_s64DynOffset[VDCLK_EN_TZ]));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d _u64AutoTimezoneOffset",_u64AutoTimezoneOffset));
	ETG_TRACE_USR4(("  vReadfromDatapool  %d offset_hour",offset_hour));
	ETG_TRACE_USR4(("  vReadfromDatapool  %doffset_minute",offset_minute));
}

tVoid vdclk_tclDataContainer::vStoretoDatapool()
{

	ETG_TRACE_USR4(("vStoretoDatapool entered"));

	//_oDpMasterModeOffset.s32SetData(_s64DynOffset[VDCLK_EN_DomainMaster]);

	_oDpTimezoneIndex.s32SetData(_u16TimeZoneIndex);
	_oDpbGPSAutoSync.s32SetData(_isPositionBased);
	_oDpAutoEnabled.s32SetData(_isEnabled);
	_oDpbDST.s32SetData(_bDST_ON);
	_oDpbDSTAutoSet.s32SetData(_bDST_AutoSet);
	_oDpTimeformat.s32SetData(_u32TimeFormat);
	_oDpDateformat.s32SetData(_u32DateFormat);
	_oDpSyncmode.s32SetData(_enSyncMode);
	_oDpDefaultsetting.s32SetData(_bDefaultSetting);
	_oDpAutoTZOffset.s32SetData(_u64AutoTimezoneOffset);
	_oDpMinuteOffset.s32SetData(offset_minute);
	_oDpHourOffset.s32SetData(offset_hour);
	_oDpTZModeOffset.s32SetData(_s64DynOffset[VDCLK_EN_TZ]);
	_oDpManualModeOffset.s32SetData(_s64DynOffset[VDCLK_EN_Manual_Mode]);
	_oDpAutomaticModeOffset	.s32SetData(_s64DynOffset[VDCLK_EN_Auto]);


	//ETG_TRACE_USR4(("  vStoretoDatapool  %d _s64DynOffset[VDCLK_EN_DomainMaster]",_s64DynOffset[VDCLK_EN_DomainMaster]));
	//	ETG_TRACE_USR4(("  vStoretoDatapool  %d _s64DynOffset[VDCLK_EN_DomainAutomatic]",_s64DynOffset[VDCLK_EN_DomainAutomatic]));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _u16TimeZoneIndex",_u16TimeZoneIndex));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d GPSAutoSync _isEnabled",_isPositionBased));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d bAutoEnabled _isEnabled",_isEnabled));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _bDST_ON",_bDST_ON));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _bDST_AutoSet",_bDST_AutoSet));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _u32TimeFormat",_u32TimeFormat));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _u32DateFormat",_u32DateFormat));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _enSyncMode",_enSyncMode));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _bDefaultSetting",_bDefaultSetting));

	ETG_TRACE_USR4(("  vStoretoDatapool  %d _s64DynOffset[VDCLK_EN_Auto]",_s64DynOffset[VDCLK_EN_Auto]));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _s64DynOffset[VDCLK_EN_Manual_Mode]",_s64DynOffset[VDCLK_EN_Manual_Mode]));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _s64DynOffset[VDCLK_EN_TZ]",_s64DynOffset[VDCLK_EN_TZ]));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _u64AutoTimezoneOffset",_u64AutoTimezoneOffset));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d offset_hour",offset_hour));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d offset_minute",offset_minute));

}


/************************************************************************
 * FUNCTION:    open
 *
 * DESCRIPTION: opens the kds file which contains data
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid vdclk_tclDataContainer::open( tVoid )
{
	ETG_TRACE_USR4(("Open KDS"));

	for( tU16 i=0; i<KDS_C_U16_MAX_RETRIES; i++ )
	{
		mDrvHandle = OSAL_IOOpen( OSAL_C_STRING_DEVICE_KDS, OSAL_EN_READONLY );
		if( mDrvHandle != OSAL_ERROR )
		{
			mIsOpen = TRUE;
			ETG_TRACE_USR4(("KDS succesfully opened"));
			break;
		}
		ETG_TRACE_USR4(("Tried to open %d from %d times",i,KDS_C_U16_MAX_RETRIES));
	}
}

/************************************************************************
 * FUNCTION:    close
 *
 * DESCRIPTION: closes the kds file which contains data
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid vdclk_tclDataContainer::close( tVoid )
{
	if( mIsOpen )
	{
		(tVoid)OSAL_s32IOClose( mDrvHandle );
		mIsOpen = FALSE;
	}
}


tU8 vdclk_tclDataContainer::ReadKDS()
{
	ETG_TRACE_USR4(("reading KDS..."));
	tU8 u8Regioncode = 0;
	tsKDSEntry           mEntryData;
	// if not open, open KDS
	if( !mIsOpen )
	{
		open();
	}

	// Read KDS
	if( mIsOpen )
	{
		// Read Data from KDS
		mEntryData.u16Entry        = VEHICLE_CONFIG_ENTRY_KEY;
		mEntryData.u16EntryLength  = KDS_MAX_ENTRY_LENGTH;          // KDS_MAX_ENTRY_LENGTH
		mEntryData.u16EntryFlags   = M_KDS_ENTRY_FLAG_NONE;   // M_KDS_ENTRY_FLAG_WRITE_PROTECTED
		mEntryData.au8EntryData[0] = 0;

		if( OSAL_ERROR != OSAL_s32IORead( mDrvHandle, (tPS8)&mEntryData, (sizeof(mEntryData)) ) )
		{
			ETG_TRACE_USR4(("Reading KDS"));
			//get SingleKDS value
			u8Regioncode = mEntryData.au8EntryData[0] & 0x1F;
		}
		else
		{
			ETG_TRACE_ERR(("Couldn't read KDS"));
		}
	}

	close();

	return u8Regioncode;
}

tVoid vdclk_tclDataContainer::vStoreOSSystemTime()
{

	tS64 s64Diff = _oSystemTime.u32GetValue() - _u32PrevSystemTimeOffset;

	_u32PrevSystemTimeOffset = _oSystemTime.u32GetValue();

	if (!((s64Diff > 2) || (s64Diff < -2)))
	{
		//ETG_TRACE_USR3((" No Change in System Time. Not required to Log"));
		return;
	}

	//ETG_TRACE_USR3((" vStoreOSSystemTime Changed Excecuting"));


	tS16  s16Year;       tU8   u8Month;       tU8   u8Day;
	tU8   u8Hour;        tU8   u8Minute;      tU8   u8Second;
	tU8   u8Weekday;

	_oSystemTime.u8GetComponents
	(
			&s16Year,      &u8Month,      &u8Day,
			&u8Hour,       &u8Minute,     &u8Second,
			&u8Weekday
	);

	OSAL_trTimeDate tTempTimeDate;

	tTempTimeDate.s32Year = (tS32)s16Year - 1900;
	tTempTimeDate.s32Month = (tS32)u8Month;
	tTempTimeDate.s32Day = (tS32)u8Day;
	tTempTimeDate.s32Hour = (tS32)u8Hour;
	tTempTimeDate.s32Minute = (tS32)u8Minute;
	tTempTimeDate.s32Second = (tS32)u8Second;
	tTempTimeDate.s32Weekday = (tS32)u8Weekday;
	tTempTimeDate.s32Daylightsaving = OSAL_NULL;
	tTempTimeDate.s32Yearday = OSAL_NULL;


	if(OSAL_s32ClockSetTime(&tTempTimeDate) != OSAL_OK)
	{
		ETG_TRACE_USR3(("ERROR occurred while Linux set time "));
		TRACE_DateTime("vStoreOSSystemTime", _oSystemTime, _CLASS, __LINE__);
	}

	//TRACE_DateTime("vStoreOSSystemTime", _oSystemTime, _CLASS, __LINE__);
	//TRACE_OSALDateTime("vStoreOSSystemTime", tTempTimeDate, _CLASS, __LINE__ );
	ETG_TRACE_USR3(("Mod_Clock: vStoreOSSystemTime: (YY:MM:DD:HH:MM:SS) %d:%d:%d:%d:%d:%d:%d",
			tTempTimeDate.s32Year,
			tTempTimeDate.s32Month,
			tTempTimeDate.s32Day,
			tTempTimeDate.s32Hour,
			tTempTimeDate.s32Minute,
			tTempTimeDate.s32Second,
			tTempTimeDate.s32Weekday ));
}

tVoid vdclk_tclDataContainer::vStoreDefaultSystemTime()
{

	ETG_TRACE_USR3((" vStoreDefaultSystemTime Called "));
	tS16  s16Year;       tU8   u8Month;       tU8   u8Day;
	tU8   u8Hour;        tU8   u8Minute;      tU8   u8Second;
	tU8   u8Weekday;

	_oSystemTime.u8GetComponents
	(
			&s16Year,      &u8Month,      &u8Day,
			&u8Hour,       &u8Minute,     &u8Second,
			&u8Weekday
	);

	OSAL_trTimeDate tTempTimeDate;

	tTempTimeDate.s32Year = (tS32)s16Year - 1900;
	tTempTimeDate.s32Month = (tS32)u8Month;
	tTempTimeDate.s32Day = (tS32)u8Day;
	tTempTimeDate.s32Hour = (tS32)u8Hour;
	tTempTimeDate.s32Minute = (tS32)u8Minute;
	tTempTimeDate.s32Second = (tS32)u8Second;
	tTempTimeDate.s32Weekday = (tS32)u8Weekday;
	tTempTimeDate.s32Daylightsaving = OSAL_NULL;
	tTempTimeDate.s32Yearday = OSAL_NULL;


	if(OSAL_s32ClockSetTime(&tTempTimeDate) != OSAL_OK)
	{
		ETG_TRACE_USR3(("ERROR occurred while Linux set time "));
		TRACE_DateTime("vStoreDefaultSystemTime", _oSystemTime, _CLASS, __LINE__);
	}

	TRACE_OSALDateTime("vStoreDefaultSystemTime", tTempTimeDate, _CLASS, __LINE__ );
}



tVoid vdclk_tclDataContainer::vStoreLocalTime()
{

	vdclk_tclDateTime          oLocalDateTime;
	vGetLocalDateTime (&oLocalDateTime);
	tS64 s64Diff = oLocalDateTime.u32GetValue() - _u32PrevSystemTimeOffset;

	_u32PrevSystemTimeOffset = oLocalDateTime.u32GetValue();

	if (!((s64Diff > 2) || (s64Diff < -2)))
	{
		ETG_TRACE_USR3((" No Change in System Time. Not required to Log"));
		return;
	}


	tS16  s16Year;       tU8   u8Month;       tU8   u8Day;
	tU8   u8Hour;        tU8   u8Minute;      tU8   u8Second;
	tU8   u8Weekday;

	oLocalDateTime.u8GetComponents
	(
			&s16Year,      &u8Month,      &u8Day,
			&u8Hour,       &u8Minute,     &u8Second,
			&u8Weekday
	);

	OSAL_trTimeDate tTempTimeDate;

	tTempTimeDate.s32Year = (tS32)s16Year - 1900;
	tTempTimeDate.s32Month = (tS32)u8Month;
	tTempTimeDate.s32Day = (tS32)u8Day;
	tTempTimeDate.s32Hour = (tS32)u8Hour;
	tTempTimeDate.s32Minute = (tS32)u8Minute;
	tTempTimeDate.s32Second = (tS32)u8Second;
	tTempTimeDate.s32Weekday = (tS32)u8Weekday;
	tTempTimeDate.s32Daylightsaving = OSAL_NULL;
	tTempTimeDate.s32Yearday = OSAL_NULL;


	if(OSAL_s32ClockSetTime(&tTempTimeDate) != OSAL_OK)
	{
		ETG_TRACE_USR3(("ERROR occurred while Linux set time "));
		TRACE_DateTime("vStoreLocalTime", oLocalDateTime, _CLASS, __LINE__);
	}

	TRACE_OSALDateTime("vStoreLocalTime", tTempTimeDate, _CLASS, __LINE__ );
}


tVoid vdclk_tclDataContainer::vUpdateSystemTime(vdclk_tclDateTime const * const poMasterDateTime)
{

	//TRACE_DateTime("MasterDateTime", (*poMasterDateTime), _CLASS, __LINE__);

	tS64 s64MasterOffset = (tS64)vdclk_rTZDetails[_u16TimeZoneIndex].s16TZOffset;


	if(_enDaylightSaving == VDCLK_EN_DST_Auto)
	{
		if(_bSummerTimeSET)
		{
			s64MasterOffset = s64MasterOffset + 3600;
		}
		else if (_bWinterTimeSET)
		{
			s64MasterOffset = s64MasterOffset - 3600;
		}
	}else if(_bDST_ON)
	{
		s64MasterOffset = s64MasterOffset + 3600;
	}

	ETG_TRACE_USR3(("Timezone offset:%d", vdclk_rTZDetails[_u16TimeZoneIndex].s16TZOffset));

	ETG_TRACE_USR3(("s64MasterOffset:%d", s64MasterOffset));

	tS64 s64TempValue = (tS64)poMasterDateTime->u32GetValue() - s64MasterOffset;


	_oSystemTime.u8SetValue((tU32)s64TempValue);

	TRACE_DateTime("vUpdateSystemTime", _oSystemTime, _CLASS, __LINE__);

}

tVoid vdclk_tclDataContainer::vSetGPSTime(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minute, tU8 u8Second)
{
	        	_oSystemTime.u8Update(s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, (tU8)VDCLK_EN_AllChange);
		        TRACE_DateTime("SetGPSTime", _oSystemTime, _CLASS, __LINE__);
	
}
tVoid vdclk_tclDataContainer::vSetCANTime(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minute, tU8 u8Second)
{
    ETG_TRACE_USR4(("eNTERING vSetCANTime")); 
    ETG_TRACE_USR4(("Recieved bGetPositionBased Value %d",bGetPositionBased()));
    ETG_TRACE_USR4(("Recieved Sync Mode Value %d",(bIsGpsSync(_enSyncMode))));
    ETG_TRACE_USR4(("Recieved  Actual Sync Mode Value %d",_enSyncMode));


      if(_VariantType == 0x02) //DA Variant
	{
	 
	  if((bIsGpsSync(_enSyncMode) == 1))
	    {
	       _isPositionBased=1; //Manual configuration to AUTO mode for DA variant 
	      ETG_TRACE_USR4(("Recieved vSetCANTime for DA Variant"));
               if((VDCLK_EN_RTCTIMESTATE_INVALID == enGetRtcTimeState()) && (FALSE == _poClientSensor->isGPSDataValid()))
                 {
	           _oSystemTime.u8Update(s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, (tU8)VDCLK_EN_AllChange);
	           TRACE_DateTime("SetGPSTime", _oSystemTime, _CLASS, __LINE__);
	         }   
              vdclk_tclDateTime          oLocalDateTime;
              oLocalDateTime.u8Update(s16Year,u8Month,u8Day,u8Hour,u8Minute,u8Second,(tU8)VDCLK_EN_AllChange );
              vSetCANLocalDateTime (&oLocalDateTime);
	
	    }
	}

    else
    {
         //NAVI Variant
	if((bGetPositionBased()== 1) && (bIsGpsSync(_enSyncMode) == 1))
	{
	   ETG_TRACE_USR4(("Recieved vSetCANTime for Navi Variant"));
          if((VDCLK_EN_RTCTIMESTATE_INVALID == enGetRtcTimeState()) && (FALSE == _poClientSensor->isGPSDataValid()))
            {
               _oSystemTime.u8Update(s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, (tU8)VDCLK_EN_AllChange);
               TRACE_DateTime("SetGPSTime", _oSystemTime, _CLASS, __LINE__);
	       
            }
            vdclk_tclDateTime          oLocalDateTime;
            oLocalDateTime.u8Update(s16Year,u8Month,u8Day,u8Hour,u8Minute,u8Second,(tU8)VDCLK_EN_AllChange );
            vSetCANLocalDateTime (&oLocalDateTime);
	}
    }
}

tVoid vdclk_tclDataContainer::SetCANTimeAvailabity(tBool status)
{
	ETG_TRACE_USR4(("Recieved CANTimeAvailablity status %d",status));
	_cantimeavailable = status;
}

tVoid vdclk_tclDataContainer::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
	(tVoid)pMsg; //to make lint happy
}

tVoid vdclk_tclDataContainer::vStartCommunication()
{
	vLoadData();
	_poMyCSMInterface = new CSMInterface();
	VD_CLOCK_NULL_POINTER_CHECK(_poMyCSMInterface);
}

tVoid vdclk_tclDataContainer::vGetReferences()
{
	_poServiceHandler = dynamic_cast<vd_clock_tclServiceClockIf*>(_cpoMain->getHandler("Ivd_clock_tclServiceClockIf"));
	VD_CLOCK_NULL_POINTER_CHECK(_poServiceHandler);

	_poClientSensor = dynamic_cast<vd_clock_tclClientSensorIf*>(_cpoMain->getHandler("Ivd_clock_tclClientSensorIf"));

	VD_CLOCK_NULL_POINTER_CHECK(_poClientSensor);


	_poINCAdapter = dynamic_cast<vd_clock_INCAdapter*>(_cpoMain->getHandler("vd_clock_INCAdapter"));
	VD_CLOCK_NULL_POINTER_CHECK(_poINCAdapter);

	_poUpdater = dynamic_cast<vdclk_tclUpdater*>(_cpoMain->getHandler("vdclk_tclUpdater"));
	VD_CLOCK_NULL_POINTER_CHECK(_poUpdater);
}

tVoid vdclk_tclDataContainer::vTraceInfo()
{

}

tVoid vdclk_tclDataContainer::vHandleTraceMessage(const tUChar* puchData)
{
	(tVoid)puchData;
}
tVoid  vdclk_tclDataContainer::vSetRegionTimeZone (VDCLK_TEN_TIMEZONE_Setting const enTIMEZONE_Setting)
{
	vEnterCriticalSection("vSetRegionTimeZone");
	_u16TimeZoneIndex = (enTIMEZONE_Setting > 0 ? enTIMEZONE_Setting : vdclk_u16DefaultTimeZoneIndex);
	ETG_TRACE_USR1(("vSetRegionTimeZone received: %d", enTIMEZONE_Setting));
	vReleaseCriticalSection("vSetRegionTimeZone");
	vUpdateTZAutomaticTime();
	OSAL_tEventMask u32NotifyEvents = 0UL;
	u32NotifyEvents = cu32EventMaskPropertyNotify8410 | cu32EventMaskPropertyNotify8200;
	vd_clock_tclAppMain::theServer()->vPostMsgTimezoneUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
	return;
};
tVoid vdclk_tclDataContainer::vSetAutoTimeZoneOffset (tS64  soffset_hour,tS64 soffset_minute)
{
	vSetAutoTimeZoneOffsetGeneric(soffset_hour,soffset_minute);

	vd_clock_tclAppMain::theServer()->vPostMsgAutoTimeZoneOffsetUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
	return;
}

tVoid vdclk_tclDataContainer::vSetAutoTimeZoneOffsetGeneric (tS64  soffset_hour,tS64 soffset_minute)
{
	vEnterCriticalSection("vSetAutoTimeZoneOffset");
	_u64AutoTimezoneOffset = soffset_minute * cu32SecondsPerMinute
			+ soffset_hour   * cu32SecondsPerHour;
	ETG_TRACE_USR1(("vSetAutoTimeZoneOffset received: %d", _u64AutoTimezoneOffset));
	vReleaseCriticalSection("vSetAutoTimeZoneOffset");
	offset_minute = soffset_minute;
	offset_hour =soffset_hour;
	ReceiveChangeStatus(soffset_hour,soffset_minute);

	return;
}
/*tVoid vdclk_tclDataContainer::defaultValue()
{
	_oSystemTime.u8Update(2017, 1, 1, 1, 0, 0, (tU8)VDCLK_EN_AllChange);

}*/

tVoid vdclk_tclDataContainer::vFactoryReset()
{
	//_oSystemTime.u8Update(2017, 1, 1, 1, 0, 0, (tU8)VDCLK_EN_AllChange);

	defaultDynamicOffset();
	tU8 _GNSS = getGPSType();
	if((_VariantType == 0x01) && (_GNSS == 0x01)) // both GNSS and variant type mounted for Nissan
	{
		_u16TimeZoneIndex = 0;

		if ( _poUpdater!= NULL )
		{
			if((_poUpdater->_RTCValidOnce) == FALSE)
			{
				_oSystemTime.u8Update(2017, 11, 1, 1, 0, 0, (tU8)VDCLK_EN_AllChange);
			}
		}

		getRegionBasedSupportedTimeZone(u8Region); // reset timezone index
		vSetAutoTimeZoneOffset(0,0); //clearing the offset hour and offset minute
		vTimeFormatReset();
		vSetGPS_AutoSync(1,1); // setting the default mode as Auto


	}
	else
	{		
		_oSystemTime.u8Update(2017, 11, 1, 1, 0, 0, (tU8)VDCLK_EN_AllChange);
		vTimeFormatReset();
		vSetGPS_AutoSync(1,0); // setting the default value as Manual in DA variant
		getRegionBasedSupportedTimeZone(u8Region); //resetting timezone index for DA Variant required for SMART

	}
	getRegionBasedSupportedDateFormat(u8Region); // rest date format
}

tVoid vdclk_tclDataContainer::vTimeFormatReset()
{
	tU8 u8Timeformat = 0;
	//KDS Variable and Get New Time format from KDS
	dp_tclKdsSystemConfiguration1 _oSystemConfiguration;
	_oSystemConfiguration.u8GetClock1224h(u8Timeformat);
	//Decide Enumeration time format to be sent to HMI for immediate updating of time format
	VDCLK_TEN_TimeFormat eTimeFormatHmi = (u8Timeformat==0)?VDCLK_EN_TF_Mode24:VDCLK_EN_TF_Mode12;
	//Call The method to update time format on HMI
	vSetTimeFormat(eTimeFormatHmi);
	//Store new KDS time format value in member variable
	_u32TimeFormat = (tU32)u8Timeformat;
	//Set the DataPool with KDS value received
	_oDpTimeformat.s32SetData(_u32TimeFormat);
	ETG_TRACE_USR4(("vTimeFormatReset _oDpTimeformat.s32SetData(_u32TimeFormat = %d): ", _u32TimeFormat));
}


tVoid vdclk_tclDataContainer::defaultDynamicOffset()
{
	/*for (tU8 u8 = (tU8) VDCLK_EN_TZ; u8 <= (tU8) VDCLK_EN_Auto; u8++)
	{
		_s64DynOffset[u8] = 0LL;
	}*/
	_s64DynOffset[VDCLK_EN_TZ] = 0LL;
	_s64DynOffset[VDCLK_EN_Manual_Mode] = 0LL;
	//Not required to clear the auto offset as it will received from the sensor.
	//_s64DynOffset[VDCLK_EN_Auto] = 0LL;

}
/*tVoid vdclk_tclDataContainer::defaultValueforGPS()
{
	ETG_TRACE_USR4(("Set the default value to 2016 incase of no GPS signal"));
	_oSystemTime.u8Update(2017, 1, 1, 1, 0, 0, (tU8)VDCLK_EN_AllChange);

}*/

/*tVoid vdclk_tclDataContainer::vFactoryResetValue()
{
	_oSystemTime.u8Update(2017, 1, 1, 1, 0, 0, (tU8)VDCLK_EN_AllChange);

}*/

tU16 vdclk_tclDataContainer::u16GetAutoTimezoneOffset()
{
	return _u64AutoTimezoneOffset;
}

/***********************************************************************//**
 *  GPS  Type Read Form KDS.
 ***************************************************************************/
unsigned char vdclk_tclDataContainer:: getGPSType()
{
	unsigned char GPSType = 0xFF;
	dp_tclKdsCMVariantCoding _oVariantCoding;

	_oVariantCoding.u8GetGNSS(GPSType);

	ETG_TRACE_USR4(("GPSType:%d ", GPSType));

	return GPSType;
}
/*****************************************************/
/*tVoid vdclk_tclDataContainer::vStoretoDP()
{

	ETG_TRACE_USR4(("vStoretoDatapool after manual clock set entered"));

	_oDpMasterModeOffset.s32SetData(_s64DynOffset[VDCLK_EN_DomainMaster]);
	_oDpAutoModeOffset.s32SetData(_s64DynOffset[VDCLK_EN_DomainAutomatic]);

	ETG_TRACE_USR4(("  vStoretoDatapool  %d _s64DynOffset[VDCLK_EN_DomainMaster]",_s64DynOffset[VDCLK_EN_DomainMaster]));
	ETG_TRACE_USR4(("  vStoretoDatapool  %d _s64DynOffset[VDCLK_EN_DomainAutomatic]",_s64DynOffset[VDCLK_EN_DomainAutomatic]));

}*/
tVoid vdclk_tclDataContainer::ReceiveChangeStatus(tS64 sOffset_Hour, tS64 sOffset_Minute)
{
	ETG_TRACE_USR4(("Offset Hour:%d Minute:%d ", sOffset_Hour, sOffset_Minute));
	if(sOffset_Hour >= 0)
	{
		hour_sign = 0x02;
	}
	else
	{
		hour_sign = 0x01;
	}

	if(sOffset_Minute >= 0)
	{
		min_sign = 0x02;
	}
	else
	{
		min_sign = 0x01;
	}
	ETG_TRACE_USR4(("Offset Sign hour_sign:%d min_sign:%d ", hour_sign, min_sign));
}

tVoid vdclk_tclDataContainer::SendMCANSettings_Status(tU8 invalid)
{
	ETG_TRACE_USR4(("Sending status to MCAN to INC"));

	/*_isEnabled = bGetGPS_AutoSync();
	_isPositionBased = bGetPositionBased();*/

	ReceiveMCANClockModeStatus();
	ReceiveMCANClockStatus();
	ReceiveMCANOffsetHourStatus();
	ReceiveMCANOffsetMinuteStatus();
	ReceiveMCANTimezoneStatus();
	ReceiveMCANDSTStatus();

	tU8 u8INC_msg_buff[MAX_MSG_SIZE_MCAN_STATUS]= {0};
	u8INC_msg_buff[0] = 0x38; // msg idll
	u8INC_msg_buff[1] = invalid; // Invalid Parameter

	u8INC_msg_buff[2] = 0x44; // available operable and display type is timeformat
	u8INC_msg_buff[3] = ReceiveMCANTimeformatStatus();

	u8INC_msg_buff[4] = ClockMode_Disp;
	u8INC_msg_buff[5] = ClockInfo_Mode;

	u8INC_msg_buff[6] = ClockInfo_Disp;
	u8INC_msg_buff[7] = ClockInfo_Clock;
	u8INC_msg_buff[8] = ClockINfo_Hr;
	u8INC_msg_buff[9] = ClockInfo_Min;

	u8INC_msg_buff[10] = OffsetHr_Sign;
	u8INC_msg_buff[11] = OffsetHr_Val;

	u8INC_msg_buff[12] = OffsetMin_Sign;
	u8INC_msg_buff[13] = OffsetMin_Val;

	u8INC_msg_buff[14] = ClockDST_State;
	u8INC_msg_buff[15] = ClockDST_Value;

	u8INC_msg_buff[16] = ClockInfo_TZState;
	u8INC_msg_buff[17] =ClockInfo_TZVal;

	tU8 count = 0;
	if(_VariantType == 0x01) // non DA variant
	{
		for(count = 18; count < 48; count++)
		{
			switch(u8regioncode)
			{
			case NAM_REGION:
			{
				u8INC_msg_buff[18] = 0x51;
				u8INC_msg_buff[19] = 0x48;
				if(count >= 20)
				{
					u8INC_msg_buff[count] = 0x00;
				}

			}
			break;
			case EUR_RUS_GOM_REGION:
			{
				if(count < 26)
				{
					u8INC_msg_buff[count] = 0xFF;

				}
				else if(count == 26)
				{
					u8INC_msg_buff[count] = 0xFC;
				}
				else
				{
					u8INC_msg_buff[count] = 0x00;
				}

			}
			break;
			case AZR_REGION:
			{
				if(count < 26)
				{
					u8INC_msg_buff[count] = 0x00;
					u8INC_msg_buff[26] = 0x03;
					u8INC_msg_buff[27] = 0xE0;
				}
				else if(count >= 28)
				{
					u8INC_msg_buff[count] = 0x00;
				}
			}
			break;
			case GCC_REGION:
			{
				if(count < 27)
				{
					u8INC_msg_buff[count] = 0x00;
					u8INC_msg_buff[27] = 0x1F;
					u8INC_msg_buff[28] = 0xE0;

				}
				else
				{
					u8INC_msg_buff[count] = 0x00;
				}
			}
			break;
			default:

			{
				u8INC_msg_buff[18] = 0x51;
				u8INC_msg_buff[19] = 0x48;
				if(count >= 20)
				{
					u8INC_msg_buff[count] = 0x00;
				}
			}
			break;

			}
		}
	}
	else
	{
		for(count = 18; count < 48; count++)
		{
			u8INC_msg_buff[count] = 0x00;
		}

	}

	tU8 u8DataLength = sizeof(u8INC_msg_buff);
	if(_poINCAdapter != NULL)
	{
		ETG_TRACE_USR4(("SendMCANSettings_Status: INC Send Message for status"));
		_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8DataLength);
		invalid = 0;
	}
	else
	{
		ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
	}
}
tVoid vdclk_tclDataContainer::SendMCANNotification()
{
	ETG_TRACE_USR4(("Sending notification to MCAN to INC"));

	/*_isEnabled = bGetGPS_AutoSync();
	_isPositionBased = bGetPositionBased();*/

	ReceiveMCANClockModeStatus();
	ReceiveMCANClockStatus();
	ReceiveMCANOffsetHourStatus();
	ReceiveMCANOffsetMinuteStatus();
	ReceiveMCANTimezoneStatus();
	ReceiveMCANDSTStatus();

	tU8 u8INC_msg_buff[MAX_MSG_SIZE_MCAN_INDICATION]= {0};
	u8INC_msg_buff[0] = 0x3E; // msg id

	u8INC_msg_buff[1] = 0x44; // standard for all time formats
	u8INC_msg_buff[2] = ReceiveMCANTimeformatStatus();

	u8INC_msg_buff[3] = ClockMode_Disp;
	u8INC_msg_buff[4] = ClockInfo_Mode;

	u8INC_msg_buff[5] = ClockInfo_Disp;
	u8INC_msg_buff[6] = ClockInfo_Clock;
	u8INC_msg_buff[7] = ClockINfo_Hr;
	u8INC_msg_buff[8] = ClockInfo_Min;

	u8INC_msg_buff[9] = OffsetHr_Sign;
	u8INC_msg_buff[10] = OffsetHr_Val;

	u8INC_msg_buff[11] = OffsetMin_Sign;
	u8INC_msg_buff[12] = OffsetMin_Val;

	u8INC_msg_buff[13] = ClockDST_State;
	u8INC_msg_buff[14] = ClockDST_Value;

	u8INC_msg_buff[15] = ClockInfo_TZState;
	u8INC_msg_buff[16] =ClockInfo_TZVal;

	tU8 count = 0x00;
	if(_VariantType == 0x01) // non DA variant
	{
		for(count = 17; count < 48; count++)
		{
			switch(u8regioncode)
			{
			case NAM_REGION:
			{
				u8INC_msg_buff[17] = 0x51;
				u8INC_msg_buff[18] = 0x48;
				if(count >= 19)
				{
					u8INC_msg_buff[count] = 0x00;
				}

			}
			break;
			case EUR_RUS_GOM_REGION:
			{
				if(count < 25)
				{
					u8INC_msg_buff[count] = 0xFF;

				}
				else if(count == 25)
				{
					u8INC_msg_buff[count] = 0xFC;
				}
				else
				{
					u8INC_msg_buff[count] = 0x00;
				}

			}
			break;
			case AZR_REGION:
			{
				if(count < 25)
				{
					u8INC_msg_buff[count] = 0x00;
					u8INC_msg_buff[25] = 0x03;
					u8INC_msg_buff[26] = 0xE0;
				}
				else if(count >= 27)
				{
					u8INC_msg_buff[count] = 0x00;
				}
			}
			break;
			case GCC_REGION:
			{
				if(count < 26)
				{
					u8INC_msg_buff[count] = 0x00;
					u8INC_msg_buff[26] = 0x1F;
					u8INC_msg_buff[27] = 0xE0;

				}
				else
				{
					u8INC_msg_buff[count] = 0x00;
				}
			}
			break;
			default:

			{
				u8INC_msg_buff[17] = 0x51;
				u8INC_msg_buff[18] = 0x48;
				if(count >= 19)
				{
					u8INC_msg_buff[count] = 0x00;
				}
			}
			break;

			}
		}
	}
	else
	{
		for(count = 17; count < 48; count++)
		{
			u8INC_msg_buff[count] = 0x00;
		}
	}


	tU8 u8DataLength = sizeof(u8INC_msg_buff);
	if(_poINCAdapter != NULL)
	{
		ETG_TRACE_USR4(("SendMCANSettings_Status: INC Send Message for status"));
		_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8DataLength);
	}
	else
	{
		ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
	}
}
tU8 vdclk_tclDataContainer::ReceiveMCANTimeformatStatus()
{
	tU8 _TimeFormat = 0;
	ETG_TRACE_USR4(("vdclk_tclDataContainer Timeformat Status"));

	VDCLK_TEN_TimeFormat enTimeFormat =enGetTimeFormat();
	if(enTimeFormat == 2)
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer Timeformat is 24hrs"));
		_TimeFormat = 0x08;
	}
	else if(enTimeFormat ==1)
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer Timeformat is 12hrs"));
		_TimeFormat = 0x04;
	}
	else
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer is same as previous"));
		_TimeFormat = 0x00;
	}
	return _TimeFormat;
}
tVoid vdclk_tclDataContainer::ReceiveMCANClockModeStatus()
{

	ETG_TRACE_USR4(("vdclk_tclDataContainer ReceiveMCANClockModeStatus"));

	if(_VariantType == 0x01) // NAVI Variant
	{
		switch(u8Region)
		{

		/* Regions which doesnt support timezone mode */
		case Region_PRC:
		case Region_TWN:
		case Region_HKG:
		case Region_EGP:
		case Region_BRA:
		case Region_AGT:
		case Region_OTHER_LAC:
		case Region_SAF:
		case Region_THI:
		case Region_SGP:
		case Region_MLY:
		case Region_BRN:
		case Region_INN:
		case Region_VNM:
		case Region_PHL:
		case Region_IND:
		case Region_JPN:
		case Region_KOR:
		{
			if((_isEnabled ==1) && (_isPositionBased == 1)) //Auto Mode =on, manual = off, timezone=unavailable
			{
				ClockMode_Disp = 70;
				ClockInfo_Mode = 64;
			}
			else if((_isEnabled == 0) && (_isPositionBased == 0)) //Auto Mode =off, manual = on, timezone=unavailable
			{

				ClockMode_Disp = 69;
				ClockInfo_Mode =  128;
			}
			else if ((_isEnabled == 1) && (_isPositionBased == 0))//Auto Mode =off, manual = off, timezone=unavailable
			{
				ClockMode_Disp = 69;
				ClockInfo_Mode =  64;
			}   //Timezone unavailable
		}
		break;
		case Region_USA:
		case Region_CAN:
		case Region_MEX:
		case Region_OTHER_EUR:
		case Region_RUS:
		case Region_OTHER_GOM:
		case Region_GCC:
		case Region_ASNZ:
		{
			if((_isEnabled ==1) && (_isPositionBased == 1)) //Auto Mode on, rest off
			{
				ClockMode_Disp = 70;
				ClockInfo_Mode = 80;
			}
			else if((_isEnabled == 0) && (_isPositionBased == 0)) //Manual on, rest off

			{

				ClockMode_Disp = 69;
				ClockInfo_Mode =  144;
			}
			else if ((_isEnabled == 1) && (_isPositionBased == 0))//Timezone on, rest off

			{
				ClockMode_Disp = 69;
				ClockInfo_Mode =  96;
			}
		}
		}
	}

	else //DA Variant
	{
		ClockMode_Disp = 0;
		ClockInfo_Mode =  0;
	}



	/*if((_isEnabled ==1) && (_isPositionBased == 1)) //Auto Mode
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer Clock Mode : Auto"));
		if(_VariantType == 0x01) // NAVI Variant
		{
			ClockMode_Disp = 70;
			ClockInfo_Mode = 80;
		}
		else
		{
			ClockMode_Disp = 0;
			ClockInfo_Mode = 0;
		}

	}
	else if((_isEnabled == 0) && (_isPositionBased == 0)) //Manual
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer Clock Mode : Manual"));

		if(_VariantType == 0x01) // NAVI Variant
		{
			ClockMode_Disp = 69;
			ClockInfo_Mode =  144;
		}
		else
		{
			ClockMode_Disp = 0;
			ClockInfo_Mode =  0;

		}

	}
	else if((_isEnabled == 1) && (_isPositionBased == 0))//Timezone
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer Clock Mode : Timezone"));
		if(_VariantType == 0x01) // NAVI Variant
		{
			ClockMode_Disp = 69;
			ClockInfo_Mode =  96;
		}
		else
		{
			ClockMode_Disp = 0;
			ClockInfo_Mode =  0;

		}
	}*/
	return ;
}
tVoid vdclk_tclDataContainer::ReceiveMCANOffsetHourStatus()
{
	tU8 _poOffsetHour = 0;
	ETG_TRACE_USR4(("vdclk_tclDataContainer ReceiveMCANOffsetHourStatus: %d", offset_hour));

	if((_VariantType == 0x01))// non DA variant
	{
		tU8 _u8OffsetHour = 0;
		if(hour_sign == 0x01) //Negative sign so convert to signed
		{
			_u8OffsetHour = -offset_hour;
		}
		else if(hour_sign == 0x02)
		{
			_u8OffsetHour = offset_hour;
		}

		if(((_isEnabled ==1) && (_isPositionBased == 1)) || ((_isEnabled ==1) && (_isPositionBased == 0))) //mode: Tz or Auto
		{
			OffsetHr_Sign = ((64) | ((hour_sign & 3) << 4)) | ((_u8OffsetHour & (60)) >> 2);
		}
		else
		{
			OffsetHr_Sign = ((128) | ((hour_sign & 3) << 4)) | ((_u8OffsetHour & (60)) >> 2); //mode :manual
		}

		OffsetHr_Val = ((_u8OffsetHour & 3) << 6);
	}
	else if (_VariantType == 0x02)
	{
		OffsetHr_Sign = 0x10;
		OffsetHr_Val = 0x0;
	}
	return;

}
tVoid vdclk_tclDataContainer ::ReceiveMCANOffsetMinuteStatus()
{
	ETG_TRACE_USR4(("vdclk_tclDataContainer ReceiveMCANOffsetMinuteStatus"));
	tU8 _poOffsetMinute = 0;

	ETG_TRACE_USR4(("vdclk_tclDataContainer ReceiveMCANOffsetHourStatus: %d", offset_minute));

	if((_VariantType == 0x01))// non DA variant
	{
		tU8 _u8OffsetMinute = 0;
		if(min_sign == 0x01) //Negative sign so convert to signed
		{
			_u8OffsetMinute = -offset_minute;
		}
		else if(min_sign == 0x02)
		{
			_u8OffsetMinute = offset_minute;
		}
		if(((_isEnabled ==1) && (_isPositionBased == 1)) || ((_isEnabled ==1) && (_isPositionBased == 0))) //mode: Tz or Auto
		{
			OffsetMin_Sign = ((64) | ((min_sign & 3) << 4)) | ((_u8OffsetMinute & (60)) >> 2);
		}
		else
		{
			OffsetMin_Sign = ((128) | ((min_sign & 3) << 4)) | ((_u8OffsetMinute & (60)) >> 2);
		}

		OffsetMin_Val = ((_u8OffsetMinute & 3) << 6);

	}
	else if(_VariantType == 0x02)
	{
		OffsetMin_Sign = 0x10;
		OffsetMin_Val = 0x00;
	}
	return;
}
tVoid vdclk_tclDataContainer ::ReceiveMCANDSTStatus()
{
	ETG_TRACE_USR4(("vdclk_tclDataContainer ReceiveMCANDSTStatus"));

	VDCLK_TEN_DST_Setting enDST_Status = enGetDaylightSavingTimeStatus();

	if(_VariantType == 0x01) // NAVI Variant
	{
		if(((_isEnabled ==1) && (_isPositionBased == 1)) || ((_isEnabled == 0) && (_isPositionBased == 0)))   //Auto Mode or Manual mode
		{
			ClockDST_State = 0x80; //   State: AVailable_inOperable
		}
		else if((_isEnabled ==1) && (_isPositionBased == 0))    //TZ Mode
		{
			switch(u8Region)
			{
			case Region_PRC:
			case Region_TWN:
			case Region_HKG:
			case Region_EGP:
			case Region_BRA:
			case Region_AGT:
			case Region_OTHER_LAC:
			case Region_SAF:
			case Region_THI:
			case Region_SGP:
			case Region_MLY:
			case Region_BRN:
			case Region_INN:
			case Region_VNM:
			case Region_PHL:
			case Region_IND:
			case Region_JPN:
			case Region_KOR:
			{
				ClockDST_State = 0;  //state:unavailable
			}
			break;
			case Region_USA:
			case Region_CAN:
			case Region_MEX:
			case Region_OTHER_EUR:
			case Region_RUS:
			case Region_OTHER_GOM:
			case Region_GCC:
			case Region_ASNZ:
			{
				ClockDST_State = 0x40; //   State: AVailable_Operable
			}
			break;
			default :
			{
				ClockDST_State = 0x40;
			}
			break;
			}

			}
		}
		else if(_VariantType == 0x02) // DA Variant
		{
			ClockDST_State = 0; //   State: Unavailable
		}


		if(enDST_Status == 1)
		{
			ETG_TRACE_USR4(("vdclk_tclDataContainer ReceiveMCANDSTStatus ON"));
			ClockDST_Value = 128;
		}
		else if(enDST_Status == 0)
		{
			ETG_TRACE_USR4(("vdclk_tclDataContainer ReceiveMCANDSTStatus is OFF"));
			ClockDST_Value = 64;
		}
		else
		{
			ETG_TRACE_USR4(("vdclk_tclDataContainer ReceiveMCANDSTStatus NO CHANGE"));
			ClockDST_Value = 0;
		}
	}
	tVoid  vdclk_tclDataContainer::ReceiveMCANClockStatus()
	{

		vdclk_tclDateTime          oLocalDateTime;
		vGetLocalDateTime (&oLocalDateTime);
		tS16 s16Year;           tU8 u8Month;         tU8  u8Day;
		tU8   u8Hour;           tU8 u8Minute;        tU8  u8Second;
		tU8   u8Weekday;
		oLocalDateTime.u8GetComponents( &s16Year,      &u8Month,      &u8Day,

				&u8Hour,       &u8Minute,     &u8Second,
				&u8Weekday );
		if(_VariantType == 0x01) // non DA variant
		{
			if((_isEnabled == 0) && (_isPositionBased == 0)) //Manual
			{

				ClockInfo_Disp = 0x44;// Available_State is available_Operable

				if(u8Hour > 12) // more than 12 hrs, PM
				{
					ClockInfo_Clock = 0x08; //Operable_PM
				}
				else
				{
					ClockInfo_Clock = 0x04; //Operable_AM
				}

				tU8 Hr_ten,Hr_unit;
				Hr_ten = (u8Hour / 10);
				Hr_unit = (u8Hour % 10);

				tU8 Min_ten, Min_unit;
				Min_ten = (u8Minute / 10);
				Min_unit = (u8Minute % 10);

				ETG_TRACE_USR4(("Meter Settings ReceiveMCANClockStatus clockInfo:  %d", ClockInfo_Clock));

				ClockINfo_Hr = (Hr_ten << 6) | (Hr_unit << 2)| ((Min_ten & 0xC) >> 2);
				ETG_TRACE_USR4(("Meter Settings ReceiveMCANClockStatus ClockINfo_Hr:  %x", ClockINfo_Hr));

				ClockInfo_Min = ((Min_ten & 0x03)<< 6) |(Min_unit << 2 ) | (0x00);
				ETG_TRACE_USR4(("Meter Settings ReceiveMCANClockStatus ClockINfo_Hr:  %x", ClockInfo_Min));

			}
			else
			{
				ClockInfo_Disp = 0x84; // Available_State is available_Inoperable

				if(u8Hour > 12) // more than 12 hrs, PM
				{
					ClockInfo_Clock = 0x0C; //InOperable_PM
				}
				else
				{
					ClockInfo_Clock = 0x10; //InOperable_AM
				}

				tU8 Hr_ten,Hr_unit;
				Hr_ten = (u8Hour / 10);
				Hr_unit = (u8Hour % 10);

				tU8 Min_ten, Min_unit;
				Min_ten = (u8Minute / 10);
				Min_unit = (u8Minute % 10);
				ETG_TRACE_USR4(("Meter Settings ReceiveMCANClockStatus clockInfo:  %d", ClockInfo_Clock));

				ClockINfo_Hr = (Hr_ten << 6) | (Hr_unit << 2)| ((Min_ten & 0xC) >> 2);
				ETG_TRACE_USR4(("Meter Settings ReceiveMCANClockStatus ClockINfo_Hr:  %x", ClockINfo_Hr));

				ClockInfo_Min = ((Min_ten & 0x03)<< 6) |(Min_unit << 2 ) | (0x00);
				ETG_TRACE_USR4(("Meter Settings ReceiveMCANClockStatus ClockINfo_Hr:  %x", ClockInfo_Min));

			}
		}

		else
		{
			if((_isEnabled == 0) && (_isPositionBased == 0)) //Manual
			{
				ClockInfo_Disp = 0x44;// Available_State is available_Operable DA variant
				if(u8Hour > 12) // more than 12 hrs, PM
				{
					ClockInfo_Clock = 0x08; //Operable_PM
				}
				else
				{
					ClockInfo_Clock = 0x04; //Operable_AM
				}

				tU8 Hr_ten,Hr_unit;
				Hr_ten = (u8Hour / 10);
				Hr_unit = (u8Hour % 10);

				tU8 Min_ten, Min_unit;
				Min_ten = (u8Minute / 10);
				Min_unit = (u8Minute % 10);

				ETG_TRACE_USR4(("Meter Settings ReceiveMCANClockStatus clockInfo:  %d", ClockInfo_Clock));

				ClockINfo_Hr = (Hr_ten << 6) | (Hr_unit << 2)| ((Min_ten & 0xC) >> 2);
				ETG_TRACE_USR4(("Meter Settings ReceiveMCANClockStatus ClockINfo_Hr:  %x", ClockINfo_Hr));

				ClockInfo_Min = ((Min_ten & 0x03)<< 6) |(Min_unit << 2 ) | (0x00);
				ETG_TRACE_USR4(("Meter Settings ReceiveMCANClockStatus ClockINfo_Hr:  %x", ClockInfo_Min));
			}
			else
			{
				ClockInfo_Disp = 0x04;
				ClockInfo_Clock= 0x00;
				ClockINfo_Hr = 0x00;
				ClockInfo_Min = 0x00;


			}

		}

	}
	tVoid vdclk_tclDataContainer::ReceiveMCANTimezoneStatus()
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer ReceiveMCANTimezoneStatus"));


		vdclk_trTimezoneDetails rDetails = vdclk_rTZDetails[u16GetTimeZoneIndex()];
		tU16 u16HexIndex = rDetails.u16HexIndex;
		clock_fi_tclString szDescription=  (clock_fi_tclString)rDetails.szDescription;

		if(_VariantType == 0x01) // non DA variant
		{
			switch(u8Region)
			{
			case Region_PRC:
			case Region_TWN:
			case Region_HKG:
			case Region_EGP:
			case Region_BRA:
			case Region_AGT:
			case Region_OTHER_LAC:
			case Region_SAF:
			case Region_THI:
			case Region_SGP:
			case Region_MLY:
			case Region_BRN:
			case Region_INN:
			case Region_VNM:
			case Region_PHL:
			case Region_IND:
			case Region_JPN:
			case Region_KOR:
			{
				ClockInfo_TZState = (0); // Timezone unavailable   | ((u16HexIndex & 0xFC) >> 2);Timezone unavailable
			}
			break;
			case Region_USA:
			case Region_CAN:
			case Region_MEX:
			case Region_OTHER_EUR:
			case Region_RUS:
			case Region_OTHER_GOM:
			case Region_GCC:
			case Region_ASNZ:
			{
				if((_isEnabled == 1) && (_isPositionBased == 0))//Timezone available operable
				{
					ClockInfo_TZState = (64)| ((u16HexIndex & 0xFC) >> 2);
				}
				else
				{
					ClockInfo_TZState = (128)| ((u16HexIndex & 0xFC) >> 2); //timezone inoperable
				}
			}
			break;
			default:
				break;

			}

			//enabling the list of timezones in clock meter settings based on the region.
			switch(u8regioncode)
			{
			case NAM_REGION:
			{
				ClockInfo_TZVal  = ((u16HexIndex & (0x03))<< 6) | (0x07);
			}
			break;
			case EUR_RUS_GOM_REGION:
			{
				ClockInfo_TZVal  = ((u16HexIndex & (0x03))<< 6) | (0x1F);
			}
			break;
			case AZR_REGION:
			{
				ClockInfo_TZVal  = ((u16HexIndex & (0x03))<< 6);
			}
			break;
			case GCC_REGION:
			{
				ClockInfo_TZVal  = ((u16HexIndex & (0x03))<< 6);
			}
			break;
			default:

				ClockInfo_TZVal  = 0;
				break;

			}
		}
		else
		{
			ClockInfo_TZState = (0);
			//ClockInfo_TZState = (0)| ((u16HexIndex & 0xFC) >> 2);
		}

		ETG_TRACE_USR4((" ReceiveMCANTimezoneStatus %d %d", ClockInfo_TZState, ClockInfo_TZVal));
		return;
	}

	void vdclk_tclDataContainer::getRegionBasedSupportedTimeZone(tU8 u8region)
	{
		ETG_TRACE_USR4(("SettingsClock::getRegionBasedSupportedTimeZone %d",_u16TimeZoneIndex));

		u8regioncode = 0;

		//Set Default values for timezones and also populate the region specific timezone list.


		switch (u8region)
		{
		case  Region_USA:
		case  Region_CAN:
		case  Region_MEX:
		{
			if(_u16TimeZoneIndex==0)
				vSetTimeZone(6);
			u8regioncode = NAM_REGION;
			_bGetTimeZoneAvailability = TRUE;
			if(_poServiceHandler != NULL)
			{
				_poServiceHandler->sendTimeZone_DSTAvailabilityStatus(_bGetTimeZoneAvailability);
			}
		}
		break;
		case Region_OTHER_EUR:
		case Region_RUS:
		case Region_OTHER_GOM:
		{
			if(_u16TimeZoneIndex==0)
				vSetTimeZone(2);
			u8regioncode = EUR_RUS_GOM_REGION;
			_bGetTimeZoneAvailability = TRUE;
			if(_poServiceHandler != NULL)
			{
				_poServiceHandler->sendTimeZone_DSTAvailabilityStatus(_bGetTimeZoneAvailability);
			}
		}
		break;
		case Region_GCC:
			if(_u16TimeZoneIndex==0)
				vSetTimeZone(77);
			u8regioncode = GCC_REGION;
			_bGetTimeZoneAvailability = TRUE;
			if(_poServiceHandler != NULL)
			{
				_poServiceHandler->sendTimeZone_DSTAvailabilityStatus(_bGetTimeZoneAvailability);
			}
			break;
		case Region_ASNZ:
			if(_u16TimeZoneIndex==0)
				vSetTimeZone(82);
			u8regioncode = AZR_REGION;
			_bGetTimeZoneAvailability = TRUE;
			if(_poServiceHandler != NULL)
			{
				_poServiceHandler->sendTimeZone_DSTAvailabilityStatus(_bGetTimeZoneAvailability);
			}
			break;
		case Region_PRC:
		case Region_TWN:
		case Region_HKG:
		case Region_EGP:
		case Region_BRA:
		case Region_AGT:
		case Region_OTHER_LAC:
		case Region_SAF:
		case Region_THI:
		case Region_SGP:
		case Region_MLY:
		case Region_BRN:
		case Region_INN:
		case Region_VNM:
		case Region_PHL:
		case Region_IND:
		case Region_JPN:
		case Region_KOR:
		{

			ETG_TRACE_USR4(("TimeZone functionality not enabled for this region... Sending status to HMI."));
			_bGetTimeZoneAvailability = FALSE;
			if(_poServiceHandler != NULL)
			{
				_poServiceHandler->sendTimeZone_DSTAvailabilityStatus(_bGetTimeZoneAvailability);
			}
			else
			{
				ETG_TRACE_USR4(("Pointer is null ... "));

			}

		}
		break;

		default :
			if(_u16TimeZoneIndex==0)
				vSetTimeZone(6);
			u8regioncode = NAM_REGION;
			_bGetTimeZoneAvailability = TRUE;
			if(_poServiceHandler != NULL)
			{
				_poServiceHandler->sendTimeZone_DSTAvailabilityStatus(_bGetTimeZoneAvailability);
			}

			break;
		}

		ETG_TRACE_USR4(("--Region Code :%d ",u8regioncode));

		if (_bGetTimeZoneAvailability)
		{
			if (_supportedTimeZoneList.empty())
			{
				for (tU8 i = 0; i < mapTimeZone[u8regioncode].u16SizeOfTimeZoneArray; i++)
				{
					tU16 u16TempTimeZone = mapTimeZone[u8regioncode].pu16TimeZoneList[i];
					ETG_TRACE_USR4(("getRegionBasedSupportedTimeZone %d", u16TempTimeZone));

					clock_fi_tclString aztimezone =vdclk_rTZDetails[u16TempTimeZone].szDescription;

					_supportedTimeZoneList.push_back(aztimezone);
					_u16IndexeList.push_back(u16TempTimeZone);
				}
			}
		}
	}

	tVoid vdclk_tclDataContainer::SendDateTimeStatusCAN(tU16 u16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minute, tU8 u8Second, tU8 u8Weekday)
	{
		tU16 u16CanOffset = 2000;  // fix for NCG3D-34298
		tU16 _CSMYear = u16Year - u16CanOffset; //Renault adds 2000 at VCAN side so we subtract and send.
		tU8 _CSMHour = u8Hour;
		tU8 _CSMMinute = u8Minute;
		tU8 _CSMSecond = u8Second;
		tU8 _CSMMonth = u8Month;
		tU8 _CSMDay = u8Day;
		tU8 _CSMWeekDay = u8Weekday;

		tCSM_MultipleSignalWrite _atCsmMultipleWriteTimeR1[] = {
          {   /* CSM_C_ASIG_TX_TimeHour */0/** Jayashree:commented as it is aivi-relavant **/, &_CSMHour, 1, CSM_C_TX_AS_CONFIGURED },
          {   /* CSM_C_ASIG_TX_TimeMinute */0/** Jayashree:commented as it is aivi-relavant **/, &_CSMMinute, 1, CSM_C_TX_AS_CONFIGURED },
          {   /* CSM_C_ASIG_TX_DateYear */0/** Jayashree:commented as it is aivi-relavant **/, &_CSMYear, 2, CSM_C_TX_AS_CONFIGURED },
          {   /* CSM_C_ASIG_TX_TimeSeconde */0/** Jayashree:commented as it is aivi-relavant **/, &_CSMSecond, 1, CSM_C_TX_AS_CONFIGURED },
          {   /* CSM_C_ASIG_TX_DateMonth */0/** Jayashree:commented as it is aivi-relavant **/, &_CSMMonth, 1, CSM_C_TX_AS_CONFIGURED },
          {   /* CSM_C_ASIG_TX_DateDay */0/** Jayashree:commented as it is aivi-relavant **/, &_CSMDay, 1, CSM_C_TX_AS_CONFIGURED },
          {   /* CSM_C_ASIG_TX_TimeWeekDay */0/** Jayashree:commented as it is aivi-relavant **/, &_CSMWeekDay, 1, CSM_C_TX_AS_CONFIGURED }
      };


		tU32 u32CsmHandle = 0;

		VD_CLOCK_NULL_POINTER_CHECK(_poMyCSMInterface);

		ETG_TRACE_USR4(("vdclk_tclDataContainer::SendDateTimeStatusCAN(): Called!"));

		tS32 s32returnValue = 0;

		s32returnValue = _poMyCSMInterface->CSM_lMultipleSignalWrite( (tVoid*)&u32CsmHandle, _atCsmMultipleWriteTimeR1, 6);
		ETG_TRACE_USR4(("vdclk_tclDataContainer::SendDateTimeStatusCAN: return value %08x", s32returnValue));

		//Multiple Signal Write for all signals TIME_R1
		if (CSM_C_NO_ERROR > s32returnValue)
		{
			ETG_TRACE_USR4(("vdclk_tclDataContainer::SendDateTimeStatusCAN: CAN data NOT sent ERROR"));
		}
		else
		{
			ETG_TRACE_USR4(("vdclk_tclDataContainer::SendDateTimeStatusCAN: CAN data sent succesfully"));
		}
	}
	tVoid  vdclk_tclDataContainer::vUpdateDSTSensorTime (tS32 _DSTDiff, tS32 _TZDiff)
	{
		//vEnterCriticalSection("vUpdateDSTDiffTime");

		ETG_TRACE_USR4(("UpdateDSTSensorTime: Daylight:%d, TZ Difference:%d",_DSTDiff, _TZDiff));


		vEnterCriticalSection("vUpdateDSTDiffTime");
		//if(_cantimeavailable == FALSE)
		{
			_s64DynOffset[VDCLK_EN_Auto] = (tS64)_TZDiff+ (tS64)_DSTDiff;
		}
		ETG_TRACE_USR1(("vUpdateDSTSensorTime: VDCLK_EN_Auto Offset: %d", _s64DynOffset[VDCLK_EN_Auto]));
		vReleaseCriticalSection("vUpdateDSTDiffTime");

		// TRACE
		//vdclk_tclDateTime oLocalDateTime = _oSystemTime;        // use assignment operator
		//TRACE_DateTime("vUpdateDSTDiffTime", oLocalDateTime, _CLASS, __LINE__);

		//tU32 u32EvtMask = 0;
		//u32EvtMask |= cu32EventMaskPropertyNotify8420;

		//vd_clock_tclAppMain::theServer()->vPostMsgDSTUpdate("Ivd_clock_tclServiceClockIf");

		//OSAL_tEventMask u32NotifyEvents = 0UL;
		//u32NotifyEvents = cu32EventMaskPropertyNotify8410 | cu32EventMaskPropertyNotify8200;
		// removed as timezone and DST update not required in auto mode

		/*vd_clock_tclAppMain::theServer()->vPostMsgTimezoneUpdate("Ivd_clock_tclServiceClockIf");
		 * vd_clock_tclAppMain::theServer()->vPostMsgDSTUpdate("Ivd_clock_tclServiceClockIf");*/

		/* Update offset values to Navigation*/
	//	vd_clock_tclAppMain::theServer()->vPostMsgLocaltimeOffsetUpdate("Ivd_clock_tclServiceClockIf");

		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
		return;
	}

	/*tVoid  vdclk_tclDataContainer::vUpdateTZSensorTime ( tS32 _TZDiff)
{
	ETG_TRACE_USR1(("vUpdateTZDiffTime"));

	vEnterCriticalSection("vUpdateTZDiffTime");
	ETG_TRACE_USR4(("TZ Difference is %d",_TZDiff));

	if(SensorUpdate_Flag < 3)
	{
		ETG_TRACE_USR1(("TZ DiffTime Not updated"));
		SensorUpdate_Flag++;
	}

	else
	{
		_s64DynOffset[VDCLK_EN_Auto] = (tS64)_TZDiff ;
	}

	ETG_TRACE_USR1(("vSetAutoTimeZoneOffset received after Sensor TZ offset: %d", _s64DynOffset[VDCLK_EN_Auto]));

	vReleaseCriticalSection("vUpdateTZDiffTime");

	// TRACE
	vdclk_tclDateTime oLocalDateTime = _oSystemTime;        // use assignment operator
	TRACE_DateTime("vUpdateTZDiffTime", oLocalDateTime, _CLASS, __LINE__);

	OSAL_tEventMask u32NotifyEvents = 0UL;
	u32NotifyEvents = cu32EventMaskPropertyNotify8410 | cu32EventMaskPropertyNotify8200;
	vd_clock_tclAppMain::theServer()->vPostMsgTimezoneUpdate("Ivd_clock_tclServiceClockIf");

	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
	vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");


	return;
}*/

	void vdclk_tclDataContainer::getRegionBasedSupportedDateFormat(tU8 u8region)
	{
		ETG_TRACE_USR4(("SettingsClock::getRegionBasedSupportedDateFormat %d",u8region));

		switch (u8region)
		{
		case  Region_USA:
		case  Region_CAN:
		case  Region_MEX:
		{
			vSetNewDateFormat(VDCLK_EN_DF_DD_MM_YYYY_DASH);
		}
		break;
		case Region_OTHER_EUR:
		case Region_RUS:
		case Region_OTHER_GOM:
		{
			vSetNewDateFormat(VDCLK_EN_DF_DD_MM_YYYY_DASH);
		}
		break;
		case Region_GCC:
		{
			vSetNewDateFormat(VDCLK_EN_DF_DD_MM_YYYY_DOT);
		}
		break;
		case Region_PRC:
		case Region_TWN:
		case Region_HKG:
		case Region_EGP:
		case Region_BRA:
		case Region_AGT:
		case Region_OTHER_LAC:
		case Region_SAF:
		case Region_THI:
		case Region_SGP:
		case Region_MLY:
		case Region_BRN:
		case Region_INN:
		case Region_VNM:
		case Region_PHL:
		case Region_IND:
		case Region_JPN:
		{
			vSetNewDateFormat(VDCLK_EN_DF_YYYY_MM_DD_JPN);
		}
		break;
		case Region_KOR:
		{
			vSetNewDateFormat(VDCLK_EN_DF_YYYY_MM_DD_KOR);

		}
		break;

		default :
			if(_u32DateFormat==0)
				vSetNewDateFormat(VDCLK_EN_DF_DD_MM_YYYY_DASH);
			break;
		}

	}

	unsigned char vdclk_tclDataContainer::getVariantSelection()
	{
		unsigned char VariantType = 0xFF;
		dp_tclKdsAIVIVariantCoding _oVariantType;
		// VariantType = FALSE;

		_oVariantType.u8GetVariantSelection(VariantType);

		if(VariantType == 0x01)
		{
			ETG_TRACE_USR4(("getVariantSelection NAVI Variant %d",VariantType));
		}
		else if(VariantType == 0x02)
		{
			ETG_TRACE_USR4(("getVariantSelection DA Variant %d",VariantType));
		}

		return VariantType;

	}

	unsigned char vdclk_tclDataContainer::getOEMType()
	{
		unsigned char OEMType = 0xFF;
		dp_tclKdsCMVariantCoding _oOEMType;

		_oOEMType.u8GetOEMType(OEMType);

		if((OEMType == 0x06) || (OEMType == 0x16))
		{

			ETG_TRACE_USR4(("OEM type is Nissan/PIVI %d",OEMType));
			OEMType = 0x01;
		}
		else
		{
			ETG_TRACE_USR4(("OEM type not Nissan/PIVI %d",OEMType));
			OEMType = 0x00;
		}

		return OEMType;

	}

	tVoid vdclk_tclDataContainer::SendMCANSettings_Set()
	{
		vd_clock_tclAppMain::theServer()->vPostMsgClock_MeterSettingsUpdate("Ivd_clock_tclServiceClockIf");

	}
	tVoid vdclk_tclDataContainer :: SetMCANTimeFormat(tU8 u8MCANTimeFormat)
	{

		if(u8MCANTimeFormat == 0x01)
		{
			vSetTimeFormatGeneric(VDCLK_EN_TF_Mode12);
		}
		else if(u8MCANTimeFormat == 0x02)
		{
			vSetTimeFormatGeneric(VDCLK_EN_TF_Mode24);
		}
	}
	tVoid vdclk_tclDataContainer :: SetMCANClockMode(tU8 u8MCANSyncMode)
	{
		ETG_TRACE_USR4(("SetMCANClockMode:%d",u8MCANSyncMode));

		if(_VariantType == 0x01)//navi variant
		{
			if(u8MCANSyncMode == 0x01) //Auto
			{
				vSetGPS_AutoSyncGeneric(1, 1);
			}
			else if(u8MCANSyncMode == 0x02)//manual
			{
				vSetGPS_AutoSyncGeneric(0, 0);
			}
			else if(u8MCANSyncMode == 0x03)//timezone
			{
				vSetGPS_AutoSyncGeneric(1, 0);
			}
		}
		else if(_VariantType == 0x02)//DA variant
		{
			if(u8MCANSyncMode == 0x02)//manual
			{
				vSetGPS_AutoSyncGeneric(0, 0);
			}
		}
	}

	tU8 vdclk_tclDataContainer :: SetMCANClock(tU8 Param1, tU8 Param2, tU8 Param3)
	{
		ETG_TRACE_USR4(("SetMCANClock:%d:%d:%d",Param1, Param2, Param3));
		//ETG_TRACE_USR4(("SetMCANClock:bEnabled:%d  bPositionBased:%d",_isEnabled,_isPositionBased));

		_InvalidParam = 0;

		if((_isEnabled == 0) && (_isPositionBased == 0))  //Manual
		{
			tU8 MCANMinute = 0, MCANHour = 0, Hr_Flag = (Param1 & 192) >> 6;

			tU8 Hr_Change, Hr_ten, Hr_Unit,Min_change,Min_ten,Min_unit;
			Hr_Change = Param1 & 0x20; //00x00000
			Hr_ten = (Param1 & 0x1E) >> 1; //000xxxx0
			Hr_Unit = ((Param1 & 0x01) << 3) | ((Param2 & 0xE0) >> 5); //1: 0000000x 2: xxx00000

			Min_change = Param2 & 0x10; //000x0000
			Min_ten = Param2 & 0x0F ; //0000xxxx
			Min_unit = (Param3 & 0xF0)>> 4;//xxxx0000

			if(Hr_Change)
			{
				switch(Hr_Flag)
				{
				case 0:// no change
					MCANHour = (Hr_ten * 10) + Hr_Unit;
					//_MCANHour = MCANHour;
					if(MCANHour > 23) // check for time greater than 24
					{
						_InvalidParam = 0x01;
					}
					break;
				case 1:// AM
					MCANHour = (Hr_ten * 10) + Hr_Unit;
					//_MCANHour = MCANHour;

					if(MCANHour > 12)
					{
						_InvalidParam = 0x01;
					}
					break;
				case 2: //PM
					MCANHour = (Hr_ten * 10) + Hr_Unit;
					if(MCANHour < 12)
					{
						MCANHour = MCANHour + 12;
						//_MCANHour = MCANHour;
					}
					else if(MCANHour > 23) // check for time greater than 24
					{
						_InvalidParam = 0x01;
					}
					break;
				}
			}

			if(Min_change)
			{
				MCANMinute = (Min_ten * 10) + Min_unit;
				if((MCANMinute > 60) || (Min_unit > 9))
				{
					_InvalidParam = 0x01;
					ETG_TRACE_USR4(("vd_clock_INCAdapter SINVALID PARAM SET"));
				}
			}


			ETG_TRACE_USR4(("SetMCANClock: MCANHour %d MCANMinute %d",MCANHour,MCANMinute));

			vdclk_tclDateTime          oLocalDateTime;
			vGetLocalDateTime (&oLocalDateTime);

			tS16 s16Year;tU8 u8Month,u8Day,u8Hour,u8Minute,u8Second,u8Weekday;
			oLocalDateTime.u8GetComponents( &s16Year,&u8Month,&u8Day,&u8Hour,&u8Minute,&u8Second,&u8Weekday );

			// updating to client //
			if((_InvalidParam != 0x01) && (Hr_Change)&&(Min_change)) //both hour and minute change
			{
				oLocalDateTime.u8Update( s16Year,u8Month,u8Day,MCANHour,MCANMinute,u8Second,(tU8)VDCLK_EN_AllChange );
			}
			else if((_InvalidParam != 0x01) && (Hr_Change) && (!Min_change)) //only hour change
			{
				oLocalDateTime.u8Update( s16Year,u8Month,u8Day,MCANHour,u8Minute,u8Second,(tU8)VDCLK_EN_AllChange );
			}
			else if((_InvalidParam != 0x01) && (!Hr_Change) && (Min_change)) //only minute change
			{
				oLocalDateTime.u8Update( s16Year,u8Month,u8Day,u8Hour,MCANMinute,u8Second,(tU8)VDCLK_EN_AllChange );
			}
			else if((!Hr_Change) && (!Min_change)) //only minute change
			{
				return _InvalidParam;
			}

			vSetLocalDateTime (&oLocalDateTime);

			return _InvalidParam;
		}

		return _InvalidParam;
	}
	tVoid vdclk_tclDataContainer :: SetMCANOffsetHourMinute(tU8 u8MCANOffsetHour, tU8 u8MCANOffsetMinute)
	{
		//int intValue = 0;
		tU8 OffsetHour_Sign, OffsetMinute_Sign;
		OffsetHour_Sign = u8MCANOffsetHour & 0xC0;//hour sign
		OffsetMinute_Sign = u8MCANOffsetMinute & 0xC0; //minute sign

		u8MCANOffsetHour = u8MCANOffsetHour & 0x3F;
		u8MCANOffsetMinute = u8MCANOffsetMinute & 0x3F;


		// Offset Hour Handling

		tS64 _TestOffsetHour = 0;
		if(OffsetHour_Sign ==128) //positive
		{
			if(u8MCANOffsetHour < 13) //less than 13
			{
				_TestOffsetHour = (tS64)u8MCANOffsetHour;
				//_MCANOffsetHr = _TestOffsetHour;
			}
			else
			{
				_TestOffsetHour = offset_hour;
			}
		}

		else if(OffsetHour_Sign ==64) //negative
		{
			if(u8MCANOffsetHour < 13)//  not more than 12
			{
				_TestOffsetHour = -(tS64)u8MCANOffsetHour;
			}
			else
			{
				_TestOffsetHour = offset_hour;
			}
		}

		else if(OffsetHour_Sign == 0)
		{
			_TestOffsetHour = offset_hour;
		}


		//offset minute handling

		tS64 _TestOffsetMin = 0;
		if(OffsetMinute_Sign ==128) //postive
		{
			if((u8MCANOffsetMinute < 60)) //not more than 59
			{
				_TestOffsetMin = (tS64)u8MCANOffsetMinute;
			}
			else
			{
				_TestOffsetMin = offset_minute;
			}
		}

		else if(OffsetMinute_Sign ==64)//negative
		{
			if((u8MCANOffsetMinute < 60)) // not more than 59
			{
				_TestOffsetMin = -(tS64)u8MCANOffsetMinute;
			}
			else
			{
				_TestOffsetMin = offset_minute;
			}
		}

		else if(OffsetMinute_Sign == 0)
		{
			_TestOffsetMin = offset_minute;
		}

		if((OffsetHour_Sign == 0) && (OffsetMinute_Sign == 0))
		{
			return;
		}


		ETG_TRACE_USR4(("SetMCANOffsetHourMinute Value %d %d ",_TestOffsetHour,_TestOffsetMin ));
		vSetAutoTimeZoneOffsetGeneric(_TestOffsetHour,_TestOffsetMin);
	}

	tVoid vdclk_tclDataContainer ::SetMCANDST(tU8 u8MCANDST)
	{
		if(((bGetGPS_AutoSync()) == 1) && ((bGetPositionBased())== 0)) // check timezone mode
		{
			if(u8MCANDST == 0x02)
			{
				vSetDaylightSavingTimeGeneric(VDCLK_EN_DST_On, TRUE);
			}
			else if(u8MCANDST == 0x01)
			{
				vSetDaylightSavingTimeGeneric(VDCLK_EN_DST_Off, TRUE);
			}
		}

	}
#ifndef __COVERITY__ 
	tVoid vdclk_tclDataContainer :: SetMCANTimezone(tU8 u8MCANTZ)
	{
		ETG_TRACE_USR4(("u8MCANTZ %d",  u8MCANTZ));

		for(tU8 itr = 0; itr <= 89; itr++)
		{
			if(u8MCANTZ == 0)//no Change selected in Tz list
			{
				Flag_TZ = TRUE;
				return;
			}
			else if(u8MCANTZ == vdclk_rTZDetails[itr].u16HexIndex)
			{
				/* Start: check if the timezone selcted is in the region based timezone list */

				bpstl::vector<tU16, bpstl::allocator<tU16> > u16Indexes;
				u16Indexes =_u16IndexeList;

				for (tU16 u16Index = 0; u16Index < u16Indexes.size(); u16Index++)
				{
					if(vdclk_rTZDetails[itr].u16Index== u16Indexes[u16Index])
					{
						vSetTimeZoneGeneric(vdclk_rTZDetails[itr].u16Index + 1);
						Flag_TZ = TRUE;
					}

				}

				/*End : check if the timezone selcted is in the region based timezone list */

				if(((bGetGPS_AutoSync()) == 1) && ((bGetPositionBased())== 0)) // check timezone mode
				{
					if(Flag_TZ == FALSE)
					{
						_InvalidParam = 0xFF;
					}
					break;
				}
			}

		}
		Flag_TZ = FALSE;
	}
#endif

	tVoid vdclk_tclDataContainer::vAppState(tU32 AppState)
	{
		_u32AppState = AppState;
		vDefaultInitialization(_u32AppState, _bRTCVAlid);
		return;
	}

	tVoid vdclk_tclDataContainer::vDefaultInitialization(tU32 AppState, tBool bRTCValid)
	{
		if((AppState == 0x03) && (bRTCValid == TRUE) && (_bDefaultSettingFlag == FALSE))
		{
			vSetDefaultSettings(TRUE);
			_bDefaultSettingFlag = TRUE;
		}
		return;

	}


	tVoid vdclk_tclDataContainer::SendDateTimeStatusCANVariant(tU16 u16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minute, tU8 u8Second, tU8 u8Weekday)
	{
		tU16 u16CanOffset = 2015;
		tU16 _CSMYear = u16Year - u16CanOffset; //Nissan adds 2015 at VCAN side so we subtract and send.
		tU8 _CSMHour = u8Hour;
		tU8 _CSMMinute = u8Minute;
		tU8 _CSMSecond = u8Second;
		tU8 _CSMMonth = u8Month;
		tU8 _CSMDay = u8Day;
		tU8 _CSMWeekDay = u8Weekday;

		tCSM_MultipleSignalWrite _atCsmMultipleWriteTimeR2[] = {
				{   /*CSM_C_ASIG_TX_GPS_Current_Year */0/** Jayashree:commented as it is aivi-relavant **/, &_CSMYear, 2, CSM_C_TX_AS_CONFIGURED },
				{   /*CSM_C_ASIG_TX_GPS_Current_Month*/0/** Jayashree:commented as it is aivi-relavant **/, &_CSMMonth, 1, CSM_C_TX_AS_CONFIGURED },
				{   /*CSM_C_ASIG_TX_GPS_CurrentDay*/0/** Jayashree:commented as it is aivi-relavant **/, &_CSMDay, 1, CSM_C_TX_AS_CONFIGURED },
				{   /*CSM_C_ASIG_TX_GPS_Current_day_of_the_week*/0/** Jayashree:commented as it is aivi-relavant **/, &_CSMWeekDay, 1, CSM_C_TX_AS_CONFIGURED }
		};


		tU32 u32CsmHandle = 0;

		VD_CLOCK_NULL_POINTER_CHECK(_poMyCSMInterface);

		ETG_TRACE_USR4(("vdclk_tclDataContainer::SendDateTimeStatusCAN(): Called!"));

		tS32 s32returnValue = 0;

		s32returnValue = _poMyCSMInterface->CSM_lMultipleSignalWrite( (tVoid*)&u32CsmHandle, _atCsmMultipleWriteTimeR2,4 );
		ETG_TRACE_USR4(("vdclk_tclDataContainer::SendDateTimeStatusCANVariant: return value %08x", s32returnValue));

		//Multiple Signal Write for all signals TIME_R1
		if (CSM_C_NO_ERROR > s32returnValue)
		{
			ETG_TRACE_USR4(("vdclk_tclDataContainer::SendDateTimeStatusCANVariant: CAN data NOT sent ERROR"));
		}
		else
		{
			ETG_TRACE_USR4(("vdclk_tclDataContainer::SendDateTimeStatusCANVariant: CAN data sent succesfully"));
		}
	}
tVoid vdclk_tclDataContainer::vToManualTimeInitialization(tBool bEnabled, tBool bPostionBased)
{
	if((enPrevDomainOffset == VDCLK_EN_TZ) || (enPrevDomainOffset == VDCLK_EN_Auto))
	{
		if((bEnabled== 0) && (bPostionBased == 0))
		{
			_s64DynOffset[VDCLK_EN_Manual_Mode] =  _s64DynOffset[VDCLK_EN_Auto] + _u64AutoTimezoneOffset;
		}

	}
	return;
}

tVoid vdclk_tclDataContainer::SetHUDActivateToCAN(VDCLK_TEN_HUDACTIVATE enHUDActivate)
{
	ETG_TRACE_USR4(("vdclk_tclDataContainer::SetHUDActivateToCAN(): Called!"));
	tBool _HUDState = FALSE;
	if(enHUDActivate == HUD_ACTIVATE)
	{
		_HUDState = TRUE;
	}
	else
	{
		_HUDState = FALSE;
	}

	tU32 u32CsmHandle = 0;

	VD_CLOCK_NULL_POINTER_CHECK(_poMyCSMInterface);
	tS32 s32returnValue = 0;

	//s32returnValue = _poMyCSMInterface->CSM_lSignalWrite((tVoid*)&u32CsmHandle, CSM_C_ASIG_TX_HUD_ActivationRequest2, &_HUDState, 1, CSM_C_TX_AS_CONFIGURED);

	ETG_TRACE_USR4(("vdclk_tclDataContainer::SetHUDActivateToCAN: return value %08x", s32returnValue));

	//Single Signal Write for HUD Activate HUD_A1
	if (CSM_C_NO_ERROR > s32returnValue)
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer::SetHUDActivateToCAN: Error in CAN data Set"));
	}
	else
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer::SetHUDActivateToCAN: CAN data Set successfully"));
	}

}

tBool vdclk_tclDataContainer::vReadHUDDeployment()
{
	tBool _bHUDDeployment = FALSE;
	tU32 u32CsmHandle = 0;
	tU32 u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;

	if(_poMyCSMInterface)
	{
		tS32 s32returnValue = 0;

		//s32returnValue = _poMyCSMInterface ->CSM_lSignalRead((tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_HUD_EffectiveDeployment,&_bHUDDeployment,1,&u32StatusRead);

		ETG_TRACE_USR4(("vdclk_tclDataContainer::vReadHUDDeployment: return value %08x", s32returnValue));
	}
	return _bHUDDeployment;


}






/************************************************************************
 * FUNCTION:    SetLocalDateTimeSMART
 *
 * DESCRIPTION: Sets the local date time according an offset
 *
 * PARAMETER:   tU8 u8Hour, tU8 u8Minute
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::SetLocalDateTimeSMART( tU8 u8Hour, tU8 u8Minute)
{
	tU16 U16PrevTotalTime=-1;
	tU16 U16CurrTotalTime=-1;
	U16PrevTotalTime=_TotalMintes ; // assign the previous time value locally for check
	U16CurrTotalTime= (u8Hour * 60) + u8Minute; // convert everything into min
	if( (U16CurrTotalTime>=0) && (U16CurrTotalTime<=0x5A00)) // max value for min
	{
		_TotalMintes=U16CurrTotalTime; // take the data only if its valid
		if(U16PrevTotalTime!=_TotalMintes) // send only if there is any change in the value 
		{
			if(_poMyCSMInterface)
			{
				tS32 s32returnValue = 0;
				s32returnValue = _poMyCSMInterface->CSM_lSignalWrite(NULL, CSM_C_SIG_TX_LocalTime_MM_ITM_State, &_TotalMintes, 2, CSM_C_TX_AS_CONFIGURED);
				
				if (CSM_C_NO_ERROR > s32returnValue)
				{
					ETG_TRACE_USR4(("vdclk_tclDataContainer::SetLocalDateTimeSMART: Error in CAN data Set"));
				}
				else
				{
					ETG_TRACE_USR4(("vdclk_tclDataContainer::SetLocalDateTimeSMART: CAN data Set successfully"));
				}
			}
			else
			{
				ETG_TRACE_USR4(("vdclk_tclDataContainer::SetLocalDateTimeSMART: CAN NULL received"));
			}
		}
		else
		{
			ETG_TRACE_USR4(("vdclk_tclDataContainer::SetLocalDateTimeSMART: No Change in the Time "));
		}
	}
	else
	{
		ETG_TRACE_USR4(("vdclk_tclDataContainer::SetLocalDateTimeSMART: CAN data out of bounds"));
	}
}



/************************************************************************
 * FUNCTION:    SetTimeFormatSMART
 *
 * DESCRIPTION: Sets the time format and transmits to CAN
 *
 * PARAMETER:   tBool bTimeFormat
 *
 * RETURNVALUE: none
 *************************************************************************/
tVoid  vdclk_tclDataContainer::SetTimeFormatSMART( tBool bTimeFormat)
{
	tBool bPrevTimeFormat=0;
	bPrevTimeFormat=_TimeFormat; // to trigger only if there is a change and valid value 
	if((bTimeFormat==0x01) || (bTimeFormat==0x00))
	{
		if(bPrevTimeFormat!=bTimeFormat)
		{
			_TimeFormat=bTimeFormat;
		
			if(_poMyCSMInterface)
			{
				tS32 s32returnValue = 0;
				s32returnValue = _poMyCSMInterface->CSM_lSignalWrite(NULL,CSM_C_SIG_TX_TimeFormat_MM_ITM_State, &_TimeFormat, 1, CSM_C_TX_AS_CONFIGURED);
				
				if (CSM_C_NO_ERROR > s32returnValue)
				{
					ETG_TRACE_USR4(("vdclk_tclDataContainer::SetTimeFormatSMART: Error in CAN data Set"));
				}
				else
				{
					ETG_TRACE_USR4(("vdclk_tclDataContainer::SetTimeFormatSMART: CAN data Set successfully"));
				}
			}
			else
			{
			//	ETG_TRACE_USR4("vdclk_tclDataContainer::SetTimeFormatSMART: CAN NULL received ");
			}
		}
		else
		{
		//	ETG_TRACE_USR4("vdclk_tclDataContainer::SetTimeFormatSMART: CAN No change in Time format  ");
		}
	}
	else
	{
	//	ETG_TRACE_USR4("vdclk_tclDataContainer::SetTimeFormatSMART: CAN Invalid Time Format Received.");
	}
}
