/*
 * vd_clock_INCAdapter.h
 *
 *  Created on: Jul 31, 2015
 *      Author: vee4kor
 */

#ifndef VD_CLOCK_INCADAPTER_H_
#define VD_CLOCK_INCADAPTER_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "vd_clock_AppMain.h"
#include "vd_clock_Event.h"
#include "vd_clock_updater.h"

#include <sys/types.h>
#include <sys/poll.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <time.h>
#include <netinet/tcp.h>


#define INC_MESSAGE_RECEIVER_BUFFER_SIZE 256

class vd_clock_tclAppMain;
class vdclk_tclEvent;
class vdclk_tclUpdater;
class Ivd_clock_tclClientDiaglogIf;
class Ivd_clock_tclServiceClockIf;

struct vdclk_MeterSettings
{
	tU8 _u8SetTimeFormat;
	tU8 _u8SetClockMode;
	tU8 _u8SetClock;
	tU8 _u8SetClockHour;
	tU8 _u8SetClockMinute;
	tU8 _u8SetClockOffsetHour;
	tU8 _u8SetClockOffsetMinute;
	tU8 _u8SetDST;
	tU8 _u8SetTimezone;

};

class vd_clock_INCAdapter:public vd_clock_tclBaseIf
{
public:
   vd_clock_INCAdapter(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_INCAdapter();
   static void* MessageReceiver(void* Data);
   int sendMessage(/*int Socket,*/void* Data, size_t DataLength);

   tVoid vGetMCANTime(OSAL_trTimeDate &tMCANTimeDate);

   tVoid vTestINCReceive(OSAL_trTimeDate &MCANTimeDate);

	virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
	virtual tVoid vHandleTraceMessage(const tUChar* puchData);
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();
	virtual const tChar* getIfName() const { return "vd_clock_INCAdapter"; };
	virtual const tChar* getName() const { return "vd_clock_INCAdapter"; };
	virtual const vdclk_MeterSettings tGetMeterSettingsData() {
		return _tMeterSettings;
	}

private:
   pthread_t ReceiverThread;
   /**
    * Flag will be set when the Thread shall exit
    */
   static tBool terminateReceiverThread;

   // socket
   static int INCClockSocket;

   static OSAL_trTimeDate  _tMCANTimeDate;

   static vdclk_tclUpdater* _poUpdater;
   static vdclk_tclDataContainer* _poContainer;

	static Ivd_clock_tclClientDiaglogIf* _poDiagHandler;
	static Ivd_clock_tclServiceClockIf* _poServiceHandler;
	// local and remote address
	struct hostent *local, *remote;
	struct sockaddr_in local_addr, remote_addr;
	static tU8  _u8ConnectionState;
	static tU8 _u8CommunicationState;
	static tU8 _u8MuteState;
	static tU8 _u8TroubleCode;
	static tBool _bConnectionStateChange;
	static tBool _bLogITC;
	static tBool _isSWCMCANConfigured;
	static tVoid vCheckforCommunicationState(tU8 u8ReceivedConnectionState,tU8 u8ReceivedCommunicationState,tU8 u8ReceivedMuteState,tU8 u8ReceivedTroulbeCode);

	static vdclk_MeterSettings _tMeterSettings;

	//DeviceDataProvider oMessageProvider;

   tBool createMessageObserver();
   tBool createSocket();

   tBool connectPort();

   //void vHandleINCMessage(int NumberOfBytesReceived, tU8* ReceivedBuffer);

};



#endif /* VD_CLOCK_INCADAPTER_H_ */
