
/*
 * vd_clock_container.cpp
 *
 *  Created on: Apr 23, 2015
 *      Author: vee4kor
 */


#pragma once

#ifndef _VDCLK_EVENT_H_
#define _VDCLK_EVENT_H_

// ****************************************************************************
// ***							  E v e n t   F i e l d s 								 ***
// ****************************************************************************

                                                 
// ---   Event Masks for vdclk_poNotificationTrigger   ---

const tU32    cu32EventMaskPropertyNotify8200      = 0x00000100UL; // LocalTimeDate
const tU32    cu32EventMaskPropertyNotify8210      = 0x00000200UL; // TimeFormat
const tU32    cu32EventMaskPropertyNotify8220      = 0x00000400UL; // DateFormat
const tU32    cu32EventMaskPropertyNotify8230      = 0x00000800UL; // ClockSourceStatus
const tU32    cu32EventMaskPropertyNotify8240      = 0x00001000UL; // FormatSourceStatus
const tU32    cu32EventMaskPropertyNotify8410      = 0x00002000UL; // TIMEZONE
const tU32    cu32EventMaskPropertyNotify8420      = 0x00004000UL; // DAYLIGHTSAVINGTIME
const tU32    cu32EventMaskPropertyNotify8430      = 0x00008000UL; // GPS_AUTOSYNC
const tU32    cu32EventMaskPropertyNotify8440      = 0x00010000UL; // SYNCMODE
const tU32    cu32EventMaskPropertyNotify8450      = 0x00020000UL; // RTC Manual Mode
const tU32	  cu32EventMaskPropertyNotify8460      = 0x00040000UL; // GPS week epoch
const tU32    cu32EventMaskPropertyNotify8470      = 0x00080000UL; // Local time Offset
const tU32    cu32EventMaskPropertyNotify8480      = 0x00000010UL; // DST Auto

const tU32    cu32EventMaskPropertyNotifyAll       = 0x000fff10UL;

const tU32    cu32EventCmdTerminateNotifierThread  = 0x10000000UL;


// ---   Event Masks for vdclk_poRunIndicator   ---

const tU32    cu32EventMaskUpdaterAlive            = 0x00010000UL;
const tU32    cu32EventMaskContainerAlive          = 0x00020000UL;
const tU32    cu32EventMaskNotificationTableAlive  = 0x00040000UL;

const tU32    cu32EventMaskNotifierThreadAlive     = 0x00100000UL;
const tU32    cu32EventMaskUpdaterThreadAlive      = 0x00200000UL;

const tU32    cu32EventMaskAllAlive                
               =  cu32EventMaskUpdaterAlive
               | cu32EventMaskContainerAlive
               | cu32EventMaskNotificationTableAlive
               | cu32EventMaskNotifierThreadAlive
               | cu32EventMaskUpdaterThreadAlive;


// ****************************************************************************
// ---   Declaration   ---
/*lint -e641 "Converting enum..." */


class vdclk_tclEvent
{

	// =========================================================================
	// ===								I n t e r f a c e									 ===
	public:

	// ---   Constructor / Destructor   ---
      vdclk_tclEvent
         (
            tCString const szEventName
         );

      virtual ~vdclk_tclEvent
         (
         );

   // ---   Methods   ---

      // 
      tVoid  vPost
         (
            const tU32  u32EventMask,
            const tU16  u16Class,         // Tracing information _CLASS
            const tU32  u32Line           // Tracing information _LINE
         );

      tVoid  vClear
         (
            const tU32  u32EventMask,
            const tU16  u16Class,         // Tracing information _CLASS
            const tU32  u32Line           // Tracing information _LINE
         );

      tVoid  vStatus
         (
            const tU32  u32EventMask,
                  tU32* pu32EventStatus,  // location for actual event status     
            const tU16  u16Class,         // Tracing information _CLASS
            const tU32  u32Line           // Tracing information _LINE
         );

      tVoid  vWait
         (
            const tU32  u32EventMask,
            OSAL_tMSecond  u32TimeOut,        
                  tU32* pu32EventStatus,  // location for actual event status     
            const tU16  u16Class,         // Tracing information _CLASS
            const tU32  u32Line           // Tracing information _LINE
         );

      tBool  bAwaitClearance
         (
            const OSAL_tEventMask   u32EventMask,
                  OSAL_tMSecond     u32TimeOut,        
            const tU16              u16Class,         // Tracing information _CLASS
            const tU32              u32Line           // Tracing information _LINE
         );


	// =========================================================================
	// ===						P r i v a t e   S e c t i o n							 ===

   private:

      // ---   member variables   --- 
      OSAL_tEventHandle    _hEvent;
      tCString              _szEventName;

      // standard constructor (suppressed); forces to give event name
      vdclk_tclEvent    //lint -e1704 PQM_authorized_multi_153. 
         (              //Reason: Intentional use of private constructor
         );

};

#endif // _VDCLK_EVENT_H_
