/*
 * DiagSystemSetListener.cpp
 *
 *  Created on: Jan 5, 2016
 *      Author: spt8kor
 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_VD_CLOCK_APPLICATION
#include "trcGenProj/Header/DiagSystemSetListener.cpp.trc.h"
#endif

#define DIAGNOSTICS_KDS_ENTRY_IMPORT_INTERFACE
#include "fc_diagnosis_if.h"

#include "DiagSystemSetListener.h"


/*************************************************************************
*
* FUNCTION: Constructor
*
* DESCRIPTION: Init Members
*
* PARAMETER: poMainAppl Pointer to main application
*            poIF Pointer to diaglib SystemSet interface
*
* RETURNVALUE:
*
*************************************************************************/
tclSystemSetListener::tclSystemSetListener(diaglib::tclSystemSetIF * poIF, vd_clock_tclAppMain* poMainAppl, vdclk_tclDataContainer* poCont )
{
  ETG_TRACE_USR1(("CONSTRUCTOR: tclSystemSetListener() entered"));

  m_poSystemSetIF = poIF;
  _poMainAppInstance = poMainAppl;
  _poCont = poCont;
  }

/*************************************************************************
*
* FUNCTION: Destructor
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE:
*
*************************************************************************/
tclSystemSetListener::~tclSystemSetListener()
{
  // +++ Free resources you might have created/used +++
  m_poSystemSetIF = OSAL_NULL;
  _poMainAppInstance = OSAL_NULL;
  _poCont = OSAL_NULL;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSet
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE:
*
*************************************************************************/
tU32 tclSystemSetListener::vOnSystemSet( tU32 u32SystemSetID,
                                                        diaglib::tenSystemSetType u32SystemSetType,
                                                        diaglib::tContext MsgContext
                                                      )
{
  ETG_TRACE_USR1(("INPUT: SystemSetListener::vOnSystemSet() - MsgContext: %X ", MsgContext ));
  ETG_TRACE_USR1(("INPUT: SystemSetListener::vOnSystemSet() %u", ETG_CENUM(tenSystemSetType, u32SystemSetType)));
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  // temp vars
  diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
  diaglib::tclParameterVector _oErrorList;
  vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));

  switch(u32SystemSetType)
  {
    case diaglib::EN_TYPE_DEFAULT_TEF: //This will be set during PD config update
    case diaglib::EN_TYPE_DEFAULT_HMI: //This will be set during Factory Reset from HMI
    {
      //if(_poMainAppInstance != NULL)	Coverity Fix
	  //{
	    if(_poContainer != NULL)
	    {
	    //	_poContainer->defaultDynamicOffset();
		  ETG_TRACE_USR4((" Called defaultValue"));

		  _poContainer->vFactoryReset();
		  ETG_TRACE_USR4((" Called vFactoryReset: Clear Time format datapool and clear some data"));
	    }
	  //}
    }
    break;
    case diaglib::EN_TYPE_CODING:      //This will be set when Manually time format
    {								   //changed from Diagnostics extended session and keyOnOFFReset
    	if(_poContainer != NULL){
    	  _poContainer->vTimeFormatReset(); //So we only reset time format and update HMI.
  		  ETG_TRACE_USR4((" Called vTimeFormatReset"));
    	}
    }
    break;
    default:
    {
      // other system type -> not supported
      // probably better NOT to return an error, since diag might trigger again and again
	  ETG_TRACE_FATAL((": SystemSetListener::vOnSystemSet() EN_TYPE_UNKNWON"));
    }
    break;
  }

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bSendSystemSetResult( _enSysSetResult, _oErrorList, MsgContext) )
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_USR1(("SystemSetListener::vOnSystemSet() - ERROR sending result"));
    }
  }
  else
  {
    ETG_TRACE_USR1(("SystemSetListener::vOnSystemSet() - ERROR invalid pointer"));
  }

  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSetFinished
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE:
*
*************************************************************************/
tU32 tclSystemSetListener::vOnSystemSetFinished( tU32 u32SystemSetID,
                                                                diaglib::tenSystemSetType u32SystemSetType,
                                                                diaglib::tContext MsgContext
                                                              )
{
  ETG_TRACE_USR1(("INPUT: SystemSetListener::vOnSystemSetFinished() entered"));
  // +++ Reallow access to values that needed default setting, then send positive response +++
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bAcknowledgeSystemSetFinished(MsgContext))
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetFinished() - ERROR giving acknowledge"));
    }
  }
  else
  {
    ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetFinished()- ERROR invalid pointer"));
  }

  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSetPrepare
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE:
*
*************************************************************************/
tU32 tclSystemSetListener::vOnSystemSetPrepare( tU32 u32SystemSetID,
                                                               diaglib::tenSystemSetType u32SystemSetType,
                                                               diaglib::tContext MsgContext
                                                             )
{
  ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetPrepare() entered"));
  // +++ Stop access to values that need default setting, then send positive response +++
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
  diaglib::tclParameterVector _oErrorList;

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bSendSystemSetPrepareResult( _enSysSetResult, _oErrorList, MsgContext ) )
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetPrepare() - ERROR sending result"));
    }
  }
  else
  {
    ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetPrepare() - ERROR: invalid pointer"));
  }

  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSetCheck
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE:
*
*************************************************************************/
tU32 tclSystemSetListener::vOnSystemSetCheck( tU32 u32SystemSetID,
                                                             diaglib::tenSystemSetType u32SystemSetType,
                                                             diaglib::tContext MsgContext
                                                           )
{
  ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetCheck() entered"));
  // +++ Check if all values are set to default. +++
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
  diaglib::tclParameterVector _oErrorList;

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bSendSystemSetCheckResult( _enSysSetResult, _oErrorList, MsgContext) )
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetCheck() - ERROR sending result"));
    }
  }
  else
  {
    ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetCheck() - ERROR invalid pointer"));
  }

  return diaglib::U32_DIAGLIB_RETURN_OK;
}




