
#ifndef _Utf8StringGroupTable_
#define _Utf8StringGroupTable_

class tclUtf8StringGroupTable
{
public:
   virtual int s32GetMaxEntries()
   {
      return 0;
   }
   virtual int s32GetMaxEntrySize()
   {
      return 0;
   }
   virtual bool bIPODSort()
   {
      return false;
   }
   virtual const unsigned char* pcu8GetEntry(int)
   {
      return 0;
   }
protected:
   tclUtf8StringGroupTable() {}
};


class tclUtf8StringGroupTableRussian : public tclUtf8StringGroupTable
{
public:
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   tclUtf8StringGroupTableRussian() {}
   static const int  NumOfEntries = 69-9;
   static const int  EntrySize    =  3;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableRussian oInstance;
};

class tclUtf8StringGroupTableLatin : public tclUtf8StringGroupTable
{
public:
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   tclUtf8StringGroupTableLatin() {}
   static const int  NumOfEntries = 36-9;
   static const int  EntrySize    =  3;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableLatin oInstance;
};

class tclUtf8StringGroupTableGreek : public tclUtf8StringGroupTable
{
public:
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   tclUtf8StringGroupTableGreek() {};
   static const int  NumOfEntries = 60-9 ;
   static const int  EntrySize    = 3  ;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableGreek oInstance;
};

class tclUtf8StringGroupTableArabic : public tclUtf8StringGroupTable
{
public:
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   tclUtf8StringGroupTableArabic() {};
   static const int  NumOfEntries = 65-10 ;
   static const int  EntrySize    = 3  ;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableArabic oInstance;
};

class tclUtf8StringGroupTableThai : public tclUtf8StringGroupTable
{
public:
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   tclUtf8StringGroupTableThai() {};
   static const int  NumOfEntries = 80-9 ;
   static const int  EntrySize    = 4  ;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableThai oInstance;
};

class tclUtf8StringGroupTableChinese : public tclUtf8StringGroupTable
{
public:
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   tclUtf8StringGroupTableChinese() {};
   static const int  NumOfEntries = 36-9;
   static const int  EntrySize    =  3;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableChinese oInstance;
};

class tclUtf8StringGroupTableKorean : public tclUtf8StringGroupTable
{
public:
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   tclUtf8StringGroupTableKorean() {};
   static const int  NumOfEntries = 55-9 ;
   static const int  EntrySize    = 4  ;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableKorean oInstance;
};

class tclUtf8StringGroupTableLatin_ipod : public tclUtf8StringGroupTable
{
public:
   // Return the reference to ipod_tclUtf8StringGroupTableLatin object
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   // Overriden function which return the Max entries in Latin table
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   // Overriden function which returns the sizeof Biggest Latin character
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   // Overriden function which indicates that this is an ipod table
   virtual bool bIPODSort()
   {
      return true;
   }
   // Return the character if index is within the range
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   // Default constructor
   tclUtf8StringGroupTableLatin_ipod() {}
   static const int  NumOfEntries = 27;
   static const int  EntrySize    =  3;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableLatin_ipod oInstance;
};

class tclUtf8StringGroupTableRussian_ipod : public tclUtf8StringGroupTable
{
public:
   // Return the reference to ipod_tclUtf8StringGroupTableRussian object
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   // Overriden function which returns Max entries in Russian Table
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   // Overriden function which return the size of the Biggest Russian character
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   // Overriden function which indicates that this is an ipod table
   virtual bool bIPODSort()
   {
      return true;
   }
   // Return the character if it is within the range
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   // default constructor
   tclUtf8StringGroupTableRussian_ipod() {}
   static const int  NumOfEntries = 60;
   static const int  EntrySize    =  3;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableRussian_ipod oInstance;
};

class tclUtf8StringGroupTableGreek_ipod : public tclUtf8StringGroupTable
{
public:
   // Return the reference to tclUtf8StringGroupTableGreek_ipod object
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   // Overriden function which returns Max entries in Greek Table
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   // Overriden function which return the size of the Biggest Greek character
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   // Overriden function which indicates that this is an ipod table
   virtual bool bIPODSort()
   {
      return true;
   }
   // Return the character if it is within the range
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   // default constructor
   tclUtf8StringGroupTableGreek_ipod() {};
   static const int  NumOfEntries =51 ;
   static const int  EntrySize    = 3  ;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableGreek_ipod oInstance;
};

class tclUtf8StringGroupTableArabic_ipod : public tclUtf8StringGroupTable
{
public:
   // Return the reference to tclUtf8StringGroupTableArabic_ipod object
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   // Overriden function which returns Max entries in Arabic Table
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   // Overriden function which return the size of the Biggest Arabic character
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   // Overriden function which indicates that this is an ipod table
   virtual bool bIPODSort()
   {
      return true;
   }
   // Return the character if it is within the range
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   // default constructor
   tclUtf8StringGroupTableArabic_ipod() {};
   static const int  NumOfEntries =55 ;
   static const int  EntrySize    = 3  ;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableArabic_ipod oInstance;
};

class tclUtf8StringGroupTableThai_ipod : public tclUtf8StringGroupTable
{
public:
   // Return the reference to tclUtf8StringGroupTableThai_ipod object
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   // Overriden function which returns Max entries in Thai Table
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   // Overriden function which return the size of the Biggest Thai character
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   // Overriden function which indicates that this is an ipod table
   virtual bool bIPODSort()
   {
      return true;
   }
   // Return the character if it is within the range
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   // default constructor
   tclUtf8StringGroupTableThai_ipod() {};
   static const int  NumOfEntries =71 ;
   static const int  EntrySize    = 4  ;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableThai_ipod oInstance;
};

class tclUtf8StringGroupTableChinese_ipod : public tclUtf8StringGroupTable
{
public:
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   // Overriden function which indicates that this is an ipod table
   virtual bool bIPODSort()
   {
      return true;
   }
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   tclUtf8StringGroupTableChinese_ipod() {};
   static const int  NumOfEntries = 27;
   static const int  EntrySize    =  3;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableChinese_ipod oInstance;
};

class tclUtf8StringGroupTableKorean_ipod : public tclUtf8StringGroupTable
{
public:
   static tclUtf8StringGroupTable* poGetInstance()
   {
      return &oInstance;
   }
   virtual int s32GetMaxEntries()
   {
      return NumOfEntries;
   }
   virtual int s32GetMaxEntrySize()
   {
      return EntrySize;
   }
   // Overriden function which indicates that this is an ipod table
   virtual bool bIPODSort()
   {
      return true;
   }
   virtual const unsigned char* pcu8GetEntry(int pos)
   {
      return pos<NumOfEntries ? (const unsigned char*)Table[pos] : 0 ;
   }
protected:
   tclUtf8StringGroupTableKorean_ipod() {};
   static const int  NumOfEntries = 55-9 ;
   static const int  EntrySize    = 4  ;
   static const unsigned char Table[NumOfEntries][EntrySize];
   static tclUtf8StringGroupTableKorean_ipod oInstance;
};

#endif //_Utf8StringGroupTable_
