
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Utf8StringGroups.h"
#include "Utf8StringComparator.h"
#include "ipod_Utf8StringComparator.h"

#ifndef TESTGUI
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_MIDW_COMMON_UTF8STRINGGROUPS
#include "trcGenProj/Header/Utf8StringGroups.cpp.trc.h"
#endif

#include "../midw_common_trace.h"    // my trace channel
#include "../midw_common_trace_macros.h"
#else
#define UTF8SORT_DEBUG
#endif //TESTGUI

/*********************************************************************
 *
 *FUNCTION:     tclUtf8StringGroup
 *
 *DESCRIPTION:  Constructor for tclUtf8StringGroup
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
tclUtf8StringGroup::tclUtf8StringGroup(TableType type):poData(NULL)
{
#ifdef UTF8SORT_DEBUG
   printf("tclUtf8StringGroup() type [%i]\n",type);
#else
   ETG_TRACE_USR4(("tclUtf8StringGroup() type [%i]\n",type));
#endif //UTF8SORT_DEBUG

   switch(type) 
   {
   case enTableLatin:
   {
      poData = tclUtf8StringGroupTableLatin::poGetInstance();
   }
   break;
   case enTableRussain:
   {
      poData = tclUtf8StringGroupTableRussian::poGetInstance();
   }
   break;
   case enTableGreek:
   {
      poData = tclUtf8StringGroupTableGreek::poGetInstance();
   }
   break;
   case enTableArabic:
   {
      poData = tclUtf8StringGroupTableArabic::poGetInstance();
   }
   break;
   case enTableThai:
   {
      poData = tclUtf8StringGroupTableThai::poGetInstance();
   }
   break;
   case enTableChinese:
   {
      poData = tclUtf8StringGroupTableChinese::poGetInstance();
   }
   break;
   case enTableKorean:
   {
      poData = tclUtf8StringGroupTableKorean::poGetInstance();
   }
   break;
   case enTableLatin_ipod:
   {
      poData = tclUtf8StringGroupTableLatin_ipod::poGetInstance();
   }
   break;
   case enTableRussain_ipod:
   {
      poData = tclUtf8StringGroupTableRussian_ipod::poGetInstance();
   }
   break;
   case enTableGreek_ipod:
   {
      poData = tclUtf8StringGroupTableGreek_ipod::poGetInstance();
   }
   break;
   case enTableArabic_ipod:
   {
      poData = tclUtf8StringGroupTableArabic_ipod::poGetInstance();
   }
   break;
   case enTableThai_ipod:
   {
      poData = tclUtf8StringGroupTableThai_ipod::poGetInstance();
   }
   break;
   case enTableChinese_ipod:
   {
      poData = tclUtf8StringGroupTableChinese_ipod::poGetInstance();
   }
   break;
   case enTableKorean_ipod:
   {
      poData = tclUtf8StringGroupTableKorean_ipod::poGetInstance();
   }
   break;

   default:
      break;
   }
}
/*********************************************************************
 *
 *FUNCTION:     operator[]
 *
 *DESCRIPTION:  Overloaded scope resolution operator
 *
 *PARAMETER:    index
 *
 *RETURNVALUE:  UTF8 character present at index
 *
 ********************************************************************/
const unsigned char* tclUtf8StringGroup::operator[](int pos)
{
   return poData ? poData->pcu8GetEntry(pos) : 0;
}

/*********************************************************************
 *
 *FUNCTION:     s32GetMaxEntries
 *
 *DESCRIPTION:  Maximum entries in the character group table
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tU32
 *
 ********************************************************************/
int tclUtf8StringGroup::s32GetMaxEntries()
{
#ifdef UTF8SORT_DEBUG
   printf("tclUtf8StringGroup::s32GetMaxEntries() [%i]\n",poData ? poData->s32GetMaxEntries() : 0);
#else
   ETG_TRACE_USR4(("tclUtf8StringGroup::s32GetMaxEntries() [%i]\n",poData ? poData->s32GetMaxEntries() : 0));
#endif //UTF8SORT_DEBUG

   return poData ? poData->s32GetMaxEntries() : 0;
}
/*********************************************************************
 *
 *FUNCTION:     s32GetMaxEntrySize
 *
 *DESCRIPTION:  Size of the Max element entry
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tU32
 *
 ********************************************************************/
int tclUtf8StringGroup::s32GetMaxEntrySize()
{
#ifdef UTF8SORT_DEBUG
   printf("tclUtf8StringGroup::s32GetMaxEntrySize() [%i]\n",poData ? poData->s32GetMaxEntrySize() : 0);
#else
   ETG_TRACE_USR4(("tclUtf8StringGroup::s32GetMaxEntrySize() [%i]\n",poData ? poData->s32GetMaxEntrySize() : 0));
#endif //UTF8SORT_DEBUG

   return poData ? poData->s32GetMaxEntrySize() : 0;
}

/*********************************************************************
 *
 *FUNCTION:     s32GetBaseIndex
 *
 *DESCRIPTION:  Return the Base index
 *
 *PARAMETER:    request string
 *
 *RETURNVALUE:  tU32
 *
 ********************************************************************/
int tclUtf8StringGroup::s32GetBaseIndex(const unsigned char* request)
{
#ifdef UTF8SORT_DEBUG
   printf("tclUtf8StringGroup::s32GetBaseIndex() request[%c], poData [%p]\n",*request, poData);
#else
   ETG_TRACE_USR4(("tclUtf8StringGroup::s32GetBaseIndex() request[%c], poData [%p]\n",*request, poData));
#endif //UTF8SORT_DEBUG

   if(0==request)
   {
      return 0;
   }
   if(0==poData)
   {
      return 0;
   }
   int NumOfEntries = poData->s32GetMaxEntries();

   if(poData->bIPODSort() == true)
   {
      ipod_tclUtf8StringComparator oRequest(request);

      ipod_tclUtf8StringComparator oFirst  (poData->pcu8GetEntry(0));
      if(oRequest <= oFirst)
      {
#ifdef UTF8SORT_DEBUG
         printf("tclUtf8StringGroup::s32GetBaseIndex() ipod oRequest <= oFirst - return 0\n");
#else
         ETG_TRACE_USR4(("tclUtf8StringGroup::s32GetBaseIndex() ipod oRequest <= oFirst - return 0\n"));
#endif //UTF8SORT_DEBUG

         return 0;
      }

      ipod_tclUtf8StringComparator oLast  (poData->pcu8GetEntry(NumOfEntries-1));
      if(oRequest >= oLast)
      {
#ifdef UTF8SORT_DEBUG
         printf("tclUtf8StringGroup::s32GetBaseIndex() ipod oRequest >= oLast - return %i\n", NumOfEntries-1);
#else
         ETG_TRACE_USR4(("tclUtf8StringGroup::s32GetBaseIndex() ipod oRequest >= oLast - return %i\n", NumOfEntries-1));
#endif //UTF8SORT_DEBUG

         return NumOfEntries-1;
      }

      for(int i=1; i<NumOfEntries; i++)
      {
         ipod_tclUtf8StringComparator oBefore(poData->pcu8GetEntry(i-1));
         ipod_tclUtf8StringComparator oAfter (poData->pcu8GetEntry(i)  );
         if( (oRequest>=oBefore)&&(oRequest<oAfter) )
         {
#ifdef UTF8SORT_DEBUG
            printf("tclUtf8StringGroup::s32GetBaseIndex() ipod - return %i\n", i-1);
#else
            ETG_TRACE_USR4(("tclUtf8StringGroup::s32GetBaseIndex() ipod - return %i\n", i-1));
#endif //UTF8SORT_DEBUG

            return i-1;
         }
      }
   }
   else
   {
      tclUtf8StringComparator oRequest(request);

      tclUtf8StringComparator oFirst  (poData->pcu8GetEntry(0));
      if(oRequest <= oFirst)
      {
#ifdef UTF8SORT_DEBUG
         printf("tclUtf8StringGroup::s32GetBaseIndex() oRequest <= oFirst - return 0\n");
#else
         ETG_TRACE_USR4(("tclUtf8StringGroup::s32GetBaseIndex() oRequest <= oFirst - return 0\n"));
#endif //UTF8SORT_DEBUG

         return 0;
      }

      tclUtf8StringComparator oLast  (poData->pcu8GetEntry(NumOfEntries-1));
      if(oRequest >= oLast)
      {
#ifdef UTF8SORT_DEBUG
         printf("tclUtf8StringGroup::s32GetBaseIndex() oRequest >= oLast - return %i\n", NumOfEntries-1);
#else
         ETG_TRACE_USR4(("tclUtf8StringGroup::s32GetBaseIndex() oRequest >= oLast - return %i\n", NumOfEntries-1));
#endif //UTF8SORT_DEBUG

         return NumOfEntries-1;
      }

      for(int i=1; i<NumOfEntries; i++)
      {
         tclUtf8StringComparator oBefore(poData->pcu8GetEntry(i-1));
         tclUtf8StringComparator oAfter (poData->pcu8GetEntry(i)  );
         if( (oRequest>=oBefore)&&(oRequest<oAfter) )
         {
#ifdef UTF8SORT_DEBUG
            printf("tclUtf8StringGroup::s32GetBaseIndex() - return %i\n", i-1);
#else
            ETG_TRACE_USR4(("tclUtf8StringGroup::s32GetBaseIndex() - return %i\n", i-1));
#endif //UTF8SORT_DEBUG

            return i-1;
         }
      }
   }
   return 0;
}


/*********************************************************************
 *
 *TABLE:     tclUtf8StringGroupTableLatin, tclUtf8StringGroupTableRussian
 *
 *DESCRIPTION:  Character tables for language character groups
 *
 *PARAMETER:    request string
 *
 *RETURNVALUE:  tU32
 *
 ********************************************************************/
tclUtf8StringGroupTableLatin   tclUtf8StringGroupTableLatin::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableRussian tclUtf8StringGroupTableRussian::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableGreek tclUtf8StringGroupTableGreek::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableArabic tclUtf8StringGroupTableArabic::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableThai tclUtf8StringGroupTableThai::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableChinese tclUtf8StringGroupTableChinese::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableKorean tclUtf8StringGroupTableKorean::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableLatin_ipod   tclUtf8StringGroupTableLatin_ipod::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableRussian_ipod tclUtf8StringGroupTableRussian_ipod::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableGreek_ipod tclUtf8StringGroupTableGreek_ipod::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableArabic_ipod tclUtf8StringGroupTableArabic_ipod::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableThai_ipod tclUtf8StringGroupTableThai_ipod::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableChinese_ipod tclUtf8StringGroupTableChinese_ipod::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members
tclUtf8StringGroupTableKorean_ipod tclUtf8StringGroupTableKorean_ipod::oInstance; //lint !e1502 Warning 1502: defined object ... of type ... has no nonstatic data members

const unsigned char tclUtf8StringGroupTableLatin::Table[tclUtf8StringGroupTableLatin::NumOfEntries][tclUtf8StringGroupTableLatin::EntrySize] =
{
   {0x30, 0x00, 0x00}, // DIGIT ZERO
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}  // LATIN CAPITAL LETTER Z
};

const unsigned char tclUtf8StringGroupTableRussian::Table[tclUtf8StringGroupTableRussian::NumOfEntries][tclUtf8StringGroupTableRussian::EntrySize] =
{
   {0x30, 0x00, 0x00}, // DIGIT ZERO
   {0xd0, 0x90, 0x00}, // CYRILLIC CAPITAL LETTER A
   {0xd0, 0x91, 0x00}, // CYRILLIC CAPITAL LETTER BE
   {0xd0, 0x92, 0x00}, // CYRILLIC CAPITAL LETTER VE
   {0xd0, 0x93, 0x00}, // CYRILLIC CAPITAL LETTER GHE
   {0xd0, 0x94, 0x00}, // CYRILLIC CAPITAL LETTER DE
   {0xd0, 0x95, 0x00}, // CYRILLIC CAPITAL LETTER IE
   {0xd0, 0x81, 0x00}, // CYRILLIC CAPITAL LETTER IO
   {0xd0, 0x96, 0x00}, // CYRILLIC CAPITAL LETTER ZHE
   {0xd0, 0x97, 0x00}, // CYRILLIC CAPITAL LETTER ZE
   {0xd0, 0x98, 0x00}, // CYRILLIC CAPITAL LETTER I
   {0xd0, 0x99, 0x00}, // CYRILLIC CAPITAL LETTER SHORT I
   {0xd0, 0x9a, 0x00}, // CYRILLIC CAPITAL LETTER KA
   {0xd0, 0x9b, 0x00}, // CYRILLIC CAPITAL LETTER EL
   {0xd0, 0x9c, 0x00}, // CYRILLIC CAPITAL LETTER EM
   {0xd0, 0x9d, 0x00}, // CYRILLIC CAPITAL LETTER EN
   {0xd0, 0x9e, 0x00}, // CYRILLIC CAPITAL LETTER O
   {0xd0, 0x9f, 0x00}, // CYRILLIC CAPITAL LETTER PE
   {0xd0, 0xa0, 0x00}, // CYRILLIC CAPITAL LETTER ER
   {0xd0, 0xa1, 0x00}, // CYRILLIC CAPITAL LETTER ES
   {0xd0, 0xa2, 0x00}, // CYRILLIC CAPITAL LETTER TE
   {0xd0, 0xa3, 0x00}, // CYRILLIC CAPITAL LETTER U
   {0xd0, 0xa4, 0x00}, // CYRILLIC CAPITAL LETTER EF
   {0xd0, 0xa5, 0x00}, // CYRILLIC CAPITAL LETTER HA
   {0xd0, 0xa6, 0x00}, // CYRILLIC CAPITAL LETTER TSE
   {0xd0, 0xa7, 0x00}, // CYRILLIC CAPITAL LETTER CHE
   {0xd0, 0xa8, 0x00}, // CYRILLIC CAPITAL LETTER SHA
   {0xd0, 0xa9, 0x00}, // CYRILLIC CAPITAL LETTER SHCHA
   {0xd0, 0xaa, 0x00}, // CYRILLIC CAPITAL LETTER HARD SIGN
   {0xd0, 0xab, 0x00}, // CYRILLIC CAPITAL LETTER YERU
   {0xd0, 0xac, 0x00}, // CYRILLIC CAPITAL LETTER SOFT SIGN
   {0xd0, 0xad, 0x00}, // CYRILLIC CAPITAL LETTER E
   {0xd0, 0xae, 0x00}, // CYRILLIC CAPITAL LETTER YU
   {0xd0, 0xaf, 0x00}, // CYRILLIC CAPITAL LETTER YA
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}  // LATIN CAPITAL LETTER Z
};

const unsigned char tclUtf8StringGroupTableGreek::Table[tclUtf8StringGroupTableGreek::NumOfEntries][tclUtf8StringGroupTableGreek::EntrySize] =
{
   {0x30, 0x00, 0x00}, // DIGIT ZERO
   {0xCE, 0x91, 0x00}, // GREEK CAPITAL LETTER ALPHA
   {0xCE, 0x92, 0x00}, // GREEK CAPITAL LETTER BETA
   {0xCE, 0x93, 0x00}, // GREEK CAPITAL LETTER GAMMA
   {0xCE, 0x94, 0x00}, // GREEK CAPITAL LETTER DELTA
   {0xCE, 0x95, 0x00}, // GREEK CAPITAL LETTER EPSILON
   {0xCE, 0x96, 0x00}, // GREEK CAPITAL LETTER ZETA
   {0xCE, 0x97, 0x00}, // GREEK CAPITAL LETTER ETA
   {0xCE, 0x98, 0x00}, // GREEK CAPITAL LETTER THETA
   {0xCE, 0x99, 0x00}, // GREEK CAPITAL LETTER IOTA
   {0xCE, 0x9A, 0x00}, // GREEK CAPITAL LETTER KAPPA
   {0xCE, 0x9B, 0x00}, // GREEK CAPITAL LETTER LAMDA
   {0xCE, 0x9C, 0x00}, // GREEK CAPITAL LETTER MU
   {0xCE, 0x9D, 0x00}, // GREEK CAPITAL LETTER NU
   {0xCE, 0x9E, 0x00}, // GREEK CAPITAL LETTER XI
   {0xCE, 0x9F, 0x00}, // GREEK CAPITAL LETTER OMICRON
   {0xCE, 0xA0, 0x00}, // GREEK CAPITAL LETTER PI
   {0xCE, 0xA1, 0x00}, // GREEK CAPITAL LETTER RHO
   {0xCE, 0xA3, 0x00}, // GREEK CAPITAL LETTER SIGMA
   {0xCE, 0xA4, 0x00}, // GREEK CAPITAL LETTER TAU
   {0xCE, 0xA5, 0x00}, // GREEK CAPITAL LETTER UPSILON
   {0xCE, 0xA6, 0x00}, // GREEK CAPITAL LETTER PHI
   {0xCE, 0xA7, 0x00}, // GREEK CAPITAL LETTER CHI
   {0xCE, 0xA8, 0x00}, // GREEK CAPITAL LETTER PSI
   {0xCE, 0xA9, 0x00}, // GREEK CAPITAL LETTER OMEGA
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}  // LATIN CAPITAL LETTER Z
};

const unsigned char tclUtf8StringGroupTableArabic::Table[tclUtf8StringGroupTableArabic::NumOfEntries][tclUtf8StringGroupTableArabic::EntrySize] =
{
   {0x30, 0x00, 0x00}, // DIGIT ZERO
   {0xD8, 0xA7, 0x00}, //
   {0xD8, 0xA8, 0x00}, //
   {0xD8, 0xAA, 0x00}, //
   {0xD8, 0xAB, 0x00}, //
   {0xD8, 0xAC, 0x00}, //
   {0xD8, 0xAD, 0x00}, //
   {0xD8, 0xAE, 0x00}, //
   {0xD8, 0xAF, 0x00}, //
   {0xD8, 0xB0, 0x00}, //
   {0xD8, 0xB1, 0x00}, //
   {0xD8, 0xB2, 0x00}, //
   {0xD8, 0xB3, 0x00}, //
   {0xD8, 0xB4, 0x00}, //
   {0xD8, 0xB5, 0x00}, //
   {0xD8, 0xB6, 0x00}, //
   {0xD8, 0xB7, 0x00}, //
   {0xD8, 0xB8, 0x00}, //
   {0xD8, 0xB9, 0x00}, //
   {0xD8, 0xBA, 0x00}, //
   {0xD9, 0x81, 0x00}, //
   {0xD9, 0x82, 0x00}, //
   {0xD9, 0x83, 0x00}, //
   {0xD9, 0x84, 0x00}, //
   {0xD9, 0x85, 0x00}, //
   {0xD9, 0x86, 0x00}, //
   {0xD9, 0x87, 0x00}, //
   {0xD9, 0x88, 0x00}, //
   {0xD9, 0x8A, 0x00}, //
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}  // LATIN CAPITAL LETTER Z
};

const unsigned char tclUtf8StringGroupTableThai::Table[tclUtf8StringGroupTableThai::NumOfEntries][tclUtf8StringGroupTableThai::EntrySize] =
{
   {0x30, 0x00, 0x00, 0x00}, // DIGIT ZERO
   {0xE0, 0xB8, 0x81, 0x00}, // THAI CHARACTER KO KAI
   {0xE0, 0xB8, 0x82, 0x00}, // THAI CHARACTER KHO KHAI
   {0xE0, 0xB8, 0x83, 0x00}, // THAI CHARACTER KHO KHUAT
   {0xE0, 0xB8, 0x84, 0x00}, // THAI CHARACTER KHO KHWAI
   {0xE0, 0xB8, 0x85, 0x00}, // THAI CHARACTER KHO KHON
   {0xE0, 0xB8, 0x86, 0x00}, // THAI CHARACTER KHO RAKHANG
   {0xE0, 0xB8, 0x87, 0x00}, // THAI CHARACTER NGO NGU
   {0xE0, 0xB8, 0x88, 0x00}, // THAI CHARACTER CHO CHAN
   {0xE0, 0xB8, 0x89, 0x00}, // THAI CHARACTER CHO CHING
   {0xE0, 0xB8, 0x8A, 0x00}, // THAI CHARACTER CHO CHANG
   {0xE0, 0xB8, 0x8B, 0x00}, // THAI CHARACTER SO SO
   {0xE0, 0xB8, 0x8C, 0x00}, // THAI CHARACTER CHO CHOE
   {0xE0, 0xB8, 0x8D, 0x00}, // THAI CHARACTER YO YING
   {0xE0, 0xB8, 0x8E, 0x00}, // THAI CHARACTER DO CHADA
   {0xE0, 0xB8, 0x8F, 0x00}, // THAI CHARACTER TO PATAK
   {0xE0, 0xB8, 0x90, 0x00}, // THAI CHARACTER THO THAN
   {0xE0, 0xB8, 0x91, 0x00}, // THAI CHARACTER THO NANGMONTHO
   {0xE0, 0xB8, 0x92, 0x00}, // THAI CHARACTER THO PHUTHAO
   {0xE0, 0xB8, 0x93, 0x00}, // THAI CHARACTER NO NEN
   {0xE0, 0xB8, 0x94, 0x00}, // THAI CHARACTER DO DEK
   {0xE0, 0xB8, 0x95, 0x00}, // THAI CHARACTER TO TAO
   {0xE0, 0xB8, 0x96, 0x00}, // THAI CHARACTER THO THUNG
   {0xE0, 0xB8, 0x97, 0x00}, // THAI CHARACTER THO THAHAN
   {0xE0, 0xB8, 0x98, 0x00}, // THAI CHARACTER THO THONG
   {0xE0, 0xB8, 0x99, 0x00}, // THAI CHARACTER NO NU
   {0xE0, 0xB8, 0x9A, 0x00}, // THAI CHARACTER BO BAIMAI
   {0xE0, 0xB8, 0x9B, 0x00}, // THAI CHARACTER PO PLA
   {0xE0, 0xB8, 0x9C, 0x00}, // THAI CHARACTER PHO PHUNG
   {0xE0, 0xB8, 0x9D, 0x00}, // THAI CHARACTER FO FA
   {0xE0, 0xB8, 0x9E, 0x00}, // THAI CHARACTER PHO PHAN
   {0xE0, 0xB8, 0x9F, 0x00}, // THAI CHARACTER FO FAN
   {0xE0, 0xB8, 0xA0, 0x00}, // THAI CHARACTER PHO SAMPHAO
   {0xE0, 0xB8, 0xA1, 0x00}, // THAI CHARACTER MO MA
   {0xE0, 0xB8, 0xA2, 0x00}, // THAI CHARACTER YO YAK
   {0xE0, 0xB8, 0xA3, 0x00}, // THAI CHARACTER RO RUA
   {0xE0, 0xB8, 0xA5, 0x00}, // THAI CHARACTER LO LING
   {0xE0, 0xB8, 0xA7, 0x00}, // THAI CHARACTER WO WAEN
   {0xE0, 0xB8, 0xA8, 0x00}, // THAI CHARACTER SO SALA
   {0xE0, 0xB8, 0xA9, 0x00}, // THAI CHARACTER SO RUSI
   {0xE0, 0xB8, 0xAA, 0x00}, // THAI CHARACTER SO SUA
   {0xE0, 0xB8, 0xAB, 0x00}, // THAI CHARACTER HO HIP
   {0xE0, 0xB8, 0xAC, 0x00}, // THAI CHARACTER LO CHULA
   {0xE0, 0xB8, 0xAD, 0x00}, // THAI CHARACTER O ANG
   {0xE0, 0xB8, 0xAE, 0x00}, // THAI CHARACTER HO NOKHUK
   {0x41, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00, 0x00}  // LATIN CAPITAL LETTER Z
};

const unsigned char tclUtf8StringGroupTableChinese::Table[tclUtf8StringGroupTableChinese::NumOfEntries][tclUtf8StringGroupTableChinese::EntrySize] =
{
   {0x30, 0x00, 0x00}, // DIGIT ZERO
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}  // LATIN CAPITAL LETTER Z
};

const unsigned char tclUtf8StringGroupTableKorean::Table[tclUtf8StringGroupTableKorean::NumOfEntries][tclUtf8StringGroupTableKorean::EntrySize] =
{
   {0x30, 0x00, 0x00, 0x00}, // DIGIT ZERO
   {0xE1, 0x84, 0x80, 0x00}, // KOREAN HANGUL CHOSEONG KIYEOK
   {0xE1, 0x84, 0x81, 0x00}, // KOREAN HANGUL CHOSEONG SSANGKIYEOK
   {0xE1, 0x84, 0x82, 0x00}, // KOREAN HANGUL CHOSEONG NIEUN
   {0xE1, 0x84, 0x83, 0x00}, // KOREAN HANGUL CHOSEONG TIKEUT
   {0xE1, 0x84, 0x84, 0x00}, // KOREAN HANGUL CHOSEONG SSANGTIKEUT
   {0xE1, 0x84, 0x85, 0x00}, // KOREAN HANGUL CHOSEONG RIEUL
   {0xE1, 0x84, 0x86, 0x00}, // KOREAN HANGUL CHOSEONG MIEUM
   {0xE1, 0x84, 0x87, 0x00}, // KOREAN HANGUL CHOSEONG PIEUP
   {0xE1, 0x84, 0x88, 0x00}, // KOREAN HANGUL CHOSEONG SSANGPIEUP
   {0xE1, 0x84, 0x89, 0x00}, // KOREAN HANGUL CHOSEONG SIOS
   {0xE1, 0x84, 0x8A, 0x00}, // KOREAN HANGUL CHOSEONG SSANGSIOS
   {0xE1, 0x84, 0x8B, 0x00}, // KOREAN HANGUL CHOSEONG IEUNG
   {0xE1, 0x84, 0x8C, 0x00}, // KOREAN HANGUL CHOSEONG CIEUC
   {0xE1, 0x84, 0x8D, 0x00}, // KOREAN HANGUL CHOSEONG SSANGCIEUC
   {0xE1, 0x84, 0x8E, 0x00}, // KOREAN HANGUL CHOSEONG CHIEUCH
   {0xE1, 0x84, 0x8F, 0x00}, // KOREAN HANGUL CHOSEONG KHIEUKH
   {0xE1, 0x84, 0x90, 0x00}, // KOREAN HANGUL CHOSEONG THIEUTH
   {0xE1, 0x84, 0x91, 0x00}, // KOREAN HANGUL CHOSEONG PHIEUPH
   {0xE1, 0x84, 0x92, 0x00}, // KOREAN HANGUL CHOSEONG HIEUH
   {0x41, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00, 0x00}  // LATIN CAPITAL LETTER Z
};

const unsigned char tclUtf8StringGroupTableLatin_ipod::Table[tclUtf8StringGroupTableLatin_ipod::NumOfEntries][tclUtf8StringGroupTableLatin_ipod::EntrySize] =
{
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}, // LATIN CAPITAL LETTER Z
   {0x30, 0x00, 0x00}  /* // DIGIT ZERO
   {0x31, 0x00, 0x00}, // DIGIT ONE
   {0x32, 0x00, 0x00}, // DIGIT TWO
   {0x33, 0x00, 0x00}, // DIGIT THREE
   {0x34, 0x00, 0x00}, // DIGIT FOUR
   {0x35, 0x00, 0x00}, // DIGIT FIVE
   {0x36, 0x00, 0x00}, // DIGIT SIX
   {0x37, 0x00, 0x00}, // DIGIT SEVEN
   {0x38, 0x00, 0x00}, // DIGIT EIGHT
   {0x39, 0x00, 0x00}  // DIGIT NINE */
};

const unsigned char tclUtf8StringGroupTableRussian_ipod::Table[tclUtf8StringGroupTableRussian_ipod::NumOfEntries][tclUtf8StringGroupTableRussian_ipod::EntrySize] =
{
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}, // LATIN CAPITAL LETTER Z
   {0xd0, 0x90, 0x00}, //  CYRILLIC CAPITAL LETTER A
   {0xd0, 0x91, 0x00}, //  CYRILLIC CAPITAL LETTER BE
   {0xd0, 0x92, 0x00}, //  CYRILLIC CAPITAL LETTER VE
   {0xd0, 0x93, 0x00}, //  CYRILLIC CAPITAL LETTER GHE
   {0xd0, 0x94, 0x00}, //  CYRILLIC CAPITAL LETTER DE
   {0xd0, 0x95, 0x00}, //  CYRILLIC CAPITAL LETTER IE
   {0xd0, 0x81, 0x00}, //  CYRILLIC CAPITAL LETTER IO
   {0xd0, 0x96, 0x00}, //  CYRILLIC CAPITAL LETTER ZHE
   {0xd0, 0x97, 0x00}, //  CYRILLIC CAPITAL LETTER ZE
   {0xd0, 0x98, 0x00}, //  CYRILLIC CAPITAL LETTER I
   {0xd0, 0x99, 0x00}, //  CYRILLIC CAPITAL LETTER SHORT I
   {0xd0, 0x9a, 0x00}, //  CYRILLIC CAPITAL LETTER KA
   {0xd0, 0x9b, 0x00}, //  CYRILLIC CAPITAL LETTER EL
   {0xd0, 0x9c, 0x00}, //  CYRILLIC CAPITAL LETTER EM
   {0xd0, 0x9d, 0x00}, //  CYRILLIC CAPITAL LETTER EN
   {0xd0, 0x9e, 0x00}, //  CYRILLIC CAPITAL LETTER O
   {0xd0, 0x9f, 0x00}, //  CYRILLIC CAPITAL LETTER PE
   {0xd0, 0xa0, 0x00}, //  CYRILLIC CAPITAL LETTER ER
   {0xd0, 0xa1, 0x00}, //  CYRILLIC CAPITAL LETTER ES
   {0xd0, 0xa2, 0x00}, //  CYRILLIC CAPITAL LETTER TE
   {0xd0, 0xa3, 0x00}, //  CYRILLIC CAPITAL LETTER U
   {0xd0, 0xa4, 0x00}, //  CYRILLIC CAPITAL LETTER EF
   {0xd0, 0xa5, 0x00}, //  CYRILLIC CAPITAL LETTER HA
   {0xd0, 0xa6, 0x00}, //  CYRILLIC CAPITAL LETTER TSE
   {0xd0, 0xa7, 0x00}, //  CYRILLIC CAPITAL LETTER CHE
   {0xd0, 0xa8, 0x00}, //  CYRILLIC CAPITAL LETTER SHA
   {0xd0, 0xa9, 0x00}, //  CYRILLIC CAPITAL LETTER SHCHA
   {0xd0, 0xaa, 0x00}, //  CYRILLIC CAPITAL LETTER HARD SIGN
   {0xd0, 0xab, 0x00}, //  CYRILLIC CAPITAL LETTER YERU
   {0xd0, 0xac, 0x00}, //  CYRILLIC CAPITAL LETTER SOFT SIGN
   {0xd0, 0xad, 0x00}, //  CYRILLIC CAPITAL LETTER E
   {0xd0, 0xae, 0x00}, //  CYRILLIC CAPITAL LETTER YU
   {0xd0, 0xaf, 0x00}, //  CYRILLIC CAPITAL LETTER YA
   {0x30, 0x00, 0x00}  /* // DIGIT ZERO
   {0x31, 0x00, 0x00}, // DIGIT ONE
   {0x32, 0x00, 0x00}, // DIGIT TWO
   {0x33, 0x00, 0x00}, // DIGIT THREE
   {0x34, 0x00, 0x00}, // DIGIT FOUR
   {0x35, 0x00, 0x00}, // DIGIT FIVE
   {0x36, 0x00, 0x00}, // DIGIT SIX
   {0x37, 0x00, 0x00}, // DIGIT SEVEN
   {0x38, 0x00, 0x00}, // DIGIT EIGHT
   {0x39, 0x00, 0x00}  // DIGIT NINE */
};

const unsigned char tclUtf8StringGroupTableGreek_ipod::Table[tclUtf8StringGroupTableGreek_ipod::NumOfEntries][tclUtf8StringGroupTableGreek_ipod::EntrySize] =
{
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}, // LATIN CAPITAL LETTER Z
   {0xCE, 0x91, 0x00}, // GREEK CAPITAL LETTER ALPHA
   {0xCE, 0x92, 0x00}, // GREEK CAPITAL LETTER BETA
   {0xCE, 0x93, 0x00}, // GREEK CAPITAL LETTER GAMMA
   {0xCE, 0x94, 0x00}, // GREEK CAPITAL LETTER DELTA
   {0xCE, 0x95, 0x00}, // GREEK CAPITAL LETTER EPSILON
   {0xCE, 0x96, 0x00}, // GREEK CAPITAL LETTER ZETA
   {0xCE, 0x97, 0x00}, // GREEK CAPITAL LETTER ETA
   {0xCE, 0x98, 0x00}, // GREEK CAPITAL LETTER THETA
   {0xCE, 0x99, 0x00}, // GREEK CAPITAL LETTER IOTA
   {0xCE, 0x9A, 0x00}, // GREEK CAPITAL LETTER KAPPA
   {0xCE, 0x9B, 0x00}, // GREEK CAPITAL LETTER LAMDA
   {0xCE, 0x9C, 0x00}, // GREEK CAPITAL LETTER MU
   {0xCE, 0x9D, 0x00}, // GREEK CAPITAL LETTER NU
   {0xCE, 0x9E, 0x00}, // GREEK CAPITAL LETTER XI
   {0xCE, 0x9F, 0x00}, // GREEK CAPITAL LETTER OMICRON
   {0xCE, 0xA0, 0x00}, // GREEK CAPITAL LETTER PI
   {0xCE, 0xA1, 0x00}, // GREEK CAPITAL LETTER RHO
   {0xCE, 0xA3, 0x00}, // GREEK CAPITAL LETTER SIGMA
   {0xCE, 0xA4, 0x00}, // GREEK CAPITAL LETTER TAU
   {0xCE, 0xA5, 0x00}, // GREEK CAPITAL LETTER UPSILON
   {0xCE, 0xA6, 0x00}, // GREEK CAPITAL LETTER PHI
   {0xCE, 0xA7, 0x00}, // GREEK CAPITAL LETTER CHI
   {0xCE, 0xA8, 0x00}, // GREEK CAPITAL LETTER PSI
   {0xCE, 0xA9, 0x00}, // GREEK CAPITAL LETTER OMEGA
   {0x30, 0x00, 0x00}  /* // DIGIT ZERO
   {0x31, 0x00, 0x00}, // DIGIT ONE
   {0x32, 0x00, 0x00}, // DIGIT TWO
   {0x33, 0x00, 0x00}, // DIGIT THREE
   {0x34, 0x00, 0x00}, // DIGIT FOUR
   {0x35, 0x00, 0x00}, // DIGIT FIVE
   {0x36, 0x00, 0x00}, // DIGIT SIX
   {0x37, 0x00, 0x00}, // DIGIT SEVEN
   {0x38, 0x00, 0x00}, // DIGIT EIGHT
   {0x39, 0x00, 0x00}  // DIGIT NINE */
};

const unsigned char tclUtf8StringGroupTableArabic_ipod::Table[tclUtf8StringGroupTableArabic_ipod::NumOfEntries][tclUtf8StringGroupTableArabic_ipod::EntrySize] =
{
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}, // LATIN CAPITAL LETTER Z
   //{0x00, 0xA7, 0xA7}, //
   //{0x00, 0xD8, 0xA8}, //
   //{0x00, 0xD8, 0xAA}, //
   //{0x00, 0xD8, 0xAB}, //
   //{0x00, 0xD8, 0xAC}, //
   //{0x00, 0xD8, 0xAD}, //
   //{0x00, 0xD8, 0xAE}, //
   //{0x00, 0xD8, 0xAF}, //
   //{0x00, 0xD8, 0xB0}, //
   //{0x00, 0xD8, 0xB1}, //
   //{0x00, 0xD8, 0xB2}, //
   //{0x00, 0xD8, 0xB3}, //
   //{0x00, 0xD8, 0xB4}, //
   //{0x00, 0xD8, 0xB5}, //
   //{0x00, 0xD8, 0xB6}, //
   //{0x00, 0xD8, 0xB7}, //
   //{0x00, 0xD8, 0xB8}, //
   //{0x00, 0xD8, 0xB9}, //
   //{0x00, 0xD8, 0xBA}, //
   //{0x00, 0xD8, 0x81}, //
   //{0x00, 0xD8, 0x82}, //
   //{0x00, 0xD8, 0x83}, //
   //{0x00, 0xD8, 0x84}, //
   //{0x00, 0xD8, 0x85}, //
   //{0x00, 0xD8, 0x86}, //
   //{0x00, 0xD8, 0x87}, //
   //{0x00, 0xD8, 0x88}, //
   //{0x00, 0xD8, 0x89}, //
   //{0x00, 0xD8, 0x8A}, //

   {0xD8, 0xA7, 0x00}, //
   {0xD8, 0xA8, 0x00}, //
   {0xD8, 0xAA, 0x00}, //
   {0xD8, 0xAB, 0x00}, //
   {0xD8, 0xAC, 0x00}, //
   {0xD8, 0xAD, 0x00}, //
   {0xD8, 0xAE, 0x00}, //
   {0xD8, 0xAF, 0x00}, //
   {0xD8, 0xB0, 0x00}, //
   {0xD8, 0xB1, 0x00}, //
   {0xD8, 0xB2, 0x00}, //
   {0xD8, 0xB3, 0x00}, //
   {0xD8, 0xB4, 0x00}, //
   {0xD8, 0xB5, 0x00}, //
   {0xD8, 0xB6, 0x00}, //
   {0xD8, 0xB7, 0x00}, //
   {0xD8, 0xB8, 0x00}, //
   {0xD8, 0xB9, 0x00}, //
   {0xD8, 0xBA, 0x00}, //
   {0xD9, 0x81, 0x00}, //
   {0xD9, 0x82, 0x00}, //
   {0xD9, 0x83, 0x00}, //
   {0xD9, 0x84, 0x00}, //
   {0xD9, 0x85, 0x00}, //
   {0xD9, 0x86, 0x00}, //
   {0xD9, 0x87, 0x00}, //
   {0xD9, 0x88, 0x00}, //
   {0xD9, 0x8A, 0x00}, //
   {0x30, 0x00, 0x00}  /* // DIGIT ZERO
   {0x31, 0x00, 0x00}, // DIGIT ONE
   {0x32, 0x00, 0x00}, // DIGIT TWO
   {0x33, 0x00, 0x00}, // DIGIT THREE
   {0x34, 0x00, 0x00}, // DIGIT FOUR
   {0x35, 0x00, 0x00}, // DIGIT FIVE
   {0x36, 0x00, 0x00}, // DIGIT SIX
   {0x37, 0x00, 0x00}, // DIGIT SEVEN
   {0x38, 0x00, 0x00}, // DIGIT EIGHT
   {0x39, 0x00, 0x00}  // DIGIT NINE */
};

const unsigned char tclUtf8StringGroupTableThai_ipod::Table[tclUtf8StringGroupTableThai_ipod::NumOfEntries][tclUtf8StringGroupTableThai_ipod::EntrySize] =
{

   {0x41, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Z
   {0xE0, 0xB8, 0x81, 0x00}, // THAI CHARACTER KO KAI
   {0xE0, 0xB8, 0x82, 0x00}, // THAI CHARACTER KHO KHAI
   {0xE0, 0xB8, 0x83, 0x00}, // THAI CHARACTER KHO KHUAT
   {0xE0, 0xB8, 0x84, 0x00}, // THAI CHARACTER KHO KHWAI
   {0xE0, 0xB8, 0x85, 0x00}, // THAI CHARACTER KHO KHON
   {0xE0, 0xB8, 0x86, 0x00}, //  THAI CHARACTER KHO RAKHANG
   {0xE0, 0xB8, 0x87, 0x00}, //  THAI CHARACTER NGO NGU
   {0xE0, 0xB8, 0x88, 0x00}, //  THAI CHARACTER CHO CHAN
   {0xE0, 0xB8, 0x89, 0x00}, //  THAI CHARACTER CHO CHING
   {0xE0, 0xB8, 0x8A, 0x00}, // THAI CHARACTER CHO CHANG
   {0xE0, 0xB8, 0x8B, 0x00}, // THAI CHARACTER SO SO
   {0xE0, 0xB8, 0x8C, 0x00}, // THAI CHARACTER CHO CHOE
   {0xE0, 0xB8, 0x8D, 0x00}, // THAI CHARACTER YO YING
   {0xE0, 0xB8, 0x8E, 0x00}, //THAI CHARACTER DO CHADA
   {0xE0, 0xB8, 0x8F, 0x00}, // THAI CHARACTER TO PATAK
   {0xE0, 0xB8, 0x90, 0x00}, // THAI CHARACTER THO THAN
   {0xE0, 0xB8, 0x91, 0x00}, // THAI CHARACTER THO NANGMONTHO
   {0xE0, 0xB8, 0x92, 0x00}, //THAI CHARACTER THO PHUTHAO
   {0xE0, 0xB8, 0x93, 0x00}, // THAI CHARACTER NO NEN
   {0xE0, 0xB8, 0x94, 0x00}, // THAI CHARACTER DO DEK
   {0xE0, 0xB8, 0x95, 0x00}, // THAI CHARACTER TO TAO
   {0xE0, 0xB8, 0x96, 0x00}, // THAI CHARACTER THO THUNG
   {0xE0, 0xB8, 0x97, 0x00}, // THAI CHARACTER THO THAHAN
   {0xE0, 0xB8, 0x98, 0x00}, // THAI CHARACTER THO THONG
   {0xE0, 0xB8, 0x99, 0x00}, // THAI CHARACTER NO NU
   {0xE0, 0xB8, 0x9A, 0x00}, // THAI CHARACTER BO BAIMAI
   {0xE0, 0xB8, 0x9B, 0x00}, //THAI CHARACTER PO PLA
   {0xE0, 0xB8, 0x9C, 0x00}, // THAI CHARACTER PHO PHUNG
   {0xE0, 0xB8, 0x9D, 0x00}, // THAI CHARACTER FO FA
   {0xE0, 0xB8, 0x9E, 0x00}, //  THAI CHARACTER PHO PHAN
   {0xE0, 0xB8, 0x9F, 0x00}, // THAI CHARACTER FO FAN
   {0xE0, 0xB8, 0xA0, 0x00}, // THAI CHARACTER PHO SAMPHAO
   {0xE0, 0xB8, 0xA1, 0x00}, // THAI CHARACTER MO MA
   {0xE0, 0xB8, 0xA2, 0x00}, // THAI CHARACTER YO YAK
   {0xE0, 0xB8, 0xA3, 0x00}, // THAI CHARACTER RO RUA
   {0xE0, 0xB8, 0xA5, 0x00}, // THAI CHARACTER LO LING
   {0xE0, 0xB8, 0xA7, 0x00}, // THAI CHARACTER WO WAEN
   {0xE0, 0xB8, 0xA8, 0x00}, // THAI CHARACTER SO SALA
   {0xE0, 0xB8, 0xA9, 0x00}, // THAI CHARACTER SO RUSI
   {0xE0, 0xB8, 0xAA, 0x00}, // THAI CHARACTER SO SUA
   {0xE0, 0xB8, 0xAB, 0x00}, // THAI CHARACTER HO HIP
   {0xE0, 0xB8, 0xAC, 0x00}, // THAI CHARACTER LO CHULA
   {0xE0, 0xB8, 0xAD, 0x00}, // THAI CHARACTER O ANG
   {0xE0, 0xB8, 0xAE, 0x00}, // THAI CHARACTER HO NOKHUK
   {0x30, 0x00, 0x00, 0x00}  /* // DIGIT ZERO
   {0x31, 0x00, 0x00}, // DIGIT ONE
   {0x32, 0x00, 0x00}, // DIGIT TWO
   {0x33, 0x00, 0x00}, // DIGIT THREE
   {0x34, 0x00, 0x00}, // DIGIT FOUR
   {0x35, 0x00, 0x00}, // DIGIT FIVE
   {0x36, 0x00, 0x00}, // DIGIT SIX
   {0x37, 0x00, 0x00}, // DIGIT SEVEN
   {0x38, 0x00, 0x00}, // DIGIT EIGHT
   {0x39, 0x00, 0x00}  // DIGIT NINE */
};

const unsigned char tclUtf8StringGroupTableChinese_ipod::Table[tclUtf8StringGroupTableChinese_ipod::NumOfEntries][tclUtf8StringGroupTableChinese_ipod::EntrySize] =
{
   {0x41, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00}, // LATIN CAPITAL LETTER Z
   {0x30, 0x00, 0x00}  /* // DIGIT ZERO
   {0x31, 0x00, 0x00}, // DIGIT ONE
   {0x32, 0x00, 0x00}, // DIGIT TWO
   {0x33, 0x00, 0x00}, // DIGIT THREE
   {0x34, 0x00, 0x00}, // DIGIT FOUR
   {0x35, 0x00, 0x00}, // DIGIT FIVE
   {0x36, 0x00, 0x00}, // DIGIT SIX
   {0x37, 0x00, 0x00}, // DIGIT SEVEN
   {0x38, 0x00, 0x00}, // DIGIT EIGHT
   {0x39, 0x00, 0x00}  // DIGIT NINE */
};

const unsigned char tclUtf8StringGroupTableKorean_ipod::Table[tclUtf8StringGroupTableKorean_ipod::NumOfEntries][tclUtf8StringGroupTableKorean_ipod::EntrySize] =
{
   {0x41, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER A
   {0x42, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER B
   {0x43, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER C
   {0x44, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER D
   {0x45, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER E
   {0x46, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER F
   {0x47, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER G
   {0x48, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER H
   {0x49, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER I
   {0x4a, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER J
   {0x4b, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER K
   {0x4c, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER L
   {0x4d, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER M
   {0x4e, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER N
   {0x4f, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER O
   {0x50, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER P
   {0x51, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Q
   {0x52, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER R
   {0x53, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER S
   {0x54, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER T
   {0x55, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER U
   {0x56, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER V
   {0x57, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER W
   {0x58, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER X
   {0x59, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Y
   {0x5a, 0x00, 0x00, 0x00}, // LATIN CAPITAL LETTER Z
   {0xE1, 0x84, 0x80, 0x00}, // KOREAN HANGUL CHOSEONG KIYEOK
   {0xE1, 0x84, 0x81, 0x00}, // KOREAN HANGUL CHOSEONG SSANGKIYEOK
   {0xE1, 0x84, 0x82, 0x00}, // KOREAN HANGUL CHOSEONG NIEUN
   {0xE1, 0x84, 0x83, 0x00}, // KOREAN HANGUL CHOSEONG TIKEUT
   {0xE1, 0x84, 0x84, 0x00}, // KOREAN HANGUL CHOSEONG SSANGTIKEUT
   {0xE1, 0x84, 0x85, 0x00}, // KOREAN HANGUL CHOSEONG RIEUL
   {0xE1, 0x84, 0x86, 0x00}, // KOREAN HANGUL CHOSEONG MIEUM
   {0xE1, 0x84, 0x87, 0x00}, // KOREAN HANGUL CHOSEONG PIEUP
   {0xE1, 0x84, 0x88, 0x00}, // KOREAN HANGUL CHOSEONG SSANGPIEUP
   {0xE1, 0x84, 0x89, 0x00}, // KOREAN HANGUL CHOSEONG SIOS
   {0xE1, 0x84, 0x8A, 0x00}, // KOREAN HANGUL CHOSEONG SSANGSIOS
   {0xE1, 0x84, 0x8B, 0x00}, // KOREAN HANGUL CHOSEONG IEUNG
   {0xE1, 0x84, 0x8C, 0x00}, // KOREAN HANGUL CHOSEONG CIEUC
   {0xE1, 0x84, 0x8D, 0x00}, // KOREAN HANGUL CHOSEONG SSANGCIEUC
   {0xE1, 0x84, 0x8E, 0x00}, // KOREAN HANGUL CHOSEONG CHIEUCH
   {0xE1, 0x84, 0x8F, 0x00}, // KOREAN HANGUL CHOSEONG KHIEUKH
   {0xE1, 0x84, 0x90, 0x00}, // KOREAN HANGUL CHOSEONG THIEUTH
   {0xE1, 0x84, 0x91, 0x00}, // KOREAN HANGUL CHOSEONG PHIEUPH
   {0xE1, 0x84, 0x92, 0x00}, // KOREAN HANGUL CHOSEONG HIEUH
   {0x30, 0x00, 0x00, 0x00}  /* // DIGIT ZERO
   {0x31, 0x00, 0x00}, // DIGIT ONE
   {0x32, 0x00, 0x00}, // DIGIT TWO
   {0x33, 0x00, 0x00}, // DIGIT THREE
   {0x34, 0x00, 0x00}, // DIGIT FOUR
   {0x35, 0x00, 0x00}, // DIGIT FIVE
   {0x36, 0x00, 0x00}, // DIGIT SIX
   {0x37, 0x00, 0x00}, // DIGIT SEVEN
   {0x38, 0x00, 0x00}, // DIGIT EIGHT
   {0x39, 0x00, 0x00}  // DIGIT NINE */
};
