
#ifndef _Utf8StringBase_
#define _Utf8StringBase_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h" //lint !e451 !e537
// Warning 451: Header file '...' repeatedly included but does not have a standard include guard
// Warning 537: Repeated include file '...'

#include "../CodeConversion/ConvertUTF.h"
#include "OfflineTableDefs.h" // To keep definitions in-line with offline_table_loader
#include "../midw_common_languages.h"

//lint -e1702 operator 'operator<' is both an ordinary function 'std::operator<(const std::pair<<1>,<2>> &, const std::pair<<1>,<2>> &)' and a member function 'tclUtf8StringBase::operator<(const tclUtf8StringBase &) const'

class tclUtf8StringBase;
static tclUtf8StringBase* po_string;

class tclUtf8StringBase
{

public:



   //! < Operator - returns value of bThisIsLess
   virtual tBool operator<  ( const tclUtf8StringBase& oOtherString) const
   {
      return bThisIsLess(oOtherString);
   };

   //! Returns this string or NULL if not defined
   virtual tPCU8 pcu8GetString() const
   {
      return ( (_pu8String != OSAL_NULL) ? _pu8String : (tPCU8)"<EMPTY>" );
   };

   static tU32 getFirstLetters (const tU8* input, tU32 len_input, tU8* dest, tU32 max_len_dest, const tU8* seperators);

   tS32 compareUtf8Strings(tVoid* pvArg, tS32 len0, tVoid const* str0, tS32 len1, tVoid const* str1);

   tclUtf8StringBase(tPCU8 pu8String = OSAL_NULL, tU32 u32StringSize = 0, tBool bAlloc = FALSE);

   virtual ~tclUtf8StringBase();

   tU32 u32GetSortValue(tU32 u32Utf8Char) const;

   void vAssign(tclUtf8StringBase const& roTheOther)
   {
      *this=roTheOther;
   }

   //! Returns the value of the current language used for sorting. May be default or variant.
   virtual tenUtf8SortLanguage get_sort_language () const
   {
      return currentSortLanguage;
   };

   tBool set_Current_Language (tenMidwCommonLanguage new_language);

   static inline tBool setCurrentLanguage (tenMidwCommonLanguage new_language)
   {
      if( po_string != 0 )
      {
         return po_string->set_Current_Language(new_language);
      }
      else
      {
          return false;
      }
   }

protected:

   static const tU32 cu32EndOfString  = 0xffffffff;

   tU32 u32GetNextUtf8Value();

   //! Returns value of embedded numbers within the string - indexed by number_index
   virtual tU32  u32GetNumberValue(tU8 number_index) const
   {
      return _u32NumberValue[number_index];
   };

   static tU8 process_chinese (const tU8* input_ptr, tU32* no_utf8);

   tU32 convertToPinyin (const tU8* input,
                         tU32 len_input,
                         tU8* dest,
                         tU32 len_dest);

   tBool getChinesePinyin (const tU8* input_ptr,
                           tU32* no_utf8,
                           tU8* pinyin_str,
                           tU32* pinyin_len);

   //! The current language - set by setCurrentLanguage
   static tenMidwCommonLanguage currentLanguage;

   //! The current sorting language - set by setCurrentLanguage
   static tenUtf8SortLanguage currentSortLanguage;

   tclUtf8StringBase& operator=( const tclUtf8StringBase& roTheOther);

   tclUtf8StringBase( const tclUtf8StringBase& roTheOther);



   static const tU32 cu32MaxUTF8Value        = 0x0000ffff;
   static const tU32 cu32EmptyField          = 0;
   static const tU32 cu32ValidOffset         = 0x01000000;
   static const tU32 cu32BiggestOneByteChar  = 0x7f;
   static const tU32 cu32NumOfDigits         = 9;
   static const tU32 cu32InvalidNumberValue  = 0x3fffffff;
   static const tU32 cu32StringNumberValue   = 0x40000000;

   tBool bThisIsLess ( const tclUtf8StringBase& oOtherString) const;

   //! Returns TRUE if u32Char is an ASCII digit
   tBool bIsANumber(tU32 u32Char)  const
   {
      return ((u32Char >= '0') && (u32Char <= '9'));
   };

   //! Returns the value of the next utf8 symbol in the string
   tU32 u32GetUtf8Value(tU32& ru32OffSet, tBool& rbSZOnce) const;

   //! Calculates the values of all numbers embedded in the string as sequences of digits
   tVoid u32CalculateNumberValues();

   //! Returns UTF8Char plus Valid Offset Flag
   static inline tU32 u32GetBigSortValue(tU32 u32Utf8Char)
   {
      return u32Utf8Char+cu32ValidOffset;
   }

   //! Sort Values - loaded at compile time with data created by the Offline Table Loader tool

   //! Note - there are multiple copies, but all have same default sorting values
   static tU32  aru32SortValues_Chinese_Unicode_1_1[cu32MaxUTF8Value];
   static tU32  aru32SortValues_Korean[cu32MaxUTF8Value];
   static tU8   aru8PinyinStrings[cu32MaxUTF8Value][8];

   //! Data for Variant languages - loaded at compile time with data created by the Offline Table Loader tool
   static tU16   aru8SortValues_Variant_Latin[RANGE_LATIN] [NO_VAR_LANGS];

   //! Data for Diacritic character sort values - loaded at compile time with data created by the Offline Table Loader tool
   static tU16   aru8SortValues_Variant_Diacritics[RANGE_DIACRITICS] [NO_VAR_LANGS];

   //! The actual string associated with this instance
   tPCU8 _pu8String;

   //! Pointer to copy of the string if it exists
   tPU8  _pu8Data;

   //! The length of the string in UTF8 bytes (not characters, which may be multi-byte)
   tU32  _u32StringSize;

   //! Holds the numeric values of each sequence of digits
#define MAX_NUMBERS 50
   tU32  _u32NumberValue[MAX_NUMBERS];

   //! Current position during processing of the string
   tU32  _u32Offset;

   //! Flag used to process German ligature ss/sz
   tBool _bSZOnce;

   //! TRUE if memory has been allocated for a copy of the string
   tBool _bAlloc;



};

//lint -restore

#endif //_Utf8StringBase_
