
#ifndef _OfflineTableDefs_
#define _OfflineTableDefs_

// Definitions common to Offline Table Loader and Utf8StringBase

// For purposes of variance, this set includes the digits
#define BASE_LATIN 0x30
#define TOP_LATIN 0x7A
#define RANGE_LATIN ((TOP_LATIN - BASE_LATIN) + 1)

#define BASE_DIACRITICS 0xC380
#define TOP_DIACRITICS 0xC5BE
#define RANGE_DIACRITICS ((TOP_DIACRITICS - BASE_DIACRITICS) + 1)

// NOTE - Check that this is the lowest sort value (-1) used within the diacritics range
#define BASE_SORT 200

// UTF8SORT SORT TYPE ENUM
typedef enum
{
   UTF8SORT_DEFAULT = 0,

   // Sort Language variants
   UTF8SORT_DANISH    = 1, // Danish and Norwegian have a common sort
   UTF8SORT_NORWEGIAN = 1, //lint !e849 Info 849: Symbol 'UTF8SORT_NORWEGIAN' has same enumerator value '1' as enumerator 'UTF8SORT_DANISH'
   UTF8SORT_SWEDISH   = 2, // Swedish and Finnish have a common sort
   UTF8SORT_FINNISH   = 2, //lint !e849 Info 849: Symbol 'UTF8SORT_FINNISH' has same enumerator value '2' as enumerator 'UTF8SORT_SWEDISH'
   UTF8SORT_POLISH    = 3,
   UTF8SORT_CZECH     = 4,
   UTF8SORT_SLOVAK    = 5,
   UTF8SORT_HUNGARIAN = 6,
   UTF8SORT_GREEK     = 7,
   UTF8SORT_LAST      = 8

} tenUtf8SortLanguage;

#define NO_VAR_LANGS ((int)UTF8SORT_LAST - 1)

#endif //_OfflineTableDefs_
