/************************************************************************
* FILE:         midw_common_trace_input.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: trace channel input interface
*              realizes the action interface the trace channel registration
*              results in a function inbox for all classes being registered
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                   | Modification
*
*************************************************************************/

#ifndef MIDW_COMMON_TCLTRACEINPUT_H
#define MIDW_COMMON_TCLTRACEINPUT_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

class midw_common_tclTraceChannel;

/* +++
 trace input interface definition
 This interface is used to call the vTraceRx in all classes participating at trace
 input in your project. Whenever you create a new class, which shall be controlable
 from TTFis input, you just need to inherit this interface and to implement vTraceRx
 function. Additionally the registering of the new trace input needs to be done in
 ccademo_main.cpp vRegisterTraceInputs().
 */
class midw_common_tclTraceInput
{
public:
   midw_common_tclTraceInput() {}
   virtual ~midw_common_tclTraceInput() {}

   /* this is a call back to all classes participating at trace channel
   * call chan->vRegisterTraceInput(myFileId, this); to register.
   * call vRegisterTraceInputRequest(chan) to your class members to let they
   * register themself  */
   virtual tVoid vRegisterTraceInputRequest(midw_common_tclTraceChannel* poChan)=0;

   /* when being registered the vTraceRx() is called containing the buffer
   entered by the user into TTFis */
   virtual tVoid vTraceRx(tPCUChar pcu8Data)=0;
};

#endif //MIDW_COMMON_TCLTRACEINPUT_H
