/*
 * SendTriggerContainer.cpp
 *
 *  Created on: 09.06.2016
 *      Author: mor2hi
 */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "../midw_common_trace.h"

#include "SendTriggerContainer.h"

//For ETG tracing
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_MIDW_COMMON_TRACE
#include "trcGenProj/Header/SendTriggerContainer.cpp.trc.h"
#endif

SendTriggerContainer::SendTriggerContainer() :
      _SendGranted(TRUE), // enable it by default for leagacy code
      _TriggerSend(FALSE)
{

}

SendTriggerContainer::~SendTriggerContainer()
{
}

/**
 * It's forbidden to send something at the moment.
 * @return
 */
tVoid SendTriggerContainer::sendDenied()
{
   _SendGranted = FALSE;
}

/**
 * From now on it's allowed to send something.
 * @return
 */
tVoid SendTriggerContainer::sendGranted()
{
   _SendGranted = TRUE;
}

/**
 * Set the trigger as a notification. Once it's been set, messages will be sent within the next time slot.
 * @return
 */
tVoid SendTriggerContainer::setSendingTrigger()
{
   _TriggerSend = TRUE;
}

/**
 * Clear the sending trigger. This is usually been done, once the message is been sent.
 * @return
 */
tVoid SendTriggerContainer::consumeSendingTrigger()
{
   _TriggerSend = FALSE;
}

tBool SendTriggerContainer::isSendingGranted()
{
   return (_SendGranted);
}

tBool SendTriggerContainer::isSendingTriggered()
{
   return (_TriggerSend);
}

/**
 * Check whether it's allowed to send the message.
 * @return
 */
tBool SendTriggerContainer::isSendingOfMessageAllowed()
{
//   ETG_TRACE_USR4(("SendTriggerContainer::isSendingOfMessageAllowed: enter: message waiting for sending: %d, send allowed: %d", _TriggerSend, _SendGranted));
   return (isSendingTriggered() && isSendingGranted());
}

