///////////////////////////////////////////////////////////

//  ConnectionConfigurator.h

//  Implementation of the Class ConnectionConfigurator

//  Created on:      12-Sep-2015 13:21:20

//  Original author: MOR2HI

///////////////////////////////////////////////////////////

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#if !defined(EA_E730334E_AF7C_4436_A694_50E15F1E78DE__INCLUDED_)

#define EA_E730334E_AF7C_4436_A694_50E15F1E78DE__INCLUDED_

#define DEFAULT_AVAILABILITY_TYPE 0xFF

#define MCAN_CHANNEL_AVAILABILITY_CHANNEL_DISABLED 0x00

#define MCAN_CHANNEL_AVAILABILITY_CHANNEL_AVAILABLE 0x01

#define MCAN_CHANNEL_AVAILABILITY_AUTO_CONFIGURATION 0x02

#define MCAN_CHANNEL_AVAILABILITY_UNKNOWN 0xFF

#include "HistoryContainer.h"
#include "ConnectionConfiguratorCallbackInterface.h"


/**

 * This class maintain whether a channel shall connect or not.

 * It'll store the connection history and decide whether connection error are going to be written as ITC.

 */

class ConnectionConfigurator

{
public:
	ConnectionConfigurator(ConnectionConfiguratorCallbackInterface* pCallbackInterface);
	ConnectionConfigurator();

	~ConnectionConfigurator();

	/**
	 * The channel is been granted once the MCAN channel is been connected.
	 * @return
	 */
	tBool isCommunicationGranted();

	/**
	 * Whether a channel connection is expected, depends on the configuration.
	 * @return: Channel connection is been expected if vehicle channel availability type is "auto" or "yes".
	 */
	tBool isChannelConnectionExpected();
	/**
	 * Feedback whether the channel is connected. Means now we can receive and send MCAN messages on this channel.
	 * @return
	 */
	tBool isChannelConnected ();

	/**
	 * Client is telling the connection configurator that the MCAN channel is connected.
	 * Now history must be stored for auto configuration.
	 */
   tVoid connectionEstablished();

   /**
    * Functions to configure the connection configurator.
    * The caller checks the KDS variables for getting to know which strategy comes into picture and it'll call one of the markChannel functions according to the strategy.
    */
	tVoid markChannelAvailable();
	tVoid markChannelAutoAvailable();
	tVoid markChannelNotAvailable();

	/**
	 * Check whether it's allowed to write error into the error memory
	 */
	tBool isErrorDetectionGranted();

	/**
	 * Maintain the MCAN channel availability (Auto, Yes, No)
	 */

	tU8 _AvailabilityType;

	/**
	 * maintain connection status. Once the MCAN channel is connected it'll be set to true.
	 */
	tBool _ChannelConnected;

	/**
	 * container to maintain the history. History comes into picture for auto configuration. The history will be set, once the channel is been connected.
	 */
	HistoryContainer oHistoryContainer;





};

#endif // !defined(EA_E730334E_AF7C_4436_A694_50E15F1E78DE__INCLUDED_)

