/**************************************************************************//**
* \file     SocketThread.h
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef SOCKETTHREAD_H
#define SOCKETTHREAD_H


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#include "DatagramSocketCallbackIf.h"
#include <dgram_service.h>
#include <stdint.h>


struct ThreadFunctionArguments
{
	int32_t socketDescriptor;
	sk_dgram* pdgram;
	DatagramSocketCallbackIf* datagramSocketCallback;
};


class SocketThread : public ahl_tclBaseThread
{
	public:
		virtual ~SocketThread();
		SocketThread(const char* name, const uint32_t stackSize, const uint32_t priority, ThreadFunctionArguments* args);

	protected:
	    virtual tVoid vClearTriggers(){};
	    virtual tVoid vTrigger(){};
	    virtual tBool bWaitForTrigger(){return 1;};
		virtual tBool bBaseThreadFunction(tPVoid pvInst);

	private:
		ThreadFunctionArguments* m_args;
};


#endif
