/**************************************************************************//**
* \file     SocketThread.cpp
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "SocketThread.h"
#include <unistd.h>
#include <sys/poll.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <errno.h>
#include <stdlib.h>


/**************************************************************************//**
* Destructor
******************************************************************************/
SocketThread::~SocketThread()
{
	m_args->socketDescriptor = 0;
	m_args->pdgram = NULL;
	m_args->datagramSocketCallback = NULL;
	if (m_args != NULL)
	{
		delete m_args;
		m_args = NULL;
	}
	
		
}


/**************************************************************************//**
* Constructor
******************************************************************************/
SocketThread::SocketThread(const char* name, const uint32_t stackSize, const uint32_t priority, ThreadFunctionArguments* args)
	 :ahl_tclBaseThread((unsigned short)-1, name, stackSize, priority)
{
	m_args = args;
}


/**************************************************************************//**
*
******************************************************************************/
tBool SocketThread::bBaseThreadFunction(tPVoid pvInst)
{

	SocketThread* pInst = (SocketThread*)pvInst;

    int32_t pfd = pInst->m_args->socketDescriptor;
    int32_t rc = -1;
	struct pollfd fds[1];
	fds[0].fd = pfd;
	fds[0].events = POLLIN;
	int32_t timeout = 200;
	tU8 recvBuffer[4096];
	memset(recvBuffer,0, sizeof(recvBuffer));
	int32_t numberOfBytesReceived =0;

	rc = poll(fds, 1, timeout);
	if((fds[0].revents & POLLIN)||(fds[0].revents & POLLPRI))
	{
		do
		{
			numberOfBytesReceived = dgram_recv(pInst->m_args->pdgram, recvBuffer, sizeof(recvBuffer));
			if (numberOfBytesReceived > 0)
			{
				pInst->m_args->datagramSocketCallback->onNewDatagramMessage(recvBuffer,numberOfBytesReceived);
				recvBuffer[numberOfBytesReceived] = 0;
				memset(recvBuffer,0, sizeof(recvBuffer));
			}
		}while (numberOfBytesReceived > 0);
	}
	else if(fds[0].revents & POLLERR)
	{
		sleep(1);
	}
	else
	{
	   // no handling.
	}

	return true;
}
