/**************************************************************************//**
* \file     DatagramSocket.h
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef DATAGRAMSOCKET_H
#define DATAGRAMSOCKET_H


#include "DatagramSocketCallbackIf.h"
#include "SocketThread.h"
#include <dgram_service.h>
#include <stdint.h>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define MAX_PORT_FD_DIGIT 5

class DatagramSocket
{
	public:
		virtual ~DatagramSocket();
		DatagramSocket(DatagramSocketCallbackIf* cb, uint32_t threadStackSize, uint32_t threadPriority, int32_t port, int32_t addressFamily, tBool bConnectV850 = FALSE, tBool bFakeDevice = FALSE, tBool bConnectToServerFD = TRUE);
		int32_t sendMessage(void* ubuf, size_t ulen);
		tS32 s32ErrorNumber;

		void vStartSocketThread(uint32_t threadStackSize, uint32_t threadPriority, int32_t port);

	private:
		bool bSetUpSocketConnection(int32_t addressFamily, int32_t type, int32_t port);
		int32_t m_SocketDescriptor, m_SocketDescriptorFD;
		sk_dgram* m_pdgram;
		DatagramSocketCallbackIf* m_DatagramSocketCallback;
		SocketThread* m_socketThread;
		char name[30];
        tBool m_bConnectV850, m_bFakeDevice, m_bConnectToServerFD;
};


#endif
