#ifndef _CHARMAP_H
#define _CHARMAP_H
/**************************************************************************//**
* \file     CharMap.h
*
*           Contains the exported interface of class CharMap.
*           See .c file for detailed description.
*
* \remark   Copyright: 2009 Robert Bosch Car Multimedia GmbH, Hildesheim
* \remark   Scope:     VAG HMI
*
* \author   - CM-AI/PJ-VW66 Janssen
******************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h" /*lint !e451 !e537 */
/* Warning 451: Header file '...' repeatedly included but does not have a standard include guard */
/* Warning 537: Repeated include file '...' */
/**
 *  See CharMap.dat for a list of valid map ids.
 *  Map ids are listed with the CHAR_MAP(id) keyword.
 */
typedef enum _MapIdEnum
{
#define MAP(map)     map,
#include "CharMapVar.h" /*lint !e537 */ /* Warning 537: Repeated include file '...' */
#undef  MAP
   MAP_NONE,
   /* end-of-enum marker */
   MAP_ID_LIMIT
} MapIdEnum;


void CharMap_vSelectMap(MapIdEnum enMapId);
tU32 CharMap_ulwTranspose(tU32 ulwChar);


#endif

