//
//---------------------

#ifndef _CSM_IF__H_IF_DONE
#define _CSM_IF__H_IF_DONE

#include "../CSMCommThreads.h"
#include "../CSMCommObjects.h"

#if (OSAL_OS==OSAL_NUCLEUS)
#define SIGNAL_IND_TYPE tDrvCsm_PFN_CBR_SIGNAL_IND
#else
typedef void (*tDrvCsm_PFN_CBR_SIGNAL_IND) ( tVoid *, tU32 , tU32 );
typedef void (*pvFN_CSMSignalInd)(tU32 SignalId, tU32 SignalStatus); 

#define SIGNAL_IND_TYPE tDrvCsm_PFN_CBR_SIGNAL_IND
#endif


//Errorcodes for CSM_s32Init
#define    CSMINIT_NOERROR      0       //no error
#define    CSMINIT_UNDEFINED_1 -1       //currently unused
#define    CSMINIT_PARAMETER_IS_NULL -2 //Your configuration is a NULL pointer.
#define    CSMINIT_BC_PRIO_IS_NULL -7  //Your BC Prio has to be unequal to 0
#define    CSMINIT_BC_STACK_IS_NULL -8 //Your BC stacksize needs to have a value unequal to 0.
#define    CSMINIT_BC_THREAD_NAME_MISSING -6 // BC Thread needs to have a name
#define    CSMINIT_NO_OSAL_DEVICE -9 //The name of your OSAL-device is a NULL pointer

class CSMInterface
{
private:
    tBool bIsBCThreadRunning;

    tBool bIsSGIDInRange(tU8 MySgID);

    csm_tclCsmAccessUser *poCsmAccessUser;

    tU8 u8CalcQualifier(tU8 LSG, tU8 FID, tU8 Req,tBool bIsReset, tBool bIsCache);

public:
    CSMInterface();
    CSMInterface(tU32 u32MsgQueueCount);

    virtual ~CSMInterface();

    static tS32 CSM_s32WaitForCAN(tU32 u32Timeout);

    tS32 CSM_s32Init(CSMThreadConfig *pMyConfig);

    // CSM access_usr adapter 
    tS32 CSM_lApplCallbackInit(tU8 u8Bus, tU32 dwProtocolType, void *pvAddressField, void *pvCallBackFkt);
    // CSM access_usr adapter 
    tS32 CSM_lApplCallbackInit(void *pvHandle, tU8 u8Bus, tU32 dwProtocolType, void *pvAddressField, void *pvCallBackFkt);
    // CSM access_usr adapter 
    tS32 CSM_lApplCallbackInit(void *pvHandle, tU32 dwProtocolType, void *pvAddressField, void *pvCallBackFkt);
    
    tS32 CSM_lApplCallbackDeInit( void *pvHandle );

    /* Lowline style (de)registration on Broadcast Signal */
    tS32 CSM_lSignalCallbackInit( void *pvHandle,
                                  tU32 dwSignalId, 
                                  SIGNAL_IND_TYPE vPFNCBRSignalInd );

    tS32 CSM_lSignalCallbackDeInit( void *pvHandle,
                                    tU32 dwSignalId );

    tS32 CSM_lSignalCallbackDeInitAll( void *pvHandle );


    tS32 CSM_lBusErrorIndCallbackInit( void *pvHandle,
                                       tCSM_PFN_BUS_ERROR_IND vPFNBusErrorInd );

    tS32 CSM_lCommunicationReq( void *pvHandle,
                                tU8  bBus,
                                tU32 dwProtocolType, 
                                const void *pvAddressField, 
                                tU8  bAction,
                                tU16 wApplID );

    tS32 CSM_lGetCommunicationState( void *pvHandle,
                                     tU8 bBus,
                                     tU32 dwProtocolType,
                                     const void *pvAddressField, 
                                     tU8 *pbConnectState,
                                     tU16 wApplId );

    tS32 CSM_lDataReq( void *pvHandle,
                       tU32 dwProtocolType,
                       const void *pvAddressField,
                       const tU8 *pbData,
                       tU16  wDataLength );

    tS32 CSM_lDataIndProcessed( void *pvHandle,
                                tU32 dwProtocolType,
                                const void *pvAddressField );

    tS32 CSM_lSignalWrite( void *pvHandle,
                           tU32  dwSignalId,
                           void *pvNewSignalData, 
                           tU8   bDataBufferLength,
                           tU8   bTxType );

    tS32 CSM_lMultipleSignalWrite( void                           *pvHandle,
                                   const tCSM_MultipleSignalWrite *prSignalList,
                                   const tU8                       bNumberOfSignals );

    tS32 CSM_lSignalRead( void *pvHandle,
                          tU32  dwSignalId,
                          void *pvActSignalData, 
                          tU8   bDataBufferLength,
                          tU32 *pdwSignalStatus );

    tS32 CSM_lMultipleSignalRead( void                          *pvHandle,
                                  const tCSM_MultipleSignalRead *prSignalList,
                                  const tU8                      bNumberOfSignals );

    tS32 CSM_lGetAllStateIndicationsAgain();

    tS32 CSM_lConTest( void *pvHandle,
                       tU32 dwProtocolType,
                       void *pvAddressField,
                       tU8  bAction );

    tS32 CSM_lDataRead( void *pvHandle,
                        tU32 dwProtocolType,
                        const void *pvAddressField,
                        tU8  *pbData,
                        tU16  wDataLength );

};

#endif

/*
typedef void (*tDrvCsm_PFN_TP_COMMUNICATION_CON) ( void *, tU8, tU32 , const void *, tU8 , tU16);
typedef void (*tDrvCsm_PFN_TP_COMMUNICATION_IND) ( void *, tU8, tU32 , const void *, tU8 , tU16 );


typedef void (*tDrvCsm_PFN_TP_DATA_CON) ( void *, tU32 , const void *, tU8 );
typedef void (*tDrvCsm_PFN_TP_DATA_IND) ( void *, tU32 , const void *, tU8* , tU16 );


typedef void (*tDrvCsm_PFN_CBR_SIGNAL_IND) ( void *, tU32 , tU32 );

*/
