// CodeLine.h: interface for the CCodeLine class.
//
//////////////////////////////////////////////////////////////////////

#ifndef _CSM_COMM_THREAD_IF__H_IF_DONE
#define _CSM_COMM_THREAD_IF__H_IF_DONE

// includes needed for drv_csm
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//#define NUCLEUS_CORE_S_IMPORT_INTERFACE_NUCLEUS
//#include "nucleus_core_pif.h"

#define CSM_S_IMPORT_INTERFACE_GENERIC
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER  //Required changes for LCN2Kai Porting (SYA2HI)
#include "../../di_can/csm_if.h"

#if (OSAL_OS==OSAL_NUCLEUS)    //Required changes for LCN2Kai Porting (SYA2HI)
#include "drv_csm.h"
#endif                    //Required changes for LCN2Kai Porting (SYA2HI)

//trace
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
//registry
#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"
//semaphore access
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "CSMCommObjects.h"


#define DEMO_EV_ENGAGE            0x00000001
#define DEMO_EV_BUTTON_CHANGE     0x00000002

//states for Cleaner Thread
#define DEMO_CLEANER_INIT 0
#define DEMO_CLEANER_READYFORACTION   1
#define DEMO_CLEANER_BUSY_FIRING 2
#define DEMO_CLEANER_BUSY_RELOADING   3
#define DEMO_CLEANER_LONGPRESS_CHECK  4

//collection of literals...
#define DEMO_CSM_BITFIELD_JUNK 0xffff
#define DEMO_CSM_RETURN_JUNK -1
#define DEMO_CSM_SIGNAL_JUNK 255
#define DEMO_CSM_JANISCHT 0
#define DEMO_CSM_CAN_DELAY_IN_MS 50

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class demo_tclCSMInterface
{
private:
    //static demo_tclCSMInterface *poMeMyselfAndI;
    tBool bThreadSetup(tVoid);
    static tVoid vCSM_CallbackThread(const tVoid *pvArg);

    tBool _bTerminate;

    CSMThreadConfig *pMyConfig;

    OSAL_tThreadID       _hCallbackThreadId;       // ID of the active thread
public:
    OSAL_tIODescriptor hCSM;
    demo_tclCSMInterface (); // constructor
    //demo_tclCSMInterface (CSMThreadConfig *ptmpConfig); // constructor
	~demo_tclCSMInterface(tVoid); // destructor
    OSAL_tIODescriptor * pGetMyOsalDevice(tVoid)  ;
    void vSetConfig(CSMThreadConfig *ptmpConfig);
    void vInit();
};

#endif

