/*****************************************************************************
* FILE 			: IntercomConstantTypes.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: IntercomTypes
*
* DESCRIPTION 	: This files provides the types and constant
*                 
*
* AUTHOR 		: Monojit Chatterjee (CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 11/08/2021     Initial version
*
* Version       : 1.0
*
****************************************************************************/
#if !defined(INTERCOM_CONSTANT_H)
#define INTERCOM_CONSTANT_H

#include <algorithm>
#include <sys/types.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unordered_map>
#include "IntercomService.h"

#include "asf/core/BaseComponent.h"
#include "AVRoutingParser.h"





class XMLReader;

namespace IntercomApp
{


enum eCallAction { ACCEPT = 1, REJECT = 2 };



#define DEV_NUM                                                                            0x01


#define ACCEPT_INTERCOM_EVENT_MSG_ID                                                       0x0105
#define CANCEL_INTERCOM_EVENT_MSG_ID                                                       0x0107
#define EVENT_HU_CALL_MSG_ID                                                               0x0103
#define PHONE_STATUS_REQUEST_MSG_ID                                                        0x0100
#define INTERCOM_GET_AVAILABILITY_MSG_ID                                                   0x0114
#define DEV_NAME_CMA                                                                       "CMA"
#define PRIMARY_CMA                                                                         0
#define MULTIPLE_CMA                                                                        1
#define VERSION_STRING                                                                     "[ 7_10_20 ]Common XML Parser inclusion"

#define BITMASK_6           (   6      )
#define BITMASK_VOLTAGE      ( 0x01C0 )


typedef enum PhoneStatusBitPosition
{
    DISABLED_ENABLED,
    CONNECTED_DISCONNECTED,
    ONHOOK_PICKUP,
    RINGING_NOTRINGING

} ePhoneStatusBitPosition;

typedef enum DevID
{		
	enDevID_Media_Center	   	= 0x01,
	enDevID_Media_Apm			= 0x02,
	enDevID_Media_Router		= 0x03,
	enDevID_Media_HDTV 			= 0x04,
	enDevID_Media_CamPort	    = 0x05,
	enDevID_Media_Glass			= 0x06,
	enDevID_Media_ControlPanel	= 0x07,
	enDevID_Intercom 			= 0x08,
	enDevID_Swivel_Holder		= 0x09,
	enDevID_TestBed				= 0x0A
} eDevID;

typedef enum Voltage_Error
{
	VOLTAGE_ERROR_EVALUATING,
	VOLTAGE_ERROR_NO_ERROR,
	VOLTAGE_ERROR_OVER_WARNING_VOLTAGE,
	VOLTAGE_ERROR_OVER_CRITICAL_VOLTAGE,
	VOLTAGE_ERROR_UNDER_WARNING_VOLTAGE,
	VOLTAGE_ERROR_UNDER_CRITICAL_VOLTAGE
}eVoltageError;







}


#endif // INTERCOM_CONSTANT_H
