/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                  : IntercomComponent.cpp
* COMPONENT Name        : Intercom
* DESCRIPTION           : DBus Server for Intercom Audio Services.
* AUTHOR                : 
* Date                  : 24.07.2018
* Revision History      : 0.1
* Date 23.08.2017       : Initial version
****************************************************************************/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
//#include "IntercomService.h"
//#include "IntercomAudioClientHandler.h"
#include "IntercomComponent.h"
#include "lcmdbusclient_main_fi.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define ETG_ENABLED
#include "trace_interface.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_INTERCOM_DBUS_SERVICE
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_INTERCOM
#define ETG_I_TTFIS_CMD_PREFIX            "INTERCOM_SERVICE_"
#define ETG_I_FILE_PREFIX                 IntercomApp::IntercomService::IntercomService
#include "trcGenProj/Header/IntercomComponent.cpp.trc.h"

#endif

using namespace ::lcmdbusclient_main_fi;

IntercomComponent* IntercomComponent::m_pIntercomComponent = nullptr; ;
DLT_DECLARE_CONTEXT(INTERCOM_SERVICE);
DLT_DECLARE_CONTEXT( INTERCOM_COMPONENT );
DLT_DECLARE_CONTEXT( INTERCOM_AUDIO_HANDLER );
DLT_DECLARE_CONTEXT( INTERCOM_RTP );
namespace IntercomApp {

IntercomComponent::IntercomComponent() : BaseComponent() ,  mStreamRouterProxy( midw_streamrouter_fi::Midw_streamrouter_fiProxy::createProxy ( "strFiPort", *this ) ), _spmProxy(::SPM_CORE_FI::SPM_CORE_FIProxy::createProxy("spmLcmFiImport", *this)), _regIdSubsystemerrorStatusUpdate(0),
_lcmDBusClientProxy(Lcmdbusclient_main_fiProxy::createProxy("lcmdbusclient_main_fiPort", (*this)))
{
  //LOG_DLT_INFO( LOG_CONTEXT_INTERCOM_MAIN, "%s %d ", __FUNCTION__, __LINE__);
  
    m_pIntercomComponent = this;
  	DLT_REGISTER_APP("INTM", "Intercom APP");
	
	DLT_REGISTER_CONTEXT(INTERCOM_SERVICE, "SERV", "Intercom Service for Logging");
	DLT_REGISTER_CONTEXT(INTERCOM_COMPONENT, "COMP", "Intercom Component for Logging");
	DLT_REGISTER_CONTEXT(INTERCOM_AUDIO_HANDLER, "AudI", "Intercom Audio for Logging");
	DLT_REGISTER_CONTEXT(INTERCOM_RTP, "RTPI", "Intercom RTP Audio");
	//trc_tclGlobalTrace::s32Init();
	vInitPlatformEtg();
	ETG_I_REGISTER_CHN(TR_TTFIS_INTERCOM);
	ETG_I_REGISTER_FILE();
	
  DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("Constructor of IntercomComponent"));
   m_pIntercomAudioClientHandler = NULL;
   m_pIntercomAudioClientHandler =  OSAL_NEW IntercomAudioClientHandler();
   m_InterComAudioProcessing = InterComAudioProcessing::createInstance(); 
   DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("before constructor IntercomNanoMessageClientHandler"));
 // m_IntercomNanoMessageClientHandler = IntercomNanoMessageClientHandler::createInstance();
  DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("after constructor IntercomNanoMessageClientHandler"));
   //bool status = m_pIntercomAudioClientHandler->bPlayIntercomAudio();
   DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("m_pIntercomAudioClientHandler"));
   ETG_TRACE_USR4(("IntercomComponent():enter."));
   if (OSAL_NULL == m_pIntercomAudioClientHandler)
   {
	   DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("m_pIntercomAudioClientHandler OSAL_NULL"));
   //  LOG_DLT_INFO( LOG_CONTEXT_INTERCOM_MAIN, "%s %d ", __FUNCTION__, __LINE__);
   }
   m_pIntercomService = NULL;
   m_pIntercomService = IntercomService::createInstance();
   if (NULL != m_pIntercomService)
   {
        DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("m_pIntercomService not null"));
     if(NULL != m_pIntercomAudioClientHandler)
     {
		 DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("vInitDBUSServicePointer not null "));
       m_pIntercomAudioClientHandler->vInitDBUSServicePointer(m_pIntercomService);
     }
   }
   
   ETG_TRACE_USR4(("IntercomComponent():exit."));
}

IntercomComponent::~IntercomComponent()
{
  //LOG_DLT_INFO( LOG_CONTEXT_INTERCOM_MAIN, "%s %d ", __FUNCTION__, __LINE__);

   if (NULL != m_pIntercomAudioClientHandler)
   {
      OSAL_DELETE m_pIntercomAudioClientHandler;
      m_pIntercomAudioClientHandler = NULL;
   }
   if (NULL != m_pIntercomService)
   {
      m_pIntercomService->destroyInstance();
      m_pIntercomService = NULL;
   }
}

void IntercomComponent::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy,
const ServiceStateChange& stateChange) {
//LOG_DLT_INFO( LOG_CONTEXT_INTERCOM_MAIN, "%s %d ", __FUNCTION__, __LINE__);
ETG_TRACE_USR4(("IntercomComponent():onAvailable."));
DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::onAvailable "));

   if (isMyLCMDBusClientProxy(proxy))
   {
	   	DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::Available sendSubsystemerrorStatusUpReg"));
      _regIdSubsystemerrorStatusUpdate = _lcmDBusClientProxy->sendSubsystemerrorStatusUpReg((*this));
   }


DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("startNanoMessageServer called "));
}

void IntercomComponent::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy,
const ServiceStateChange& stateChange)
{
	ETG_TRACE_USR4(("IntercomComponent():onUnavailable."));
	//LOG_DLT_INFO( LOG_CONTEXT_INTERCOM_MAIN, "%s %d ", __FUNCTION__, __LINE__);
	DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::onUnavailable "));
}

void IntercomComponent::onOffTriggerRequest ( bool status )
{
		if ( status == true )
		{
			DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("onOffTriggerRequest SWITCH ON  "));
			//_spmProxy->sendOnOffTriggerStart(*this, spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_TELEMATIC_ACTIVE, false);
			_spmProxy->sendOnOffTriggerStart(*this, spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_TELEMATIC_ACTIVE, true);
		}
		else
		{
			DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("onOffTriggerRequest SWITCH OFF "));
			//_spmProxy->sendOnOffTriggerStart(*this, spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_TELEMATIC_ACTIVE, true);
			_spmProxy->sendOnOffTriggerStart(*this, spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_TELEMATIC_ACTIVE, false);
		}

}

void IntercomComponent::onSubsystemerrorStatusError(const ::boost::shared_ptr< Lcmdbusclient_main_fiProxy >& proxy, const ::boost::shared_ptr< SubsystemerrorStatusError >& error)
{
   if (isMyLCMDBusClientProxy(proxy) && (NULL != error.get()) && (error->getAct() == _regIdSubsystemerrorStatusUpdate))
   {
      	DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::onSubsystemerrorStatusError"));
   }
}


void IntercomComponent::onSubsystemerrorStatusStatus(const ::boost::shared_ptr< Lcmdbusclient_main_fiProxy >& proxy, const ::boost::shared_ptr< SubsystemerrorStatusStatus >& status)
{
   if (isMyLCMDBusClientProxy(proxy) && (NULL != status.get()) && (status->getAct() == _regIdSubsystemerrorStatusUpdate))
   {
      const ::lcmdbusclient_main_fi_types::TheSubsystemList& tTheSubsystemListInfo = status->getSubsystemerrorconstate();
      for (::lcmdbusclient_main_fi_types::TheSubsystemList::const_iterator itr = tTheSubsystemListInfo.begin(); (itr != tTheSubsystemListInfo.end()); ++itr)
      {
		  DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::onSubsystemerrorStatusStatus error value : "), DLT_UINT16 ((*itr).getDevError()), DLT_CSTRING ("dev id : "), DLT_UINT16 ( (*itr).getDevId() )  );
		   // blocking of intercom call in low voltage error  
          if (((*itr).getDevId() ) == enDevID_Media_Apm  && (CheckVoltErrorStatus((*itr).getDevError() , VOLTAGE_ERROR_UNDER_WARNING_VOLTAGE ) ) == true   ) 
		  {
			  DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::onSubsystemerrorStatusStatus VOLTAGE_ERROR_UNDER_WARNING_VOLTAGE "));
		     setLowVoltageErrorStatus ( true );
          }
		  // blocking of intercom call in protected off 
		  else if (((*itr).getDevId() ) == enDevID_Media_Apm  && (CheckVoltErrorStatus((*itr).getDevError() , VOLTAGE_ERROR_UNDER_CRITICAL_VOLTAGE ) ) == true   ) 
		  {
			  DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::onSubsystemerrorStatusStatus VOLTAGE_ERROR_UNDER_CRITICAL_VOLTAGE "));
		     setLowVoltageErrorStatus ( true );
          }
		  // blocking of intercom call in protected off 
		  else if (((*itr).getDevId() ) == enDevID_Media_Apm  && (CheckVoltErrorStatus((*itr).getDevError() , VOLTAGE_ERROR_OVER_CRITICAL_VOLTAGE ) ) == true   ) 
		  {
			  DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::onSubsystemerrorStatusStatus VOLTAGE_ERROR_OVER_CRITICAL_VOLTAGE "));
		     setLowVoltageErrorStatus ( true );
          }
		   // blocking of intercom call in protected off 
		  else if (((*itr).getDevId() ) == enDevID_Media_Apm  && (CheckVoltErrorStatus((*itr).getDevError() , VOLTAGE_ERROR_OVER_WARNING_VOLTAGE ) ) == true   ) 
		  {
			  DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::onSubsystemerrorStatusStatus VOLTAGE_ERROR_OVER_WARNING_VOLTAGE "));
		     setLowVoltageErrorStatus ( true );
          }
		  else if (((*itr).getDevId() ) == enDevID_Media_Apm  && (CheckVoltErrorStatus((*itr).getDevError() , VOLTAGE_ERROR_NO_ERROR) ) == true   ) 
		  {
			  DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::onSubsystemerrorStatusStatus VOLTAGE_ERROR_NO_ERROR "));
			  setLowVoltageErrorStatus ( false );
		  }
		  
	  }
   }
}

bool IntercomComponent::CheckVoltErrorStatus ( uint16_t errorBits, eVoltageError VoltageError  )
{	
    bool status = false;
    errorBits = ( BITMASK_VOLTAGE & errorBits) >> BITMASK_6;
    status =  ( errorBits == VoltageError ) ? true : false;
	
	DLT_LOG(INTERCOM_COMPONENT , DLT_LOG_INFO, DLT_CSTRING("IntercomComponent::CheckVoltErrorStatus errorBits "), DLT_UINT16 ( errorBits ),  DLT_CSTRING (" status "),DLT_BOOL ( status ) );
	
	return status;
}







}//IntercomApp

